/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleSelector
extends JComponent
implements ChangeListener {
    private static final int MAX_SIZE = 135;
    private ImagePanel preview;
    private JLabel value;
    private JLabel size;
    private JSlider slider = new JSlider(1, 10, 1);
    private Image image;
    private int width;
    private int height;

    public ScaleSelector() {
        this.value = new JLabel("x1");
        this.size = new JLabel("   ");
        this.preview = new ImagePanel();
        this.value.setPreferredSize(new Dimension(25, 10));
        this.size.setHorizontalAlignment(0);
        this.slider.setMajorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(this);
        this.setLayout(new BorderLayout());
        Box b1 = new Box(0);
        b1.add(Box.createHorizontalStrut(5));
        b1.add(Box.createHorizontalGlue());
        b1.add(this.preview);
        b1.add(Box.createHorizontalGlue());
        b1.add(Box.createHorizontalStrut(5));
        this.add((Component)b1, "Center");
        Box b2 = new Box(0);
        b2.add(this.slider);
        b2.add(Box.createHorizontalStrut(5));
        b2.add(this.value);
        Box b3 = new Box(0);
        b3.add(Box.createHorizontalStrut(5));
        b3.add(Box.createHorizontalGlue());
        b3.add(this.size);
        b3.add(Box.createHorizontalGlue());
        b3.add(Box.createHorizontalStrut(5));
        Box b4 = new Box(1);
        b4.add(b2);
        b4.add(b3);
        this.add((Component)b4, "South");
    }

    public void setImage(Image img) {
        this.image = this.getScaledImage(img);
        this.stateChanged(null);
    }

    private Image getScaledImage(Image img) {
        int w = this.width = img.getWidth(null);
        int h = this.height = img.getHeight(null);
        double ar = (double)w / (double)h;
        int nw = 135;
        int nh = 135;
        if (w > h) {
            nh = (int)Math.round((double)nw / ar);
        } else {
            nw = (int)Math.round((double)nh * ar);
        }
        return img.getScaledInstance(nw, nh, 4);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        int scale = this.slider.getValue();
        this.value.setText("x" + String.valueOf(scale));
        this.size.setText("Image Size: " + this.width * scale + " x " + this.height * scale + " pixels");
        this.preview.repaint();
    }

    public double getScale() {
        return this.slider.getValue();
    }

    public class ImagePanel
    extends JComponent {
        Dimension d = new Dimension(135, 135);

        public ImagePanel() {
            this.setPreferredSize(this.d);
            this.setMinimumSize(this.d);
            this.setMaximumSize(this.d);
        }

        @Override
        public void paintComponent(Graphics g) {
            double scale = 0.4 + 0.06 * ScaleSelector.this.getScale();
            int w = (int)Math.round(scale * (double)ScaleSelector.this.image.getWidth(null));
            int h = (int)Math.round(scale * (double)ScaleSelector.this.image.getHeight(null));
            Image img = scale == 1.0 ? ScaleSelector.this.image : ScaleSelector.this.image.getScaledInstance(w, h, 1);
            int x = (135 - w) / 2;
            int y = (135 - h) / 2;
            g.drawImage(img, x, y, null);
        }
    }
}

