/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.tuple;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import prefuse.Visualization;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TableTuple;
import prefuse.data.tuple.TupleSet;
import prefuse.render.Renderer;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class TableVisualItem
extends TableTuple
implements VisualItem {
    @Override
    protected void init(Table table, Graph graph, int row) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(row) ? row : -1;
    }

    @Override
    public Visualization getVisualization() {
        return ((VisualTable)this.m_table).getVisualization();
    }

    @Override
    public String getGroup() {
        return ((VisualTable)this.m_table).getGroup();
    }

    @Override
    public boolean isInGroup(String group) {
        return this.getVisualization().isInGroup(this, group);
    }

    @Override
    public TupleSet getSourceData() {
        VisualTable vt = (VisualTable)this.m_table;
        return vt.getVisualization().getSourceData(vt.getGroup());
    }

    @Override
    public Tuple getSourceTuple() {
        VisualTable vt = (VisualTable)this.m_table;
        return vt.getVisualization().getSourceTuple(this);
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("VisualItem[").append(this.getGroup());
        sbuf.append(",").append(this.m_row).append(',');
        VisualTable vt = (VisualTable)this.m_table;
        int local = vt.getLocalColumnCount();
        int inherited = vt.getColumnCount() - local;
        for (int i = 0; i < inherited; ++i) {
            if (i > 0) {
                sbuf.append(',');
            }
            String name = vt.getColumnName(local + i);
            sbuf.append(name);
            sbuf.append('=');
            if (vt.canGetString(name)) {
                sbuf.append(vt.getString(this.m_row, name));
                continue;
            }
            sbuf.append(vt.get(this.m_row, name).toString());
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    @Override
    public void render(Graphics2D g) {
        this.getRenderer().render(g, this);
    }

    @Override
    public Renderer getRenderer() {
        return this.getVisualization().getRenderer(this);
    }

    @Override
    public Rectangle2D validateBounds() {
        if (this.isValidated()) {
            return this.getBounds();
        }
        Visualization v = this.getVisualization();
        this.getRenderer().setBounds(this);
        this.setValidated(true);
        Rectangle2D bounds = this.getBounds();
        v.damageReport(this, bounds);
        return bounds;
    }

    @Override
    public boolean isValidated() {
        return ((VisualTable)this.m_table).isValidated(this.m_row);
    }

    @Override
    public void setValidated(boolean value) {
        ((VisualTable)this.m_table).setValidated(this.m_row, value);
    }

    @Override
    public boolean isVisible() {
        return ((VisualTable)this.m_table).isVisible(this.m_row);
    }

    @Override
    public void setVisible(boolean value) {
        ((VisualTable)this.m_table).setVisible(this.m_row, value);
    }

    @Override
    public boolean isStartVisible() {
        return ((VisualTable)this.m_table).isStartVisible(this.m_row);
    }

    @Override
    public void setStartVisible(boolean value) {
        ((VisualTable)this.m_table).setStartVisible(this.m_row, value);
    }

    @Override
    public boolean isEndVisible() {
        return ((VisualTable)this.m_table).isEndVisible(this.m_row);
    }

    @Override
    public void setEndVisible(boolean value) {
        ((VisualTable)this.m_table).setEndVisible(this.m_row, value);
    }

    @Override
    public boolean isInteractive() {
        return ((VisualTable)this.m_table).isInteractive(this.m_row);
    }

    @Override
    public void setInteractive(boolean value) {
        ((VisualTable)this.m_table).setInteractive(this.m_row, value);
    }

    @Override
    public boolean isExpanded() {
        return ((VisualTable)this.m_table).isExpanded(this.m_row);
    }

    @Override
    public void setExpanded(boolean value) {
        ((VisualTable)this.m_table).setExpanded(this.m_row, value);
    }

    @Override
    public boolean isFixed() {
        return ((VisualTable)this.m_table).isFixed(this.m_row);
    }

    @Override
    public void setFixed(boolean value) {
        ((VisualTable)this.m_table).setFixed(this.m_row, value);
    }

    @Override
    public boolean isHighlighted() {
        return ((VisualTable)this.m_table).isHighlighted(this.m_row);
    }

    @Override
    public void setHighlighted(boolean value) {
        ((VisualTable)this.m_table).setHighlighted(this.m_row, value);
    }

    @Override
    public boolean isHover() {
        return ((VisualTable)this.m_table).isHover(this.m_row);
    }

    @Override
    public void setHover(boolean value) {
        ((VisualTable)this.m_table).setHover(this.m_row, value);
    }

    @Override
    public double getX() {
        return ((VisualTable)this.m_table).getX(this.m_row);
    }

    @Override
    public void setX(double x) {
        ((VisualTable)this.m_table).setX(this.m_row, x);
    }

    @Override
    public double getY() {
        return ((VisualTable)this.m_table).getY(this.m_row);
    }

    @Override
    public void setY(double y) {
        ((VisualTable)this.m_table).setY(this.m_row, y);
    }

    @Override
    public double getStartX() {
        return ((VisualTable)this.m_table).getStartX(this.m_row);
    }

    @Override
    public void setStartX(double x) {
        ((VisualTable)this.m_table).setStartX(this.m_row, x);
    }

    @Override
    public double getStartY() {
        return ((VisualTable)this.m_table).getStartY(this.m_row);
    }

    @Override
    public void setStartY(double y) {
        ((VisualTable)this.m_table).setStartY(this.m_row, y);
    }

    @Override
    public double getEndX() {
        return ((VisualTable)this.m_table).getEndX(this.m_row);
    }

    @Override
    public void setEndX(double x) {
        ((VisualTable)this.m_table).setEndX(this.m_row, x);
    }

    @Override
    public double getEndY() {
        return ((VisualTable)this.m_table).getEndY(this.m_row);
    }

    @Override
    public void setEndY(double y) {
        ((VisualTable)this.m_table).setEndY(this.m_row, y);
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.isValidated()) {
            return this.validateBounds();
        }
        return ((VisualTable)this.m_table).getBounds(this.m_row);
    }

    @Override
    public void setBounds(double x, double y, double w, double h) {
        ((VisualTable)this.m_table).setBounds(this.m_row, x, y, w, h);
    }

    @Override
    public int getStrokeColor() {
        return ((VisualTable)this.m_table).getStrokeColor(this.m_row);
    }

    @Override
    public void setStrokeColor(int color) {
        ((VisualTable)this.m_table).setStrokeColor(this.m_row, color);
    }

    @Override
    public int getStartStrokeColor() {
        return ((VisualTable)this.m_table).getStartStrokeColor(this.m_row);
    }

    @Override
    public void setStartStrokeColor(int color) {
        ((VisualTable)this.m_table).setStartStrokeColor(this.m_row, color);
    }

    @Override
    public int getEndStrokeColor() {
        return ((VisualTable)this.m_table).getEndStrokeColor(this.m_row);
    }

    @Override
    public void setEndStrokeColor(int color) {
        ((VisualTable)this.m_table).setEndStrokeColor(this.m_row, color);
    }

    @Override
    public int getFillColor() {
        return ((VisualTable)this.m_table).getFillColor(this.m_row);
    }

    @Override
    public void setFillColor(int color) {
        ((VisualTable)this.m_table).setFillColor(this.m_row, color);
    }

    @Override
    public int getStartFillColor() {
        return ((VisualTable)this.m_table).getStartFillColor(this.m_row);
    }

    @Override
    public void setStartFillColor(int color) {
        ((VisualTable)this.m_table).setStartFillColor(this.m_row, color);
    }

    @Override
    public int getEndFillColor() {
        return ((VisualTable)this.m_table).getEndFillColor(this.m_row);
    }

    @Override
    public void setEndFillColor(int color) {
        ((VisualTable)this.m_table).setEndFillColor(this.m_row, color);
    }

    @Override
    public int getTextColor() {
        return ((VisualTable)this.m_table).getTextColor(this.m_row);
    }

    @Override
    public void setTextColor(int color) {
        ((VisualTable)this.m_table).setTextColor(this.m_row, color);
    }

    @Override
    public int getStartTextColor() {
        return ((VisualTable)this.m_table).getStartTextColor(this.m_row);
    }

    @Override
    public void setStartTextColor(int color) {
        ((VisualTable)this.m_table).setStartTextColor(this.m_row, color);
    }

    @Override
    public int getEndTextColor() {
        return ((VisualTable)this.m_table).getEndTextColor(this.m_row);
    }

    @Override
    public void setEndTextColor(int color) {
        ((VisualTable)this.m_table).setEndTextColor(this.m_row, color);
    }

    @Override
    public double getSize() {
        return ((VisualTable)this.m_table).getSize(this.m_row);
    }

    @Override
    public void setSize(double size) {
        ((VisualTable)this.m_table).setSize(this.m_row, size);
    }

    @Override
    public double getStartSize() {
        return ((VisualTable)this.m_table).getStartSize(this.m_row);
    }

    @Override
    public void setStartSize(double size) {
        ((VisualTable)this.m_table).setStartSize(this.m_row, size);
    }

    @Override
    public double getEndSize() {
        return ((VisualTable)this.m_table).getEndSize(this.m_row);
    }

    @Override
    public void setEndSize(double size) {
        ((VisualTable)this.m_table).setEndSize(this.m_row, size);
    }

    @Override
    public int getShape() {
        return ((VisualTable)this.m_table).getShape(this.m_row);
    }

    @Override
    public void setShape(int shape) {
        ((VisualTable)this.m_table).setShape(this.m_row, shape);
    }

    @Override
    public BasicStroke getStroke() {
        return ((VisualTable)this.m_table).getStroke(this.m_row);
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        ((VisualTable)this.m_table).setStroke(this.m_row, stroke);
    }

    @Override
    public Font getFont() {
        return ((VisualTable)this.m_table).getFont(this.m_row);
    }

    @Override
    public void setFont(Font font) {
        ((VisualTable)this.m_table).setFont(this.m_row, font);
    }

    @Override
    public Font getStartFont() {
        return ((VisualTable)this.m_table).getStartFont(this.m_row);
    }

    @Override
    public void setStartFont(Font font) {
        ((VisualTable)this.m_table).setStartFont(this.m_row, font);
    }

    @Override
    public Font getEndFont() {
        return ((VisualTable)this.m_table).getEndFont(this.m_row);
    }

    @Override
    public void setEndFont(Font font) {
        ((VisualTable)this.m_table).setEndFont(this.m_row, font);
    }

    @Override
    public double getDOI() {
        return ((VisualTable)this.m_table).getDOI(this.m_row);
    }

    @Override
    public void setDOI(double doi) {
        ((VisualTable)this.m_table).setDOI(this.m_row, doi);
    }
}

