/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.test.MiniCluster;
import org.junit.After;
import org.junit.Before;

public abstract class PigExecTestCase
extends TestCase {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ExecType execType = ExecType.LOCAL;
    protected MiniCluster cluster;
    protected PigServer pigServer;

    @Before
    protected void setUp() throws Exception {
        String execTypeString = System.getProperty("test.exectype");
        if (execTypeString != null && execTypeString.length() > 0) {
            this.execType = PigServer.parseExecType((String)execTypeString);
        }
        if (this.execType == ExecType.MAPREDUCE) {
            this.cluster = MiniCluster.buildCluster();
            this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        } else {
            this.pigServer = new PigServer(ExecType.LOCAL);
        }
    }

    @After
    protected void tearDown() throws Exception {
        this.pigServer.shutdown();
    }
}

