/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestBatchAliases
extends TestCase {
    private static final MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer myPig;

    @Before
    public void setUp() throws Exception {
        cluster.setProperty("opt.multiquery", "true");
        this.myPig = new PigServer(ExecType.MAPREDUCE, cluster.getProperties());
        this.deleteOutputFiles();
    }

    @After
    public void tearDown() throws Exception {
        this.myPig = null;
        Util.deleteFile(cluster, "passwd");
    }

    @Test
    public void testBatchAliases() throws IOException {
        Util.copyFromLocalToCluster(cluster, "test/org/apache/pig/test/data/passwd", "passwd");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int, gid:int);");
            this.myPig.registerQuery("b = group a by uid;");
            this.myPig.registerQuery("c = group a by gid;");
            this.myPig.registerQuery("d = foreach b generate SUM(a.gid);");
            this.myPig.registerQuery("e = foreach c generate group, COUNT(a);");
            this.myPig.registerQuery("store d into '/tmp/output1';");
            this.myPig.registerQuery("store e into '/tmp/output2';");
            List jobs = this.myPig.executeBatch();
            boolean foundD = false;
            boolean foundE = false;
            for (ExecJob job : jobs) {
                TestBatchAliases.assertTrue((job.getStatus() == ExecJob.JOB_STATUS.COMPLETED ? 1 : 0) != 0);
                foundD = foundD || "d".equals(job.getAlias());
                foundE = foundE || "e".equals(job.getAlias());
            }
            TestBatchAliases.assertTrue((boolean)foundD);
            TestBatchAliases.assertTrue((boolean)foundE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void deleteOutputFiles() {
        try {
            FileLocalizer.delete((String)"/tmp/output1", (PigContext)this.myPig.getPigContext());
            FileLocalizer.delete((String)"/tmp/output2", (PigContext)this.myPig.getPigContext());
            FileLocalizer.delete((String)"/tmp/output3", (PigContext)this.myPig.getPigContext());
            FileLocalizer.delete((String)"/tmp/output4", (PigContext)this.myPig.getPigContext());
            FileLocalizer.delete((String)"/tmp/output5", (PigContext)this.myPig.getPigContext());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

