/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.builtin.ARITY;
import org.apache.pig.builtin.BagSize;
import org.apache.pig.builtin.CONCAT;
import org.apache.pig.builtin.COUNT;
import org.apache.pig.builtin.COUNT_STAR;
import org.apache.pig.builtin.DIFF;
import org.apache.pig.builtin.Distinct;
import org.apache.pig.builtin.MapSize;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.builtin.SIZE;
import org.apache.pig.builtin.StringConcat;
import org.apache.pig.builtin.StringSize;
import org.apache.pig.builtin.TOKENIZE;
import org.apache.pig.builtin.TextLoader;
import org.apache.pig.builtin.TupleSize;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBuiltin
extends TestCase {
    private String initString = "mapreduce";
    MiniCluster cluster = MiniCluster.buildCluster();
    PigServer pigServer;
    TupleFactory tupleFactory = DefaultTupleFactory.getInstance();
    BagFactory bagFactory = DefaultBagFactory.getInstance();
    private static Integer[] intInput = new Integer[]{3, 1, 2, 4, 5, 7, null, 6, 8, 9, 10};
    private static Long[] intAsLong = new Long[]{3L, 1L, 2L, 4L, 5L, 7L, null, 6L, 8L, 9L, 10L};
    private static Long[] longInput = new Long[]{145769183483345L, null, 4345639849L, 3435543121L, 2L, 5L, 9L, 7L, 8L, 6L, 10L};
    private static Float[] floatInput = new Float[]{Float.valueOf(10.4f), Float.valueOf(2.35f), Float.valueOf(3.099f), null, Float.valueOf(4.08495f), Float.valueOf(5.35f), Float.valueOf(6.78f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(0.09f)};
    private static Double[] floatAsDouble = new Double[]{10.4, 2.35, 3.099, null, 4.08495, 5.35, 6.78, 7.0, 8.0, 9.0, 0.09};
    private static Double[] doubleInput = new Double[]{5.567391, 121.0, 3.0, 8.34593E-7, 1.0, 6.0, 7.0, 8.0, 9.0, 10.0, null};
    private static String[] ba = new String[]{"7", "2", "3", null, "4", "5", "6", "1", "8", "9", "10"};
    private static Double[] baAsDouble = new Double[]{7.0, 2.0, 3.0, null, 4.0, 5.0, 6.0, 1.0, 8.0, 9.0, 10.0};
    private static String[] stringInput = new String[]{"unit", "test", null, "input", "string"};
    private static DataByteArray[] ByteArrayInput = Util.toDataByteArrays(ba);
    private static HashMap<String, EvalFunc<?>> evalFuncMap = new HashMap();
    private static HashMap<String, Tuple> inputMap = new HashMap();
    private static HashMap<String, String> allowedInput = new HashMap();
    private static HashMap<String, Object> expectedMap = new HashMap();
    String[] stages = new String[]{"Initial", "Intermediate", "Final"};
    String[][] aggs = new String[][]{{"SUM", "IntSum", "LongSum", "FloatSum", "DoubleSum"}, {"AVG", "IntAvg", "LongAvg", "FloatAvg", "DoubleAvg"}, {"MIN", "IntMin", "LongMin", "FloatMin", "DoubleMin", "StringMin"}, {"MAX", "IntMax", "LongMax", "FloatMax", "DoubleMax", "StringMax"}, {"COUNT"}};
    String[] inputTypeAsString = new String[]{"ByteArray", "Integer", "Long", "Float", "Double", "String"};

    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.setupEvalFuncMap();
        expectedMap.put("SUM", new Double(55.0));
        expectedMap.put("DoubleSum", new Double(170.567391834593));
        expectedMap.put("IntSum", new Long(55L));
        expectedMap.put("LongSum", new Long(145776964666362L));
        expectedMap.put("FloatSum", new Double(56.15395));
        expectedMap.put("AVG", new Double(5.5));
        expectedMap.put("DoubleAvg", new Double(17.0567391834593));
        expectedMap.put("LongAvg", new Double(1.45776964666362E13));
        expectedMap.put("IntAvg", new Double(5.5));
        expectedMap.put("FloatAvg", new Double(5.615394958853722));
        expectedMap.put("MIN", new Double(1.0));
        expectedMap.put("IntMin", new Integer(1));
        expectedMap.put("LongMin", new Long(2L));
        expectedMap.put("FloatMin", new Float(0.09f));
        expectedMap.put("DoubleMin", new Double(8.34593E-7));
        expectedMap.put("StringMin", "input");
        expectedMap.put("MAX", new Double(10.0));
        expectedMap.put("IntMax", new Integer(10));
        expectedMap.put("LongMax", new Long(145769183483345L));
        expectedMap.put("FloatMax", new Float(10.4f));
        expectedMap.put("DoubleMax", new Double(121.0));
        expectedMap.put("StringMax", "unit");
        expectedMap.put("COUNT", new Long(10L));
        for (String[] aggGroups : this.aggs) {
            int i = 0;
            for (String agg : aggGroups) {
                allowedInput.put(agg, this.inputTypeAsString[i++]);
            }
        }
        String[][] arr$ = this.aggs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] aggGroups;
            for (String agg : aggGroups = arr$[i$]) {
                for (String stage : this.stages) {
                    if (stage.equals("Initial")) {
                        allowedInput.put(agg + stage, allowedInput.get(agg));
                        continue;
                    }
                    if (agg.equals("IntSum") || agg.equals("IntAvg")) {
                        allowedInput.put(agg + stage, "IntegerAsLong");
                    } else if (agg.equals("FloatSum") || agg.equals("FloatAvg")) {
                        allowedInput.put(agg + stage, "FloatAsDouble");
                    } else if (agg.equals("MIN") || agg.equals("MAX") || agg.equals("SUM") || agg.equals("AVG")) {
                        allowedInput.put(agg + stage, "ByteArrayAsDouble");
                    } else {
                        allowedInput.put(agg + stage, allowedInput.get(agg));
                    }
                    if (agg.matches("(?i)avg") && !stage.equals("Final")) continue;
                    expectedMap.put(agg + stage, expectedMap.get(agg));
                }
            }
        }
        expectedMap.put("AVGIntermediate", expectedMap.get("SUM"));
        expectedMap.put("DoubleAvgIntermediate", expectedMap.get("DoubleSum"));
        expectedMap.put("LongAvgIntermediate", expectedMap.get("LongSum"));
        expectedMap.put("IntAvgIntermediate", expectedMap.get("IntSum"));
        expectedMap.put("FloatAvgIntermediate", expectedMap.get("FloatSum"));
        try {
            inputMap.put("Integer", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), intInput));
            inputMap.put("IntegerAsLong", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), intAsLong));
            inputMap.put("Long", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), longInput));
            inputMap.put("Float", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), floatInput));
            inputMap.put("FloatAsDouble", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), floatAsDouble));
            inputMap.put("Double", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), doubleInput));
            inputMap.put("ByteArray", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), ByteArrayInput));
            inputMap.put("ByteArrayAsDouble", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), baAsDouble));
            inputMap.put("String", Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), stringInput));
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
    }

    private void setupEvalFuncMap() {
        String[][] arr$ = this.aggs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] aggGroup;
            for (String agg : aggGroup = arr$[i$]) {
                EvalFunc func = (EvalFunc)PigContext.instantiateFuncFromSpec((String)agg);
                evalFuncMap.put(agg, func);
                evalFuncMap.put(agg + "Initial", (EvalFunc)PigContext.instantiateFuncFromSpec((String)((Algebraic)func).getInitial()));
                evalFuncMap.put(agg + "Intermediate", (EvalFunc)PigContext.instantiateFuncFromSpec((String)((Algebraic)func).getIntermed()));
                evalFuncMap.put(agg + "Final", (EvalFunc)PigContext.instantiateFuncFromSpec((String)((Algebraic)func).getFinal()));
            }
        }
    }

    @Test
    public void testAggNoCombine() throws Exception {
        for (String[] aggGroup : this.aggs) {
            String[] aggFinalTypes = null;
            String[] aggInitialTypes = null;
            for (String stage : this.stages) {
                String[] aggTypesArray = null;
                if (stage.equals("Initial")) {
                    aggTypesArray = aggInitialTypes = new String[aggGroup.length];
                } else {
                    if (!stage.equals("Final")) continue;
                    aggFinalTypes = new String[aggGroup.length];
                    aggTypesArray = aggFinalTypes;
                }
                for (int i = 0; i < aggTypesArray.length; ++i) {
                    aggTypesArray[i] = aggGroup[i] + stage;
                }
            }
            for (int k = 0; k < aggFinalTypes.length; ++k) {
                EvalFunc<?> avgInitial = evalFuncMap.get(aggInitialTypes[k]);
                Tuple tup = inputMap.get(TestBuiltin.getInputType(aggInitialTypes[k]));
                DataBag bg = (DataBag)tup.get(0);
                DataBag finalInputBg = this.bagFactory.newDefaultBag();
                for (Tuple tuple : bg) {
                    DataBag initialInputBg = this.bagFactory.newDefaultBag();
                    initialInputBg.add(tuple);
                    Tuple initialInputTuple = this.tupleFactory.newTuple((Object)initialInputBg);
                    finalInputBg.add((Tuple)avgInitial.exec(initialInputTuple));
                }
                Tuple finalInputTuple = this.tupleFactory.newTuple((Object)finalInputBg);
                EvalFunc<?> aggFinal = evalFuncMap.get(aggFinalTypes[k]);
                String msg = "[Testing " + aggGroup[k] + " on input type: " + TestBuiltin.getInputType(aggFinalTypes[k]);
                System.err.println(msg + " for no combiner case]");
                Object output = aggFinal.exec(finalInputTuple);
                msg = msg + " ( (output) " + output + " == " + this.getExpected(aggFinalTypes[k]) + " (expected) )]";
                if (this.getExpected(aggFinalTypes[k]) instanceof Double) {
                    TestBuiltin.assertEquals((String)msg, (double)((Double)this.getExpected(aggFinalTypes[k])), (double)((Double)output), (double)1.0E-5);
                    continue;
                }
                TestBuiltin.assertEquals((String)msg, (Object)this.getExpected(aggFinalTypes[k]), (Object)output);
            }
        }
    }

    @Test
    public void testAggSingleCombine() throws Exception {
        for (String[] aggGroup : this.aggs) {
            String[] aggFinalTypes = null;
            String[] aggInitialTypes = null;
            String[] aggIntermediateTypes = null;
            for (String stage : this.stages) {
                String[] aggTypesArray = null;
                if (stage.equals("Initial")) {
                    aggTypesArray = aggInitialTypes = new String[aggGroup.length];
                } else if (stage.equals("Intermediate")) {
                    aggIntermediateTypes = new String[aggGroup.length];
                    aggTypesArray = aggIntermediateTypes;
                } else {
                    aggFinalTypes = new String[aggGroup.length];
                    aggTypesArray = aggFinalTypes;
                }
                for (int i = 0; i < aggTypesArray.length; ++i) {
                    aggTypesArray[i] = aggGroup[i] + stage;
                }
            }
            for (int k = 0; k < aggFinalTypes.length; ++k) {
                EvalFunc<?> aggInitial = evalFuncMap.get(aggInitialTypes[k]);
                Tuple tup = inputMap.get(TestBuiltin.getInputType(aggInitialTypes[k]));
                DataBag bg = (DataBag)tup.get(0);
                DataBag intermediateInputBg1 = this.bagFactory.newDefaultBag();
                DataBag intermediateInputBg2 = this.bagFactory.newDefaultBag();
                int i = 0;
                for (Tuple tuple : bg) {
                    DataBag initialInputBg = this.bagFactory.newDefaultBag();
                    initialInputBg.add(tuple);
                    Tuple initialInputTuple = this.tupleFactory.newTuple((Object)initialInputBg);
                    if ((long)i < bg.size() / 2L) {
                        intermediateInputBg1.add((Tuple)aggInitial.exec(initialInputTuple));
                    } else {
                        intermediateInputBg2.add((Tuple)aggInitial.exec(initialInputTuple));
                    }
                    ++i;
                }
                EvalFunc<?> avgIntermediate = evalFuncMap.get(aggIntermediateTypes[k]);
                DataBag finalInputBg = this.bagFactory.newDefaultBag();
                Tuple intermediateInputTuple = this.tupleFactory.newTuple((Object)intermediateInputBg1);
                finalInputBg.add((Tuple)avgIntermediate.exec(intermediateInputTuple));
                intermediateInputTuple = this.tupleFactory.newTuple((Object)intermediateInputBg2);
                finalInputBg.add((Tuple)avgIntermediate.exec(intermediateInputTuple));
                Tuple finalInputTuple = this.tupleFactory.newTuple((Object)finalInputBg);
                EvalFunc<?> aggFinal = evalFuncMap.get(aggFinalTypes[k]);
                String msg = "[Testing " + aggGroup[k] + " on input type: " + TestBuiltin.getInputType(aggFinalTypes[k]);
                System.err.println(msg + " for single combiner case]");
                Object output = aggFinal.exec(finalInputTuple);
                msg = msg + " ( (output) " + output + " == " + this.getExpected(aggFinalTypes[k]) + " (expected) )]";
                if (this.getExpected(aggFinalTypes[k]) instanceof Double) {
                    TestBuiltin.assertEquals((String)msg, (double)((Double)this.getExpected(aggFinalTypes[k])), (double)((Double)output), (double)1.0E-5);
                    continue;
                }
                TestBuiltin.assertEquals((String)msg, (Object)this.getExpected(aggFinalTypes[k]), (Object)output);
            }
        }
    }

    @Test
    public void testAggMultipleCombine() throws Exception {
        for (String[] aggGroup : this.aggs) {
            String[] aggFinalTypes = null;
            String[] aggInitialTypes = null;
            String[] aggIntermediateTypes = null;
            for (String stage : this.stages) {
                String[] aggTypesArray = null;
                if (stage.equals("Initial")) {
                    aggTypesArray = aggInitialTypes = new String[aggGroup.length];
                } else if (stage.equals("Intermediate")) {
                    aggIntermediateTypes = new String[aggGroup.length];
                    aggTypesArray = aggIntermediateTypes;
                } else {
                    aggFinalTypes = new String[aggGroup.length];
                    aggTypesArray = aggFinalTypes;
                }
                for (int i = 0; i < aggTypesArray.length; ++i) {
                    aggTypesArray[i] = aggGroup[i] + stage;
                }
            }
            for (int k = 0; k < aggFinalTypes.length; ++k) {
                int i;
                EvalFunc<?> aggInitial = evalFuncMap.get(aggInitialTypes[k]);
                Tuple tup = inputMap.get(TestBuiltin.getInputType(aggInitialTypes[k]));
                DataBag bg = (DataBag)tup.get(0);
                DataBag[] mapIntermediateInputBgs = new DataBag[4];
                for (int i2 = 0; i2 < mapIntermediateInputBgs.length; ++i2) {
                    mapIntermediateInputBgs[i2] = this.bagFactory.newDefaultBag();
                }
                Iterator it = bg.iterator();
                for (int i3 = 0; i3 < 4; ++i3) {
                    int j = 0;
                    while ((long)j < bg.size() / 4L) {
                        DataBag initialInputBg = this.bagFactory.newDefaultBag();
                        initialInputBg.add((Tuple)it.next());
                        Tuple initialInputTuple = this.tupleFactory.newTuple((Object)initialInputBg);
                        mapIntermediateInputBgs[i3].add((Tuple)aggInitial.exec(initialInputTuple));
                        ++j;
                    }
                    if (i3 != 3) continue;
                    while (it.hasNext()) {
                        DataBag initialInputBg = this.bagFactory.newDefaultBag();
                        initialInputBg.add((Tuple)it.next());
                        Tuple initialInputTuple = this.tupleFactory.newTuple((Object)initialInputBg);
                        mapIntermediateInputBgs[i3].add((Tuple)aggInitial.exec(initialInputTuple));
                    }
                }
                EvalFunc<?> aggIntermediate = evalFuncMap.get(aggIntermediateTypes[k]);
                DataBag[] reduceIntermediateInputBgs = new DataBag[2];
                for (i = 0; i < reduceIntermediateInputBgs.length; ++i) {
                    reduceIntermediateInputBgs[i] = this.bagFactory.newDefaultBag();
                }
                for (i = 0; i < 4; ++i) {
                    Tuple intermediateInputTuple = this.tupleFactory.newTuple((Object)mapIntermediateInputBgs[i]);
                    if (i < 2) {
                        reduceIntermediateInputBgs[0].add((Tuple)aggIntermediate.exec(intermediateInputTuple));
                        continue;
                    }
                    reduceIntermediateInputBgs[1].add((Tuple)aggIntermediate.exec(intermediateInputTuple));
                }
                DataBag finalInputBag = this.bagFactory.newDefaultBag();
                for (int i4 = 0; i4 < 2; ++i4) {
                    Tuple intermediateInputTuple = this.tupleFactory.newTuple((Object)reduceIntermediateInputBgs[i4]);
                    finalInputBag.add((Tuple)aggIntermediate.exec(intermediateInputTuple));
                }
                Tuple finalInputTuple = this.tupleFactory.newTuple((Object)finalInputBag);
                EvalFunc<?> aggFinal = evalFuncMap.get(aggFinalTypes[k]);
                String msg = "[Testing " + aggGroup[k] + " on input type: " + TestBuiltin.getInputType(aggFinalTypes[k]);
                System.err.println(msg + " for multiple combiner case]");
                Object output = aggFinal.exec(finalInputTuple);
                msg = msg + " ( (output) " + output + " == " + this.getExpected(aggFinalTypes[k]) + " (expected) )]";
                if (this.getExpected(aggFinalTypes[k]) instanceof Double) {
                    TestBuiltin.assertEquals((String)msg, (double)((Double)this.getExpected(aggFinalTypes[k])), (double)((Double)output), (double)1.0E-5);
                    continue;
                }
                TestBuiltin.assertEquals((String)msg, (Object)this.getExpected(aggFinalTypes[k]), (Object)output);
            }
        }
    }

    @Test
    public void testAggEmptyBagWithCombiner() throws Exception {
        for (String[] aggGroup : this.aggs) {
            String[] aggFinalTypes = null;
            String[] aggInitialTypes = null;
            String[] aggIntermediateTypes = null;
            for (String stage : this.stages) {
                String[] aggTypesArray = null;
                if (stage.equals("Initial")) {
                    aggTypesArray = aggInitialTypes = new String[aggGroup.length];
                } else if (stage.equals("Intermediate")) {
                    aggIntermediateTypes = new String[aggGroup.length];
                    aggTypesArray = aggIntermediateTypes;
                } else {
                    aggFinalTypes = new String[aggGroup.length];
                    aggTypesArray = aggFinalTypes;
                }
                for (int i = 0; i < aggTypesArray.length; ++i) {
                    aggTypesArray[i] = aggGroup[i] + stage;
                }
            }
            for (int k = 0; k < aggFinalTypes.length; ++k) {
                EvalFunc<?> aggInitial = evalFuncMap.get(aggInitialTypes[k]);
                DataBag intermediateInputBg1 = this.bagFactory.newDefaultBag();
                DataBag intermediateInputBg2 = this.bagFactory.newDefaultBag();
                Tuple outputTuple = null;
                for (int i = 0; i < 10; ++i) {
                    DataBag initialInputBg = this.bagFactory.newDefaultBag();
                    Tuple initialInputTuple = this.tupleFactory.newTuple((Object)initialInputBg);
                    if (i < 5) {
                        outputTuple = (Tuple)aggInitial.exec(initialInputTuple);
                        this.checkZeroOrNull(aggInitial, outputTuple.get(0));
                        intermediateInputBg1.add(outputTuple);
                        continue;
                    }
                    outputTuple = (Tuple)aggInitial.exec(initialInputTuple);
                    this.checkZeroOrNull(aggInitial, outputTuple.get(0));
                    intermediateInputBg2.add(outputTuple);
                }
                EvalFunc<?> aggIntermediate = evalFuncMap.get(aggIntermediateTypes[k]);
                DataBag finalInputBg = this.bagFactory.newDefaultBag();
                Tuple intermediateInputTuple = this.tupleFactory.newTuple((Object)intermediateInputBg1);
                outputTuple = (Tuple)aggIntermediate.exec(intermediateInputTuple);
                this.checkZeroOrNull(aggIntermediate, outputTuple.get(0));
                finalInputBg.add(outputTuple);
                intermediateInputTuple = this.tupleFactory.newTuple((Object)intermediateInputBg2);
                outputTuple = (Tuple)aggIntermediate.exec(intermediateInputTuple);
                this.checkZeroOrNull(aggIntermediate, outputTuple.get(0));
                finalInputBg.add(outputTuple);
                Tuple finalInputTuple = this.tupleFactory.newTuple((Object)finalInputBg);
                EvalFunc<?> aggFinal = evalFuncMap.get(aggFinalTypes[k]);
                Object output = aggFinal.exec(finalInputTuple);
                this.checkZeroOrNull(aggFinal, output);
            }
        }
    }

    @Test
    public void testAggEmptyBag() throws Exception {
        for (String[] aggGroup : this.aggs) {
            for (int k = 0; k < aggGroup.length; ++k) {
                EvalFunc<?> agg = evalFuncMap.get(aggGroup[k]);
                DataBag inputBag = this.bagFactory.newDefaultBag();
                Tuple inputTuple = this.tupleFactory.newTuple((Object)inputBag);
                Object output = agg.exec(inputTuple);
                this.checkZeroOrNull(agg, output);
            }
        }
    }

    private void checkZeroOrNull(EvalFunc<?> func, Object output) {
        if (func.getClass().getName().contains("COUNT")) {
            TestBuiltin.assertEquals((Object)new Long(0L), (Object)output);
        } else {
            TestBuiltin.assertEquals(null, (Object)output);
        }
    }

    @Test
    public void testAVG() throws Exception {
        String[] avgTypes = new String[]{"AVG", "DoubleAvg", "LongAvg", "IntAvg", "FloatAvg"};
        for (int k = 0; k < avgTypes.length; ++k) {
            EvalFunc<?> avg = evalFuncMap.get(avgTypes[k]);
            Tuple tup = inputMap.get(TestBuiltin.getInputType(avgTypes[k]));
            Object output = avg.exec(tup);
            String msg = "[Testing " + avgTypes[k] + " on input type: " + TestBuiltin.getInputType(avgTypes[k]) + " ( (output) " + output + " == " + this.getExpected(avgTypes[k]) + " (expected) )]";
            TestBuiltin.assertEquals((String)msg, (double)((Double)output), (double)((Double)this.getExpected(avgTypes[k])), (double)1.0E-5);
        }
    }

    @Test
    public void testAVGIntermediate() throws Exception {
        String[] avgTypes = new String[]{"AVGIntermediate", "DoubleAvgIntermediate", "LongAvgIntermediate", "IntAvgIntermediate", "FloatAvgIntermediate"};
        for (int k = 0; k < avgTypes.length; ++k) {
            String msg;
            EvalFunc<?> avg = evalFuncMap.get(avgTypes[k]);
            String inputType = TestBuiltin.getInputType(avgTypes[k]);
            Tuple tup = inputMap.get(inputType);
            DataBag bag = (DataBag)tup.get(0);
            DataBag bg = this.bagFactory.newDefaultBag();
            for (Tuple t : bag) {
                Tuple newTuple = this.tupleFactory.newTuple(2);
                newTuple.set(0, t.get(0));
                newTuple.set(1, (Object)new Long(1L));
                bg.add(newTuple);
            }
            Tuple intermediateInput = this.tupleFactory.newTuple();
            intermediateInput.append((Object)bg);
            Object output = avg.exec(intermediateInput);
            if (inputType == "Long" || inputType == "Integer" || inputType == "IntegerAsLong") {
                Long l = (Long)((Tuple)output).get(0);
                msg = "[Testing " + avgTypes[k] + " on input type: " + TestBuiltin.getInputType(avgTypes[k]) + " ( (output) " + l + " == " + this.getExpected(avgTypes[k]) + " (expected) )]";
                TestBuiltin.assertEquals((String)msg, (Object)((Long)this.getExpected(avgTypes[k])), (Object)l);
            } else {
                Double f1 = (Double)((Tuple)output).get(0);
                msg = "[Testing " + avgTypes[k] + " on input type: " + TestBuiltin.getInputType(avgTypes[k]) + " ( (output) " + f1 + " == " + this.getExpected(avgTypes[k]) + " (expected) )]";
                TestBuiltin.assertEquals((String)msg, (double)((Double)this.getExpected(avgTypes[k])), (double)f1, (double)1.0E-5);
            }
            Long f2 = (Long)((Tuple)output).get(1);
            TestBuiltin.assertEquals((String)("[Testing " + avgTypes[k] + " on input type: " + inputType + "]Expected count to be 11"), (long)11L, (long)f2);
        }
    }

    @Test
    public void testAVGFinal() throws Exception {
        String[] avgTypes = new String[]{"AVGFinal", "DoubleAvgFinal", "LongAvgFinal", "IntAvgFinal", "FloatAvgFinal"};
        String[] avgIntermediateTypes = new String[]{"AVGIntermediate", "DoubleAvgIntermediate", "LongAvgIntermediate", "IntAvgIntermediate", "FloatAvgIntermediate"};
        for (int k = 0; k < avgTypes.length; ++k) {
            EvalFunc<?> avg = evalFuncMap.get(avgTypes[k]);
            Tuple tup = inputMap.get(TestBuiltin.getInputType(avgTypes[k]));
            EvalFunc<?> avgIntermediate = evalFuncMap.get(avgIntermediateTypes[k]);
            DataBag bg = (DataBag)tup.get(0);
            DataBag bg1 = this.bagFactory.newDefaultBag();
            DataBag bg2 = this.bagFactory.newDefaultBag();
            int i = 0;
            for (Tuple t : bg) {
                Tuple newTuple = this.tupleFactory.newTuple(2);
                newTuple.set(0, t.get(0));
                if (t.get(0) == null) {
                    newTuple.set(1, (Object)new Long(0L));
                } else {
                    newTuple.set(1, (Object)new Long(1L));
                }
                if (i < 5) {
                    bg1.add(newTuple);
                } else {
                    bg2.add(newTuple);
                }
                ++i;
            }
            Tuple intermediateInput1 = this.tupleFactory.newTuple();
            intermediateInput1.append((Object)bg1);
            Object output1 = avgIntermediate.exec(intermediateInput1);
            Tuple intermediateInput2 = this.tupleFactory.newTuple();
            intermediateInput2.append((Object)bg2);
            Object output2 = avgIntermediate.exec(intermediateInput2);
            DataBag bag = Util.createBag(new Tuple[]{(Tuple)output1, (Tuple)output2});
            Tuple finalTuple = TupleFactory.getInstance().newTuple(1);
            finalTuple.set(0, (Object)bag);
            Object output = avg.exec(finalTuple);
            String msg = "[Testing " + avgTypes[k] + " on input type: " + TestBuiltin.getInputType(avgTypes[k]) + " ( (output) " + output + " == " + this.getExpected(avgTypes[k]) + " (expected) )]";
            TestBuiltin.assertEquals((String)msg, (double)((Double)this.getExpected(avgTypes[k])), (double)((Double)output), (double)1.0E-5);
        }
    }

    @Test
    public void testCOUNT() throws Exception {
        Integer[] input = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, null};
        long expected = input.length - 1;
        COUNT count = new COUNT();
        Tuple tup = Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), input);
        Long output = (Long)count.exec(tup);
        TestBuiltin.assertTrue((output == expected ? 1 : 0) != 0);
    }

    @Test
    public void testCOUNTIntermed() throws Exception {
        Integer[] input = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        DataBag intermediateInputBag = this.bagFactory.newDefaultBag();
        for (Integer i : input) {
            Tuple t = this.tupleFactory.newTuple((Object)i);
            DataBag b = this.bagFactory.newDefaultBag();
            b.add(t);
            Tuple initialInput = this.tupleFactory.newTuple((Object)b);
            COUNT.Initial initial = new COUNT.Initial();
            intermediateInputBag.add((Tuple)initial.exec(initialInput));
        }
        COUNT.Intermediate countIntermed = new COUNT.Intermediate();
        Tuple intermediateInput = this.tupleFactory.newTuple((Object)intermediateInputBag);
        Tuple output = (Tuple)countIntermed.exec(intermediateInput);
        Long f1 = DataType.toLong((Object)output.get(0));
        TestBuiltin.assertEquals((String)"Expected count to be 10", (long)10L, (long)f1);
    }

    @Test
    public void testCOUNTFinal() throws Exception {
        long[] input = new long[]{23L, 38L, 39L};
        Tuple tup = Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), input);
        COUNT.Final count = new COUNT.Final();
        Long output = (Long)count.exec(tup);
        TestBuiltin.assertEquals((String)"Expected count to be 100", (long)100L, (long)output);
    }

    @Test
    public void testCOUNT_STAR() throws Exception {
        Integer[] input = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, null};
        long expected = input.length;
        COUNT_STAR count = new COUNT_STAR();
        Tuple tup = Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), input);
        Long output = (Long)count.exec(tup);
        TestBuiltin.assertTrue((output == expected ? 1 : 0) != 0);
    }

    @Test
    public void testCOUNT_STARIntermed() throws Exception {
        Integer[] input = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        DataBag intermediateInputBag = this.bagFactory.newDefaultBag();
        for (Integer i : input) {
            Tuple t = this.tupleFactory.newTuple((Object)i);
            DataBag b = this.bagFactory.newDefaultBag();
            b.add(t);
            Tuple initialInput = this.tupleFactory.newTuple((Object)b);
            COUNT_STAR.Initial initial = new COUNT_STAR.Initial();
            intermediateInputBag.add((Tuple)initial.exec(initialInput));
        }
        COUNT_STAR.Intermediate countIntermed = new COUNT_STAR.Intermediate();
        Tuple intermediateInput = this.tupleFactory.newTuple((Object)intermediateInputBag);
        Tuple output = (Tuple)countIntermed.exec(intermediateInput);
        Long f1 = DataType.toLong((Object)output.get(0));
        TestBuiltin.assertEquals((String)"Expected count to be 10", (long)10L, (long)f1);
    }

    @Test
    public void testCOUNT_STARFinal() throws Exception {
        long[] input = new long[]{23L, 38L, 39L};
        Tuple tup = Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), input);
        COUNT_STAR.Final count = new COUNT_STAR.Final();
        Long output = (Long)count.exec(tup);
        TestBuiltin.assertEquals((String)"Expected count to be 100", (long)100L, (long)output);
    }

    @Test
    public void testSUM() throws Exception {
        String[] sumTypes = new String[]{"SUM", "DoubleSum", "LongSum", "IntSum", "FloatSum"};
        for (int k = 0; k < sumTypes.length; ++k) {
            EvalFunc<?> sum = evalFuncMap.get(sumTypes[k]);
            String inputType = TestBuiltin.getInputType(sumTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = sum.exec(tup);
            String msg = "[Testing " + sumTypes[k] + " on input type: " + TestBuiltin.getInputType(sumTypes[k]) + " ( (output) " + output + " == " + this.getExpected(sumTypes[k]) + " (expected) )]";
            if (inputType == "Integer" || inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (double)((Long)output).longValue(), (double)((Long)this.getExpected(sumTypes[k])).longValue(), (double)1.0E-5);
                continue;
            }
            TestBuiltin.assertEquals((String)msg, (double)((Double)output), (double)((Double)this.getExpected(sumTypes[k])), (double)1.0E-5);
        }
    }

    @Test
    public void testSUMIntermed() throws Exception {
        String[] sumTypes = new String[]{"SUMIntermediate", "DoubleSumIntermediate", "LongSumIntermediate", "IntSumIntermediate", "FloatSumIntermediate"};
        for (int k = 0; k < sumTypes.length; ++k) {
            EvalFunc<?> sum = evalFuncMap.get(sumTypes[k]);
            String inputType = TestBuiltin.getInputType(sumTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = sum.exec(tup);
            String msg = "[Testing " + sumTypes[k] + " on input type: " + TestBuiltin.getInputType(sumTypes[k]) + " ( (output) " + ((Tuple)output).get(0) + " == " + this.getExpected(sumTypes[k]) + " (expected) )]";
            if (inputType.equals("Integer") || inputType.equals("Long") || inputType.equals("IntegerAsLong")) {
                TestBuiltin.assertEquals((String)msg, (double)((Long)((Tuple)output).get(0)).longValue(), (double)((Long)this.getExpected(sumTypes[k])).longValue(), (double)1.0E-5);
                continue;
            }
            TestBuiltin.assertEquals((String)msg, (double)((Double)((Tuple)output).get(0)), (double)((Double)this.getExpected(sumTypes[k])), (double)1.0E-5);
        }
    }

    @Test
    public void testSUMFinal() throws Exception {
        String[] sumTypes = new String[]{"SUMFinal", "DoubleSumFinal", "LongSumFinal", "IntSumFinal", "FloatSumFinal"};
        for (int k = 0; k < sumTypes.length; ++k) {
            EvalFunc<?> sum = evalFuncMap.get(sumTypes[k]);
            String inputType = TestBuiltin.getInputType(sumTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = sum.exec(tup);
            String msg = "[Testing " + sumTypes[k] + " on input type: " + TestBuiltin.getInputType(sumTypes[k]) + " ( (output) " + output + " == " + this.getExpected(sumTypes[k]) + " (expected) )]";
            if (inputType.equals("Integer") || inputType.equals("Long") || inputType.equals("IntegerAsLong")) {
                TestBuiltin.assertEquals((String)msg, (double)((Long)output).longValue(), (double)((Long)this.getExpected(sumTypes[k])).longValue(), (double)1.0E-5);
                continue;
            }
            TestBuiltin.assertEquals((String)msg, (double)((Double)output), (double)((Double)this.getExpected(sumTypes[k])), (double)1.0E-5);
        }
    }

    @Test
    public void testMIN() throws Exception {
        String[] minTypes = new String[]{"MIN", "LongMin", "IntMin", "FloatMin"};
        for (int k = 0; k < minTypes.length; ++k) {
            EvalFunc<?> min = evalFuncMap.get(minTypes[k]);
            String inputType = TestBuiltin.getInputType(minTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = min.exec(tup);
            String msg = "[Testing " + minTypes[k] + " on input type: " + TestBuiltin.getInputType(minTypes[k]) + " ( (output) " + output + " == " + this.getExpected(minTypes[k]) + " (expected) )]";
            if (inputType == "ByteArray") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (Object)((Long)output), (Object)((Long)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Integer") {
                TestBuiltin.assertEquals((String)msg, (Object)((Integer)output), (Object)((Integer)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Double") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Float") {
                TestBuiltin.assertEquals((String)msg, (Object)((Float)output), (Object)((Float)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType != "String") continue;
            TestBuiltin.assertEquals((String)msg, (String)((String)output), (String)((String)this.getExpected(minTypes[k])));
        }
    }

    @Test
    public void testMINIntermediate() throws Exception {
        String[] minTypes = new String[]{"MINIntermediate", "LongMinIntermediate", "IntMinIntermediate", "FloatMinIntermediate"};
        for (int k = 0; k < minTypes.length; ++k) {
            EvalFunc<?> min = evalFuncMap.get(minTypes[k]);
            String inputType = TestBuiltin.getInputType(minTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = min.exec(tup);
            String msg = "[Testing " + minTypes[k] + " on input type: " + TestBuiltin.getInputType(minTypes[k]) + " ( (output) " + ((Tuple)output).get(0) + " == " + this.getExpected(minTypes[k]) + " (expected) )]";
            if (inputType == "ByteArray") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)((Tuple)output).get(0)), (Object)((Double)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (Object)((Long)((Tuple)output).get(0)), (Object)((Long)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Integer") {
                TestBuiltin.assertEquals((String)msg, (Object)((Integer)((Tuple)output).get(0)), (Object)((Integer)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Double") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)((Tuple)output).get(0)), (Object)((Double)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Float") {
                TestBuiltin.assertEquals((String)msg, (Object)((Float)((Tuple)output).get(0)), (Object)((Float)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType != "String") continue;
            TestBuiltin.assertEquals((String)msg, (String)((String)((Tuple)output).get(0)), (String)((String)this.getExpected(minTypes[k])));
        }
    }

    @Test
    public void testMINFinal() throws Exception {
        String[] minTypes = new String[]{"MINFinal", "LongMinFinal", "IntMinFinal", "FloatMinFinal"};
        for (int k = 0; k < minTypes.length; ++k) {
            EvalFunc<?> min = evalFuncMap.get(minTypes[k]);
            String inputType = TestBuiltin.getInputType(minTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = min.exec(tup);
            String msg = "[Testing " + minTypes[k] + " on input type: " + TestBuiltin.getInputType(minTypes[k]) + " ( (output) " + output + " == " + this.getExpected(minTypes[k]) + " (expected) )]";
            if (inputType == "ByteArray") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (Object)((Long)output), (Object)((Long)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Integer") {
                TestBuiltin.assertEquals((String)msg, (Object)((Integer)output), (Object)((Integer)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Double") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType == "Float") {
                TestBuiltin.assertEquals((String)msg, (Object)((Float)output), (Object)((Float)this.getExpected(minTypes[k])));
                continue;
            }
            if (inputType != "String") continue;
            TestBuiltin.assertEquals((String)msg, (String)((String)output), (String)((String)this.getExpected(minTypes[k])));
        }
    }

    @Test
    public void testMAX() throws Exception {
        String[] maxTypes = new String[]{"MAX", "LongMax", "IntMax", "FloatMax"};
        for (int k = 0; k < maxTypes.length; ++k) {
            EvalFunc<?> max = evalFuncMap.get(maxTypes[k]);
            String inputType = TestBuiltin.getInputType(maxTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = max.exec(tup);
            String msg = "[Testing " + maxTypes[k] + " on input type: " + TestBuiltin.getInputType(maxTypes[k]) + " ( (output) " + output + " == " + this.getExpected(maxTypes[k]) + " (expected) )]";
            if (inputType == "ByteArray") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (Object)((Long)output), (Object)((Long)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Integer") {
                TestBuiltin.assertEquals((String)msg, (Object)((Integer)output), (Object)((Integer)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Double") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Float") {
                TestBuiltin.assertEquals((String)msg, (Object)((Float)output), (Object)((Float)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType != "String") continue;
            TestBuiltin.assertEquals((String)msg, (String)((String)output), (String)((String)this.getExpected(maxTypes[k])));
        }
    }

    @Test
    public void testMAXIntermed() throws Exception {
        String[] maxTypes = new String[]{"MAXIntermediate", "LongMaxIntermediate", "IntMaxIntermediate", "FloatMaxIntermediate"};
        for (int k = 0; k < maxTypes.length; ++k) {
            EvalFunc<?> max = evalFuncMap.get(maxTypes[k]);
            String inputType = TestBuiltin.getInputType(maxTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = max.exec(tup);
            String msg = "[Testing " + maxTypes[k] + " on input type: " + TestBuiltin.getInputType(maxTypes[k]) + " ( (output) " + ((Tuple)output).get(0) + " == " + this.getExpected(maxTypes[k]) + " (expected) )]";
            if (inputType == "ByteArray") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)((Tuple)output).get(0)), (Object)((Double)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (Object)((Long)((Tuple)output).get(0)), (Object)((Long)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Integer") {
                TestBuiltin.assertEquals((String)msg, (Object)((Integer)((Tuple)output).get(0)), (Object)((Integer)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Double") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)((Tuple)output).get(0)), (Object)((Double)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Float") {
                TestBuiltin.assertEquals((String)msg, (Object)((Float)((Tuple)output).get(0)), (Object)((Float)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType != "String") continue;
            TestBuiltin.assertEquals((String)msg, (String)((String)((Tuple)output).get(0)), (String)((String)this.getExpected(maxTypes[k])));
        }
    }

    @Test
    public void testMAXFinal() throws Exception {
        String[] maxTypes = new String[]{"MAXFinal", "LongMaxFinal", "IntMaxFinal", "FloatMaxFinal"};
        for (int k = 0; k < maxTypes.length; ++k) {
            EvalFunc<?> max = evalFuncMap.get(maxTypes[k]);
            String inputType = TestBuiltin.getInputType(maxTypes[k]);
            Tuple tup = inputMap.get(inputType);
            Object output = max.exec(tup);
            String msg = "[Testing " + maxTypes[k] + " on input type: " + TestBuiltin.getInputType(maxTypes[k]) + " ( (output) " + output + " == " + this.getExpected(maxTypes[k]) + " (expected) )]";
            if (inputType == "ByteArray") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Long") {
                TestBuiltin.assertEquals((String)msg, (Object)((Long)output), (Object)((Long)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Integer") {
                TestBuiltin.assertEquals((String)msg, (Object)((Integer)output), (Object)((Integer)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Double") {
                TestBuiltin.assertEquals((String)msg, (Object)((Double)output), (Object)((Double)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType == "Float") {
                TestBuiltin.assertEquals((String)msg, (Object)((Float)output), (Object)((Float)this.getExpected(maxTypes[k])));
                continue;
            }
            if (inputType != "String") continue;
            TestBuiltin.assertEquals((String)msg, (String)((String)output), (String)((String)this.getExpected(maxTypes[k])));
        }
    }

    @Test
    public void testDistinct() throws Exception {
        Integer[] inp = new Integer[]{1, 2, 3, 1, 4, 5, 3};
        DataBag inputBag = Util.createBagOfOneColumn(inp);
        Distinct.Initial initial = new Distinct.Initial();
        DataBag intermedInputBg1 = this.bagFactory.newDefaultBag();
        DataBag intermedInputBg2 = this.bagFactory.newDefaultBag();
        int i = 0;
        for (Tuple t : inputBag) {
            Tuple initialOutput = (Tuple)initial.exec(this.tupleFactory.newTuple((Object)t));
            if (i < inp.length / 2) {
                intermedInputBg1.add(initialOutput);
            } else {
                intermedInputBg2.add(initialOutput);
            }
            ++i;
        }
        Distinct.Intermediate intermed = new Distinct.Intermediate();
        DataBag finalInputBg = this.bagFactory.newDefaultBag();
        finalInputBg.add((Tuple)intermed.exec(this.tupleFactory.newTuple((Object)intermedInputBg1)));
        finalInputBg.add((Tuple)intermed.exec(this.tupleFactory.newTuple((Object)intermedInputBg2)));
        Distinct.Final fin = new Distinct.Final();
        DataBag result = (DataBag)fin.exec(this.tupleFactory.newTuple((Object)finalInputBg));
        Integer[] exp = new Integer[]{1, 2, 3, 4, 5};
        DataBag expectedBag = Util.createBagOfOneColumn(exp);
        TestBuiltin.assertEquals((Object)expectedBag, (Object)result);
    }

    @Test
    public void testDistinctProgressNonAlgebraic() throws Exception {
        int inputSize = 2002;
        Integer[] inp = new Integer[inputSize];
        for (int i = 0; i < inputSize; i += 2) {
            inp[i] = i / 2;
            inp[i + 1] = i / 2;
        }
        DataBag inputBag = Util.createBagOfOneColumn(inp);
        Distinct distinct = new Distinct();
        DataBag result = (DataBag)distinct.exec(this.tupleFactory.newTuple((Object)inputBag));
        Integer[] exp = new Integer[inputSize / 2];
        for (int j = 0; j < inputSize / 2; ++j) {
            exp[j] = j;
        }
        DataBag expectedBag = Util.createBagOfOneColumn(exp);
        TestBuiltin.assertEquals((Object)expectedBag, (Object)result);
    }

    @Test
    public void testCONCAT() throws Exception {
        byte[] a = new byte[]{1, 2, 3};
        byte[] b = new byte[]{4, 5, 6};
        byte[] expected = new byte[]{1, 2, 3, 4, 5, 6};
        DataByteArray dbaExpected = new DataByteArray(expected);
        DataByteArray dbaA = new DataByteArray(a);
        DataByteArray dbaB = new DataByteArray(b);
        CONCAT concat = new CONCAT();
        Tuple t = TupleFactory.getInstance().newTuple(2);
        t.set(0, (Object)dbaA);
        t.set(1, (Object)dbaB);
        DataByteArray result = (DataByteArray)concat.exec(t);
        String msg = "[Testing CONCAT on input type: bytearray]";
        TestBuiltin.assertTrue((String)msg, (boolean)result.equals((Object)dbaExpected));
        String s1 = "unit ";
        String s2 = "test";
        String exp = "unit test";
        StringConcat sConcat = new StringConcat();
        Tuple ts = TupleFactory.getInstance().newTuple(2);
        ts.set(0, (Object)s1);
        ts.set(1, (Object)s2);
        String res = (String)sConcat.exec(ts);
        msg = "[Testing StringConcat on input type: String]";
        TestBuiltin.assertTrue((String)msg, (boolean)res.equals(exp));
    }

    @Test
    public void testSIZE() throws Exception {
        byte[] a = new byte[]{1, 2, 3};
        DataByteArray dba = new DataByteArray(a);
        Long expected = new Long(3L);
        Tuple t = TupleFactory.getInstance().newTuple(1);
        t.set(0, (Object)dba);
        SIZE size = new SIZE();
        String msg = "[Testing SIZE on input type: bytearray]";
        TestBuiltin.assertTrue((String)msg, (boolean)expected.equals(size.exec(t)));
        String s = "Unit test case";
        expected = new Long(14L);
        t.set(0, (Object)s);
        size = new StringSize();
        msg = "[Testing StringSize on input type: String]";
        TestBuiltin.assertTrue((String)msg, (boolean)expected.equals(size.exec(t)));
        String[] mapContents = new String[]{"key1", "value1", "key2", "value2"};
        Map<String, Object> map = Util.createMap(mapContents);
        expected = new Long(2L);
        t.set(0, map);
        size = new MapSize();
        msg = "[Testing MapSize on input type: Map]";
        TestBuiltin.assertTrue((String)msg, (boolean)expected.equals(size.exec(t)));
        Tuple t1 = Util.createTuple(new String[]{"a", "b", "c"});
        Tuple t2 = Util.createTuple(new String[]{"d", "e", "f"});
        Tuple t3 = Util.createTuple(new String[]{"g", "h", "i"});
        Tuple t4 = Util.createTuple(new String[]{"j", "k", "l"});
        DataBag b = Util.createBag(new Tuple[]{t1, t2, t3, t4});
        expected = new Long(4L);
        t.set(0, (Object)b);
        size = new BagSize();
        msg = "[Testing BagSize on input type: Bag]";
        TestBuiltin.assertTrue((String)msg, (boolean)expected.equals(size.exec(t)));
        expected = new Long(3L);
        size = new TupleSize();
        msg = "[Testing TupleSize on input type: Tuple]";
        TestBuiltin.assertTrue((String)msg, (boolean)expected.equals(size.exec(t1)));
        ARITY arrity = new ARITY();
        msg = "[Testing ARRITY on input type: Tuple]";
        TestBuiltin.assertTrue((String)msg, (boolean)expected.equals(new Long(arrity.exec(t1).intValue())));
    }

    @Test
    public void testLFPig() throws Exception {
        Tuple f15;
        Util.createInputFile(this.cluster, "input.txt", new String[]{"this:is:delimited:by:a:colon\n"});
        int arity1 = 6;
        PigStorage lf = new PigStorage(":");
        ReadToEndLoader p1 = new ReadToEndLoader((LoadFunc)lf, ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "input.txt", 0);
        Tuple f1 = p1.getNext();
        TestBuiltin.assertTrue((f1.size() == arity1 ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "input.txt");
        int LOOP_COUNT = 100;
        String[] input = new String[LOOP_COUNT * LOOP_COUNT];
        int n = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; ++j) {
                input[n++] = i + "\t" + i + "\t" + j % 2;
            }
        }
        Util.createInputFile(this.cluster, "input.txt", input);
        ReadToEndLoader p15 = new ReadToEndLoader((LoadFunc)new PigStorage(), ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "input.txt", 0);
        int count = 0;
        while ((f15 = p15.getNext()) != null) {
            ++count;
            TestBuiltin.assertEquals((int)3, (int)f15.size());
        }
        TestBuiltin.assertEquals((int)(LOOP_COUNT * LOOP_COUNT), (int)count);
        Util.deleteFile(this.cluster, "input.txt");
        String input2 = ":this:has:a:leading:colon\n";
        int arity2 = 6;
        Util.createInputFile(this.cluster, "input.txt", new String[]{input2});
        ReadToEndLoader p2 = new ReadToEndLoader((LoadFunc)new PigStorage(":"), ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "input.txt", 0);
        Tuple f2 = p2.getNext();
        TestBuiltin.assertTrue((f2.size() == arity2 ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "input.txt");
        String input3 = "this:has:a:trailing:colon:\n";
        int arity3 = 6;
        Util.createInputFile(this.cluster, "input.txt", new String[]{input3});
        ReadToEndLoader p3 = new ReadToEndLoader((LoadFunc)new PigStorage(":"), ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "input.txt", 0);
        Tuple f3 = p3.getNext();
        TestBuiltin.assertTrue((f3.size() == arity3 ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "input.txt");
    }

    @Test
    public void testLFText() throws Exception {
        String input1 = "This is some text.\nWith a newline in it.\n";
        String expected1 = "This is some text.";
        String expected2 = "With a newline in it.";
        Util.createInputFile(this.cluster, "/tmp/testLFTextdir1/testLFTextdir2/testLFTest-input1.txt", new String[]{input1});
        ReadToEndLoader text1 = new ReadToEndLoader((LoadFunc)new TextLoader(), ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "/tmp/testLFTextdir1", 0);
        Tuple f1 = text1.getNext();
        Tuple f2 = text1.getNext();
        TestBuiltin.assertTrue((expected1.equals(f1.get(0).toString()) && expected2.equals(f2.get(0).toString()) ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "testLFTest-input1.txt");
        Util.createInputFile(this.cluster, "testLFTest-input2.txt");
        ReadToEndLoader text2 = new ReadToEndLoader((LoadFunc)new TextLoader(), ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "testLFTest-input2.txt", 0);
        Tuple f3 = text2.getNext();
        TestBuiltin.assertTrue((f3 == null ? 1 : 0) != 0);
        Util.deleteFile(this.cluster, "testLFTest-input2.txt");
    }

    @Test
    public void testSFPig() throws Exception {
        String inputStr = "amy\tbob\tcharlene\tdavid\terin\tfrank";
        Util.createInputFile(this.cluster, "testSFPig-input.txt", new String[]{inputStr});
        DataByteArray[] input = new DataByteArray[]{new DataByteArray("amy"), new DataByteArray("bob"), new DataByteArray("charlene"), new DataByteArray("david"), new DataByteArray("erin"), new DataByteArray("frank")};
        Tuple f1 = Util.loadTuple(TupleFactory.getInstance().newTuple(input.length), input);
        String query = "a = load 'testSFPig-input.txt';store a into 'testSFPig-output.txt';";
        this.pigServer.setBatchOn();
        Util.registerMultiLineQuery(this.pigServer, query);
        this.pigServer.executeBatch();
        ReadToEndLoader lfunc = new ReadToEndLoader((LoadFunc)new PigStorage(), ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()), "testSFPig-output.txt", 0);
        Tuple f2 = lfunc.getNext();
        TestBuiltin.assertEquals((Object)f1, (Object)f2);
        Util.deleteFile(this.cluster, "testSFPig-input.txt");
        Util.deleteFile(this.cluster, "testSFPig-output.txt");
    }

    @Test
    public void testTOKENIZE() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple(1);
        t1.set(0, (Object)"123 456\"789");
        Tuple t2 = tf.newTuple(1);
        t2.set(0, null);
        Tuple t3 = tf.newTuple(0);
        TOKENIZE f = new TOKENIZE();
        DataBag b = f.exec(t1);
        TestBuiltin.assertTrue((b.size() == 3L ? 1 : 0) != 0);
        Iterator i = b.iterator();
        Tuple rt = (Tuple)i.next();
        TestBuiltin.assertTrue((boolean)rt.get(0).equals("123"));
        rt = (Tuple)i.next();
        TestBuiltin.assertTrue((boolean)rt.get(0).equals("456"));
        rt = (Tuple)i.next();
        TestBuiltin.assertTrue((boolean)rt.get(0).equals("789"));
        b = f.exec(t2);
        TestBuiltin.assertTrue((b == null ? 1 : 0) != 0);
        b = f.exec(t3);
        TestBuiltin.assertTrue((b == null ? 1 : 0) != 0);
    }

    @Test
    public void testDIFF() throws Exception {
        int j;
        int i;
        BagFactory bf = BagFactory.getInstance();
        TupleFactory tf = TupleFactory.getInstance();
        DataBag b1 = bf.newDefaultBag();
        DataBag b2 = bf.newDefaultBag();
        for (i = 0; i < 10; ++i) {
            b1.add(tf.newTuple((Object)new Integer(i)));
        }
        for (i = 0; i < 10; i += 2) {
            b2.add(tf.newTuple((Object)new Integer(i)));
        }
        Tuple t = tf.newTuple(2);
        t.set(0, (Object)b1);
        t.set(1, (Object)b2);
        DIFF d = new DIFF();
        DataBag result = d.exec(t);
        TestBuiltin.assertEquals((long)5L, (long)result.size());
        Iterator i2 = result.iterator();
        int[] values = new int[5];
        for (j = 0; j < 5; ++j) {
            values[j] = (Integer)((Tuple)i2.next()).get(0);
        }
        Arrays.sort(values);
        for (j = 1; j < 10; j += 2) {
            TestBuiltin.assertEquals((int)j, (int)values[j / 2]);
        }
        t = tf.newTuple(2);
        t.set(0, (Object)new Integer(1));
        t.set(1, (Object)new Integer(1));
        result = d.exec(t);
        TestBuiltin.assertEquals((long)0L, (long)result.size());
        t = tf.newTuple(2);
        t.set(0, (Object)new Integer(1));
        t.set(1, (Object)new Integer(2));
        result = d.exec(t);
        TestBuiltin.assertEquals((long)2L, (long)result.size());
    }

    private static String getInputType(String typeFor) {
        return allowedInput.get(typeFor);
    }

    private Object getExpected(String expectedFor) {
        return expectedMap.get(expectedFor);
    }
}

