/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;

public class TestCharArrayToNumeric
extends TestCase {
    private Double dummyDouble = null;
    private Float dummyFloat = null;
    private Long dummyLong = null;
    private Integer dummyInteger = null;
    private Double MaxDouble = Double.MIN_VALUE;
    private Double MinDouble = Double.MIN_VALUE;
    private Float MaxFloat = Float.valueOf(Float.MAX_VALUE);
    private Float MinFloat = Float.valueOf(Float.MIN_VALUE);
    private Long MaxLong = Long.MAX_VALUE;
    private Long MinLong = Long.MIN_VALUE;
    private Integer MaxInteger = Integer.MAX_VALUE;
    private Integer MinInteger = Integer.MIN_VALUE;
    MiniCluster cluster = MiniCluster.buildCluster();
    PigServer pig;

    protected void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    public static OperatorKey newOperatorKey() {
        long newId = NodeIdGenerator.getGenerator().getNextNodeId("scope");
        return new OperatorKey("scope", newId);
    }

    public void testCast() throws ExecException {
        POCast cast = new POCast(TestCharArrayToNumeric.newOperatorKey(), -1);
        POProject proj = new POProject(TestCharArrayToNumeric.newOperatorKey(), -1, 0);
        proj.setResultType((byte)55);
        ArrayList<POProject> inputs = new ArrayList<POProject>();
        inputs.add(proj);
        cast.setInputs(inputs);
        String[] items = new String[]{"12.0", "-13.2", "0.1f", "1.3e2", "zjf", this.MaxDouble.toString(), this.MinDouble.toString()};
        Double[] doubleExpected = new Double[]{12.0, -13.2, 0.1, 130.0, null, this.MaxDouble, this.MinDouble};
        for (int i = 0; i < items.length; ++i) {
            Tuple tuple = TupleFactory.getInstance().newTuple(1);
            tuple.set(0, (Object)items[i]);
            proj.attachInput(tuple);
            Double actual = (Double)cast.getNext((Double)this.dummyDouble).result;
            if (doubleExpected[i] != null) {
                TestCharArrayToNumeric.assertEquals((double)doubleExpected[i], (double)actual, (double)1.0E-6);
                continue;
            }
            TestCharArrayToNumeric.assertNull((Object)actual);
        }
        items = new String[]{"12.0", "-13.2", "0.1f", "1.3e2", this.MaxFloat.toString(), this.MinFloat.toString(), "zjf"};
        Float[] floatExpected = new Float[]{Float.valueOf(12.0f), Float.valueOf(-13.2f), Float.valueOf(0.1f), Float.valueOf(130.0f), this.MaxFloat, this.MinFloat, null};
        for (int i = 0; i < items.length; ++i) {
            Tuple tuple = TupleFactory.getInstance().newTuple(1);
            tuple.set(0, (Object)items[i]);
            proj.attachInput(tuple);
            Float actual = (Float)cast.getNext((Float)this.dummyFloat).result;
            if (floatExpected[i] != null) {
                TestCharArrayToNumeric.assertEquals((double)floatExpected[i].floatValue(), (double)actual.floatValue(), (double)1.0E-6);
                continue;
            }
            TestCharArrayToNumeric.assertNull((Object)actual);
        }
        items = new String[]{"1", "-1", "12.2", "12.8", this.MaxLong.toString(), this.MinLong.toString(), "df1.2"};
        Long[] longExpected = new Long[]{1L, -1L, 12L, 12L, this.MaxLong, this.MinLong, null};
        for (int i = 0; i < items.length; ++i) {
            Tuple tuple = TupleFactory.getInstance().newTuple(1);
            tuple.set(0, (Object)items[i]);
            proj.attachInput(tuple);
            Long actual = (Long)cast.getNext((Long)this.dummyLong).result;
            if (longExpected[i] != null) {
                TestCharArrayToNumeric.assertEquals((Object)longExpected[i], (Object)actual);
                continue;
            }
            TestCharArrayToNumeric.assertNull((Object)actual);
        }
        items = new String[]{"1", "-1", "12.2", "12.8", this.MaxInteger.toString(), this.MinInteger.toString(), "ff4332"};
        Integer[] intExpected = new Integer[]{1, -1, 12, 12, this.MaxInteger, this.MinInteger, null};
        for (int i = 0; i < items.length; ++i) {
            Tuple tuple = TupleFactory.getInstance().newTuple(1);
            tuple.set(0, (Object)items[i]);
            proj.attachInput(tuple);
            Integer actual = (Integer)cast.getNext((Integer)this.dummyInteger).result;
            if (intExpected[i] != null) {
                TestCharArrayToNumeric.assertEquals((Object)intExpected[i], (Object)actual);
                continue;
            }
            TestCharArrayToNumeric.assertNull((Object)actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharArray2FloatAndDoubleScript() throws IOException {
        int size = 100;
        String[] numbers = new String[size + 1];
        Random rand = new Random();
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        try {
            byte[] numericTypes;
            for (int i = 0; i < numbers.length; ++i) {
                int key = i;
                double value = rand.nextDouble() * 100.0;
                numbers[i] = key + "\t" + value;
                map.put(key, value);
            }
            numbers[numbers.length - 1] = numbers.length + "\t" + "null";
            map.put(numbers.length, null);
            Util.createInputFile(this.cluster, "pig_jira_893-input1.txt", numbers);
            for (byte type : numericTypes = new byte[]{25, 20}) {
                this.pig.registerQuery("A = Load 'pig_jira_893-input1.txt' AS (key:int,value:chararray);");
                this.pig.registerQuery("B = FOREACH A GENERATE key,(" + DataType.findTypeName((byte)type) + ")value;");
                Iterator iter = this.pig.openIterator("B");
                while (iter.hasNext()) {
                    Number expected;
                    Tuple tuple = (Tuple)iter.next();
                    Integer key = (Integer)tuple.get(0);
                    String value = null;
                    if (tuple.get(1) != null) {
                        value = tuple.get(1).toString();
                    }
                    if (type == 25) {
                        expected = (Double)map.get(key);
                        if (value != null) {
                            TestCharArrayToNumeric.assertEquals((Object)expected, (Object)Double.parseDouble(value));
                        } else {
                            TestCharArrayToNumeric.assertEquals((Object)expected, null);
                        }
                    }
                    if (type != 20) continue;
                    expected = null;
                    if (map.get(key) != null) {
                        expected = Float.valueOf(((Double)map.get(key)).floatValue());
                    }
                    if (value != null) {
                        TestCharArrayToNumeric.assertEquals((Object)expected, (Object)Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    TestCharArrayToNumeric.assertEquals((Object)expected, null);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCharArrayToNumeric.fail();
        }
        finally {
            Util.deleteFile(this.cluster, "pig_jira_893-input1.txt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharArrayToIntAndLongScript() throws IOException {
        int size = 100;
        String[] numbers = new String[size + 1];
        Random rand = new Random();
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        Object inputFile = null;
        try {
            byte[] numericTypes;
            for (int i = 0; i < numbers.length; ++i) {
                int key = i;
                long value = rand.nextInt(100);
                numbers[i] = key + "\t" + value;
                map.put(key, value);
            }
            numbers[numbers.length - 1] = numbers.length + "\t" + "null";
            map.put(numbers.length, null);
            Util.createInputFile(this.cluster, "pig_jira_893-input2.txt", numbers);
            for (byte type : numericTypes = new byte[]{10, 15}) {
                this.pig.registerQuery("A = Load 'pig_jira_893-input2.txt' AS (key:int,value:chararray);");
                this.pig.registerQuery("B = FOREACH A GENERATE key,(" + DataType.findTypeName((byte)type) + ")value;");
                Iterator iter = this.pig.openIterator("B");
                while (iter.hasNext()) {
                    Number actual;
                    Number expected;
                    Tuple tuple = (Tuple)iter.next();
                    Integer key = (Integer)tuple.get(0);
                    String value = null;
                    if (tuple.get(1) != null) {
                        value = tuple.get(1).toString();
                    }
                    if (type == 15) {
                        expected = (Long)map.get(key);
                        if (value != null) {
                            actual = Long.parseLong(value);
                            TestCharArrayToNumeric.assertEquals((Object)expected, (Object)actual);
                        } else {
                            TestCharArrayToNumeric.assertEquals((Object)expected, null);
                        }
                    }
                    if (type != 10) continue;
                    expected = null;
                    if (map.get(key) != null) {
                        expected = ((Long)map.get(key)).intValue();
                    }
                    if (value != null) {
                        actual = Integer.parseInt(value);
                        TestCharArrayToNumeric.assertEquals((Object)expected, (Object)actual);
                        continue;
                    }
                    TestCharArrayToNumeric.assertEquals((Object)expected, null);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCharArrayToNumeric.fail();
        }
        finally {
            Util.deleteFile(this.cluster, "pig_jira_893-input2.txt");
        }
    }
}

