/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.GZIPOutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.DIFF;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCompressedFiles
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    MiniCluster cluster = MiniCluster.buildCluster();
    File datFile;
    File gzFile;

    @Before
    protected void setUp() throws Exception {
        this.datFile = File.createTempFile("compTest", ".dat");
        this.gzFile = File.createTempFile("compTest", ".gz");
        FileOutputStream dat = new FileOutputStream(this.datFile);
        GZIPOutputStream gz = new GZIPOutputStream(new FileOutputStream(this.gzFile));
        Random rand = new Random();
        for (int i = 0; i < 1024; ++i) {
            StringBuffer sb = new StringBuffer();
            int x = rand.nextInt();
            int y = rand.nextInt();
            sb.append(x);
            sb.append('\t');
            sb.append(y);
            sb.append('\n');
            byte[] bytes = sb.toString().getBytes();
            dat.write(bytes);
            gz.write(bytes);
        }
        dat.close();
        gz.close();
    }

    @After
    protected void tearDown() throws Exception {
        this.datFile.delete();
        this.gzFile.delete();
    }

    @Test
    public void testCompressed1() throws Throwable {
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pig.registerQuery("A = foreach (cogroup (load '" + Util.generateURI(this.gzFile.toString(), pig.getPigContext()) + "') by $1, (load '" + Util.generateURI(this.datFile.toString(), pig.getPigContext()) + "') by $1) generate flatten( " + DIFF.class.getName() + "($1.$1,$2.$1)) ;");
        Iterator it = pig.openIterator("A");
        boolean success = true;
        while (it.hasNext()) {
            success = false;
            this.log.info(it.next());
        }
        TestCompressedFiles.assertTrue((boolean)success);
    }

    @Test
    public void testCompressed2() throws Throwable {
        PigServer pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        pig.registerQuery("A = load '" + Util.generateURI(this.gzFile.toString(), pig.getPigContext()) + "';");
        DataBag dbGz = BagFactory.getInstance().newDefaultBag();
        DataBag dbDt = BagFactory.getInstance().newDefaultBag();
        Iterator iter = pig.openIterator("A");
        while (iter.hasNext()) {
            dbGz.add((Tuple)iter.next());
        }
        pig.registerQuery("B = load '" + Util.generateURI(this.datFile.toString(), pig.getPigContext()) + "';");
        iter = pig.openIterator("B");
        while (iter.hasNext()) {
            dbDt.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbGz.size() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((dbDt.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)dbGz.size(), (long)dbDt.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbGz, dbDt));
    }
}

