/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestConstExpr
extends TestCase {
    Random r = new Random();
    ConstantExpression ce = GenPhyOp.exprConst();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNextInteger() throws ExecException {
        Integer inp = this.r.nextInt();
        this.ce.setValue((Object)inp);
        Result resi = this.ce.getNext(inp);
        Integer ret = (Integer)resi.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        resi = this.ce.getNext(inp);
        ret = (Integer)resi.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextLong() throws ExecException {
        Long inp = this.r.nextLong();
        this.ce.setValue((Object)inp);
        Result resl = this.ce.getNext(inp);
        Long ret = (Long)resl.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        resl = this.ce.getNext(inp);
        ret = (Long)resl.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextDouble() throws ExecException {
        Double inp = this.r.nextDouble();
        this.ce.setValue((Object)inp);
        Result resd = this.ce.getNext(inp);
        Double ret = (Double)resd.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        resd = this.ce.getNext(inp);
        ret = (Double)resd.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextFloat() throws ExecException {
        Float inp = Float.valueOf(this.r.nextFloat());
        this.ce.setValue((Object)inp);
        Result resf = this.ce.getNext(inp);
        Float ret = (Float)resf.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        resf = this.ce.getNext(inp);
        ret = (Float)resf.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextString() throws ExecException {
        String inp = GenRandomData.genRandString(this.r);
        this.ce.setValue((Object)inp);
        Result ress = this.ce.getNext(inp);
        String ret = (String)ress.result;
        TestConstExpr.assertEquals((String)inp, (String)ret);
        this.ce.setValue(null);
        ress = this.ce.getNext(inp);
        ret = (String)ress.result;
        TestConstExpr.assertEquals(null, (String)ret);
    }

    @Test
    public void testGetNextDataByteArray() throws ExecException {
        DataByteArray inp = GenRandomData.genRandDBA(this.r);
        this.ce.setValue((Object)inp);
        Result resba = this.ce.getNext(inp);
        DataByteArray ret = (DataByteArray)resba.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        resba = this.ce.getNext(inp);
        ret = (DataByteArray)resba.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextMap() throws ExecException {
        Map<String, Object> inp = GenRandomData.genRandMap(this.r, 10);
        this.ce.setValue(inp);
        Result resm = this.ce.getNext(inp);
        Map ret = (Map)resm.result;
        TestConstExpr.assertEquals(inp, (Object)ret);
        this.ce.setValue(null);
        resm = this.ce.getNext(inp);
        ret = (Map)resm.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextBoolean() throws ExecException {
        Boolean inp = this.r.nextBoolean();
        this.ce.setValue((Object)inp);
        Result res = this.ce.getNext(inp);
        Boolean ret = (Boolean)res.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        res = this.ce.getNext(inp);
        ret = (Boolean)res.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextTuple() throws ExecException {
        Tuple inp = GenRandomData.genRandSmallBagTuple(this.r, 10, 100);
        this.ce.setValue((Object)inp);
        Result rest = this.ce.getNext(inp);
        Tuple ret = (Tuple)rest.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        rest = this.ce.getNext(inp);
        ret = (Tuple)rest.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }

    @Test
    public void testGetNextDataBag() throws ExecException {
        DataBag inp = GenRandomData.genRandSmallTupDataBag(this.r, 10, 100);
        this.ce.setValue((Object)inp);
        Result res = this.ce.getNext(inp);
        DataBag ret = (DataBag)res.result;
        TestConstExpr.assertEquals((Object)inp, (Object)ret);
        this.ce.setValue(null);
        res = this.ce.getNext(inp);
        ret = (DataBag)res.result;
        TestConstExpr.assertEquals(null, (Object)ret);
    }
}

