/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.SingleTupleBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestDataBagAccess
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testSingleTupleBagAcess() throws Exception {
        DefaultTuple inputTuple = new DefaultTuple();
        inputTuple.append((Object)"a");
        inputTuple.append((Object)"b");
        SingleTupleBag bg = new SingleTupleBag((Tuple)inputTuple);
        Iterator it = bg.iterator();
        TestDataBagAccess.assertEquals((Object)inputTuple, it.next());
        TestDataBagAccess.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testNonSpillableDataBag() throws Exception {
        String[][] tupleContents = new String[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};
        NonSpillableDataBag bg = new NonSpillableDataBag();
        for (int i = 0; i < tupleContents.length; ++i) {
            bg.add(Util.createTuple(tupleContents[i]));
        }
        Iterator it = bg.iterator();
        int j = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            TestDataBagAccess.assertEquals((Object)Util.createTuple(tupleContents[j]), (Object)t);
            ++j;
        }
        TestDataBagAccess.assertEquals((int)tupleContents.length, (int)j);
    }

    @Test
    public void testBagConstantAccess() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"sampledata\tnot_used"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(Util.encodeEscape(input.toString()), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("b = foreach a generate {(16, 4.0e-2, 'hello')} as mybag:{t:(i: int, d: double, c: chararray)};");
        this.pigServer.registerQuery("c = foreach b generate mybag.i, mybag.d, mybag.c;");
        Iterator it = this.pigServer.openIterator("c");
        Tuple t = (Tuple)it.next();
        Object[] results = new Object[]{new Integer(16), new Double(0.04), "hello"};
        Class[] resultClasses = new Class[]{Integer.class, Double.class, String.class};
        TestDataBagAccess.assertEquals((int)results.length, (int)t.size());
        for (int i = 0; i < results.length; ++i) {
            DataBag bag = (DataBag)t.get(i);
            TestDataBagAccess.assertEquals((Object)results[i], (Object)((Tuple)bag.iterator().next()).get(0));
            TestDataBagAccess.assertEquals((Object)resultClasses[i], ((Tuple)bag.iterator().next()).get(0).getClass());
        }
    }

    @Test
    public void testBagConstantAccessFailure() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"sampledata\tnot_used"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(Util.encodeEscape(input.toString()), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("b = foreach a generate {(16, 4.0e-2, 'hello')} as mybag:{t:(i: int, d: double, c: chararray)};");
        boolean exceptionOccured = false;
        try {
            this.pigServer.registerQuery("c = foreach b generate mybag.t;");
        }
        catch (IOException e) {
            exceptionOccured = true;
            String msg = e.getMessage();
            TestDataBagAccess.assertTrue((boolean)msg.contains("Only access to the elements of the tuple in the bag is allowed."));
        }
        TestDataBagAccess.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBagConstantFlatten1() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"sampledata\tnot_used"});
        this.pigServer.registerQuery("A = load '" + Util.generateURI(Util.encodeEscape(input.toString()), this.pigServer.getPigContext()) + "';");
        this.pigServer.registerQuery("B = foreach A generate {(('p1-t1-e1', 'p1-t1-e2'),('p1-t2-e1', 'p1-t2-e2')),(('p2-t1-e1', 'p2-t1-e2'), ('p2-t2-e1', 'p2-t2-e2'))};");
        this.pigServer.registerQuery("C = foreach B generate $0 as pairbag { pair: ( t1: (e1, e2), t2: (e1, e2) ) };");
        this.pigServer.registerQuery("D = foreach C generate FLATTEN(pairbag);");
        this.pigServer.registerQuery("E = foreach D generate t1.e2 as t1e2, t2.e1 as t2e1;");
        Iterator it = this.pigServer.openIterator("E");
        Tuple t = (Tuple)it.next();
        TestDataBagAccess.assertEquals((String)"p1-t1-e2", (String)((String)t.get(0)));
        TestDataBagAccess.assertEquals((String)"p1-t2-e1", (String)((String)t.get(1)));
        t = (Tuple)it.next();
        TestDataBagAccess.assertEquals((String)"p2-t1-e2", (String)((String)t.get(0)));
        TestDataBagAccess.assertEquals((String)"p2-t2-e1", (String)((String)t.get(1)));
        TestDataBagAccess.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testBagConstantFlatten2() throws IOException, ExecException {
        int j;
        Tuple t;
        File input = Util.createInputFile("tmp", "", new String[]{"somestring\t10\t{(a,10),(b,20)}"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(Util.encodeEscape(input.toString()), this.pigServer.getPigContext()) + "' " + "as (str:chararray, intval:int, bg:bag{t:tuple(s:chararray, i:int)});");
        this.pigServer.registerQuery("b = foreach a generate str, intval, flatten(bg);");
        this.pigServer.registerQuery("c = foreach b generate str, intval, s, i;");
        Iterator it = this.pigServer.openIterator("c");
        int i = 0;
        Object[][] results = new Object[][]{{"somestring", new Integer(10), "a", new Integer(10)}, {"somestring", new Integer(10), "b", new Integer(20)}};
        Class[] resultClasses = new Class[]{String.class, Integer.class, String.class, Integer.class};
        while (it.hasNext()) {
            t = (Tuple)it.next();
            for (j = 0; j < resultClasses.length; ++j) {
                TestDataBagAccess.assertEquals((Object)results[i][j], (Object)t.get(j));
                TestDataBagAccess.assertEquals((Object)resultClasses[j], t.get(j).getClass());
            }
            ++i;
        }
        TestDataBagAccess.assertEquals((int)results.length, (int)i);
        this.pigServer.registerQuery("c = foreach b generate str, intval, bg::s, bg::i;");
        it = this.pigServer.openIterator("c");
        i = 0;
        while (it.hasNext()) {
            t = (Tuple)it.next();
            for (j = 0; j < resultClasses.length; ++j) {
                TestDataBagAccess.assertEquals((Object)results[i][j], (Object)t.get(j));
                TestDataBagAccess.assertEquals((Object)resultClasses[j], t.get(j).getClass());
            }
            ++i;
        }
        TestDataBagAccess.assertEquals((int)results.length, (int)i);
    }

    @Test
    public void testBagStoreLoad() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"a\tid1", "a\tid2", "a\tid3", "b\tid4", "b\tid5", "b\tid6"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(Util.encodeEscape(input.toString()), this.pigServer.getPigContext()) + "' " + "as (s:chararray, id:chararray);");
        this.pigServer.registerQuery("b = group a by s;");
        Class[] loadStoreClasses = new Class[]{BinStorage.class, PigStorage.class};
        for (int i = 0; i < loadStoreClasses.length; ++i) {
            Tuple t;
            String output = "/pig/out/TestDataBagAccess-testBagStoreLoad-" + loadStoreClasses[i].getName() + ".txt";
            this.pigServer.deleteFile(output);
            this.pigServer.store("b", output, loadStoreClasses[i].getName());
            this.pigServer.registerQuery("c = load '" + output + "' using " + loadStoreClasses[i].getName() + "() AS " + "(gp: chararray, bg:bag { t: tuple (sReLoaded: chararray, idReLoaded: chararray)});;");
            Iterator it = this.pigServer.openIterator("c");
            MultiMap results = new MultiMap();
            results.put((Object)"a", (Object)"id1");
            results.put((Object)"a", (Object)"id2");
            results.put((Object)"a", (Object)"id3");
            results.put((Object)"b", (Object)"id4");
            results.put((Object)"b", (Object)"id5");
            results.put((Object)"b", (Object)"id6");
            int j = 0;
            while (it.hasNext()) {
                Tuple t2 = (Tuple)it.next();
                Object groupKey = t2.get(0);
                DataBag groupBag = (DataBag)t2.get(1);
                Iterator bgIt = groupBag.iterator();
                int k = 0;
                while (bgIt.hasNext()) {
                    HashMap<Object, Boolean> seen = new HashMap<Object, Boolean>();
                    Tuple bgt = (Tuple)bgIt.next();
                    TestDataBagAccess.assertTrue((boolean)bgt.get(0).equals(groupKey));
                    Collection values = results.get(groupKey);
                    TestDataBagAccess.assertTrue((boolean)values.contains(bgt.get(1)));
                    if (seen.containsKey(bgt.get(1))) {
                        TestDataBagAccess.fail((String)("LoadStoreClass used : " + loadStoreClasses[i].getName() + " " + ", duplicate value (" + bgt.get(1) + ")"));
                    } else {
                        seen.put(bgt.get(1), true);
                    }
                    ++k;
                }
                TestDataBagAccess.assertEquals((int)3, (int)k);
                ++j;
            }
            TestDataBagAccess.assertEquals((int)results.keySet().size(), (int)j);
            this.pigServer.registerQuery("d = foreach c generate gp, flatten(bg);");
            ArrayList<Tuple> resultTuples = new ArrayList<Tuple>();
            resultTuples.add(Util.createTuple(new String[]{"a", "a", "id1"}));
            resultTuples.add(Util.createTuple(new String[]{"a", "a", "id2"}));
            resultTuples.add(Util.createTuple(new String[]{"a", "a", "id3"}));
            resultTuples.add(Util.createTuple(new String[]{"b", "b", "id4"}));
            resultTuples.add(Util.createTuple(new String[]{"b", "b", "id5"}));
            resultTuples.add(Util.createTuple(new String[]{"b", "b", "id6"}));
            it = this.pigServer.openIterator("d");
            j = 0;
            HashMap<Tuple, Boolean> seen = new HashMap<Tuple, Boolean>();
            while (it.hasNext()) {
                t = (Tuple)it.next();
                TestDataBagAccess.assertTrue((boolean)resultTuples.contains(t));
                if (seen.containsKey(t)) {
                    TestDataBagAccess.fail((String)("LoadStoreClass used : " + loadStoreClasses[i].getName() + " " + ", duplicate tuple (" + t + ") encountered."));
                } else {
                    seen.put(t, true);
                }
                ++j;
            }
            TestDataBagAccess.assertEquals((int)resultTuples.size(), (int)j);
            this.pigServer.registerQuery("e = foreach d generate gp, sReLoaded, idReLoaded;");
            it = this.pigServer.openIterator("e");
            j = 0;
            seen = new HashMap();
            while (it.hasNext()) {
                t = (Tuple)it.next();
                TestDataBagAccess.assertTrue((boolean)resultTuples.contains(t));
                if (seen.containsKey(t)) {
                    TestDataBagAccess.fail((String)("LoadStoreClass used : " + loadStoreClasses[i].getName() + " " + ", duplicate tuple (" + t + ") encountered."));
                } else {
                    seen.put(t, true);
                }
                ++j;
            }
            TestDataBagAccess.assertEquals((int)resultTuples.size(), (int)j);
            this.pigServer.registerQuery("f = foreach d generate $0, $1, $2;");
            it = this.pigServer.openIterator("f");
            j = 0;
            seen = new HashMap();
            while (it.hasNext()) {
                t = (Tuple)it.next();
                TestDataBagAccess.assertTrue((boolean)resultTuples.contains(t));
                if (seen.containsKey(t)) {
                    TestDataBagAccess.fail((String)("LoadStoreClass used : " + loadStoreClasses[i].getName() + " " + ", duplicate tuple (" + t + ") encountered."));
                } else {
                    seen.put(t, true);
                }
                ++j;
            }
            TestDataBagAccess.assertEquals((int)resultTuples.size(), (int)j);
        }
    }
}

