/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestDataModel
extends TestCase {
    @Test
    public void testDatum() throws Exception {
    }

    @Test
    public void testTuple() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        int arity = 5;
        int[] input1 = new int[]{1, 2, 3, 4, 5};
        String[] input2 = new String[]{"1", "2", "3", "4", "5"};
        String[] input3 = new String[]{"1", "2", "3", "4", "5", "6"};
        Tuple f1 = Util.loadFlatTuple(tf.newTuple(arity), input1);
        Tuple f2 = Util.loadFlatTuple(tf.newTuple(arity), input1);
        Tuple f3 = tf.newTuple(arity);
        TestDataModel.assertTrue((f1.size() == arity ? 1 : 0) != 0);
        TestDataModel.assertTrue((boolean)f1.equals(f2));
        f2 = Util.loadTuple(tf.newTuple(input3.length), input3);
        TestDataModel.assertFalse((boolean)f1.equals(f2));
        int[] input4 = new int[]{1, 2, 3};
        int[] input5 = new int[]{4, 5};
        f1 = Util.loadFlatTuple(tf.newTuple(input1.length), input1);
        f2 = Util.loadFlatTuple(tf.newTuple(input4.length), input4);
        TestDataModel.assertTrue((f1.compareTo((Object)f2) > 0 ? 1 : 0) != 0);
        TestDataModel.assertFalse((f1.compareTo((Object)f2) < 0 ? 1 : 0) != 0);
        int[] input6 = new int[]{1, 2, 3, 4, 6};
        f2 = Util.loadFlatTuple(tf.newTuple(input6.length), input6);
        TestDataModel.assertTrue((f1.compareTo((Object)f2) < 0 ? 1 : 0) != 0);
        TestDataModel.assertFalse((f1.compareTo((Object)f2) > 0 ? 1 : 0) != 0);
        String expected = "1:2:3:4:5";
        f1 = Util.loadFlatTuple(tf.newTuple(input1.length), input1);
        TestDataModel.assertTrue((boolean)expected.equals(f1.toDelimitedString(":")));
        PipedOutputStream pos = new PipedOutputStream();
        DataOutputStream dos = new DataOutputStream(pos);
        PipedInputStream pis = new PipedInputStream(pos);
        DataInputStream dis = new DataInputStream(pis);
        f1.write((DataOutput)dos);
        f1.write((DataOutput)dos);
        f2.readFields((DataInput)dis);
        TestDataModel.assertTrue((boolean)f1.equals(f2));
        f2.readFields((DataInput)dis);
        TestDataModel.assertTrue((boolean)f1.equals(f2));
    }

    @Test
    public void testNestTuple() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        int[][] input1 = new int[][]{{1, 2, 3, 4, 5}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 5}};
        int[][] input2 = new int[][]{{1, 2}, {1, 2}};
        Tuple n1 = Util.loadNestTuple(tf.newTuple(input1.length), input1);
        Tuple n2 = tf.newTuple();
        n2 = Util.loadNestTuple(tf.newTuple(input2.length), input2);
    }

    @Test
    public void testReadWrite() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = this.giveMeOneOfEach();
        File file = File.createTempFile("Tuple", "put");
        FileOutputStream fos = new FileOutputStream(file);
        DataOutputStream out = new DataOutputStream(fos);
        t1.write((DataOutput)out);
        t1.write((DataOutput)out);
        fos.close();
        FileInputStream fis = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fis);
        for (int i = 0; i < 2; ++i) {
            Tuple after = tf.newTuple();
            after.readFields((DataInput)in);
            Object o = after.get(0);
            TestDataModel.assertTrue((String)"isa Tuple", (boolean)(o instanceof Tuple));
            Tuple t3 = (Tuple)o;
            o = t3.get(0);
            TestDataModel.assertTrue((String)"isa Integer", (boolean)(o instanceof Integer));
            TestDataModel.assertEquals((Object)new Integer(3), (Object)((Integer)o));
            o = t3.get(1);
            TestDataModel.assertTrue((String)"isa Float", (boolean)(o instanceof Float));
            TestDataModel.assertEquals((Object)new Float(3.0), (Object)((Float)o));
            o = after.get(1);
            TestDataModel.assertTrue((String)"isa Bag", (boolean)(o instanceof DataBag));
            DataBag b = (DataBag)o;
            Iterator j = b.iterator();
            Tuple[] ts = new Tuple[2];
            TestDataModel.assertTrue((String)"first tuple in bag", (boolean)j.hasNext());
            ts[0] = (Tuple)j.next();
            TestDataModel.assertTrue((String)"second tuple in bag", (boolean)j.hasNext());
            ts[1] = (Tuple)j.next();
            o = ts[0].get(0);
            TestDataModel.assertTrue((String)"isa Integer", (boolean)(o instanceof Integer));
            TestDataModel.assertEquals((Object)new Integer(4), (Object)((Integer)o));
            o = ts[1].get(0);
            TestDataModel.assertTrue((String)"isa String", (boolean)(o instanceof String));
            TestDataModel.assertEquals((String)"mary had a little lamb", (String)((String)o));
            o = after.get(2);
            TestDataModel.assertTrue((String)"isa Map", (boolean)(o instanceof Map));
            Map m = (Map)o;
            TestDataModel.assertEquals((String)"world", (String)((String)m.get("hello")));
            TestDataModel.assertEquals((String)"all", (String)((String)m.get("goodbye")));
            TestDataModel.assertNull(m.get("fred"));
            o = after.get(3);
            TestDataModel.assertTrue((String)"isa Integer", (boolean)(o instanceof Integer));
            Integer ii = (Integer)o;
            TestDataModel.assertEquals((Object)new Integer(42), (Object)ii);
            o = after.get(4);
            TestDataModel.assertTrue((String)"isa Long", (boolean)(o instanceof Long));
            Long l = (Long)o;
            TestDataModel.assertEquals((Object)new Long(5000000000L), (Object)l);
            o = after.get(5);
            TestDataModel.assertTrue((String)"isa Float", (boolean)(o instanceof Float));
            Float f = (Float)o;
            TestDataModel.assertEquals((Object)new Float(3.141592654), (Object)f);
            o = after.get(6);
            TestDataModel.assertTrue((String)"isa Double", (boolean)(o instanceof Double));
            Double d = (Double)o;
            TestDataModel.assertEquals((Object)2.99792458E8, (Object)d);
            o = after.get(7);
            TestDataModel.assertTrue((String)"isa Boolean", (boolean)(o instanceof Boolean));
            Boolean bool = (Boolean)o;
            TestDataModel.assertTrue((boolean)bool);
            o = after.get(8);
            TestDataModel.assertTrue((String)"isa DataByteArray", (boolean)(o instanceof DataByteArray));
            DataByteArray ba = (DataByteArray)o;
            TestDataModel.assertEquals((Object)new DataByteArray("hello"), (Object)ba);
            o = after.get(9);
            TestDataModel.assertTrue((String)"isa String", (boolean)(o instanceof String));
            String s = (String)o;
            TestDataModel.assertEquals((String)"goodbye", (String)s);
        }
        file.delete();
    }

    @Test
    public void testReadWriteInternal() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple(1);
        InternalMap map = new InternalMap(2);
        map.put((Object)new Integer(1), (Object)new String("world"));
        map.put((Object)new Long(3L), (Object)new String("all"));
        t1.set(0, (Object)map);
        File file = File.createTempFile("Tuple", "put");
        FileOutputStream fos = new FileOutputStream(file);
        DataOutputStream out = new DataOutputStream(fos);
        t1.write((DataOutput)out);
        fos.close();
        FileInputStream fis = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fis);
        Tuple after = tf.newTuple();
        after.readFields((DataInput)in);
        Object o = after.get(0);
        TestDataModel.assertTrue((String)"isa InternalMap", (boolean)(o instanceof InternalMap));
        InternalMap m = (InternalMap)o;
        TestDataModel.assertEquals((String)"world", (String)((String)m.get((Object)new Integer(1))));
        TestDataModel.assertEquals((String)"all", (String)((String)m.get((Object)new Long(3L))));
        TestDataModel.assertNull((Object)m.get((Object)"fred"));
        file.delete();
    }

    @Test
    public void testTupleToString() throws Exception {
        Tuple t = this.giveMeOneOfEach();
        TestDataModel.assertEquals((String)"toString", (String)"((3,3.0F),{(4),(mary had a little lamb)},[hello#world,goodbye#all],42,5000000000L,3.1415927F,2.99792458E8,true,hello,goodbye,)", (String)t.toString());
    }

    @Test
    public void testTupleHashCode() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple(2);
        t1.set(0, (Object)new DataByteArray("hello world"));
        t1.set(1, (Object)new Integer(1));
        Tuple t2 = tf.newTuple(2);
        t2.set(0, (Object)new DataByteArray("hello world"));
        t2.set(1, (Object)new Integer(1));
        TestDataModel.assertEquals((String)"same data", (int)t1.hashCode(), (int)t2.hashCode());
        Tuple t3 = tf.newTuple(3);
        t3.set(0, (Object)new DataByteArray("hello world"));
        t3.set(1, (Object)new Integer(1));
        t3.set(2, (Object)new Long(4L));
        TestDataModel.assertFalse((String)"different size", (t1.hashCode() == t3.hashCode() ? 1 : 0) != 0);
        Tuple t4 = tf.newTuple(2);
        t4.set(0, (Object)new DataByteArray("hello world"));
        t4.set(1, (Object)new Integer(2));
        TestDataModel.assertFalse((String)"same size, different data", (t1.hashCode() == t4.hashCode() ? 1 : 0) != 0);
        Tuple t5 = this.giveMeOneOfEach();
        t5.hashCode();
    }

    @Test
    public void testTupleEquals() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple();
        Tuple t2 = tf.newTuple();
        t1.append((Object)new Integer(3));
        t2.append((Object)new Integer(3));
        TestDataModel.assertFalse((String)"different object", (boolean)t1.equals(new String()));
        TestDataModel.assertTrue((String)"same data", (boolean)t1.equals(t2));
        t2 = tf.newTuple();
        t2.append((Object)new Integer(4));
        TestDataModel.assertFalse((String)"different data", (boolean)t1.equals(t2));
        t2 = tf.newTuple();
        t2.append((Object)new Integer(3));
        t2.append((Object)new Integer(3));
        TestDataModel.assertFalse((String)"different size", (boolean)t1.equals(t2));
    }

    @Test
    public void testTupleCompareTo() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple();
        Tuple t2 = tf.newTuple();
        t1.append((Object)new Integer(3));
        t2.append((Object)new Integer(3));
        TestDataModel.assertEquals((String)"same data equal", (int)0, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new Integer(2));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new Integer(4));
        TestDataModel.assertEquals((String)"less than tuple with greater value", (int)-1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new Integer(3));
        t2.append((Object)new Integer(4));
        TestDataModel.assertEquals((String)"less than bigger tuple", (int)-1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        TestDataModel.assertEquals((String)"greater than smaller tuple", (int)1, (int)t1.compareTo((Object)t2));
    }

    @Test
    public void testMultiFieldTupleCompareTo() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple();
        Tuple t2 = tf.newTuple();
        t1.append((Object)new DataByteArray("bbb"));
        t1.append((Object)new DataByteArray("bbb"));
        t2.append((Object)new DataByteArray("bbb"));
        t2.append((Object)new DataByteArray("bbb"));
        TestDataModel.assertEquals((String)"same data equal", (int)0, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("aaa"));
        t2.append((Object)new DataByteArray("aaa"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("ddd"));
        t2.append((Object)new DataByteArray("ddd"));
        TestDataModel.assertEquals((String)"less than tuple with greater value", (int)-1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("bbb"));
        t2.append((Object)new DataByteArray("aaa"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("bbb"));
        t2.append((Object)new DataByteArray("ccc"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)-1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("aaa"));
        t2.append((Object)new DataByteArray("bbb"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("ccc"));
        t2.append((Object)new DataByteArray("bbb"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)-1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("aaa"));
        t2.append((Object)new DataByteArray("ccc"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)1, (int)t1.compareTo((Object)t2));
        t2 = tf.newTuple();
        t2.append((Object)new DataByteArray("ccc"));
        t2.append((Object)new DataByteArray("aaa"));
        TestDataModel.assertEquals((String)"greater than tuple with lesser value", (int)-1, (int)t1.compareTo((Object)t2));
    }

    @Test
    public void testByteArrayToString() throws Exception {
        DataByteArray ba = new DataByteArray("hello world");
        TestDataModel.assertEquals((String)"toString", (String)"hello world", (String)ba.toString());
    }

    @Test
    public void testByteArrayHashCode() throws Exception {
        DataByteArray ba1 = new DataByteArray("hello world");
        DataByteArray ba2 = new DataByteArray("hello world");
        DataByteArray ba3 = new DataByteArray("goodbye world");
        TestDataModel.assertEquals((String)"same data", (int)ba1.hashCode(), (int)ba2.hashCode());
        TestDataModel.assertFalse((String)"different data", (ba1.hashCode() == ba3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testByteArrayEquals() throws Exception {
        DataByteArray ba1 = new DataByteArray("hello world");
        DataByteArray ba2 = new DataByteArray("hello world");
        DataByteArray ba3 = new DataByteArray("goodbye world");
        TestDataModel.assertTrue((String)"same data", (boolean)ba1.equals((Object)ba2));
        TestDataModel.assertFalse((String)"different data", (boolean)ba1.equals((Object)ba3));
    }

    @Test
    public void testByteArrayCompareTo() throws Exception {
        DataByteArray ba1 = new DataByteArray("hello world");
        DataByteArray ba2 = new DataByteArray("hello world");
        DataByteArray ba3 = new DataByteArray("goodbye world");
        TestDataModel.assertTrue((String)"same data", (ba1.compareTo((Object)ba2) == 0 ? 1 : 0) != 0);
        TestDataModel.assertTrue((String)"different length lexically lower value less than", (ba3.compareTo((Object)ba1) < 0 ? 1 : 0) != 0);
        TestDataModel.assertTrue((String)"different length lexically higher value greater than", (ba1.compareTo((Object)ba3) > 0 ? 1 : 0) != 0);
        ba2 = new DataByteArray("hello worlc");
        TestDataModel.assertTrue((String)"same length lexically lower value less than", (ba2.compareTo((Object)ba1) < 0 ? 1 : 0) != 0);
        TestDataModel.assertTrue((String)"same length lexically higher value greater than", (ba1.compareTo((Object)ba2) > 0 ? 1 : 0) != 0);
        ba2 = new DataByteArray("hello worlds");
        TestDataModel.assertTrue((String)"shorter lexically same value less than", (ba1.compareTo((Object)ba2) < 0 ? 1 : 0) != 0);
        TestDataModel.assertTrue((String)"longer lexically same value greater than", (ba2.compareTo((Object)ba1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerConversionErr() throws Exception {
        ArrayList list = new ArrayList();
        try {
            DataType.toInteger(list);
            TestDataModel.fail((String)"Error expected.");
        }
        catch (ExecException ee) {
            TestDataModel.assertTrue((ee.getErrorCode() == 1071 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIntegerConversionErr1() throws Exception {
        DataByteArray ba = new DataByteArray("hello world");
        try {
            DataType.toInteger((Object)ba);
            TestDataModel.fail((String)"Error expected.");
        }
        catch (ExecException ee) {
            TestDataModel.assertTrue((ee.getErrorCode() == 1074 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTupleConversionErr() throws Exception {
        ArrayList list = new ArrayList();
        try {
            DataType.toTuple(list);
            TestDataModel.fail((String)"Error expected.");
        }
        catch (ExecException ee) {
            TestDataModel.assertTrue((ee.getErrorCode() == 1071 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTupleConversionErr1() throws Exception {
        DataByteArray ba = new DataByteArray("hello world");
        try {
            DataType.toTuple((Object)ba);
            TestDataModel.fail((String)"Error expected.");
        }
        catch (ExecException ee) {
            TestDataModel.assertTrue((ee.getErrorCode() == 1071 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMapConversionErr() throws Exception {
        ArrayList list = new ArrayList();
        try {
            DataType.toMap(list);
            TestDataModel.fail((String)"Error expected.");
        }
        catch (ExecException ee) {
            TestDataModel.assertTrue((ee.getErrorCode() == 1071 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMapConversion() throws Exception {
        HashMap map = new HashMap();
        try {
            DataType.toMap(map);
        }
        catch (ExecException ee) {
            TestDataModel.fail((String)"Exception not expected.");
        }
    }

    @Test
    public void testDetermineFieldSchemaErr() throws Exception {
        ArrayList list = new ArrayList();
        try {
            DataType.determineFieldSchema(list);
            TestDataModel.fail((String)"Error expected.");
        }
        catch (ExecException ee) {
            TestDataModel.assertTrue((ee.getErrorCode() == 1073 ? 1 : 0) != 0);
        }
    }

    private Tuple giveMeOneOfEach() throws Exception {
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t1 = tf.newTuple(11);
        Tuple t2 = tf.newTuple(2);
        t2.set(0, (Object)new Integer(3));
        t2.set(1, (Object)new Float(3.0));
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(tf.newTuple((Object)new Integer(4)));
        bag.add(tf.newTuple((Object)new String("mary had a little lamb")));
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(new String("hello"), new String("world"));
        map.put(new String("goodbye"), new String("all"));
        t1.set(0, (Object)t2);
        t1.set(1, (Object)bag);
        t1.set(2, map);
        t1.set(3, (Object)new Integer(42));
        t1.set(4, (Object)new Long(5000000000L));
        t1.set(5, (Object)new Float(3.141592654));
        t1.set(6, (Object)new Double(2.99792458E8));
        t1.set(7, (Object)new Boolean(true));
        t1.set(8, (Object)new DataByteArray("hello"));
        t1.set(9, (Object)new String("goodbye"));
        return t1;
    }
}

