/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.builtin.TextLoader;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.PigFile;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.Identity;
import org.junit.Before;
import org.junit.Test;

public class TestEvalPipeline
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;
    private PigContext pigContext;
    TupleFactory mTf = TupleFactory.getInstance();
    BagFactory mBf = BagFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        FileLocalizer.setR((Random)new Random());
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        this.pigContext = this.pigServer.getPigContext();
    }

    @Test
    public void testFunctionInsideFunction() throws Exception {
        File f1 = Util.createFile(new String[]{"a:1", "b:1", "a:1"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(f1.toString(), this.pigContext) + "' using " + PigStorage.class.getName() + "(':');");
        this.pigServer.registerQuery("b = foreach a generate 1-1/1;");
        Iterator iter = this.pigServer.openIterator("b");
        for (int i = 0; i < 3; ++i) {
            TestEvalPipeline.assertEquals((Object)DataType.toDouble((Object)((Tuple)iter.next()).get(0)), (Object)0.0);
        }
    }

    @Test
    public void testJoin() throws Exception {
        File f1 = Util.createFile(new String[]{"a:1", "b:1", "a:1"});
        File f2 = Util.createFile(new String[]{"b", "b", "a"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(f1.toString(), this.pigContext) + "' using " + PigStorage.class.getName() + "(':');");
        this.pigServer.registerQuery("b = load '" + Util.generateURI(f2.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("c = cogroup a by $0, b by $0;");
        this.pigServer.registerQuery("d = foreach c generate flatten($1),flatten($2);");
        Iterator iter = this.pigServer.openIterator("d");
        int count = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertTrue((boolean)t.get(0).toString().equals(t.get(2).toString()));
            ++count;
        }
        TestEvalPipeline.assertEquals((int)count, (int)4);
    }

    @Test
    public void testDriverMethod() throws Exception {
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        pw.println("a");
        pw.println("a");
        pw.close();
        this.pigServer.registerQuery("a = foreach (load '" + Util.generateURI(f.toString(), this.pigContext) + "') " + "generate 1, flatten(" + MyBagFunction.class.getName() + "(*));");
        Iterator iter = this.pigServer.openIterator("a");
        int count = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertTrue((boolean)t.get(0).toString().equals("1"));
            TestEvalPipeline.assertTrue((boolean)t.get(1).toString().equals("a"));
            ++count;
        }
        TestEvalPipeline.assertEquals((int)count, (int)6);
        f.delete();
    }

    @Test
    public void testMapLookup() throws Exception {
        DataBag b = BagFactory.getInstance().newDefaultBag();
        HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("apple", "red");
        colors.put("orange", "orange");
        HashMap<String, String> weights = new HashMap<String, String>();
        weights.put("apple", "0.1");
        weights.put("orange", "0.3");
        Tuple t = this.mTf.newTuple();
        t.append(colors);
        t.append(weights);
        b.add(t);
        File tmpFile = File.createTempFile("tmp", "");
        tmpFile.deleteOnExit();
        String fileName = tmpFile.getAbsolutePath();
        PigFile f = new PigFile(fileName);
        f.store(b, new FuncSpec(BinStorage.class.getCanonicalName()), this.pigServer.getPigContext());
        this.pigServer.registerQuery("a = load '" + fileName + "' using BinStorage();");
        this.pigServer.registerQuery("b = foreach a generate $0#'apple',flatten($1#'orange');");
        Iterator iter = this.pigServer.openIterator("b");
        t = (Tuple)iter.next();
        TestEvalPipeline.assertEquals((String)t.get(0).toString(), (String)"red");
        TestEvalPipeline.assertEquals((Object)DataType.toDouble((Object)t.get(1)), (Object)0.3);
        TestEvalPipeline.assertFalse((boolean)iter.hasNext());
        Util.deleteFile(this.cluster, fileName);
    }

    @Test
    public void testBagFunctionWithFlattening() throws Exception {
        File queryLogFile = Util.createFile(new String[]{"stanford\tdeer\tsighting", "bush\tpresident", "stanford\tbush", "conference\tyahoo", "world\tcup\tcricket", "bush\twins", "stanford\tpresident"});
        File newsFile = Util.createFile(new String[]{"deer seen at stanford", "george bush visits stanford", "yahoo hosting a conference in the bay area", "who will win the world cup"});
        HashMap<String, Integer> expectedResults = new HashMap<String, Integer>();
        expectedResults.put("bush", 2);
        expectedResults.put("stanford", 3);
        expectedResults.put("world", 1);
        expectedResults.put("conference", 1);
        this.pigServer.registerQuery("newsArticles = LOAD '" + Util.generateURI(newsFile.toString(), this.pigContext) + "' USING " + TextLoader.class.getName() + "();");
        this.pigServer.registerQuery("queryLog = LOAD '" + Util.generateURI(queryLogFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("titleNGrams = FOREACH newsArticles GENERATE flatten(" + TitleNGrams.class.getName() + "(*));");
        this.pigServer.registerQuery("cogrouped = COGROUP titleNGrams BY $0 INNER, queryLog BY $0 INNER;");
        this.pigServer.registerQuery("answer = FOREACH cogrouped GENERATE COUNT(queryLog),group;");
        Iterator iter = this.pigServer.openIterator("answer");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No Output received");
        }
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertEquals((Object)((Integer)expectedResults.get(t.get(1).toString())).doubleValue(), (Object)DataType.toDouble((Object)t.get(0)));
        }
    }

    @Test
    public void testSortWithUDF() throws Exception {
        this.testSortDistinct(false, true);
    }

    @Test
    public void testDistinct() throws Exception {
        this.testSortDistinct(true, false);
    }

    private void testSortDistinct(boolean eliminateDuplicates, boolean useUDF) throws Exception {
        int LOOP_SIZE = 16384;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        Random r = new Random();
        for (int i = 0; i < LOOP_SIZE; ++i) {
            ps.println(r.nextInt(LOOP_SIZE / 2) + "\t" + i);
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        if (eliminateDuplicates) {
            this.pigServer.registerQuery("B = DISTINCT (FOREACH A GENERATE $0) PARALLEL 10;");
        } else if (!useUDF) {
            this.pigServer.registerQuery("B = ORDER A BY $0 PARALLEL 10;");
        } else {
            this.pigServer.registerQuery("B = ORDER A BY $0 using " + TupComp.class.getName() + ";");
        }
        Iterator iter = this.pigServer.openIterator("B");
        String last = "";
        HashSet<Integer> seen = new HashSet<Integer>();
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No Results obtained");
        }
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            if (eliminateDuplicates) {
                Integer act = Integer.parseInt(t.get(0).toString());
                TestEvalPipeline.assertFalse((boolean)seen.contains(act));
                seen.add(act);
                continue;
            }
            TestEvalPipeline.assertTrue((last.compareTo(t.get(0).toString()) <= 0 ? 1 : 0) != 0);
            TestEvalPipeline.assertEquals((int)t.size(), (int)2);
            last = t.get(0).toString();
        }
    }

    public void testNestedPlan() throws Exception {
        int LOOP_COUNT = 10;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = group A by $0;");
        String query = "C = foreach B {C1 = filter A by $0 > -1;C2 = distinct C1;C3 = distinct A;generate (int)group," + Identity.class.getName() + "(*), COUNT(C2), SUM(C2.$1)," + TitleNGrams.class.getName() + "(C3), MAX(C3.$1), C2;" + "};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numIdentity = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertEquals((Object)numIdentity, (Object)((Integer)t.get(0)));
            TestEvalPipeline.assertEquals((Object)5L, (Object)((Long)t.get(2)));
            TestEvalPipeline.assertEquals((double)((double)LOOP_COUNT * 2.0), (double)((Double)t.get(3)), (double)0.01);
            TestEvalPipeline.assertEquals((double)8.0, (double)((Double)t.get(5)), (double)0.01);
            TestEvalPipeline.assertEquals((long)5L, (long)((DataBag)t.get(6)).size());
            TestEvalPipeline.assertEquals((int)7, (int)t.size());
            ++numIdentity;
        }
        TestEvalPipeline.assertEquals((int)LOOP_COUNT, (int)numIdentity);
    }

    public void testNestedPlanWithExpressionAssignment() throws Exception {
        int LOOP_COUNT = 10;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = group A by $0;");
        String query = "C = foreach B {C1 = filter A by $0 > -1;C2 = distinct C1;C3 = distinct A;C4 = " + Identity.class.getName() + "(*);" + "C5 = COUNT(C2);" + "C6 = SUM(C2.$1);" + "C7 = " + TitleNGrams.class.getName() + "(C3);" + "C8 = MAX(C3.$1);" + "generate (int)group, C4, C5, C6, C7, C8, C2;" + "};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numIdentity = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertEquals((Object)numIdentity, (Object)((Integer)t.get(0)));
            TestEvalPipeline.assertEquals((Object)5L, (Object)((Long)t.get(2)));
            TestEvalPipeline.assertEquals((double)((double)LOOP_COUNT * 2.0), (double)((Double)t.get(3)), (double)0.01);
            TestEvalPipeline.assertEquals((double)8.0, (double)((Double)t.get(5)), (double)0.01);
            TestEvalPipeline.assertEquals((long)5L, (long)((DataBag)t.get(6)).size());
            TestEvalPipeline.assertEquals((int)7, (int)t.size());
            ++numIdentity;
        }
        TestEvalPipeline.assertEquals((int)LOOP_COUNT, (int)numIdentity);
    }

    public void testLimit() throws Exception {
        int LOOP_COUNT = 20;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            ps.println(i);
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = limit A 5;");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numIdentity = 0;
        while (iter.hasNext()) {
            iter.next();
            ++numIdentity;
        }
        TestEvalPipeline.assertEquals((int)5, (int)numIdentity);
    }

    @Test
    public void testComplexData() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"{(f1, f2),(f3, f4)}\t(1,2)\t[key1#value1,key2#value2]"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (b:bag{t:tuple(x,y)}, t2:tuple(a,b), m:map[]);");
        this.pigServer.registerQuery("b = foreach a generate COUNT(b), t2.a, t2.b, m#'key1', m#'key2';");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)new Long(2L), (Object)t.get(0));
        TestEvalPipeline.assertEquals((String)"1", (String)t.get(1).toString());
        TestEvalPipeline.assertEquals((String)"2", (String)t.get(2).toString());
        TestEvalPipeline.assertEquals((String)"value1", (String)t.get(3).toString());
        TestEvalPipeline.assertEquals((String)"value2", (String)t.get(4).toString());
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (b:bag{t:tuple(x,y)}, t2:tuple(a,b), m:map[]);");
        String output = "/pig/out/TestEvalPipeline-testComplexData";
        this.pigServer.deleteFile(output);
        this.pigServer.store("a", output, BinStorage.class.getName());
        this.pigServer.registerQuery("x = load '" + output + "' using BinStorage() " + "as (b:bag{t:tuple(x,y)}, t2:tuple(a,b), m:map[]);");
        this.pigServer.registerQuery("y = foreach x generate COUNT(b), t2.a, t2.b, m#'key1', m#'key2';");
        it = this.pigServer.openIterator("y");
        t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)new Long(2L), (Object)t.get(0));
        TestEvalPipeline.assertEquals((String)"1", (String)t.get(1).toString());
        TestEvalPipeline.assertEquals((String)"2", (String)t.get(2).toString());
        TestEvalPipeline.assertEquals((String)"value1", (String)t.get(3).toString());
        TestEvalPipeline.assertEquals((String)"value2", (String)t.get(4).toString());
    }

    @Test
    public void testBinStorageDetermineSchema() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"{(f1, f2),(f3, f4)}\t(1,2)\t[key1#value1,key2#value2]"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (b:bag{t:tuple(x:chararray,y:chararray)}, t2:tuple(a:int,b:int), m:map[]);");
        this.pigServer.registerQuery("b = foreach a generate COUNT(b), t2.a, t2.b, m#'key1', m#'key2';");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)new Long(2L), (Object)t.get(0));
        TestEvalPipeline.assertEquals((Object)1, (Object)t.get(1));
        TestEvalPipeline.assertEquals((Object)2, (Object)t.get(2));
        TestEvalPipeline.assertEquals((String)"value1", (String)t.get(3).toString());
        TestEvalPipeline.assertEquals((String)"value2", (String)t.get(4).toString());
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (b:bag{t:tuple(x:chararray,y:chararray)}, t2:tuple(a:int,b:int), m:map[]);");
        String output = "/pig/out/TestEvalPipeline-testBinStorageDetermineSchema";
        this.pigServer.deleteFile(output);
        this.pigServer.store("a", output, BinStorage.class.getName());
        String[] loads = new String[]{"p = load '" + output + "' using BinStorage() " + "as (b:bag{t:tuple(x,y)}, t2:tuple(a,b), m:map[]);", "p = load '" + output + "' using BinStorage() " + "as (b, t2, m);", "p = load '" + output + "' using BinStorage() ;"};
        String[] generates = new String[]{"q = foreach p generate COUNT(b), t2.a, t2.b as t2b, m#'key1', m#'key2', b;", "q = foreach p generate COUNT(b), t2.$0, t2.$1, m#'key1', m#'key2', b;", "q = foreach p generate COUNT($0), $1.$0, $1.$1, $2#'key1', $2#'key2', $0;"};
        for (int i = 0; i < loads.length; ++i) {
            this.pigServer.registerQuery(loads[i]);
            this.pigServer.registerQuery(generates[i]);
            it = this.pigServer.openIterator("q");
            t = (Tuple)it.next();
            TestEvalPipeline.assertEquals((Object)new Long(2L), (Object)t.get(0));
            TestEvalPipeline.assertEquals(Integer.class, t.get(1).getClass());
            TestEvalPipeline.assertEquals((Object)1, (Object)t.get(1));
            TestEvalPipeline.assertEquals(Integer.class, t.get(2).getClass());
            TestEvalPipeline.assertEquals((Object)2, (Object)t.get(2));
            TestEvalPipeline.assertEquals((String)"value1", (String)t.get(3).toString());
            TestEvalPipeline.assertEquals((String)"value2", (String)t.get(4).toString());
            TestEvalPipeline.assertEquals(DefaultDataBag.class, t.get(5).getClass());
            DataBag bg = (DataBag)t.get(5);
            for (Tuple bt : bg) {
                TestEvalPipeline.assertEquals(String.class, bt.get(0).getClass());
                TestEvalPipeline.assertEquals(String.class, bt.get(1).getClass());
            }
        }
    }

    @Test
    public void testProjectBag() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"f1\tf2\tf3"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' as (x, y, z);");
        this.pigServer.registerQuery("b = group a by x;");
        this.pigServer.registerQuery("c = foreach b generate flatten(a.(y, z));");
        Iterator it = this.pigServer.openIterator("c");
        Tuple t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((int)2, (int)t.size());
        TestEvalPipeline.assertEquals((String)"f2", (String)t.get(0).toString());
        TestEvalPipeline.assertEquals((String)"f3", (String)t.get(1).toString());
    }

    @Test
    public void testBinStorageDetermineSchema2() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"pigtester\t10\t1.2"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (name:chararray, age:int, gpa:double);");
        String output = "/pig/out/TestEvalPipeline-testBinStorageDetermineSchema2";
        this.pigServer.deleteFile(output);
        this.pigServer.store("a", output, BinStorage.class.getName());
        String[] loads = new String[]{"p = load '" + output + "' using BinStorage() " + "as (name:chararray, age:int, gpa:double);", "p = load '" + output + "' using BinStorage() " + "as (name, age, gpa);", "p = load '" + output + "' using BinStorage() ;"};
        String[] generates = new String[]{"q = foreach p generate name, age, gpa;", "q = foreach p generate name, age, gpa;", "q = foreach p generate $0, $1, $2;"};
        for (int i = 0; i < loads.length; ++i) {
            this.pigServer.registerQuery(loads[i]);
            this.pigServer.registerQuery(generates[i]);
            Iterator it = this.pigServer.openIterator("q");
            Tuple t = (Tuple)it.next();
            TestEvalPipeline.assertEquals((Object)"pigtester", (Object)t.get(0));
            TestEvalPipeline.assertEquals(String.class, t.get(0).getClass());
            TestEvalPipeline.assertEquals((Object)10, (Object)t.get(1));
            TestEvalPipeline.assertEquals(Integer.class, t.get(1).getClass());
            TestEvalPipeline.assertEquals((Object)1.2, (Object)t.get(2));
            TestEvalPipeline.assertEquals(Double.class, t.get(2).getClass());
        }
        this.pigServer.registerQuery("p = load '" + output + "' using BinStorage() " + " as (name, age:long, gpa:float);");
        this.pigServer.registerQuery("q = foreach p generate name, age, gpa;");
        Iterator it = this.pigServer.openIterator("q");
        Tuple t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)"pigtester", (Object)t.get(0));
        TestEvalPipeline.assertEquals(String.class, t.get(0).getClass());
        TestEvalPipeline.assertEquals((Object)10L, (Object)t.get(1));
        TestEvalPipeline.assertEquals(Long.class, t.get(1).getClass());
        TestEvalPipeline.assertEquals((Object)Float.valueOf(1.2f), (Object)t.get(2));
        TestEvalPipeline.assertEquals(Float.class, t.get(2).getClass());
        this.pigServer.registerQuery("p = load '" + output + "' using BinStorage() " + " as (name, age, gpa);");
        this.pigServer.registerQuery("q = foreach p generate name, age + 1L, (int)gpa;");
        it = this.pigServer.openIterator("q");
        t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)"pigtester", (Object)t.get(0));
        TestEvalPipeline.assertEquals(String.class, t.get(0).getClass());
        TestEvalPipeline.assertEquals((Object)11L, (Object)t.get(1));
        TestEvalPipeline.assertEquals(Long.class, t.get(1).getClass());
        TestEvalPipeline.assertEquals((Object)1, (Object)t.get(2));
        TestEvalPipeline.assertEquals(Integer.class, t.get(2).getClass());
    }

    @Test
    public void testCogroupWithInputFromGroup() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"pigtester\t10\t1.2", "pigtester\t15\t1.2", "pigtester2\t10\t1.2", "pigtester3\t10\t1.2", "pigtester3\t20\t1.2", "pigtester3\t30\t1.2"});
        HashMap<String, Pair> resultMap = new HashMap<String, Pair>();
        resultMap.put("pigtester", new Pair((Object)25L, (Object)2L));
        resultMap.put("pigtester2", new Pair((Object)10L, (Object)1L));
        resultMap.put("pigtester3", new Pair((Object)60L, (Object)3L));
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (name:chararray, age:int, gpa:double);");
        this.pigServer.registerQuery("b = group a by name;");
        this.pigServer.registerQuery("c = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (name:chararray, age:int, gpa:double);");
        this.pigServer.registerQuery("d = cogroup b by group, c by name;");
        this.pigServer.registerQuery("e = foreach d generate flatten(group), SUM(c.age), COUNT(c.name);");
        Iterator it = this.pigServer.openIterator("e");
        for (int i = 0; i < resultMap.size(); ++i) {
            Tuple t = (Tuple)it.next();
            TestEvalPipeline.assertEquals((boolean)true, (boolean)resultMap.containsKey(t.get(0)));
            Pair output = (Pair)resultMap.get(t.get(0));
            TestEvalPipeline.assertEquals((Object)output.first, (Object)t.get(1));
            TestEvalPipeline.assertEquals((Object)output.second, (Object)t.get(2));
        }
    }

    @Test
    public void testUtf8Dump() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"wendy\u03be"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using PigStorage() " + "as (name:chararray);");
        Iterator it = this.pigServer.openIterator("a");
        Tuple t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)"wendy\u03be", (Object)t.get(0));
    }

    public void testMapUDF() throws Exception {
        int LOOP_COUNT = 2;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = foreach A generate " + MapUDF.class.getName() + "($0) as mymap;");
        String query = "C = foreach B {generate (double)mymap#'double' as d, (long)mymap#'long' + (float)mymap#'float' as float_sum, CONCAT((chararray) mymap#'string', ' World!'), mymap#'int' * 10, (bag{tuple()}) mymap#'bag' as mybag, (tuple()) mymap#'tuple' as mytuple, (map[])mymap#'map' as mapInMap, mymap#'dba' as dba;};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numIdentity = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertEquals((double)1.0, (double)((Double)t.get(0)), (double)0.01);
            TestEvalPipeline.assertEquals((double)2.0, (double)((Float)t.get(1)).floatValue(), (double)0.01);
            TestEvalPipeline.assertTrue((boolean)((String)t.get(2)).equals("Hello World!"));
            TestEvalPipeline.assertEquals((Object)new Integer(10), (Object)((Integer)t.get(3)));
            TestEvalPipeline.assertEquals((long)1L, (long)((DataBag)t.get(4)).size());
            TestEvalPipeline.assertEquals((int)4, (int)((Tuple)t.get(5)).size());
            TestEvalPipeline.assertEquals((int)2, (int)((Map)t.get(6)).size());
            TestEvalPipeline.assertEquals(DataByteArray.class, t.get(7).getClass());
            TestEvalPipeline.assertEquals((int)8, (int)t.size());
            ++numIdentity;
        }
        TestEvalPipeline.assertEquals((int)(LOOP_COUNT * LOOP_COUNT), (int)numIdentity);
    }

    public void testMapUDFFail() throws Exception {
        int LOOP_COUNT = 2;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = foreach A generate " + MapUDF.class.getName() + "($0) as mymap;");
        String query = "C = foreach B {generate mymap#'dba' * 10;};";
        this.pigServer.registerQuery(query);
        try {
            this.pigServer.openIterator("C");
            TestEvalPipeline.fail((String)"Error expected.");
        }
        catch (Exception e) {
            e.getMessage().contains("Cannot determine");
        }
    }

    @Test
    public void testLoadCtorArgs() throws IOException, ExecException {
        File input = Util.createInputFile("tmp", "", new String[]{"hello:world"});
        this.pigServer.registerQuery("a = load '" + Util.generateURI(input.toString(), this.pigContext) + "' using org.apache.pig.test.PigStorageNoDefCtor(':');");
        this.pigServer.registerQuery("b = foreach a generate (chararray)$0, (chararray)$1;");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        TestEvalPipeline.assertEquals((Object)"hello", (Object)t.get(0));
        TestEvalPipeline.assertEquals((Object)"world", (Object)t.get(1));
    }

    @Test
    public void testNestedPlanForCloning() throws Exception {
        int LOOP_COUNT = 10;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = group A by $0;");
        String query = "C = foreach B {C1 = filter A by not($0 <= -1);C2 = distinct C1;C3 = distinct A;C4 = order A by $0;generate (group + 1) * 10, COUNT(C4), COUNT(C2), SUM(C2.$1)," + TitleNGrams.class.getName() + "(C3), MAX(C3.$1), C2;" + "};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numIdentity = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestEvalPipeline.assertEquals((Object)((numIdentity + 1) * 10), (Object)((Integer)t.get(0)));
            TestEvalPipeline.assertEquals((Object)10L, (Object)((Long)t.get(1)));
            TestEvalPipeline.assertEquals((Object)5L, (Object)((Long)t.get(2)));
            TestEvalPipeline.assertEquals((double)((double)LOOP_COUNT * 2.0), (double)((Double)t.get(3)), (double)0.01);
            TestEvalPipeline.assertEquals((double)8.0, (double)((Double)t.get(5)), (double)0.01);
            TestEvalPipeline.assertEquals((long)5L, (long)((DataBag)t.get(6)).size());
            TestEvalPipeline.assertEquals((int)7, (int)t.size());
            ++numIdentity;
        }
        TestEvalPipeline.assertEquals((int)LOOP_COUNT, (int)numIdentity);
    }

    @Test
    public void testArithmeticCloning() throws Exception {
        int LOOP_COUNT = 10;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = distinct A;");
        String query = "C = foreach B {C1 = $1 - $0;C2 = $1%2;C3 = ($1 == 0? 0 : $0/$1);generate C1, C2, C3;};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numRows = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                Tuple t = null;
                if (iter.hasNext()) {
                    t = (Tuple)iter.next();
                }
                TestEvalPipeline.assertEquals((int)3, (int)t.size());
                TestEvalPipeline.assertEquals((double)new Double(j - i), (double)((Double)t.get(0)), (double)0.01);
                TestEvalPipeline.assertEquals((Object)(j % 2), (Object)((Integer)t.get(1)));
                if (j == 0) {
                    TestEvalPipeline.assertEquals((double)0.0, (double)((Double)t.get(2)), (double)0.01);
                } else {
                    TestEvalPipeline.assertEquals((double)((double)i / (double)j), (double)((Double)t.get(2)), (double)0.01);
                }
                ++numRows;
            }
        }
        TestEvalPipeline.assertEquals((int)(LOOP_COUNT * LOOP_COUNT / 2), (int)numRows);
    }

    @Test
    public void testExpressionReUse() throws Exception {
        int LOOP_COUNT = 10;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = distinct A;");
        String query = "C = foreach B {C1 = $0 + $1;C2 = C1 + $0;generate C1, C2;};";
        this.pigServer.registerQuery(query);
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numRows = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                Tuple t = null;
                if (iter.hasNext()) {
                    t = (Tuple)iter.next();
                }
                TestEvalPipeline.assertEquals((int)2, (int)t.size());
                TestEvalPipeline.assertEquals((double)new Double(i + j), (double)((Double)t.get(0)), (double)0.01);
                TestEvalPipeline.assertEquals((Object)new Double(i + j + i), (Object)((Double)t.get(1)));
                ++numRows;
            }
        }
        TestEvalPipeline.assertEquals((int)(LOOP_COUNT * LOOP_COUNT / 2), (int)numRows);
    }

    @Test
    public void testIdentity() throws Exception {
        int LOOP_COUNT = 2;
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                ps.println(i + "\t" + j);
                ps.println(i + "\t" + j);
            }
        }
        ps.close();
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(tmpFile.toString(), this.pigContext) + "';");
        this.pigServer.registerQuery("B = distinct A ;");
        this.pigServer.registerQuery("C = foreach B generate FLATTEN(" + Identity.class.getName() + "($0, $1));");
        Iterator iter = this.pigServer.openIterator("C");
        if (!iter.hasNext()) {
            TestEvalPipeline.fail((String)"No output found");
        }
        int numRows = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            for (int j = 0; j < LOOP_COUNT; j += 2) {
                Tuple t = null;
                if (iter.hasNext()) {
                    t = (Tuple)iter.next();
                }
                TestEvalPipeline.assertEquals((int)2, (int)t.size());
                TestEvalPipeline.assertEquals((double)new Double(i), (double)new Double(t.get(0).toString()), (double)0.01);
                TestEvalPipeline.assertEquals((double)new Double(j), (double)new Double(t.get(1).toString()), (double)0.01);
                ++numRows;
            }
        }
        TestEvalPipeline.assertEquals((int)(LOOP_COUNT * LOOP_COUNT / 2), (int)numRows);
    }

    @Test
    public void testCogroupAfterDistinct() throws Exception {
        String[] input1 = new String[]{"abc", "abc", "def", "def", "def", "abc", "def", "ghi"};
        String[] input2 = new String[]{"ghi\t4", "rst\t12344", "uvw\t1", "xyz\t4141"};
        Util.createInputFile(this.cluster, "table1", input1);
        Util.createInputFile(this.cluster, "table2", input2);
        this.pigServer.registerQuery("nonuniqtable1 = LOAD 'table1' AS (f1:chararray);");
        this.pigServer.registerQuery("table1 = DISTINCT nonuniqtable1;");
        this.pigServer.registerQuery("table2 = LOAD 'table2' AS (f1:chararray, f2:int);");
        this.pigServer.registerQuery("temp = COGROUP table1 BY f1 INNER, table2 BY f1;");
        Iterator it = this.pigServer.openIterator("temp");
        HashMap<String, Tuple> results = new HashMap<String, Tuple>();
        Object[] row = new Object[]{"abc", Util.createBagOfOneColumn(new String[]{"abc"}), this.mBf.newDefaultBag()};
        results.put("abc", Util.createTuple(row));
        row = new Object[]{"def", Util.createBagOfOneColumn(new String[]{"def"}), this.mBf.newDefaultBag()};
        results.put("def", Util.createTuple(row));
        Object[] thirdColContents = new Object[]{"ghi", 4};
        Tuple t = Util.createTuple(thirdColContents);
        row = new Object[]{"ghi", Util.createBagOfOneColumn(new String[]{"ghi"}), Util.createBag(new Tuple[]{t})};
        results.put("ghi", Util.createTuple(row));
        while (it.hasNext()) {
            Tuple tup = (Tuple)it.next();
            List fields = tup.getAll();
            Tuple expected = (Tuple)results.get((String)fields.get(0));
            int i = 0;
            for (Object field : fields) {
                TestEvalPipeline.assertEquals((Object)expected.get(i++), field);
            }
        }
        Util.deleteFile(this.cluster, "table1");
        Util.deleteFile(this.cluster, "table2");
    }

    @Test
    public void testAlgebraicDistinctProgress() throws Exception {
        int inputSize = 4004;
        Integer[] inp = new Integer[inputSize];
        String[] inpString = new String[inputSize];
        for (int i = 0; i < inputSize; i += 2) {
            inp[i] = i / 2;
            inp[i + 1] = i / 2;
            inpString[i] = new Integer(i / 2).toString();
            inpString[i + 1] = new Integer(i / 2).toString();
        }
        Util.createInputFile(this.cluster, "table", inpString);
        this.pigServer.registerQuery("a = LOAD 'table' AS (i:int);");
        this.pigServer.registerQuery("b = group a ALL;");
        this.pigServer.registerQuery("c = foreach b {aa = DISTINCT a; generate COUNT(aa);};");
        Iterator it = this.pigServer.openIterator("c");
        Integer[] exp = new Integer[inputSize / 2];
        for (int j = 0; j < inputSize / 2; ++j) {
            exp[j] = j;
        }
        DataBag expectedBag = Util.createBagOfOneColumn(exp);
        while (it.hasNext()) {
            Tuple tup = (Tuple)it.next();
            Long resultBagSize = (Long)tup.get(0);
            TestEvalPipeline.assertTrue((DataType.compare((Object)expectedBag.size(), (Object)resultBagSize) == 0 ? 1 : 0) != 0);
        }
        Util.deleteFile(this.cluster, "table");
    }

    @Test
    public void testBinStorageWithLargeStrings() throws Exception {
        int testSize = 100;
        String[] stringArray = new String[testSize];
        Random random = new Random();
        stringArray[0] = GenRandomData.genRandLargeString(random, 65534);
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = i % 25 == 0 ? GenRandomData.genRandLargeString(random, 65535 + i) : GenRandomData.genRandString(random);
        }
        Util.createInputFile(this.cluster, "table", stringArray);
        this.pigServer.registerQuery("a = load 'table' using PigStorage() as (c: chararray);");
        String output = "/pig/out/TestEvalPipeline-testBinStorageLargeStrings";
        this.pigServer.deleteFile(output);
        this.pigServer.store("a", output, BinStorage.class.getName());
        this.pigServer.registerQuery("b = load '" + output + "' using BinStorage() " + "as (c:chararray);");
        this.pigServer.registerQuery("c = foreach b generate c;");
        Iterator it = this.pigServer.openIterator("c");
        int counter = 0;
        while (it.hasNext()) {
            Tuple tup = (Tuple)it.next();
            String resultString = (String)tup.get(0);
            String expectedString = stringArray[counter];
            TestEvalPipeline.assertTrue((boolean)expectedString.equals(resultString));
            ++counter;
        }
        Util.deleteFile(this.cluster, "table");
    }

    public static class TupComp
    extends ComparisonFunc {
        public int compare(Tuple t1, Tuple t2) {
            return t1.compareTo((Object)t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapUDF
    extends EvalFunc<Map<String, Object>> {
        public Map<String, Object> exec(Tuple input) throws IOException {
            TupleFactory tupleFactory = TupleFactory.getInstance();
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(new Integer(1));
            objList.add(new Double(1.0));
            objList.add(new Float(1.0));
            objList.add(new String("World!"));
            Tuple tuple = tupleFactory.newTuple(objList);
            BagFactory bagFactory = BagFactory.getInstance();
            DataBag bag = bagFactory.newDefaultBag();
            bag.add(tuple);
            HashMap<String, Number> mapInMap = new HashMap<String, Number>();
            mapInMap.put("int", new Integer(10));
            mapInMap.put("float", new Float(10.0));
            HashMap<String, Object> myMap = new HashMap<String, Object>();
            myMap.put("string", new String("Hello"));
            myMap.put("int", new Integer(1));
            myMap.put("long", new Long(1L));
            myMap.put("float", new Float(1.0));
            myMap.put("double", new Double(1.0));
            myMap.put("dba", new DataByteArray(new String("bytes").getBytes()));
            myMap.put("map", mapInMap);
            myMap.put("tuple", tuple);
            myMap.put("bag", bag);
            return myMap;
        }

        public Schema outputSchema(Schema input) {
            return new Schema(new Schema.FieldSchema(null, 100));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TitleNGrams
    extends EvalFunc<DataBag> {
        public DataBag exec(Tuple input) throws IOException {
            try {
                String str;
                DataBag output = BagFactory.getInstance().newDefaultBag();
                String title = str = input.get(0).toString();
                if (title != null) {
                    List<String> nGrams = this.makeNGrams(title);
                    Iterator<String> it = nGrams.iterator();
                    while (it.hasNext()) {
                        Tuple t = TupleFactory.getInstance().newTuple(1);
                        t.set(0, (Object)it.next());
                        output.add(t);
                    }
                }
                return output;
            }
            catch (ExecException ee) {
                IOException ioe = new IOException(ee.getMessage());
                ioe.initCause(ee);
                throw ioe;
            }
        }

        List<String> makeNGrams(String str) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str);
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
            return this.nGramHelper(tokens, new ArrayList<String>());
        }

        ArrayList<String> nGramHelper(List<String> str, ArrayList<String> nGrams) {
            if (str.size() == 0) {
                return nGrams;
            }
            for (int i = 0; i < str.size(); ++i) {
                nGrams.add(this.makeString(str.subList(0, i + 1)));
            }
            return this.nGramHelper(str.subList(1, str.size()), nGrams);
        }

        String makeString(List<String> list) {
            StringBuffer sb = new StringBuffer();
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }

        public Schema outputSchema(Schema input) {
            try {
                Schema stringSchema = new Schema(new Schema.FieldSchema(null, 55));
                Schema.FieldSchema fs = new Schema.FieldSchema(null, stringSchema, 120);
                return new Schema(fs);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyBagFunction
    extends EvalFunc<DataBag> {
        public DataBag exec(Tuple input) throws IOException {
            TupleFactory tf = TupleFactory.getInstance();
            DataBag output = BagFactory.getInstance().newDefaultBag();
            output.add(tf.newTuple((Object)"a"));
            output.add(tf.newTuple((Object)"a"));
            output.add(tf.newTuple((Object)"a"));
            return output;
        }
    }
}

