/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.junit.Before;
import org.junit.Test;

public class TestExampleGenerator
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    PigContext pigContext = new PigContext(ExecType.MAPREDUCE, this.cluster.getProperties());
    Random rand = new Random();
    int MAX = 100;
    String A;
    String B;

    public TestExampleGenerator() {
        try {
            this.pigContext.connect();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        File fileA = File.createTempFile("dataA", ".dat");
        File fileB = File.createTempFile("dataB", ".dat");
        this.writeData(fileA);
        this.writeData(fileB);
        this.A = "'" + FileLocalizer.hadoopify((String)fileA.toString(), (PigContext)this.pigContext) + "'";
        this.B = "'" + FileLocalizer.hadoopify((String)fileB.toString(), (PigContext)this.pigContext) + "'";
        System.out.println("A : " + this.A + "\n" + "B : " + this.B);
        System.out.println("Test data created.");
    }

    private void writeData(File dataFile) throws Exception {
        FileOutputStream dat = new FileOutputStream(dataFile);
        Random rand = new Random();
        for (int i = 0; i < this.MAX; ++i) {
            dat.write((rand.nextInt(10) + "\t" + rand.nextInt(10) + "\n").getBytes());
        }
        dat.close();
    }

    @Test
    public void testFilter() throws Exception {
        PigServer pigserver = new PigServer(this.pigContext);
        String query = "A = load " + this.A + " using PigStorage() as (x : int, y : int);\n";
        pigserver.registerQuery(query);
        query = "B = filter A by x > 10;";
        pigserver.registerQuery(query);
        Map derivedData = pigserver.getExamples("B");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }

    @Test
    public void testForeach() throws ExecException, IOException {
        PigServer pigServer = new PigServer(this.pigContext);
        pigServer.registerQuery("A = load " + this.A + " using PigStorage() as (x : int, y : int);");
        pigServer.registerQuery("B = foreach A generate x + y as sum;");
        Map derivedData = pigServer.getExamples("B");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }

    @Test
    public void testJoin() throws IOException, ExecException {
        PigServer pigServer = new PigServer(this.pigContext);
        pigServer.registerQuery("A1 = load " + this.A + " as (x, y);");
        pigServer.registerQuery("B1 = load " + this.B + " as (x, y);");
        pigServer.registerQuery("E = join A1 by x, B1 by x;");
        Map derivedData = pigServer.getExamples("E");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }

    @Test
    public void testCogroupMultipleCols() throws Exception {
        PigServer pigServer = new PigServer(this.pigContext);
        pigServer.registerQuery("A = load " + this.A + " as (x, y);");
        pigServer.registerQuery("B = load " + this.B + " as (x, y);");
        pigServer.registerQuery("C = cogroup A by (x, y), B by (x, y);");
        Map derivedData = pigServer.getExamples("C");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }

    @Test
    public void testCogroup() throws Exception {
        PigServer pigServer = new PigServer(this.pigContext);
        pigServer.registerQuery("A = load " + this.A + " as (x, y);");
        pigServer.registerQuery("B = load " + this.B + " as (x, y);");
        pigServer.registerQuery("C = cogroup A by x, B by x;");
        Map derivedData = pigServer.getExamples("C");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }

    @Test
    public void testGroup() throws Exception {
        PigServer pigServer = new PigServer(this.pigContext);
        pigServer.registerQuery("A = load " + this.A.toString() + " as (x, y);");
        pigServer.registerQuery("B = group A by x;");
        Map derivedData = pigServer.getExamples("B");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }

    @Test
    public void testUnion() throws Exception {
        PigServer pigServer = new PigServer(this.pigContext);
        pigServer.registerQuery("A = load " + this.A.toString() + " as (x, y);");
        pigServer.registerQuery("B = load " + this.B.toString() + " as (x, y);");
        pigServer.registerQuery("C = union A, B;");
        Map derivedData = pigServer.getExamples("C");
        TestExampleGenerator.assertTrue((derivedData != null ? 1 : 0) != 0);
    }
}

