/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.pig.experimental.logical.LogicalPlanMigrationVistor;
import org.apache.pig.experimental.logical.optimizer.LogicalPlanOptimizer;
import org.apache.pig.experimental.logical.optimizer.UidStamper;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalRelationalOperator;
import org.apache.pig.experimental.logical.rules.AddForEach;
import org.apache.pig.experimental.logical.rules.ColumnMapKeyPrune;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.optimizer.Rule;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.test.utils.LogicalPlanTester;

public class TestExperimentalColumnPrune
extends TestCase {
    LogicalPlan plan = null;

    private LogicalPlan migratePlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp) throws VisitorException {
        LogicalPlanMigrationVistor visitor = new LogicalPlanMigrationVistor(lp);
        visitor.visit();
        LogicalPlan newPlan = visitor.getNewLogicalPlan();
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)newPlan);
            stamper.visit();
            return newPlan;
        }
        catch (Exception e) {
            throw new VisitorException((Throwable)e);
        }
    }

    public void testNoPrune() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v2);");
        lpt.buildPlan("b = filter a by v1==NULL;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v2);");
        lpt.buildPlan("b = filter a by v1==NULL;");
        plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("b = foreach a generate $0, $1;");
        plan = lpt.buildPlan("store b into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("b = foreach a generate $0, $1;");
        plan = lpt.buildPlan("store b into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
    }

    public void testPrune() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v2);");
        lpt.buildPlan("b = foreach a generate id;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id);");
        lpt.buildPlan("b = foreach a generate id;");
        plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = filter a by v1 != NULL AND (v2+v3)<100;");
        lpt.buildPlan("c = foreach b generate id;");
        plan = lpt.buildPlan("store c into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v3, v2);");
        lpt.buildPlan("b = filter a by v1 != NULL AND (v2+v3)<100;");
        lpt.buildPlan("c = foreach b generate id;");
        plan = lpt.buildPlan("store c into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v2, v5, v4;");
        lpt.buildPlan("c = foreach b generate v5, v4;");
        plan = lpt.buildPlan("store c into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (v5, v4);");
        lpt.buildPlan("b = foreach a generate v5, v4;");
        lpt.buildPlan("c = foreach b generate v5, v4;");
        plan = lpt.buildPlan("store c into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate id, v1, v5, v3, v4;");
        lpt.buildPlan("c = foreach b generate v5, v4;");
        plan = lpt.buildPlan("store c into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (v5, v4);");
        lpt.buildPlan("b = foreach a generate v5, v4;");
        lpt.buildPlan("c = foreach b generate v5, v4;");
        plan = lpt.buildPlan("store c into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v2, v5, v4;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5, v4;");
        plan = lpt.buildPlan("store d into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (v5, v4, v2);");
        lpt.buildPlan("b = foreach a generate v2, v5, v4;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5, v4;");
        plan = lpt.buildPlan("store d into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v2, v3);");
        lpt.buildPlan("b = load 'c.txt' as (id, v4, v5, v6);");
        lpt.buildPlan("c = join a by id, b by id;");
        lpt.buildPlan("d = foreach c generate a::id, v5, v3, v4;");
        plan = lpt.buildPlan("store d into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v3);");
        lpt.buildPlan("b = load 'c.txt' as (id, v4, v5);");
        lpt.buildPlan("c = join a by id, b by id;");
        lpt.buildPlan("d = foreach c generate a::id, v5, v3, v4;");
        plan = lpt.buildPlan("store d into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' using BinStorage() as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("c = filter a by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5, v4;");
        plan = lpt.buildPlan("store d into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' using BinStorage() as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v5, v4, v2;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5, v4;");
        plan = lpt.buildPlan("store d into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' using BinStorage() as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v5, v4, v2;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5;");
        plan = lpt.buildPlan("store d into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' using BinStorage() as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v5, v2;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5;");
        plan = lpt.buildPlan("store d into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' using BinStorage() as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v5, v4, v2, 10;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5;");
        plan = lpt.buildPlan("store d into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' using BinStorage() as (id, v1, v5, v3, v4, v2);");
        lpt.buildPlan("b = foreach a generate v5, v2, 10;");
        lpt.buildPlan("c = filter b by v2 != NULL;");
        lpt.buildPlan("d = foreach c generate v5;");
        plan = lpt.buildPlan("store d into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
    }

    public void testPruneWithMapKey() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, m:map[]);");
        lpt.buildPlan("b = foreach a generate id, m#'path';");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, m:map[]);");
        lpt.buildPlan("b = foreach a generate id, m#'path';");
        plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        LOLoad op = (LOLoad)newLogicalPlan.getSources().get(0);
        Map annotation = (Map)op.getAnnotation("MapPruner:RequiredKeys");
        TestExperimentalColumnPrune.assertEquals((int)annotation.size(), (int)1);
        HashSet<String> s = new HashSet<String>();
        s.add("path");
        TestExperimentalColumnPrune.assertEquals(annotation.get(2), s);
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, m:map[]);");
        lpt.buildPlan("b = load 'd.txt' as (id, v1, m:map[]);");
        lpt.buildPlan("c = join a by id, b by id;");
        lpt.buildPlan("d = filter c by a::m#'path' != NULL;");
        lpt.buildPlan("e = foreach d generate a::id, b::id, b::m#'path', a::m;");
        plan = lpt.buildPlan("store e into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, m:map[]);");
        lpt.buildPlan("b = load 'd.txt' as (id, m:map[]);");
        lpt.buildPlan("c = join a by id, b by id;");
        lpt.buildPlan("d = filter c by a::m#'path' != NULL;");
        lpt.buildPlan("e = foreach d generate a::id, b::id, b::m#'path', a::m;");
        plan = lpt.buildPlan("store e into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        List ll = newLogicalPlan.getSources();
        TestExperimentalColumnPrune.assertEquals((int)ll.size(), (int)2);
        LOLoad loada = null;
        LOLoad loadb = null;
        for (Operator opp : ll) {
            if (((LogicalRelationalOperator)opp).getAlias().equals("a")) {
                loada = (LOLoad)opp;
                continue;
            }
            if (!((LogicalRelationalOperator)opp).getAlias().equals("b")) continue;
            loadb = (LOLoad)opp;
        }
        annotation = (Map)loada.getAnnotation("MapPruner:RequiredKeys");
        TestExperimentalColumnPrune.assertNull((Object)annotation);
        annotation = (Map)loadb.getAnnotation("MapPruner:RequiredKeys");
        TestExperimentalColumnPrune.assertEquals((int)annotation.size(), (int)1);
        s = new HashSet();
        s.add("path");
        TestExperimentalColumnPrune.assertEquals(annotation.get(2), s);
    }

    public void testPruneWithBag() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v:bag{t:(s1,s2,s3)});");
        lpt.buildPlan("b = filter a by id>10;");
        lpt.buildPlan("c = foreach b generate id, FLATTEN(v);");
        lpt.buildPlan("d = foreach c generate id, v::s2;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store d into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v:bag{t:(s1,s2,s3)});");
        lpt.buildPlan("b = filter a by id>10;");
        lpt.buildPlan("c = foreach b generate id, FLATTEN(v);");
        lpt.buildPlan("d = foreach c generate id, v::s2;");
        plan = lpt.buildPlan("store d into 'empty';");
        LogicalPlan expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
    }

    public void testAddForeach() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v2);");
        lpt.buildPlan("b = filter a by v1>10;");
        lpt.buildPlan("c = foreach b generate id;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1);");
        lpt.buildPlan("b = filter a by v1>10;");
        lpt.buildPlan("c = foreach b generate id;");
        plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1, v2);");
        lpt.buildPlan("b = load 'd.txt' as (id, v1, v2);");
        lpt.buildPlan("c = join a by id, b by id;");
        lpt.buildPlan("d = filter c by a::v1>b::v1;");
        lpt.buildPlan("e = foreach d generate a::id;");
        plan = lpt.buildPlan("store e into 'empty';");
        newLogicalPlan = this.migratePlan(plan);
        optimizer = new MyPlanOptimizer((OperatorPlan)newLogicalPlan, 3);
        optimizer.optimize();
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, v1);");
        lpt.buildPlan("b = load 'd.txt' as (id, v1);");
        lpt.buildPlan("c = join a by id, b by id;");
        lpt.buildPlan("d = foreach c generate a::id, a::v1, b::v1;");
        lpt.buildPlan("e = filter d by a::v1>b::v1;");
        lpt.buildPlan("f = foreach e generate a::id;");
        plan = lpt.buildPlan("store f into 'empty';");
        expected = this.migratePlan(plan);
        TestExperimentalColumnPrune.assertTrue((boolean)expected.isEqual((OperatorPlan)newLogicalPlan));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyPlanOptimizer
    extends LogicalPlanOptimizer {
        protected MyPlanOptimizer(OperatorPlan p, int iterations) {
            super(p, iterations);
        }

        protected List<Set<Rule>> buildRuleSets() {
            ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
            ColumnMapKeyPrune r = new ColumnMapKeyPrune("ColumnMapKeyPrune");
            HashSet<ColumnMapKeyPrune> s = new HashSet<ColumnMapKeyPrune>();
            s.add(r);
            ls.add(s);
            r = new AddForEach("AddForEach");
            s = new HashSet();
            s.add(r);
            ls.add(s);
            return ls;
        }
    }
}

