/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.pig.experimental.logical.expression.AndExpression;
import org.apache.pig.experimental.logical.expression.ConstantExpression;
import org.apache.pig.experimental.logical.expression.EqualExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.experimental.logical.optimizer.AllSameVisitor;
import org.apache.pig.experimental.logical.optimizer.ProjectionPatcher;
import org.apache.pig.experimental.logical.optimizer.SchemaPatcher;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOJoin;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalRelationalOperator;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.plan.DepthFirstWalker;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.PlanWalker;
import org.apache.pig.impl.util.MultiMap;
import org.junit.Before;
import org.junit.Test;

public class TestExperimentalListener
extends TestCase {
    private LogicalPlan lp;
    private LogicalPlan changedPlan;

    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.lp = new LogicalPlan();
        LogicalSchema aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        aschema.getField((int)0).uid = 1L;
        LOLoad A = new LOLoad(null, aschema, this.lp);
        this.lp.add((Operator)A);
        LogicalSchema bschema = new LogicalSchema();
        bschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        bschema.getField((int)0).uid = 2L;
        LOLoad B = new LOLoad(null, bschema, this.lp);
        this.lp.add((Operator)B);
        LogicalSchema cschema = new LogicalSchema();
        cschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        cschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        cschema.getField((int)0).uid = 1L;
        cschema.getField((int)1).uid = 2L;
        LogicalExpressionPlan aprojplan = new LogicalExpressionPlan();
        ProjectExpression x = new ProjectExpression((OperatorPlan)aprojplan, 10, 0, 0);
        x.neverUseForRealSetUid(1L);
        LogicalExpressionPlan bprojplan = new LogicalExpressionPlan();
        ProjectExpression y = new ProjectExpression((OperatorPlan)bprojplan, 10, 1, 0);
        y.neverUseForRealSetUid(2L);
        MultiMap mm = new MultiMap();
        mm.put((Object)0, (Object)aprojplan);
        mm.put((Object)1, (Object)bprojplan);
        LOJoin C = new LOJoin(this.lp, mm, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C.neverUseForRealSetSchema(cschema);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression fy = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 1);
        fy.neverUseForRealSetUid(2L);
        ConstantExpression fc = new ConstantExpression((OperatorPlan)filterPlan, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)fy, (LogicalExpression)fc);
        LOFilter D = new LOFilter(this.lp, filterPlan);
        D.neverUseForRealSetSchema(cschema);
        this.lp.add((Operator)D);
        this.lp.connect((Operator)B, (Operator)D);
        this.lp.add((Operator)C);
        this.lp.connect((Operator)A, (Operator)C);
        this.lp.connect((Operator)D, (Operator)C);
        this.changedPlan = new LogicalPlan();
        this.changedPlan.add((Operator)D);
        this.changedPlan.add((Operator)C);
        this.changedPlan.connect((Operator)D, (Operator)C);
    }

    @Test
    public void testAllSameVisitor() throws IOException {
        SillySameVisitor v = new SillySameVisitor((OperatorPlan)this.lp);
        v.visit();
        TestExperimentalListener.assertTrue(("LOLoad LOJoin LOLoad LOFilter ".equals(v.toString()) || "LOLoad LOFilter LOJoin LOLoad ".equals(v.toString()) ? 1 : 0) != 0);
    }

    @Test
    public void testAllExpressionVisitor() throws IOException {
        SillyAllExpressionVisitor v = new SillyAllExpressionVisitor((OperatorPlan)this.lp);
        v.visit();
        TestExperimentalListener.assertTrue(("proj proj equal proj const ".equals(v.toString()) || "equal proj const proj proj ".equals(v.toString()) ? 1 : 0) != 0);
    }

    @Test
    public void testSchemaPatcher() throws IOException {
        SchemaPatcher patcher = new SchemaPatcher();
        patcher.transformed((OperatorPlan)this.lp, (OperatorPlan)this.changedPlan);
        List roots = this.changedPlan.getSources();
        TestExperimentalListener.assertEquals((int)1, (int)roots.size());
        LOFilter D = (LOFilter)roots.get(0);
        TestExperimentalListener.assertNotNull((Object)D);
        LogicalSchema dschema = D.getSchema();
        TestExperimentalListener.assertEquals((int)1, (int)dschema.size());
        LogicalSchema.LogicalFieldSchema y = dschema.getField(0);
        TestExperimentalListener.assertEquals((String)"y", (String)y.alias);
        TestExperimentalListener.assertEquals((long)2L, (long)y.uid);
    }

    @Test
    public void testProjectionPatcher() throws IOException {
        ProjectionPatcher patcher = new ProjectionPatcher();
        patcher.transformed((OperatorPlan)this.lp, (OperatorPlan)this.changedPlan);
        List roots = this.changedPlan.getSources();
        TestExperimentalListener.assertEquals((int)1, (int)roots.size());
        LOFilter D = (LOFilter)roots.get(0);
        TestExperimentalListener.assertNotNull((Object)D);
        LogicalExpressionPlan filterPlan = D.getFilterPlan();
        List leaves = filterPlan.getSinks();
        TestExperimentalListener.assertEquals((int)2, (int)leaves.size());
        ProjectExpression proj = null;
        for (Operator leaf : leaves) {
            if (!(leaf instanceof ProjectExpression)) continue;
            proj = (ProjectExpression)leaf;
            break;
        }
        TestExperimentalListener.assertNotNull(proj);
        TestExperimentalListener.assertEquals((int)0, (int)proj.getInputNum());
        TestExperimentalListener.assertEquals((int)0, (int)proj.getColNum());
    }

    private static class SillyAllExpressionVisitor
    extends AllExpressionVisitor {
        StringBuffer buf = new StringBuffer();

        public SillyAllExpressionVisitor(OperatorPlan plan) {
            super(plan, (PlanWalker)new DepthFirstWalker(plan));
        }

        protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan expr) {
            return new SillyExpressionVisitor((OperatorPlan)expr, this.buf);
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    private static class SillyExpressionVisitor
    extends LogicalExpressionVisitor {
        StringBuffer buf;

        protected SillyExpressionVisitor(OperatorPlan p, StringBuffer b) {
            super(p, (PlanWalker)new DepthFirstWalker(p));
            this.buf = b;
        }

        public void visitAnd(AndExpression andExpr) throws IOException {
            this.buf.append("and ");
        }

        public void visitEqual(EqualExpression equal) throws IOException {
            this.buf.append("equal ");
        }

        public void visitProject(ProjectExpression p) throws IOException {
            this.buf.append("proj ");
        }

        public void visitConstant(ConstantExpression c) throws IOException {
            this.buf.append("const ");
        }
    }

    private static class SillySameVisitor
    extends AllSameVisitor {
        StringBuffer buf = new StringBuffer();

        SillySameVisitor(OperatorPlan plan) {
            super(plan, (PlanWalker)new DepthFirstWalker(plan));
        }

        protected void execute(LogicalRelationalOperator op) throws IOException {
            this.buf.append(op.getName());
            this.buf.append(" ");
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

