/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.pig.FuncSpec;
import org.apache.pig.experimental.logical.expression.AndExpression;
import org.apache.pig.experimental.logical.expression.ConstantExpression;
import org.apache.pig.experimental.logical.expression.EqualExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.optimizer.LogicalPlanOptimizer;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOJoin;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.util.MultiMap;
import org.junit.Test;

public class TestExperimentalLogicalOptimizer
extends TestCase {
    @Test
    public void testFilterPushDown() throws IOException {
        LogicalPlan lp = new LogicalPlan();
        LogicalSchema aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        aschema.getField((int)0).uid = 1L;
        aschema.getField((int)1).uid = 2L;
        LOLoad A = new LOLoad(new FileSpec("bla", new FuncSpec("PigStorage", "\t")), aschema, lp);
        lp.add((Operator)A);
        LogicalSchema bschema = new LogicalSchema();
        bschema.addField(new LogicalSchema.LogicalFieldSchema("a", null, 10));
        bschema.addField(new LogicalSchema.LogicalFieldSchema("b", null, 10));
        bschema.getField((int)0).uid = 3L;
        bschema.getField((int)1).uid = 4L;
        LOLoad B = new LOLoad(null, bschema, lp);
        lp.add((Operator)B);
        LogicalSchema cschema = new LogicalSchema();
        cschema.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        cschema.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        cschema.addField(new LogicalSchema.LogicalFieldSchema("a", null, 10));
        cschema.addField(new LogicalSchema.LogicalFieldSchema("b", null, 10));
        cschema.getField((int)0).uid = 1L;
        cschema.getField((int)1).uid = 2L;
        cschema.getField((int)2).uid = 3L;
        cschema.getField((int)3).uid = 4L;
        LogicalExpressionPlan aprojplan = new LogicalExpressionPlan();
        ProjectExpression x = new ProjectExpression((OperatorPlan)aprojplan, 10, 0, 0);
        x.neverUseForRealSetUid(1L);
        LogicalExpressionPlan bprojplan = new LogicalExpressionPlan();
        ProjectExpression y = new ProjectExpression((OperatorPlan)bprojplan, 10, 1, 0);
        y.neverUseForRealSetUid(3L);
        MultiMap mm = new MultiMap();
        mm.put((Object)0, (Object)aprojplan);
        mm.put((Object)1, (Object)bprojplan);
        LOJoin C = new LOJoin(lp, mm, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C.neverUseForRealSetSchema(cschema);
        lp.add((Operator)C);
        lp.connect((Operator)A, (Operator)C);
        lp.connect((Operator)B, (Operator)C);
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ProjectExpression fx = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 0);
        fx.neverUseForRealSetUid(1L);
        ConstantExpression fc0 = new ConstantExpression((OperatorPlan)filterPlan, 10, (Object)new Integer(0));
        EqualExpression eq1 = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)fx, (LogicalExpression)fc0);
        ProjectExpression fanotherx = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 0);
        fanotherx.neverUseForRealSetUid(1L);
        ProjectExpression fa = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 2);
        fa.neverUseForRealSetUid(3L);
        EqualExpression eq2 = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)fanotherx, (LogicalExpression)fa);
        AndExpression and1 = new AndExpression((OperatorPlan)filterPlan, (LogicalExpression)eq1, (LogicalExpression)eq2);
        ProjectExpression fb = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 3);
        fb.neverUseForRealSetUid(4L);
        ConstantExpression fc1 = new ConstantExpression((OperatorPlan)filterPlan, 10, (Object)new Integer(1));
        EqualExpression eq3 = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)fb, (LogicalExpression)fc1);
        AndExpression and2 = new AndExpression((OperatorPlan)filterPlan, (LogicalExpression)and1, (LogicalExpression)eq3);
        ProjectExpression fanotherb = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 3);
        fanotherb.neverUseForRealSetUid(4L);
        ProjectExpression fy = new ProjectExpression((OperatorPlan)filterPlan, 10, 0, 1);
        fy.neverUseForRealSetUid(2L);
        EqualExpression eq4 = new EqualExpression((OperatorPlan)filterPlan, (LogicalExpression)fy, (LogicalExpression)fanotherb);
        new AndExpression((OperatorPlan)filterPlan, (LogicalExpression)and2, (LogicalExpression)eq4);
        LOFilter D = new LOFilter(lp, filterPlan);
        D.neverUseForRealSetSchema(cschema);
        lp.add((Operator)D);
        lp.connect((Operator)C, (Operator)D);
        LogicalPlanOptimizer optimizer = new LogicalPlanOptimizer((OperatorPlan)lp, 500);
        optimizer.optimize();
        LogicalPlan expected = new LogicalPlan();
        LogicalSchema aschema2 = new LogicalSchema();
        aschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        aschema2.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        aschema2.getField((int)0).uid = 1L;
        aschema2.getField((int)1).uid = 2L;
        LOLoad A2 = new LOLoad(new FileSpec("bla", new FuncSpec("PigStorage", "\t")), aschema2, expected);
        expected.add((Operator)A2);
        LogicalExpressionPlan DAfilterPlan = new LogicalExpressionPlan();
        ProjectExpression fx2 = new ProjectExpression((OperatorPlan)DAfilterPlan, 10, 0, 0);
        fx2.neverUseForRealSetUid(1L);
        ConstantExpression fc02 = new ConstantExpression((OperatorPlan)DAfilterPlan, 10, (Object)new Integer(0));
        new EqualExpression((OperatorPlan)DAfilterPlan, (LogicalExpression)fx2, (LogicalExpression)fc02);
        LOFilter DA = new LOFilter(expected, DAfilterPlan);
        DA.neverUseForRealSetSchema(aschema2);
        expected.add((Operator)DA);
        expected.connect((Operator)A2, (Operator)DA);
        LogicalSchema bschema2 = new LogicalSchema();
        bschema2.addField(new LogicalSchema.LogicalFieldSchema("a", null, 10));
        bschema2.addField(new LogicalSchema.LogicalFieldSchema("b", null, 10));
        bschema2.getField((int)0).uid = 3L;
        bschema2.getField((int)1).uid = 4L;
        LOLoad B2 = new LOLoad(null, bschema2, expected);
        expected.add((Operator)B2);
        LogicalExpressionPlan DBfilterPlan = new LogicalExpressionPlan();
        ProjectExpression fb2 = new ProjectExpression((OperatorPlan)DBfilterPlan, 10, 0, 1);
        fb2.neverUseForRealSetUid(4L);
        ConstantExpression fc12 = new ConstantExpression((OperatorPlan)DBfilterPlan, 10, (Object)new Integer(1));
        new EqualExpression((OperatorPlan)DBfilterPlan, (LogicalExpression)fb2, (LogicalExpression)fc12);
        LOFilter DB = new LOFilter(expected, DBfilterPlan);
        DB.neverUseForRealSetSchema(bschema2);
        expected.add((Operator)DB);
        expected.connect((Operator)B2, (Operator)DB);
        LogicalSchema cschema2 = new LogicalSchema();
        cschema2.addField(new LogicalSchema.LogicalFieldSchema("x", null, 10));
        cschema2.addField(new LogicalSchema.LogicalFieldSchema("y", null, 10));
        cschema2.addField(new LogicalSchema.LogicalFieldSchema("a", null, 10));
        cschema2.addField(new LogicalSchema.LogicalFieldSchema("b", null, 10));
        cschema2.getField((int)0).uid = 1L;
        cschema2.getField((int)1).uid = 2L;
        cschema2.getField((int)2).uid = 3L;
        cschema2.getField((int)3).uid = 4L;
        LogicalExpressionPlan aprojplan2 = new LogicalExpressionPlan();
        ProjectExpression x2 = new ProjectExpression((OperatorPlan)aprojplan2, 10, 0, 0);
        x2.neverUseForRealSetUid(1L);
        LogicalExpressionPlan bprojplan2 = new LogicalExpressionPlan();
        ProjectExpression y2 = new ProjectExpression((OperatorPlan)bprojplan2, 10, 1, 0);
        y2.neverUseForRealSetUid(3L);
        MultiMap mm2 = new MultiMap();
        mm2.put((Object)0, (Object)aprojplan2);
        mm2.put((Object)1, (Object)bprojplan2);
        LOJoin C2 = new LOJoin(expected, mm2, LOJoin.JOINTYPE.HASH, new boolean[]{true, true});
        C2.neverUseForRealSetSchema(cschema2);
        expected.add((Operator)C2);
        expected.connect((Operator)DA, (Operator)C2);
        expected.connect((Operator)DB, (Operator)C2);
        LogicalExpressionPlan filterPlan2 = new LogicalExpressionPlan();
        ProjectExpression fanotherx2 = new ProjectExpression((OperatorPlan)filterPlan2, 10, 0, 0);
        fanotherx2.neverUseForRealSetUid(1L);
        ProjectExpression fa2 = new ProjectExpression((OperatorPlan)filterPlan2, 10, 0, 2);
        fa2.neverUseForRealSetUid(3L);
        EqualExpression eq22 = new EqualExpression((OperatorPlan)filterPlan2, (LogicalExpression)fanotherx2, (LogicalExpression)fa2);
        ProjectExpression fanotherb2 = new ProjectExpression((OperatorPlan)filterPlan2, 10, 0, 3);
        fanotherb2.neverUseForRealSetUid(4L);
        ProjectExpression fy2 = new ProjectExpression((OperatorPlan)filterPlan2, 10, 0, 1);
        fy2.neverUseForRealSetUid(2L);
        EqualExpression eq42 = new EqualExpression((OperatorPlan)filterPlan2, (LogicalExpression)fy2, (LogicalExpression)fanotherb2);
        new AndExpression((OperatorPlan)filterPlan2, (LogicalExpression)eq22, (LogicalExpression)eq42);
        LOFilter D2 = new LOFilter(expected, filterPlan2);
        D2.neverUseForRealSetSchema(cschema2);
        expected.add((Operator)D2);
        expected.connect((Operator)C2, (Operator)D2);
        TestExperimentalLogicalOptimizer.assertTrue((boolean)lp.isEqual((OperatorPlan)expected));
    }
}

