/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.experimental.logical.LogicalPlanMigrationVistor;
import org.apache.pig.experimental.logical.optimizer.PlanPrinter;
import org.apache.pig.experimental.logical.optimizer.ProjectionPatcher;
import org.apache.pig.experimental.logical.optimizer.SchemaPatcher;
import org.apache.pig.experimental.logical.optimizer.UidStamper;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LogToPhyTranslationVisitor;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.rules.ColumnMapKeyPrune;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.experimental.plan.optimizer.PlanOptimizer;
import org.apache.pig.experimental.plan.optimizer.PlanTransformListener;
import org.apache.pig.experimental.plan.optimizer.Rule;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.test.utils.LogicalPlanTester;

public class TestExperimentalPruneMapKeys
extends TestCase {
    private PhysicalPlan translatePlan(OperatorPlan plan) throws IOException {
        LogToPhyTranslationVisitor visitor = new LogToPhyTranslationVisitor(plan);
        visitor.visit();
        return visitor.getPhysicalPlan();
    }

    private LogicalPlan migratePlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp) throws VisitorException {
        LogicalPlanMigrationVistor visitor = new LogicalPlanMigrationVistor(lp);
        visitor.visit();
        LogicalPlan newPlan = visitor.getNewLogicalPlan();
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)newPlan);
            stamper.visit();
            HashSet<ColumnMapKeyPrune> s = new HashSet<ColumnMapKeyPrune>();
            ArrayList<Set<Rule>> ls = new ArrayList<Set<Rule>>();
            ls.add(s);
            ColumnMapKeyPrune r = new ColumnMapKeyPrune("PruneMapKeys");
            s.add(r);
            this.printPlan(newPlan);
            MyPlanOptimizer optimizer = new MyPlanOptimizer((OperatorPlan)newPlan, ls, 3);
            optimizer.addPlanTransformListener((PlanTransformListener)new ProjectionPatcher());
            optimizer.addPlanTransformListener((PlanTransformListener)new SchemaPatcher());
            optimizer.optimize();
            return newPlan;
        }
        catch (Exception e) {
            throw new VisitorException((Throwable)e);
        }
    }

    public void testSimplePlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:map[], b:int, c:float);");
        lpt.buildPlan("b = filter a by a#'name' == 'hello';");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        List sources = newLogicalPlan.getSources();
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)sources.size());
        for (Operator source : sources) {
            Map annotation = (Map)source.getAnnotation("MapPruner:RequiredKeys");
            TestExperimentalPruneMapKeys.assertTrue((annotation == null || annotation.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void testSimplePlan2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:map[], b:int, c:float);");
        lpt.buildPlan("b = filter a by a#'name' == 'hello';");
        lpt.buildPlan("c = foreach b generate b,c;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)newLogicalPlan.getSources().size());
        LOLoad load = (LOLoad)newLogicalPlan.getSources().get(0);
        Map annotation = (Map)load.getAnnotation("MapPruner:RequiredKeys");
        TestExperimentalPruneMapKeys.assertTrue((annotation != null ? 1 : 0) != 0);
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)annotation.keySet().size());
        Integer[] keySet = annotation.keySet().toArray(new Integer[0]);
        TestExperimentalPruneMapKeys.assertEquals((Object)new Integer(0), (Object)keySet[0]);
        Set keys = (Set)annotation.get(0);
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)keys.size());
        TestExperimentalPruneMapKeys.assertEquals((String)"name", (String)keys.toArray(new String[0])[0]);
    }

    public void testSimplePlan3() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:map[], b:int, c:float);");
        lpt.buildPlan("b = filter a by a#'name' == 'hello';");
        lpt.buildPlan("c = foreach b generate a#'age',b,c;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)newLogicalPlan.getSources().size());
        LOLoad load = (LOLoad)newLogicalPlan.getSources().get(0);
        Map annotation = (Map)load.getAnnotation("MapPruner:RequiredKeys");
        TestExperimentalPruneMapKeys.assertTrue((annotation != null ? 1 : 0) != 0);
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)annotation.keySet().size());
        Integer[] keySet = annotation.keySet().toArray(new Integer[0]);
        TestExperimentalPruneMapKeys.assertEquals((Object)new Integer(0), (Object)keySet[0]);
        Set keys = (Set)annotation.get(0);
        TestExperimentalPruneMapKeys.assertEquals((int)2, (int)keys.size());
        TestExperimentalPruneMapKeys.assertTrue((boolean)keys.contains("name"));
        TestExperimentalPruneMapKeys.assertTrue((boolean)keys.contains("age"));
    }

    public void testSimplePlan4() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:map[], b:int, c:float);");
        lpt.buildPlan("b = filter a by a#'name' == 'hello';");
        lpt.buildPlan("c = foreach b generate a#'age',a,b,c;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        List sources = newLogicalPlan.getSources();
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)sources.size());
        for (Operator source : sources) {
            Map annotation = (Map)source.getAnnotation("MapPruner:RequiredKeys");
            TestExperimentalPruneMapKeys.assertTrue((annotation == null || annotation.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void testSimplePlan5() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (a:chararray, b:int, c:float);");
        lpt.buildPlan("b = filter a by a == 'hello';");
        lpt.buildPlan("c = foreach b generate a,b,c;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        List sources = newLogicalPlan.getSources();
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)sources.size());
        for (Operator source : sources) {
            Map annotation = (Map)source.getAnnotation("MapPruner:RequiredKeys");
            TestExperimentalPruneMapKeys.assertTrue((annotation == null ? 1 : 0) != 0);
        }
    }

    public void testSimplePlan6() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("b = filter a by $0 == 'hello';");
        lpt.buildPlan("c = foreach b generate $0,$1,$2;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        List sources = newLogicalPlan.getSources();
        TestExperimentalPruneMapKeys.assertEquals((int)1, (int)sources.size());
        for (Operator source : sources) {
            Map annotation = (Map)source.getAnnotation("MapPruner:RequiredKeys");
            TestExperimentalPruneMapKeys.assertTrue((annotation == null ? 1 : 0) != 0);
        }
    }

    public void testSimplePlan7() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("a1 = load 'b.txt' as (a:map[],b:int, c:float);");
        lpt.buildPlan("b = join a by $0, a1 by a#'name';");
        lpt.buildPlan("c = foreach b generate $0,$1,$2;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        this.printPlan(plan);
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        List sources = newLogicalPlan.getSources();
        TestExperimentalPruneMapKeys.assertEquals((int)2, (int)sources.size());
        for (Operator source : sources) {
            Map annotation = (Map)source.getAnnotation("MapPruner:RequiredKeys");
            TestExperimentalPruneMapKeys.assertTrue((annotation == null || annotation.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void testSimplePlan8() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("a1 = load 'b.txt' as (a:chararray,b:int, c:float);");
        lpt.buildPlan("b = join a by $0, a1 by a;");
        lpt.buildPlan("c = foreach b generate $0,$1,$2;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into 'empty';");
        this.printPlan(plan);
        LogicalPlan newLogicalPlan = this.migratePlan(plan);
        List sources = newLogicalPlan.getSources();
        TestExperimentalPruneMapKeys.assertEquals((int)2, (int)sources.size());
        for (Operator source : sources) {
            Map annotation = (Map)source.getAnnotation("MapPruner:RequiredKeys");
            TestExperimentalPruneMapKeys.assertTrue((annotation == null || annotation.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void printPlan(LogicalPlan logicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        PlanPrinter pp = new PlanPrinter((OperatorPlan)logicalPlan, ps);
        pp.visit();
        System.err.println(out.toString());
    }

    public void printPlan(org.apache.pig.impl.logicalLayer.LogicalPlan logicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        logicalPlan.explain(ps, "text", true);
        System.err.println(out.toString());
    }

    public void printPlan(PhysicalPlan physicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        physicalPlan.explain(ps, "text", true);
        System.err.println(out.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyPlanOptimizer
    extends PlanOptimizer {
        protected MyPlanOptimizer(OperatorPlan p, List<Set<Rule>> rs, int iterations) {
            super(p, rs, iterations);
        }

        public void addPlanTransformListener(PlanTransformListener listener) {
            super.addPlanTransformListener(listener);
        }
    }
}

