/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFRJoin
extends TestCase {
    private static final String INPUT_FILE = "testFrJoinInput.txt";
    private static final String INPUT_FILE2 = "testFrJoinInput2.txt";
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();
    private File tmpFile;

    public TestFRJoin() throws ExecException, IOException {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Before
    public void setUp() throws Exception {
        int LOOP_SIZE = 2;
        String[] input = new String[2 * LOOP_SIZE];
        int k = 0;
        for (int i = 1; i <= LOOP_SIZE; ++i) {
            String si = i + "";
            for (int j = 1; j <= LOOP_SIZE; ++j) {
                input[k++] = si + "\t" + j;
            }
        }
        Util.createInputFile(this.cluster, INPUT_FILE, input);
        String[] input2 = new String[2 * (LOOP_SIZE / 2)];
        k = 0;
        for (int i = 1; i <= LOOP_SIZE / 2; ++i) {
            String si = i + "";
            for (int j = 1; j <= LOOP_SIZE / 2; ++j) {
                input2[k++] = si + "\t" + j;
            }
        }
        Util.createInputFile(this.cluster, INPUT_FILE2, input2);
    }

    @After
    public void tearDown() throws Exception {
        Util.deleteFile(this.cluster, INPUT_FILE);
        Util.deleteFile(this.cluster, INPUT_FILE2);
    }

    public void testSortFRJoin() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("D = ORDER A by y;");
        this.pigServer.registerQuery("E = ORDER B by y;");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join D by $0, E by $0 using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join D by $0, E by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbfrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    public void testDistinctFRJoin() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("D = distinct A ;");
        this.pigServer.registerQuery("E = distinct B ;");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join D by $0, E by $0 using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join D by $0, E by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertEquals((long)dbfrj.size(), (long)dbshj.size());
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testUDFFRJ() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:chararray,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:chararray,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        String fSpec = FRJoin.class.getName() + "('" + INPUT_FILE + "')";
        this.pigServer.registerFunction("FRJ", new FuncSpec(fSpec));
        this.pigServer.registerQuery("C = foreach A generate *, flatten(FRJ(*));");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        Iterator iter2 = this.pigServer.openIterator("C");
        while (iter2.hasNext()) {
            dbshj.add((Tuple)iter2.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut1() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut2() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt';");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut3() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("C = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0 using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0;");
        iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut4() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("C = LOAD 'testFrJoinInput.txt';");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0 using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0;");
        iter = this.pigServer.openIterator("D");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut5() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1) using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1);");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut6() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt';");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1) using \"replicated\";");
        Iterator iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1);");
        iter = this.pigServer.openIterator("C");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut7() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"replicated\";");
        this.pigServer.registerQuery("D = join A by $1, B by $1 using \"replicated\";");
        this.pigServer.registerQuery("E = union C,D;");
        Iterator iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbfrj.add((Tuple)iter.next());
        }
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        this.pigServer.registerQuery("D = join A by $1, B by $1;");
        this.pigServer.registerQuery("E = union C,D;");
        iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            dbshj.add((Tuple)iter.next());
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut8() throws IOException {
        String Key;
        Tuple tuple;
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput2.txt' as (x:int,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        HashMap<String, Tuple> hashFRJoin = new HashMap<String, Tuple>();
        HashMap<String, Tuple> hashJoin = new HashMap<String, Tuple>();
        this.pigServer.registerQuery("C = join A by $0 left, B by $0 using \"replicated\";");
        this.pigServer.registerQuery("D = join A by $1 left, B by $1 using \"replicated\";");
        this.pigServer.registerQuery("E = union C,D;");
        Iterator iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            tuple = (Tuple)iter.next();
            Key = tuple.toDelimitedString(",");
            hashFRJoin.put(Key, tuple);
            dbfrj.add(tuple);
        }
        this.pigServer.registerQuery("C = join A by $0 left, B by $0;");
        this.pigServer.registerQuery("D = join A by $1 left, B by $1;");
        this.pigServer.registerQuery("E = union C,D;");
        iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            tuple = (Tuple)iter.next();
            Key = tuple.toDelimitedString(",");
            hashJoin.put(Key, tuple);
            dbshj.add(tuple);
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinOut9() throws IOException {
        String Key;
        Tuple tuple;
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput2.txt' as (x:int,y:int);");
        DataBag dbfrj = BagFactory.getInstance().newDefaultBag();
        DataBag dbshj = BagFactory.getInstance().newDefaultBag();
        HashMap<String, Tuple> hashFRJoin = new HashMap<String, Tuple>();
        HashMap<String, Tuple> hashJoin = new HashMap<String, Tuple>();
        this.pigServer.registerQuery("C = join A by $0 left, B by $0 using \"repl\";");
        this.pigServer.registerQuery("D = join A by $1 left, B by $1 using \"repl\";");
        this.pigServer.registerQuery("E = union C,D;");
        Iterator iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            tuple = (Tuple)iter.next();
            Key = tuple.toDelimitedString(",");
            hashFRJoin.put(Key, tuple);
            dbfrj.add(tuple);
        }
        this.pigServer.registerQuery("C = join A by $0 left, B by $0;");
        this.pigServer.registerQuery("D = join A by $1 left, B by $1;");
        this.pigServer.registerQuery("E = union C,D;");
        iter = this.pigServer.openIterator("E");
        while (iter.hasNext()) {
            tuple = (Tuple)iter.next();
            Key = tuple.toDelimitedString(",");
            hashJoin.put(Key, tuple);
            dbshj.add(tuple);
        }
        Assert.assertTrue((dbfrj.size() > 0L && dbshj.size() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((boolean)true, (boolean)TestHelper.compareBags(dbfrj, dbshj));
    }

    @Test
    public void testFRJoinSch1() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        Schema frjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"repl\";");
        frjSch = this.pigServer.dumpSchema("C");
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        shjSch = this.pigServer.dumpSchema("C");
        Assert.assertEquals((boolean)true, (boolean)shjSch.equals((Object)frjSch));
    }

    @Test
    public void testFRJoinSch2() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt';");
        Schema frjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("C = join A by $0, B by $0 using \"repl\";");
        frjSch = this.pigServer.dumpSchema("C");
        this.pigServer.registerQuery("C = join A by $0, B by $0;");
        shjSch = this.pigServer.dumpSchema("C");
        Assert.assertTrue((shjSch == null ? 1 : 0) != 0);
    }

    @Test
    public void testFRJoinSch3() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("C = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        Schema frjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0 using \"repl\";");
        frjSch = this.pigServer.dumpSchema("D");
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0;");
        shjSch = this.pigServer.dumpSchema("D");
        Assert.assertEquals((boolean)true, (boolean)shjSch.equals((Object)frjSch));
    }

    @Test
    public void testFRJoinSch4() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("C = LOAD 'testFrJoinInput.txt';");
        Schema frjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0 using \"repl\";");
        frjSch = this.pigServer.dumpSchema("D");
        this.pigServer.registerQuery("D = join A by $0, B by $0, C by $0;");
        shjSch = this.pigServer.dumpSchema("D");
        Assert.assertTrue((shjSch == null ? 1 : 0) != 0);
    }

    @Test
    public void testFRJoinSch5() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt' as (x:int,y:int);");
        Schema frjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1) using \"repl\";");
        frjSch = this.pigServer.dumpSchema("C");
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1);");
        shjSch = this.pigServer.dumpSchema("C");
        Assert.assertEquals((boolean)true, (boolean)shjSch.equals((Object)frjSch));
    }

    @Test
    public void testFRJoinSch6() throws IOException {
        this.pigServer.registerQuery("A = LOAD 'testFrJoinInput.txt';");
        this.pigServer.registerQuery("B = LOAD 'testFrJoinInput.txt';");
        Schema frjSch = null;
        Schema shjSch = null;
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1) using \"repl\";");
        frjSch = this.pigServer.dumpSchema("C");
        this.pigServer.registerQuery("C = join A by ($0,$1), B by ($0,$1);");
        shjSch = this.pigServer.dumpSchema("C");
        Assert.assertTrue((shjSch == null ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FRJoin
    extends EvalFunc<DataBag> {
        String repl;
        int keyField;
        boolean isTblSetUp = false;
        Hashtable<String, DataBag> replTbl = new Hashtable();

        public FRJoin() {
        }

        public FRJoin(String repl) {
            this.repl = repl;
        }

        public DataBag exec(Tuple input) throws IOException {
            if (!this.isTblSetUp) {
                this.setUpHashTable();
                this.isTblSetUp = true;
            }
            try {
                String key = (String)input.get(this.keyField);
                if (!this.replTbl.containsKey(key)) {
                    return BagFactory.getInstance().newDefaultBag();
                }
                return this.replTbl.get(key);
            }
            catch (ExecException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void setUpHashTable() throws IOException {
            FileSpec replFile = new FileSpec(this.repl, new FuncSpec(PigStorage.class.getName() + "()"));
            POLoad ld = new POLoad(new OperatorKey("Repl File Loader", 1L), replFile);
            PigContext pc = new PigContext(ExecType.MAPREDUCE, ConfigurationUtil.toProperties((Configuration)PigMapReduce.sJobConf));
            try {
                pc.connect();
                ld.setPc(pc);
                Tuple dummyTuple = null;
                Result res = ld.getNext(dummyTuple);
                while (res.returnStatus != 3) {
                    Tuple tup = (Tuple)res.result;
                    LoadFunc lf = (LoadFunc)PigContext.instantiateFuncFromSpec((FuncSpec)ld.getLFile().getFuncSpec());
                    String key = lf.getLoadCaster().bytesToCharArray(((DataByteArray)tup.get(this.keyField)).get());
                    Tuple csttup = TupleFactory.getInstance().newTuple(2);
                    csttup.set(0, (Object)key);
                    csttup.set(1, (Object)lf.getLoadCaster().bytesToInteger(((DataByteArray)tup.get(1)).get()));
                    DataBag vals = null;
                    if (this.replTbl.containsKey(key)) {
                        vals = this.replTbl.get(key);
                    } else {
                        vals = BagFactory.getInstance().newDefaultBag();
                        this.replTbl.put(key, vals);
                    }
                    vals.add(csttup);
                    res = ld.getNext(dummyTuple);
                }
            }
            catch (ExecException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

