/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GreaterThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POAnd;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORead;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFilter
extends TestCase {
    POFilter pass;
    POFilter fail;
    Tuple t;
    DataBag inp;
    POFilter projFil;
    boolean[] nullFlags = new boolean[]{false, true};

    @Before
    public void setUp() throws Exception {
        this.pass = GenPhyOp.topFilterOpWithExPlan(50, 25);
        this.fail = GenPhyOp.topFilterOpWithExPlan(25, 50);
    }

    private void setUpProjFil(boolean withNulls) throws Exception {
        Random r = new Random();
        this.inp = withNulls ? GenRandomData.genRandSmallTupDataBagWithNulls(r, 10, 100) : GenRandomData.genRandSmallTupDataBag(r, 10, 100);
        this.t = GenRandomData.genRandSmallBagTuple(r, 10, 100);
        this.projFil = GenPhyOp.topFilterOpWithProj(1, 50);
        POProject inpPrj = GenPhyOp.exprProject();
        DefaultTuple tmpTpl = new DefaultTuple();
        tmpTpl.append((Object)this.inp);
        inpPrj.setColumn(0);
        inpPrj.setResultType((byte)110);
        inpPrj.setOverloaded(true);
        inpPrj.attachInput((Tuple)tmpTpl);
        ArrayList<POProject> inputs = new ArrayList<POProject>();
        inputs.add(inpPrj);
        this.projFil.setInputs(inputs);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNextTuple() throws Exception {
        this.pass.attachInput(this.t);
        Result res = this.pass.getNext(this.t);
        TestFilter.assertEquals((Object)this.t, (Object)res.result);
        this.fail.attachInput(this.t);
        res = this.fail.getNext(this.t);
        TestFilter.assertEquals((byte)res.returnStatus, (byte)3);
        for (int i = 0; i < this.nullFlags.length; ++i) {
            int count = 0;
            this.setUpProjFil(this.nullFlags[i]);
            while (true) {
                res = this.projFil.getNext(this.t);
                if (res.returnStatus == 3) break;
                ++count;
                TestFilter.assertEquals((byte)0, (byte)res.returnStatus);
                Tuple output = (Tuple)res.result;
                TestFilter.assertEquals((String)("Running testGetNextTuple with nullFlags set to " + this.nullFlags[i] + ":"), (boolean)true, (boolean)TestHelper.bagContains(this.inp, output));
                TestFilter.assertEquals((String)("Running testGetNextTuple with nullFlags set to " + this.nullFlags[i] + ":"), (boolean)true, ((Integer)((Tuple)res.result).get(1) > 50 ? 1 : 0) != 0);
            }
            TestFilter.assertEquals((String)("Running testGetNextTuple with nullFlags set to " + this.nullFlags[i] + ":"), (int)this.getExpCount(this.inp), (int)count);
        }
    }

    private int getExpCount(DataBag inp2) throws ExecException {
        int count = 0;
        for (Tuple t : inp2) {
            if (t.get(1) == null || (Integer)t.get(1) <= 50) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testSimpleFilter() throws Exception {
        for (int i = 0; i < this.nullFlags.length; ++i) {
            Result res;
            POProject p1 = GenPhyOp.exprProject(0);
            POProject p2 = GenPhyOp.exprProject(1);
            GreaterThanExpr gt = GenPhyOp.compGreaterThanExpr((ExpressionOperator)p1, (ExpressionOperator)p2, (byte)10);
            PhysicalPlan ip = new PhysicalPlan();
            ip.add((Operator)p1);
            ip.add((Operator)p2);
            ip.add((Operator)gt);
            ip.connect((PhysicalOperator)p1, (PhysicalOperator)gt);
            ip.connect((PhysicalOperator)p2, (PhysicalOperator)gt);
            int[] ints = new int[]{0, 1, 1, 0, 1, 1};
            TupleFactory tf = TupleFactory.getInstance();
            DataBag inbag = BagFactory.getInstance().newDefaultBag();
            Random r = new Random();
            for (int j = 0; j < ints.length; j += 2) {
                if (this.nullFlags[i]) {
                    Tuple t;
                    int rand = r.nextInt(100);
                    if (rand <= 20) {
                        t = tf.newTuple(2);
                        t.set(0, (Object)new Integer(ints[j]));
                        t.set(1, null);
                        inbag.add(t);
                    } else if (rand > 20 && rand <= 40) {
                        t = tf.newTuple(2);
                        t.set(0, null);
                        t.set(1, (Object)new Integer(ints[j + 1]));
                        inbag.add(t);
                    } else if (rand > 40 && rand <= 60) {
                        t = tf.newTuple(2);
                        t.set(0, null);
                        t.set(1, null);
                        inbag.add(t);
                    }
                }
                Tuple t = tf.newTuple(2);
                t.set(0, (Object)new Integer(ints[j]));
                t.set(1, (Object)new Integer(ints[j + 1]));
                inbag.add(t);
            }
            PORead read = GenPhyOp.topReadOp(inbag);
            POFilter filter = GenPhyOp.connectedFilterOp((PhysicalOperator)read);
            filter.setPlan(ip);
            PhysicalPlan op = new PhysicalPlan();
            op.add((Operator)filter);
            op.add((Operator)read);
            op.connect((PhysicalOperator)read, (PhysicalOperator)filter);
            DataBag outbag = BagFactory.getInstance().newDefaultBag();
            Tuple t = tf.newTuple();
            do {
                res = filter.getNext(t);
                if (res.returnStatus != 0) continue;
                outbag.add((Tuple)res.result);
            } while (res.returnStatus == 0);
            TestFilter.assertEquals((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (byte)3, (byte)res.returnStatus);
            TestFilter.assertEquals((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (long)1L, (long)outbag.size());
            Iterator it = outbag.iterator();
            TestFilter.assertTrue((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (boolean)it.hasNext());
            t = (Tuple)it.next();
            TestFilter.assertEquals((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (int)2, (int)t.size());
            TestFilter.assertTrue((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (boolean)(t.get(0) instanceof Integer));
            TestFilter.assertTrue((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (boolean)(t.get(1) instanceof Integer));
            Integer i1 = (Integer)t.get(0);
            Integer i2 = (Integer)t.get(1);
            TestFilter.assertEquals((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (int)1, (int)i1);
            TestFilter.assertEquals((String)("Running " + this.getName() + "with nullFlags set to " + this.nullFlags[i] + ":"), (int)0, (int)i2);
        }
    }

    @Test
    public void testAndFilter() throws Exception {
        for (int i = 0; i < this.nullFlags.length; ++i) {
            Result res;
            POProject p1 = GenPhyOp.exprProject(0);
            ConstantExpression c2 = GenPhyOp.exprConst();
            c2.setValue((Object)new Integer(0));
            GreaterThanExpr gt = GenPhyOp.compGreaterThanExpr((ExpressionOperator)p1, (ExpressionOperator)c2, (byte)10);
            POProject p3 = GenPhyOp.exprProject(1);
            ConstantExpression c = GenPhyOp.exprConst();
            c.setValue((Object)new Integer(1));
            EqualToExpr eq = GenPhyOp.compEqualToExpr((ExpressionOperator)p3, (ExpressionOperator)c, (byte)10);
            POAnd and = GenPhyOp.compAndExpr((ExpressionOperator)gt, (ExpressionOperator)eq);
            PhysicalPlan ip = new PhysicalPlan();
            ip.add((Operator)p1);
            ip.add((Operator)c2);
            ip.add((Operator)gt);
            ip.add((Operator)p3);
            ip.add((Operator)c);
            ip.add((Operator)eq);
            ip.add((Operator)and);
            ip.connect((PhysicalOperator)p1, (PhysicalOperator)gt);
            ip.connect((PhysicalOperator)c2, (PhysicalOperator)gt);
            ip.connect((PhysicalOperator)p3, (PhysicalOperator)eq);
            ip.connect((PhysicalOperator)c, (PhysicalOperator)eq);
            ip.connect((PhysicalOperator)eq, (PhysicalOperator)and);
            ip.connect((PhysicalOperator)gt, (PhysicalOperator)and);
            int[] ints = new int[]{0, 1, 1, 0, 1, 1};
            TupleFactory tf = TupleFactory.getInstance();
            DataBag inbag = BagFactory.getInstance().newDefaultBag();
            Random r = new Random();
            for (int j = 0; j < ints.length; j += 2) {
                if (this.nullFlags[i]) {
                    Tuple t;
                    int rand = r.nextInt(100);
                    if (rand <= 20) {
                        t = tf.newTuple(2);
                        t.set(0, (Object)new Integer(ints[j]));
                        t.set(1, null);
                        inbag.add(t);
                    } else if (rand > 20 && rand <= 40) {
                        t = tf.newTuple(2);
                        t.set(0, null);
                        t.set(1, (Object)new Integer(ints[j + 1]));
                        inbag.add(t);
                    } else if (rand > 40 && rand <= 60) {
                        t = tf.newTuple(2);
                        t.set(0, null);
                        t.set(1, null);
                        inbag.add(t);
                    }
                }
                Tuple t = tf.newTuple(2);
                t.set(0, (Object)new Integer(ints[j]));
                t.set(1, (Object)new Integer(ints[j + 1]));
                inbag.add(t);
            }
            PORead read = GenPhyOp.topReadOp(inbag);
            POFilter filter = GenPhyOp.connectedFilterOp((PhysicalOperator)read);
            filter.setPlan(ip);
            PhysicalPlan op = new PhysicalPlan();
            op.add((Operator)filter);
            op.add((Operator)read);
            op.connect((PhysicalOperator)read, (PhysicalOperator)filter);
            DataBag outbag = BagFactory.getInstance().newDefaultBag();
            Tuple t = tf.newTuple();
            do {
                res = filter.getNext(t);
                if (res.returnStatus != 0) continue;
                outbag.add((Tuple)res.result);
            } while (res.returnStatus == 0);
            TestFilter.assertEquals((byte)3, (byte)res.returnStatus);
            TestFilter.assertEquals((long)1L, (long)outbag.size());
            Iterator it = outbag.iterator();
            TestFilter.assertTrue((boolean)it.hasNext());
            t = (Tuple)it.next();
            TestFilter.assertEquals((int)2, (int)t.size());
            TestFilter.assertTrue((boolean)(t.get(0) instanceof Integer));
            TestFilter.assertTrue((boolean)(t.get(1) instanceof Integer));
            Integer i1 = (Integer)t.get(0);
            Integer i2 = (Integer)t.get(1);
            TestFilter.assertEquals((int)1, (int)i1);
            TestFilter.assertEquals((int)1, (int)i2);
        }
    }

    public static void main(String[] args) {
        TestFilter tf = new TestFilter();
        try {
            tf.testAndFilter();
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e.getMessage());
        }
    }
}

