/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestFilterOpNumeric
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static int LOOP_COUNT = 1024;
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig;

    @Before
    protected void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testNumericEq() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println(i + ":" + (double)i);
                continue;
            }
            ps.println(i + ":" + (i - 1));
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 == $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            Double second = Double.valueOf(t.get(1).toString());
            TestFilterOpNumeric.assertTrue((boolean)first.equals(second));
            String sfirst = t.get(0).toString();
            String ssecond = t.get(1).toString();
            TestFilterOpNumeric.assertFalse((boolean)sfirst.equals(ssecond));
        }
    }

    @Test
    public void testNumericNeq() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("1:1");
                continue;
            }
            ps.println("2:3");
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 != $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            Double second = Double.valueOf(t.get(1).toString());
            TestFilterOpNumeric.assertFalse((boolean)first.equals(second));
        }
    }

    @Test
    public void testNumericGt() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println(i + ":" + (double)i);
                continue;
            }
            ps.println(i + 1 + ":" + (double)i);
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':') as (f1: double, f2:double);");
        String query = "A = filter A by $0 > $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        while (it.hasNext()) {
            Double second;
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            TestFilterOpNumeric.assertTrue((first.compareTo(second = Double.valueOf(t.get(1).toString())) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBinCond() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            ps.println(i + "\t" + i + "\t1");
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "';");
        String query = "A = foreach A generate ($1 >= " + LOOP_COUNT + "-10?'1':'0');";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            if (first == 1.0) {
                ++count;
                continue;
            }
            TestFilterOpNumeric.assertTrue((first == 0.0 ? 1 : 0) != 0);
        }
        TestFilterOpNumeric.assertEquals((String)"expected count of 10", (int)10, (int)count);
    }

    @Test
    public void testNestedBinCond() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            ps.println(i + "\t" + i + "\t1");
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "';");
        String query = "A = foreach A generate ($0 < 10?($1 >= 5 ? 2: 1) : 0);";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            Integer first = (Integer)t.get(0);
            count += first.intValue();
            TestFilterOpNumeric.assertTrue((first == 1 || first == 2 || first == 0 ? 1 : 0) != 0);
        }
        TestFilterOpNumeric.assertEquals((String)"expected count of 15", (int)15, (int)count);
    }

    @Test
    public void testNumericLt() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println(i + ":" + (double)i);
                continue;
            }
            ps.println(i + ":" + (double)(i + 1));
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':') as (a: double, b:double);");
        String query = "A = filter A by $0 < $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        while (it.hasNext()) {
            Double second;
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            TestFilterOpNumeric.assertTrue((first.compareTo(second = Double.valueOf(t.get(1).toString())) < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNumericGte() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println(i + ":" + (double)i);
                continue;
            }
            if (i % 3 == 0) {
                ps.println(i - 1 + ":" + (double)i);
                continue;
            }
            ps.println(i + 1 + ":" + (double)i);
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 >= $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        while (it.hasNext()) {
            Double second;
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            TestFilterOpNumeric.assertTrue((first.compareTo(second = Double.valueOf(t.get(1).toString())) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNumericLte() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println(i + ":" + (double)i);
                continue;
            }
            if (i % 3 == 0) {
                ps.println(i - 1 + ":" + (double)i);
                continue;
            }
            ps.println(i + 1 + ":" + (double)i);
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':') as (a: double, b:double);");
        String query = "A = filter A by $0 <= $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        while (it.hasNext()) {
            Double second;
            Tuple t = (Tuple)it.next();
            Double first = Double.valueOf(t.get(0).toString());
            TestFilterOpNumeric.assertTrue((first.compareTo(second = Double.valueOf(t.get(1).toString())) <= 0 ? 1 : 0) != 0);
        }
    }
}

