/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestFilterOpString
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static int LOOP_COUNT = 1024;
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig;

    @Before
    protected void setUp() throws Exception {
        FileLocalizer.deleteTempFiles();
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testStringEq() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        int expectedCount = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("a:" + i);
                ps.println("a:");
                ps.println(":a");
                ps.println(":");
                continue;
            }
            ps.println("ab:ab");
            ++expectedCount;
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 eq $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            String first = t.get(0).toString();
            String second = t.get(1).toString();
            ++count;
            TestFilterOpString.assertTrue((boolean)first.equals(second));
        }
        TestFilterOpString.assertEquals((int)expectedCount, (int)count);
    }

    @Test
    public void testStringNeq() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        int expectedCount = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("ab:ab");
                continue;
            }
            if (i % 3 == 0) {
                ps.println("ab:abc");
                ++expectedCount;
                continue;
            }
            ps.println(":");
            ps.println("ab:");
            ps.println(":ab");
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 neq $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            String first = t.get(0).toString();
            String second = t.get(1).toString();
            TestFilterOpString.assertFalse((boolean)first.equals(second));
            ++count;
        }
        TestFilterOpString.assertEquals((int)expectedCount, (int)count);
    }

    @Test
    public void testStringGt() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        int expectedCount = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("b:a");
                ++expectedCount;
                continue;
            }
            ps.println("a:b");
            ps.println("a:");
            ps.println(":b");
            ps.println(":");
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 gt $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            String second;
            Tuple t = (Tuple)it.next();
            String first = t.get(0).toString();
            TestFilterOpString.assertTrue((first.compareTo(second = t.get(1).toString()) > 0 ? 1 : 0) != 0);
            ++count;
        }
        TestFilterOpString.assertEquals((int)expectedCount, (int)count);
    }

    @Test
    public void testStringGte() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        int expectedCount = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("b:a");
                ++expectedCount;
                continue;
            }
            if (i % 3 == 0) {
                ps.println("b:b");
                ++expectedCount;
                continue;
            }
            ps.println("a:b");
            ps.println("a:");
            ps.println(":b");
            ps.println(":");
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 gte $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            String second;
            Tuple t = (Tuple)it.next();
            String first = t.get(0).toString();
            TestFilterOpString.assertTrue((first.compareTo(second = t.get(1).toString()) >= 0 ? 1 : 0) != 0);
            ++count;
        }
        TestFilterOpString.assertEquals((int)expectedCount, (int)count);
    }

    @Test
    public void testStringLt() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        int expectedCount = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("b:a");
                ps.println("a:");
                ps.println(":b");
                ps.println(":");
                continue;
            }
            ps.println("a:b");
            ++expectedCount;
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 lt $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            String second;
            Tuple t = (Tuple)it.next();
            String first = t.get(0).toString();
            TestFilterOpString.assertTrue((first.compareTo(second = t.get(1).toString()) < 0 ? 1 : 0) != 0);
            ++count;
        }
        TestFilterOpString.assertEquals((int)expectedCount, (int)count);
    }

    @Test
    public void testStringLte() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
        int expectedCount = 0;
        for (int i = 0; i < LOOP_COUNT; ++i) {
            if (i % 5 == 0) {
                ps.println("b:a");
                ps.println("a:");
                ps.println(":b");
                ps.println(":");
                continue;
            }
            if (i % 3 == 0) {
                ps.println("b:b");
                ++expectedCount;
                continue;
            }
            ps.println("a:b");
            ++expectedCount;
        }
        ps.close();
        this.pig.registerQuery("A=load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':');");
        String query = "A = filter A by $0 lte $1;";
        this.log.info((Object)query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("A");
        tmpFile.delete();
        int count = 0;
        while (it.hasNext()) {
            String second;
            Tuple t = (Tuple)it.next();
            String first = t.get(0).toString();
            TestFilterOpString.assertTrue((first.compareTo(second = t.get(1).toString()) <= 0 ? 1 : 0) != 0);
            ++count;
        }
        TestFilterOpString.assertEquals((int)expectedCount, (int)count);
    }
}

