/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.FILTERFROMFILE;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFilterUDF
extends TestCase {
    private PigServer pigServer;
    private MiniCluster cluster = MiniCluster.buildCluster();
    private File tmpFile;
    TupleFactory tf = TupleFactory.getInstance();

    public TestFilterUDF() throws ExecException, IOException {
        int LOOP_SIZE = 20;
        this.tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile));
        for (int i = 1; i <= LOOP_SIZE; ++i) {
            ps.println(i);
        }
        ps.close();
    }

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        int LOOP_SIZE = 20;
        this.tmpFile = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(this.tmpFile));
        for (int i = 1; i <= LOOP_SIZE; ++i) {
            ps.println(i);
        }
        ps.close();
    }

    @After
    public void tearDown() throws Exception {
        this.tmpFile.delete();
    }

    private File createFile(String[] data) throws Exception {
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        for (int i = 0; i < data.length; ++i) {
            pw.println(data[i]);
        }
        pw.close();
        return f;
    }

    @Test
    public void testFilterUDF() throws Exception {
        this.pigServer.registerQuery("A = LOAD '" + Util.generateURI(this.tmpFile.toString(), this.pigServer.getPigContext()) + "' as (x:int);");
        this.pigServer.registerQuery("B = filter A by " + MyFilterFunction.class.getName() + "();");
        Iterator iter = this.pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestFilterUDF.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestFilterUDF.assertEquals((boolean)true, ((Integer)t.get(0) > 10 ? 1 : 0) != 0);
            ++cnt;
        }
        TestFilterUDF.assertEquals((int)10, (int)cnt);
    }

    @Test
    public void testFilterUDFusingDefine() throws Exception {
        File inputFile = this.createFile(new String[]{"www.paulisageek.com\t4", "www.yahoo.com\t12344", "google.com\t1", "us2.amazon.com\t4141"});
        File filterFile = this.createFile(new String[]{"12344"});
        this.pigServer.registerQuery("define FILTER_CRITERION " + FILTERFROMFILE.class.getName() + "('" + Util.generateURI(filterFile.toString(), this.pigServer.getPigContext()) + "');");
        this.pigServer.registerQuery("a = LOAD '" + Util.generateURI(inputFile.toString(), this.pigServer.getPigContext()) + "' as (url:chararray, numvisits:int);");
        this.pigServer.registerQuery("b = filter a by FILTER_CRITERION(numvisits);");
        Tuple expectedTuple = this.tf.newTuple();
        expectedTuple.append((Object)new String("www.yahoo.com"));
        expectedTuple.append((Object)new Integer("12344"));
        Iterator iter = this.pigServer.openIterator("b");
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestFilterUDF.assertTrue((boolean)t.equals(expectedTuple));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyFilterFunction
    extends EvalFunc<Boolean> {
        public Boolean exec(Tuple input) throws IOException {
            try {
                int col = (Integer)input.get(0);
                if (col > 10) {
                    return true;
                }
            }
            catch (ExecException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

