/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestFinish
extends TestCase {
    private PigServer pigServer;
    TupleFactory mTf = TupleFactory.getInstance();
    BagFactory mBf = BagFactory.getInstance();
    File f1;
    MiniCluster cluster = MiniCluster.buildCluster();

    protected void setUp() throws Exception {
        FileLocalizer.setInitialized((boolean)false);
    }

    private String setUp(ExecType execType) throws Exception {
        String inputFileName;
        if (execType == ExecType.LOCAL) {
            this.pigServer = new PigServer(ExecType.LOCAL);
            this.f1 = File.createTempFile("test", "txt");
            this.f1.deleteOnExit();
            inputFileName = this.f1.getAbsolutePath();
            PrintStream ps = new PrintStream(new FileOutputStream(this.f1));
            for (int i = 0; i < 3; ++i) {
                ps.println(97 + i + ":1");
            }
            ps.close();
        } else {
            this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
            this.f1 = File.createTempFile("test", "txt");
            this.f1.deleteOnExit();
            inputFileName = this.f1.getAbsolutePath();
            String[] input = new String[3];
            for (int i = 0; i < 3; ++i) {
                input[i] = 97 + i + ":1";
            }
            Util.createInputFile(this.cluster, inputFileName, input);
        }
        return inputFileName;
    }

    private void checkAndCleanup(ExecType execType, String expectedFileName, String inputFileName) throws IOException {
        if (execType == ExecType.MAPREDUCE) {
            FileSystem fs = FileSystem.get((Configuration)ConfigurationUtil.toConfiguration((Properties)this.cluster.getProperties()));
            TestFinish.assertTrue((boolean)fs.exists(new Path(expectedFileName)));
            Util.deleteFile(this.cluster, inputFileName);
            Util.deleteFile(this.cluster, expectedFileName);
        } else if (execType == ExecType.LOCAL) {
            File f = new File(expectedFileName);
            TestFinish.assertTrue((boolean)f.exists());
            f.delete();
        } else {
            throw new IllegalArgumentException("invalid excetype " + execType.toString());
        }
    }

    @Test
    public void testFinishInMapMR() throws Exception {
        String inputFileName = this.setUp(ExecType.MAPREDUCE);
        String expectedFileName = "testFinishInMapMR-finish.txt";
        this.pigServer.registerQuery("define MYUDF " + MyEvalFunction.class.getName() + "('MAPREDUCE','" + expectedFileName + "');");
        this.pigServer.registerQuery("a = load '" + inputFileName + "' using " + PigStorage.class.getName() + "(':');");
        this.pigServer.registerQuery("b = foreach a generate MYUDF(*);");
        Iterator iter = this.pigServer.openIterator("b");
        while (iter.hasNext()) {
            iter.next();
        }
        this.checkAndCleanup(ExecType.MAPREDUCE, expectedFileName, inputFileName);
    }

    @Test
    public void testFinishInReduceMR() throws Exception {
        String inputFileName = this.setUp(ExecType.MAPREDUCE);
        String expectedFileName = "testFinishInReduceMR-finish.txt";
        this.pigServer.registerQuery("define MYUDF " + MyEvalFunction.class.getName() + "('MAPREDUCE','" + expectedFileName + "');");
        this.pigServer.registerQuery("a = load '" + inputFileName + "' using " + PigStorage.class.getName() + "(':');");
        this.pigServer.registerQuery("a1 = group a by $1;");
        this.pigServer.registerQuery("b = foreach a1 generate MYUDF(*);");
        Iterator iter = this.pigServer.openIterator("b");
        while (iter.hasNext()) {
            iter.next();
        }
        this.checkAndCleanup(ExecType.MAPREDUCE, expectedFileName, inputFileName);
    }

    @Test
    public void testFinishInMapLoc() throws Exception {
        String inputFileName = this.setUp(ExecType.LOCAL);
        String expectedFileName = "testFinishInMapLoc-finish.txt";
        this.pigServer.registerQuery("define MYUDF " + MyEvalFunction.class.getName() + "('LOCAL','" + expectedFileName + "');");
        this.pigServer.registerQuery("a = load '" + inputFileName + "' using " + PigStorage.class.getName() + "(':');");
        this.pigServer.registerQuery("b = foreach a generate MYUDF(*);");
        this.pigServer.openIterator("b");
        this.checkAndCleanup(ExecType.LOCAL, expectedFileName, inputFileName);
    }

    @Test
    public void testFinishInReduceLoc() throws Exception {
        String inputFileName = this.setUp(ExecType.LOCAL);
        String expectedFileName = "testFinishInReduceLoc-finish.txt";
        this.pigServer.registerQuery("define MYUDF " + MyEvalFunction.class.getName() + "('LOCAL','" + expectedFileName + "');");
        this.pigServer.registerQuery("a = load '" + inputFileName + "' using " + PigStorage.class.getName() + "(':');");
        this.pigServer.registerQuery("a1 = group a by $1;");
        this.pigServer.registerQuery("b = foreach a1 generate MYUDF(*);");
        this.pigServer.openIterator("b");
        this.checkAndCleanup(ExecType.LOCAL, expectedFileName, inputFileName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyEvalFunction
    extends EvalFunc<Tuple> {
        String execType;
        String expectedFileName;

        public MyEvalFunction(String execType, String expectedFileName) {
            this.execType = execType;
            this.expectedFileName = expectedFileName;
        }

        public Tuple exec(Tuple input) throws IOException {
            return input;
        }

        public void finish() {
            try {
                FileSystem fs = FileSystem.get((Configuration)PigMapReduce.sJobConf);
                fs.create(new Path(this.expectedFileName));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create file:" + this.expectedFileName);
            }
        }
    }
}

