/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Test;

public class TestForEachNestedPlan
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig;
    Boolean[] nullFlags = new Boolean[]{false, true};

    public TestForEachNestedPlan() throws Throwable {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testInnerOrderBy() throws Exception {
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Running testInnerOrderBy with nullFlags set to :" + this.nullFlags[i]);
            File tmpFile = this.genDataSetFile1(this.nullFlags[i]);
            this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "'; ");
            this.pig.registerQuery("b = group a by $0; ");
            this.pig.registerQuery("c = foreach b {      c1 = order $1 by *;     generate flatten(c1); };");
            Iterator it = this.pig.openIterator("c");
            Tuple t = null;
            int count = 0;
            while (it.hasNext()) {
                t = (Tuple)it.next();
                System.out.println(count + ":" + t);
                ++count;
            }
            Assert.assertEquals((int)count, (int)30);
        }
    }

    @Test
    public void testInnerOrderByStarWithSchema() throws Exception {
        File tmpFile = this.genDataSetFile1(false);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' as (a0, a1);");
        this.pig.registerQuery("b = group a by a0; ");
        this.pig.registerQuery("c = foreach b { d = order a by *;   generate group, d; };");
        Iterator it = this.pig.openIterator("c");
        Tuple t = null;
        int count = 0;
        while (it.hasNext()) {
            t = (Tuple)it.next();
            System.out.println(count + ":" + t);
            ++count;
        }
        Assert.assertEquals((int)count, (int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlgebricFuncWithoutGroupBy() throws IOException, ParseException {
        String INPUT_FILE = "test-sum.txt";
        PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
        w.println("10\t{(1),(2),(3)}");
        w.println("20\t{(4),(5),(6),(7)}");
        w.println("30\t{(8),(9)}");
        w.close();
        try {
            Util.copyFromLocalToCluster(this.cluster, INPUT_FILE, INPUT_FILE);
            this.pig.registerQuery("a = load '" + INPUT_FILE + "' " + "as (id:int, g:bag{t:tuple(u:int)});");
            this.pig.registerQuery("b = foreach a generate id, SUM(g);");
            Iterator iter = this.pig.openIterator("b");
            List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"(10,6L)", "(20,22L)", "(30,17L)"});
            int counter = 0;
            while (iter.hasNext()) {
                TestForEachNestedPlan.assertEquals((String)expectedResults.get(counter++).toString(), (String)((Tuple)iter.next()).toString());
            }
            TestForEachNestedPlan.assertEquals((int)expectedResults.size(), (int)counter);
        }
        finally {
            new File(INPUT_FILE).delete();
            try {
                Util.deleteFile(this.cluster, INPUT_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInnerDistinct() throws IOException, ParseException {
        String INPUT_FILE = "test-distinct.txt";
        PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
        w.println("10\t89");
        w.println("20\t78");
        w.println("10\t68");
        w.println("10\t89");
        w.println("20\t92");
        w.close();
        try {
            Util.copyFromLocalToCluster(this.cluster, INPUT_FILE, INPUT_FILE);
            this.pig.registerQuery("A = load '" + INPUT_FILE + "' as (age:int, gpa:int);");
            this.pig.registerQuery("B = group A by age;");
            this.pig.registerQuery("C = foreach B { D = A.gpa; E = distinct D; generate group, MIN(E); };");
            Iterator iter = this.pig.openIterator("C");
            List<Tuple> expectedResults = Util.getTuplesFromConstantTupleStrings(new String[]{"(10,68)", "(20,78)"});
            int counter = 0;
            while (iter.hasNext()) {
                TestForEachNestedPlan.assertEquals((String)expectedResults.get(counter++).toString(), (String)((Tuple)iter.next()).toString());
            }
            TestForEachNestedPlan.assertEquals((int)expectedResults.size(), (int)counter);
        }
        finally {
            new File(INPUT_FILE).delete();
            try {
                Util.deleteFile(this.cluster, INPUT_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    private File genDataSetFile1(boolean withNulls) throws IOException {
        int dataLength = 30;
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        Random r = new Random();
        for (int i = 0; i < dataLength; ++i) {
            data[i] = new String[2];
            data[i][0] = withNulls && (double)r.nextInt(dataLength) < 0.3 * (double)dataLength ? "" : formatter.format(i % 10);
            data[i][1] = formatter.format((dataLength - i) / 2);
        }
        return TestHelper.createTempFile(data);
    }
}

