/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import junit.framework.TestCase;
import org.apache.pig.FuncSpec;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.PigContext;

public class TestFuncSpec
extends TestCase {
    public void testSpecCtorClassName() {
        String pigStorage = PigStorage.class.getName();
        FuncSpec fs = new FuncSpec(pigStorage);
        Object o = PigContext.instantiateFuncFromSpec((FuncSpec)fs);
        TestFuncSpec.assertEquals((boolean)true, (boolean)(o instanceof PigStorage));
    }

    public void testSpecCtorClassNameNoArgs() {
        String pigStorage = PigStorage.class.getName();
        FuncSpec fs = new FuncSpec(pigStorage + "()");
        Object o = PigContext.instantiateFuncFromSpec((FuncSpec)fs);
        TestFuncSpec.assertEquals((boolean)true, (boolean)(o instanceof PigStorage));
    }

    public void testSpecCtorClassNameWithArgs() {
        String dummy = DummyClass.class.getName();
        FuncSpec fs = new FuncSpec(dummy + "(':')");
        Object o = PigContext.instantiateFuncFromSpec((FuncSpec)fs);
        TestFuncSpec.assertEquals((boolean)true, (boolean)(o instanceof DummyClass));
        TestFuncSpec.assertEquals((byte)58, (byte)((DummyClass)o).delim);
    }

    public void testCtorClassNameArgs() {
        String dummy = DummyClass.class.getName();
        String[] args = new String[]{":"};
        FuncSpec fs = new FuncSpec(dummy, args);
        Object o = PigContext.instantiateFuncFromSpec((FuncSpec)fs);
        TestFuncSpec.assertEquals((boolean)true, (boolean)(o instanceof DummyClass));
        TestFuncSpec.assertEquals((byte)58, (byte)((DummyClass)o).delim);
    }

    public static class DummyClass {
        public byte delim = (byte)9;

        public DummyClass(String delim) {
            this.delim = (byte)delim.charAt(0);
        }
    }
}

