/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckingValidator;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.TestLogicalOptimizer;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TypeCheckingTestUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestImplicitSplit
extends TestCase {
    private PigServer pigServer;
    MiniCluster cluster = MiniCluster.buildCluster();

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testImplicitSplit() throws Exception {
        int LOOP_SIZE = 20;
        String[] input = new String[LOOP_SIZE];
        for (int i = 1; i <= LOOP_SIZE; ++i) {
            input[i - 1] = Integer.toString(i);
        }
        String inputFileName = "testImplicitSplit-input.txt";
        Util.createInputFile(this.cluster, inputFileName, input);
        this.pigServer.registerQuery("A = LOAD '" + inputFileName + "';");
        this.pigServer.registerQuery("B = filter A by $0<=10;");
        this.pigServer.registerQuery("C = filter A by $0>10;");
        this.pigServer.registerQuery("D = union B,C;");
        Iterator iter = this.pigServer.openIterator("D");
        if (!iter.hasNext()) {
            TestImplicitSplit.fail((String)"No Output received");
        }
        int cnt = 0;
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            ++cnt;
        }
        TestImplicitSplit.assertEquals((int)20, (int)cnt);
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testImplicitSplitInCoGroup() throws Exception {
        String input1 = "testImplicitSplitInCoGroup-input1.txt";
        String input2 = "testImplicitSplitInCoGroup-input2.txt";
        Util.createInputFile(this.cluster, input1, new String[]{"a:1", "b:2", "b:20", "c:3", "c:30"});
        Util.createInputFile(this.cluster, input2, new String[]{"a:first", "b:second", "c:third"});
        this.pigServer.registerQuery("a = load '" + input1 + "' using PigStorage(':') as (name:chararray, marks:int);");
        this.pigServer.registerQuery("b = load '" + input2 + "' using PigStorage(':') as (name:chararray, rank:chararray);");
        this.pigServer.registerQuery("c = cogroup a by name, b by name;");
        this.pigServer.registerQuery("d = foreach c generate group, FLATTEN(a.marks) as newmarks;");
        this.pigServer.registerQuery("e = cogroup a by marks, d by newmarks;");
        this.pigServer.registerQuery("f = foreach e generate group, flatten(a), flatten(d);");
        HashMap<Integer, Object[]> results = new HashMap<Integer, Object[]>();
        results.put(1, new Object[]{"a", 1, "a", 1});
        results.put(2, new Object[]{"b", 2, "b", 2});
        results.put(3, new Object[]{"c", 3, "c", 3});
        results.put(20, new Object[]{"b", 20, "b", 20});
        results.put(30, new Object[]{"c", 30, "c", 30});
        Iterator it = this.pigServer.openIterator("f");
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            System.err.println("Tuple:" + t);
            Integer group = (Integer)t.get(0);
            Object[] groupValues = (Object[])results.get(group);
            for (int i = 0; i < 4; ++i) {
                TestImplicitSplit.assertEquals((Object)groupValues[i], (Object)t.get(i + 1));
            }
        }
        Util.deleteFile(this.cluster, input1);
        Util.deleteFile(this.cluster, input2);
    }

    @Test
    public void testImplicitSplitInCoGroup2() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("a = load 'file1' using PigStorage(':') as (name:chararray, marks:int);");
        planTester.buildPlan("b = load 'file2' using PigStorage(':') as (name:chararray, rank:chararray);");
        planTester.buildPlan("c = cogroup a by name, b by name;");
        planTester.buildPlan("d = foreach c generate group, FLATTEN(a.marks) as newmarks;");
        planTester.buildPlan("e = cogroup a by marks, d by newmarks;");
        LogicalPlan plan = planTester.buildPlan("f = foreach e generate group, flatten(a), flatten(d);");
        PlanSetter ps = new PlanSetter(plan);
        ps.visit();
        CompilationMessageCollector collector = new CompilationMessageCollector();
        TypeCheckingValidator typeValidator = new TypeCheckingValidator();
        typeValidator.validate(plan, collector);
        TypeCheckingTestUtil.printMessageCollector(collector);
        TypeCheckingTestUtil.printTypeGraph(plan);
        if (collector.hasError()) {
            throw new Exception("Error during type checking");
        }
        TestLogicalOptimizer.optimizePlan(plan);
        Schema expectedSchema = Util.getSchemaFromString("grp: int,A::username: chararray,A::marks: int,AB::group: chararray,AB::newmarks: int");
        TestImplicitSplit.assertTrue((boolean)Schema.equals((Schema)expectedSchema, (Schema)((LogicalOperator)plan.getLeaves().get(0)).getSchema(), (boolean)false, (boolean)true));
    }
}

