/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestInfixArithmetic
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static int LOOP_COUNT = 1024;
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig;
    Boolean[] nullFlags = new Boolean[]{false, true};

    @Before
    protected void setUp() throws Exception {
        this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testAdd() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing with nulls: " + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "A = foreach (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':')) generate $0, $0 + $1, $1;";
            this.log.info((Object)query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("A");
            tmpFile.delete();
            while (it.hasNext()) {
                Double third;
                Tuple t = (Tuple)it.next();
                Double first = t.get(0) == null ? null : DataType.toDouble((Object)t.get(0));
                Double second = t.get(1) == null ? null : DataType.toDouble((Object)t.get(1));
                Double d = third = t.get(2) == null ? null : DataType.toDouble((Object)t.get(2));
                if (first != null && third != null) {
                    TestInfixArithmetic.assertTrue((boolean)second.equals(first + first));
                    continue;
                }
                TestInfixArithmetic.assertEquals(null, (Object)second);
            }
        }
    }

    @Test
    public void testSubtract() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing with nulls: " + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "A = foreach (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':')) generate $0, $0 - $1, $1 ;";
            this.log.info((Object)query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("A");
            tmpFile.delete();
            while (it.hasNext()) {
                Double third;
                Tuple t = (Tuple)it.next();
                Double first = t.get(0) == null ? null : DataType.toDouble((Object)t.get(0));
                Double second = t.get(1) == null ? null : DataType.toDouble((Object)t.get(1));
                Double d = third = t.get(2) == null ? null : DataType.toDouble((Object)t.get(2));
                if (first != null && third != null) {
                    TestInfixArithmetic.assertTrue((boolean)second.equals(0.0));
                    continue;
                }
                TestInfixArithmetic.assertEquals(null, (Object)second);
            }
        }
    }

    @Test
    public void testMultiply() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing with nulls: " + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "A = foreach (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':')) generate $0, $0 * $1, $1 ;";
            this.log.info((Object)query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("A");
            tmpFile.delete();
            while (it.hasNext()) {
                Double third;
                Tuple t = (Tuple)it.next();
                Double first = t.get(0) == null ? null : DataType.toDouble((Object)t.get(0));
                Double second = t.get(1) == null ? null : DataType.toDouble((Object)t.get(1));
                Double d = third = t.get(2) == null ? null : DataType.toDouble((Object)t.get(2));
                if (first != null && third != null) {
                    TestInfixArithmetic.assertTrue((boolean)second.equals(first * first));
                    continue;
                }
                TestInfixArithmetic.assertEquals(null, (Object)second);
            }
        }
    }

    @Test
    public void testDivide() throws Throwable {
        File tmpFile = File.createTempFile("test", "txt");
        for (int i = 0; i < this.nullFlags.length; ++i) {
            System.err.println("Testing with nulls: " + this.nullFlags[i]);
            PrintStream ps = new PrintStream(new FileOutputStream(tmpFile));
            this.generateInput(ps, this.nullFlags[i]);
            String query = "A = foreach (load '" + Util.generateURI(tmpFile.toString(), this.pig.getPigContext()) + "' using " + PigStorage.class.getName() + "(':')) generate $0, $0 / $1, $1 ;";
            this.log.info((Object)query);
            this.pig.registerQuery(query);
            Iterator it = this.pig.openIterator("A");
            tmpFile.delete();
            while (it.hasNext()) {
                Double third;
                Tuple t = (Tuple)it.next();
                Double first = t.get(0) == null ? null : DataType.toDouble((Object)t.get(0));
                Double second = t.get(1) == null ? null : DataType.toDouble((Object)t.get(1));
                Double d = third = t.get(2) == null ? null : DataType.toDouble((Object)t.get(2));
                if (first != null && third != null) {
                    TestInfixArithmetic.assertTrue((boolean)second.equals(1.0));
                    continue;
                }
                TestInfixArithmetic.assertEquals(null, (Object)second);
            }
        }
    }

    private void generateInput(PrintStream ps, boolean withNulls) {
        if (withNulls) {
            for (int i = 1; i < LOOP_COUNT; ++i) {
                int rand = new Random().nextInt(LOOP_COUNT);
                if ((double)rand <= 0.2 * (double)LOOP_COUNT) {
                    ps.println(":" + i);
                    continue;
                }
                if ((double)rand > 0.2 * (double)LOOP_COUNT && (double)rand <= 0.4 * (double)LOOP_COUNT) {
                    ps.println(i + ":");
                    continue;
                }
                if ((double)rand > 0.2 * (double)LOOP_COUNT && (double)rand <= 0.4 * (double)LOOP_COUNT) {
                    ps.println(":");
                    continue;
                }
                ps.println(i + ":" + i);
            }
        } else {
            for (int i = 1; i < LOOP_COUNT; ++i) {
                ps.println(i + ":" + i);
            }
        }
        ps.close();
    }
}

