/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.pig.ExecType;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecutionEngine;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceLauncher;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.util.ConfigurationValidator;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestJobSubmission
extends TestCase {
    static PigContext pc;
    String ldFile;
    String expFile;
    PhysicalPlan php = new PhysicalPlan();
    String stFile;
    String hadoopLdFile;
    String grpName;
    Random r = new Random();
    String curDir;
    String inpDir;
    String golDir;

    @Before
    public void setUp() throws Exception {
        this.curDir = System.getProperty("user.dir");
        this.inpDir = this.curDir + File.separatorChar + "test/org/apache/pig/test/data/InputFiles/";
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            this.inpDir = "/" + FileLocalizer.parseCygPath((String)this.inpDir, (int)1);
        }
        this.golDir = this.curDir + File.separatorChar + "test/org/apache/pig/test/data/GoldenFiles/";
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            this.golDir = "/" + FileLocalizer.parseCygPath((String)this.golDir, (int)1);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testJobControlCompilerErr() throws Exception {
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("a = load 'input';");
        LogicalPlan lp = planTester.buildPlan("b = order a by $0;");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        POStore store = GenPhyOp.dummyPigStorageOp();
        pp.addAsLeaf((Operator)store);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        for (MapReduceOper mro : mrPlan.getLeaves()) {
            PhysicalOperator po;
            if (mro.reducePlan == null || !((po = (PhysicalOperator)mro.reducePlan.getRoots().get(0)) instanceof POPackage)) continue;
            ((POPackage)po).setKeyType((byte)120);
            mro.setGlobalSort(true);
        }
        ExecutionEngine exe = pc.getExecutionEngine();
        ConfigurationValidator.validatePigProperties((Properties)exe.getConfiguration());
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)exe.getConfiguration());
        JobControlCompiler jcc = new JobControlCompiler(pc, conf);
        try {
            jcc.compile(mrPlan, "Test");
        }
        catch (JobCreationException jce) {
            TestJobSubmission.assertTrue((jce.getErrorCode() == 1068 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefaultParallel() throws Throwable {
        TestJobSubmission.pc.defaultParallel = 100;
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("a = load 'input';");
        LogicalPlan lp = planTester.buildPlan("b = group a by $0;");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        POStore store = GenPhyOp.dummyPigStorageOp();
        pp.addAsLeaf((Operator)store);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        ExecutionEngine exe = pc.getExecutionEngine();
        ConfigurationValidator.validatePigProperties((Properties)exe.getConfiguration());
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)exe.getConfiguration());
        JobControlCompiler jcc = new JobControlCompiler(pc, conf);
        JobControl jobControl = jcc.compile(mrPlan, "Test");
        Job job = (Job)jobControl.getWaitingJobs().get(0);
        int parallel = job.getJobConf().getNumReduceTasks();
        TestJobSubmission.assertTrue((parallel == 100 ? 1 : 0) != 0);
        TestJobSubmission.pc.defaultParallel = -1;
    }

    @Test
    public void testDefaultParallelInSort() throws Throwable {
        TestJobSubmission.pc.defaultParallel = 100;
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("a = load 'input';");
        LogicalPlan lp = planTester.buildPlan("b = order a by $0;");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        POStore store = GenPhyOp.dummyPigStorageOp();
        pp.addAsLeaf((Operator)store);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        ExecutionEngine exe = pc.getExecutionEngine();
        ConfigurationValidator.validatePigProperties((Properties)exe.getConfiguration());
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)exe.getConfiguration());
        JobControlCompiler jcc = new JobControlCompiler(pc, conf);
        Iterator iter = mrPlan.getKeys().values().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            MapReduceOper op = (MapReduceOper)iter.next();
            ++counter;
            if (!op.isGlobalSort()) continue;
            TestJobSubmission.assertTrue((op.getRequestedParallelism() == 100 ? 1 : 0) != 0);
        }
        TestJobSubmission.assertEquals((int)3, (int)counter);
        TestJobSubmission.pc.defaultParallel = -1;
    }

    @Test
    public void testDefaultParallelInSkewJoin() throws Throwable {
        TestJobSubmission.pc.defaultParallel = 100;
        LogicalPlanTester planTester = new LogicalPlanTester();
        planTester.buildPlan("a = load 'input';");
        planTester.buildPlan("b = load 'input';");
        LogicalPlan lp = planTester.buildPlan("c = join a by $0, b by $0 using \"skewed\";");
        PhysicalPlan pp = Util.buildPhysicalPlan(lp, pc);
        POStore store = GenPhyOp.dummyPigStorageOp();
        pp.addAsLeaf((Operator)store);
        MROperPlan mrPlan = Util.buildMRPlan(pp, pc);
        ExecutionEngine exe = pc.getExecutionEngine();
        ConfigurationValidator.validatePigProperties((Properties)exe.getConfiguration());
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)exe.getConfiguration());
        JobControlCompiler jcc = new JobControlCompiler(pc, conf);
        Iterator iter = mrPlan.getKeys().values().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            MapReduceOper op = (MapReduceOper)iter.next();
            ++counter;
            if (!op.isSkewedJoin()) continue;
            TestJobSubmission.assertTrue((op.getRequestedParallelism() == 100 ? 1 : 0) != 0);
        }
        TestJobSubmission.assertEquals((int)3, (int)counter);
        TestJobSubmission.pc.defaultParallel = -1;
    }

    private void submit() throws Exception {
        TestJobSubmission.assertEquals((boolean)true, (boolean)FileLocalizer.fileExists((String)this.hadoopLdFile, (PigContext)pc));
        MapReduceLauncher mrl = new MapReduceLauncher();
        mrl.launchPig(this.php, this.grpName, pc);
    }

    static {
        MiniCluster cluster = MiniCluster.buildCluster();
        pc = new PigContext(ExecType.MAPREDUCE, cluster.getProperties());
        try {
            pc.connect();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
        GenPhyOp.setPc(pc);
    }
}

