/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestKeyTypeDiscoveryVisitor
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;
    TupleFactory mTf = TupleFactory.getInstance();
    BagFactory mBf = BagFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testNullJoin() throws Exception {
        String[] inputData = new String[]{"\t7\t8", "\t8\t9", "1\t20\t30", "1\t20\t40"};
        Util.createInputFile(this.cluster, "a.txt", inputData);
        inputData = new String[]{"7\t2", "1\t5", "1\t10"};
        Util.createInputFile(this.cluster, "b.txt", inputData);
        String script = "a = load 'a.txt' as (x:int, y:int, z:int);b = load 'b.txt' as (x:int, y:int);b_group = group b by x;b_sum = foreach b_group generate flatten(group) as x, SUM(b.y) as clicks;a_group = group a by (x, y);a_aggs = foreach a_group generate flatten(group) as (x, y), SUM(a.z) as zs;join_a_b = join b_sum by x, a_aggs by x;";
        Util.registerMultiLineQuery(this.pigServer, script);
        Iterator it = this.pigServer.openIterator("join_a_b");
        Object[] results = new Object[]{1, 15L, 1, 20, 70L};
        Tuple output = (Tuple)it.next();
        TestKeyTypeDiscoveryVisitor.assertFalse((boolean)it.hasNext());
        TestKeyTypeDiscoveryVisitor.assertEquals((int)results.length, (int)output.size());
        for (int i = 0; i < output.size(); ++i) {
            TestKeyTypeDiscoveryVisitor.assertEquals((Object)results[i], (Object)output.get(i));
        }
    }
}

