/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import junit.framework.TestCase;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LTOrEqualToExpr;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.test.utils.GenPhyOp;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLTOrEqual
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIntegerGt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Integer(1));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Integer(0));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)10);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertFalse((boolean)((Boolean)r.result));
    }

    @Test
    public void testIntegerLt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Integer(0));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Integer(1));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)10);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testIntegerEq() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Integer(1));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Integer(1));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)10);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testIntegerAndNullValues() throws Exception {
        this.checkNullValues((byte)10, new Integer(1));
    }

    @Test
    public void testLongGt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Long(1L));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Long(0L));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)15);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertFalse((boolean)((Boolean)r.result));
    }

    @Test
    public void testLongLt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Long(0L));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Long(1L));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)15);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testLongEq() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Long(1L));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Long(1L));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)15);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testLongAndNullValues() throws Exception {
        this.checkNullValues((byte)15, new Long(1L));
    }

    @Test
    public void testFloatGt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Float(1.0f));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Float(0.0f));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)20);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertFalse((boolean)((Boolean)r.result));
    }

    @Test
    public void testFloatLt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Float(0.0f));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Float(1.0f));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)20);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testFloatEq() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Float(1.0f));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Float(1.0f));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)20);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testFloatAndNullValues() throws Exception {
        this.checkNullValues((byte)20, new Float(1.0f));
    }

    @Test
    public void testDoubleGt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Double(1.0));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Double(0.0));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)25);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertFalse((boolean)((Boolean)r.result));
    }

    @Test
    public void testDoubleLt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Double(0.0));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Double(1.0));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)25);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testDoubleEq() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new Double(1.0));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new Double(1.0));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)25);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testDoubleAndNullValues() throws Exception {
        this.checkNullValues((byte)25, new Double(1.0));
    }

    @Test
    public void testStringGt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new String("b"));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new String("a"));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)55);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertFalse((boolean)((Boolean)r.result));
    }

    @Test
    public void testStringLt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new String("a"));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new String("b"));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)55);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testStringEq() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new String("b"));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new String("b"));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)55);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testStringAndNullValues() throws Exception {
        this.checkNullValues((byte)55, new String("b"));
    }

    @Test
    public void testDataByteArrayGt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new DataByteArray("b"));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new DataByteArray("a"));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)50);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertFalse((boolean)((Boolean)r.result));
    }

    @Test
    public void testDataByteArrayLt() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new DataByteArray("a"));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new DataByteArray("b"));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)50);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testDataByteArrayEq() throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        lt.setValue((Object)new DataByteArray("b"));
        ConstantExpression rt = GenPhyOp.exprConst();
        rt.setValue((Object)new DataByteArray("b"));
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        g.setOperandType((byte)50);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)0, (byte)r.returnStatus);
        TestLTOrEqual.assertTrue((boolean)((Boolean)r.result));
    }

    @Test
    public void testDataByteArrayAndNullValues() throws Exception {
        this.checkNullValues((byte)50, new DataByteArray("b"));
    }

    public <U> void checkNullValues(byte operandType, U value) throws Exception {
        ConstantExpression lt = GenPhyOp.exprConst();
        ConstantExpression rt = GenPhyOp.exprConst();
        LTOrEqualToExpr g = GenPhyOp.compLTOrEqualToExpr();
        g.setOperandType(operandType);
        lt.setValue(null);
        rt.setValue(value);
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        Result r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)1, (byte)r.returnStatus);
        TestLTOrEqual.assertEquals(null, (Object)((Boolean)r.result));
        g.setOperandType(operandType);
        lt.setValue(value);
        rt.setValue(null);
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)1, (byte)r.returnStatus);
        TestLTOrEqual.assertEquals(null, (Object)((Boolean)r.result));
        g.setOperandType(operandType);
        lt.setValue(null);
        rt.setValue(null);
        g.setLhs((ExpressionOperator)lt);
        g.setRhs((ExpressionOperator)rt);
        r = g.getNext(new Boolean(true));
        TestLTOrEqual.assertEquals((byte)1, (byte)r.returnStatus);
        TestLTOrEqual.assertEquals(null, (Object)((Boolean)r.result));
    }
}

