/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestLargeFile
extends TestCase {
    File datFile;
    private long defaultBlockSize = new Configuration().getLong("dfs.block.size", 0L);
    private long total = this.defaultBlockSize >> 1;
    private int max_rand = 500;
    MiniCluster cluster = MiniCluster.buildCluster();
    Integer[] COUNT = new Integer[this.max_rand];
    PigServer pig;
    String fileName;
    String tmpFile1;

    @Before
    protected void setUp() throws Exception {
        System.out.println("Generating test data...");
        System.out.println("Default block size = " + this.defaultBlockSize);
        System.out.println("Total no. of iterations to run for the test data = " + this.total);
        this.datFile = File.createTempFile("StoreTest", ".dat");
        FileOutputStream dat = new FileOutputStream(this.datFile);
        Random rand = new Random();
        for (int i = 0; i < this.max_rand; ++i) {
            this.COUNT[i] = 0;
        }
        for (long i = 0L; i < this.total; ++i) {
            Integer x = new Integer(rand.nextInt(this.max_rand));
            Integer[] integerArray = this.COUNT;
            int n = x;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
            dat.write((x.toString() + "\n").getBytes());
        }
        dat.close();
        try {
            this.pig = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
        }
        catch (ExecException e) {
            IOException ioe = new IOException("Failed to create Pig server");
            ioe.initCause(e);
            throw ioe;
        }
        this.fileName = "'" + FileLocalizer.hadoopify((String)this.datFile.toString(), (PigContext)this.pig.getPigContext()) + "'";
        this.tmpFile1 = "'" + FileLocalizer.getTemporaryPath(null, (PigContext)this.pig.getPigContext()).toString() + "'";
        this.datFile.delete();
    }

    @After
    protected void tearDown() throws Exception {
    }

    @Test
    public void testLargeFile() throws Exception {
        System.out.println("Running testLargeFile...");
        this.pig.registerQuery("A = load " + this.fileName + ";");
        this.pig.registerQuery("A = group A by $0;");
        this.pig.store("A", this.tmpFile1, "BinStorage()");
        this.pig.registerQuery("B = foreach A generate group, COUNT($1);");
        Iterator B = this.pig.openIterator("B");
        while (B.hasNext()) {
            Tuple temp = (Tuple)B.next();
            int index = DataType.toInteger((Object)temp.get(0));
            int value = DataType.toInteger((Object)temp.get(1));
            System.out.println("COUNT [" + index + "] = " + this.COUNT[index] + " B[" + index + "] = " + value);
            TestLargeFile.assertEquals((int)this.COUNT[index], (int)value);
        }
    }

    @Test
    public void testOrder() throws Exception {
        System.out.println("Running testOrder...");
        int N = 0;
        int Nplus1 = 0;
        this.pig.registerQuery("A = load " + this.fileName + ";");
        this.pig.registerQuery("B = order A by $0;");
        Iterator B = this.pig.openIterator("B");
        if (B.hasNext()) {
            N = DataType.toInteger((Object)((Tuple)B.next()).get(0));
        }
        while (B.hasNext()) {
            int flag = 0;
            Nplus1 = DataType.toInteger((Object)((Tuple)B.next()).get(0));
            if (Nplus1 >= N) {
                flag = 1;
            }
            TestLargeFile.assertEquals((int)flag, (int)1);
            N = Nplus1;
        }
    }

    @Test
    public void testDistinct() throws Exception {
        int i;
        System.out.println("Running testDistinct...");
        this.pig.registerQuery("A = load " + this.fileName + ";");
        this.pig.registerQuery("B = distinct A;");
        Iterator B = this.pig.openIterator("B");
        Integer[] COUNT_Test = new Integer[this.max_rand];
        Integer[] COUNT_Data = new Integer[this.max_rand];
        for (i = 0; i < this.max_rand; ++i) {
            COUNT_Test[i] = 0;
            COUNT_Data[i] = this.COUNT[i] > 0 ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        while (B.hasNext()) {
            int temp = DataType.toInteger((Object)((Tuple)B.next()).get(0));
            Integer[] integerArray = COUNT_Test;
            int n = temp;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        }
        for (i = 0; i < this.max_rand; ++i) {
            TestLargeFile.assertEquals((int)COUNT_Test[i], (int)COUNT_Data[i]);
        }
    }
}

