/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.backend.datastorage.DataStorage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenPhyOp;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestLoad
extends TestCase {
    PigContext pc;
    PigServer[] servers;
    static MiniCluster cluster = MiniCluster.buildCluster();

    @Before
    public void setUp() throws Exception {
        FileLocalizer.deleteTempFiles();
        this.servers = new PigServer[]{new PigServer(ExecType.MAPREDUCE, cluster.getProperties()), new PigServer(ExecType.LOCAL, new Properties())};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNextTuple() throws IOException {
        this.pc = this.servers[0].getPigContext();
        String curDir = System.getProperty("user.dir");
        String inpDir = curDir + File.separatorChar + "test/org/apache/pig/test/data/InputFiles/";
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            inpDir = "/" + FileLocalizer.parseCygPath((String)inpDir, (int)1);
        }
        Util.copyFromLocalToCluster(cluster, inpDir + "passwd", "passwd");
        FileSpec inpFSpec = new FileSpec("passwd", new FuncSpec(PigStorage.class.getName(), new String[]{":"}));
        POLoad ld = GenPhyOp.topLoadOp();
        ld.setLFile(inpFSpec);
        ld.setPc(this.pc);
        DataBag inpDB = DefaultBagFactory.getInstance().newDefaultBag();
        BufferedReader br = new BufferedReader(new FileReader("test/org/apache/pig/test/data/InputFiles/passwd"));
        String line = br.readLine();
        while (line != null) {
            String[] flds = line.split(":", -1);
            DefaultTuple t = new DefaultTuple();
            for (String fld : flds) {
                t.append((Object)(fld.compareTo("") != 0 ? new DataByteArray(fld.getBytes()) : null));
            }
            inpDB.add((Tuple)t);
            line = br.readLine();
        }
        Tuple t = null;
        int size = 0;
        Result res = ld.getNext(t);
        while (res.returnStatus != 3) {
            TestLoad.assertEquals((boolean)true, (boolean)TestHelper.bagContains(inpDB, (Tuple)res.result));
            ++size;
            res = ld.getNext(t);
        }
        TestLoad.assertEquals((boolean)true, ((long)size == inpDB.size() ? 1 : 0) != 0);
    }

    @Test
    public void testLoadRemoteRel() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("test", "/tmp/test");
        }
    }

    @Test
    public void testLoadRemoteAbs() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("/tmp/test", "/tmp/test");
        }
    }

    @Test
    public void testLoadRemoteRelScheme() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("test", "/tmp/test");
        }
    }

    @Test
    public void testLoadRemoteAbsScheme() throws Exception {
        this.pc = this.servers[0].getPigContext();
        this.checkLoadPath("hdfs:/tmp/test", "/tmp/test");
    }

    @Test
    public void testLoadRemoteAbsAuth() throws Exception {
        this.pc = this.servers[0].getPigContext();
        this.checkLoadPath("hdfs://localhost:9000/test", "/test");
    }

    @Test
    public void testLoadRemoteNormalize() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("/tmp/foo/../././", "/tmp");
        }
    }

    @Test
    public void testGlobChars() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("t?s*", "/tmp/t?s*");
        }
    }

    @Test
    public void testCommaSeparatedString() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("usr/pig/a,usr/pig/b", "/tmp/usr/pig/a,/tmp/usr/pig/b");
        }
    }

    @Test
    public void testCommaSeparatedString2() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("t?s*,test", "/tmp/t?s*,/tmp/test");
        }
    }

    @Test
    public void testCommaSeparatedString3() throws Exception {
        PigServer pig = this.servers[0];
        this.pc = pig.getPigContext();
        this.checkLoadPath("hdfs:/tmp/test,hdfs:/tmp/test2,hdfs:/tmp/test3", "/tmp/test,/tmp/test2,/tmp/test3");
    }

    @Test
    public void testCommaSeparatedString4() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("usr/pig/{a,c},usr/pig/b", "/tmp/usr/pig/{a,c},/tmp/usr/pig/b");
        }
    }

    @Test
    public void testCommaSeparatedString5() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("/usr/pig/{a,c},usr/pig/b", "/usr/pig/{a,c},/tmp/usr/pig/b");
        }
    }

    @Test
    public void testCommaSeparatedString6() throws Exception {
        for (PigServer pig : this.servers) {
            this.pc = pig.getPigContext();
            this.checkLoadPath("usr/pig/{a,c},/usr/pig/b", "/tmp/usr/pig/{a,c},/usr/pig/b");
        }
    }

    @Test
    public void testNonDfsLocation() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        String nonDfsUrl = "har://hdfs-namenode/user/foo/";
        LogicalPlan lp = lpt.buildPlan("a = load '" + nonDfsUrl + "';");
        LOLoad load = (LOLoad)lp.getRoots().get(0);
        Assert.assertEquals((String)nonDfsUrl, (String)load.getInputFile().getFileName());
    }

    private void checkLoadPath(String orig, String expected) throws Exception {
        boolean[] multiquery;
        for (boolean b : multiquery = new boolean[]{true, false}) {
            this.pc.getProperties().setProperty("opt.multiquery", "" + b);
            DataStorage dfs = this.pc.getDfs();
            dfs.setActiveContainer(dfs.asContainer("/tmp"));
            HashMap aliases = new HashMap();
            HashMap logicalOpTable = new HashMap();
            HashMap aliasOp = new HashMap();
            HashMap fileNameMap = new HashMap();
            LogicalPlanBuilder builder = new LogicalPlanBuilder(this.pc);
            String query = "a = load '" + orig + "';";
            LogicalPlan lp = builder.parse("Test-Load", query, aliases, logicalOpTable, aliasOp, fileNameMap);
            Assert.assertTrue((lp.size() > 0 ? 1 : 0) != 0);
            LogicalOperator op = (LogicalOperator)lp.getRoots().get(0);
            Assert.assertTrue((boolean)(op instanceof LOLoad));
            LOLoad load = (LOLoad)op;
            String p = load.getInputFile().getFileName();
            System.err.println("DEBUG: p:" + p + " expected:" + expected + ", exectype:" + this.pc.getExecType());
            if (this.pc.getExecType() == ExecType.MAPREDUCE) {
                Assert.assertTrue((boolean)p.matches("hdfs://[0-9a-zA-Z:\\.]*.*"));
                Assert.assertEquals((String)p.replaceAll("hdfs://[0-9a-zA-Z:\\.]*/", "/"), (String)expected);
                continue;
            }
            Assert.assertTrue((boolean)p.matches("file://[0-9a-zA-Z:\\.]*.*"));
            Assert.assertEquals((String)p.replaceAll("file://[0-9a-zA-Z:\\.]*/", "/"), (String)expected);
        }
    }
}

