/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.fs.Path;
import org.apache.pig.LoadFunc;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLoadFunc {
    private static Path curHdfsDir;
    private static String curHdfsRoot;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        curHdfsDir = new Path(curHdfsRoot + "/user/pig/");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetAbsolutePath() throws IOException {
        Assert.assertEquals((String)(curHdfsRoot + "/hadoop/test/passwd"), (String)LoadFunc.getAbsolutePath((String)"/hadoop/test/passwd", (Path)curHdfsDir));
    }

    @Test
    public void testGetAbsolutePath2() throws IOException {
        Assert.assertEquals((String)(curHdfsRoot + "/user/pig/data/passwd"), (String)LoadFunc.getAbsolutePath((String)"data/passwd", (Path)curHdfsDir));
    }

    @Test
    public void testGetAbsolutePath3() throws IOException {
        String absPath = "hdfs://myhost.mydomain:37765/data/passwd";
        Assert.assertEquals((String)absPath, (String)LoadFunc.getAbsolutePath((String)absPath, (Path)curHdfsDir));
    }

    @Test
    public void testGetAbsolutePath4() throws IOException {
        Assert.assertEquals((String)"http://myhost:12345/data/passwd", (String)LoadFunc.getAbsolutePath((String)"http://myhost:12345/data/passwd", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/usr/pig/a," + curHdfsRoot + "/usr/pig/b"), (String)LoadFunc.getAbsolutePath((String)"/usr/pig/a,/usr/pig/b", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString2() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/user/pig/t?s*," + curHdfsRoot + "/user/pig/test"), (String)LoadFunc.getAbsolutePath((String)"t?s*,test", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString3() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/tmp/test," + curHdfsRoot + "/tmp/test2," + curHdfsRoot + "/tmp/test3"), (String)LoadFunc.getAbsolutePath((String)"/tmp/test,/tmp/test2,/tmp/test3", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString4() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/user/pig/test/{a,c}," + curHdfsRoot + "/user/pig/test/b"), (String)LoadFunc.getAbsolutePath((String)"test/{a,c},test/b", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString5() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/test/data/{a,c}," + curHdfsRoot + "/user/pig/test/b"), (String)LoadFunc.getAbsolutePath((String)"/test/data/{a,c},test/b", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString6() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/user/pig/test/{a,c}," + curHdfsRoot + "/test/data/b"), (String)LoadFunc.getAbsolutePath((String)"test/{a,c},/test/data/b", (Path)curHdfsDir));
    }

    @Test
    public void testCommaSeparatedString7() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/user/pig/test/{a,c}," + curHdfsRoot + "/test/data/b"), (String)LoadFunc.getAbsolutePath((String)"test/{a,c}, /test/data/b", (Path)curHdfsDir));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCommaSeparatedString8() throws Exception {
        Assert.assertEquals((String)(curHdfsRoot + "/user/pig/," + curHdfsRoot + "/test/data/b"), (String)LoadFunc.getAbsolutePath((String)", /test/data/b", (Path)curHdfsDir));
    }

    static {
        curHdfsRoot = "hdfs://localhost.localdomain:12345";
    }
}

