/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigServer;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Test;

public class TestLocal2
extends TestCase {
    private String initString = "local";
    private PigServer pig = new PigServer(this.initString);

    @Test
    public void testUnion1() throws Exception {
        File tmpFile1 = this.genDataSetFile(false, 30);
        File tmpFile2 = this.genDataSetFile(false, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("c = union a, b; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testUnion1WithNulls() throws Exception {
        File tmpFile1 = this.genDataSetFile(true, 30);
        File tmpFile2 = this.genDataSetFile(true, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("c = union a, b; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testUnion2() throws Exception {
        File tmpFile1 = this.genDataSetFile(false, 30);
        File tmpFile2 = this.genDataSetFile(false, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("a1 = foreach a generate $0, $1; ");
        this.pig.registerQuery("b1 = foreach b generate $0, $1; ");
        this.pig.registerQuery("c = union a1, b1; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testUnion2WithNulls() throws Exception {
        File tmpFile1 = this.genDataSetFile(true, 30);
        File tmpFile2 = this.genDataSetFile(true, 50);
        this.pig.registerQuery("a = load '" + Util.generateURI(tmpFile1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("b = load '" + Util.generateURI(tmpFile2.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("a1 = foreach a generate $0, $1; ");
        this.pig.registerQuery("b1 = foreach b generate $0, $1; ");
        this.pig.registerQuery("c = union a1, b1; ");
        this.verifyUnion("c", 80);
    }

    @Test
    public void testPig800Distinct() throws Exception {
        File fp1 = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(fp1));
        ps.println("1\t1}");
        ps.close();
        this.pig.registerQuery("A = load '" + Util.generateURI(fp1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("B = foreach A generate flatten(" + Pig800Udf.class.getName() + "($0));");
        this.pig.registerQuery("C = distinct B;");
        Iterator iter = this.pig.openIterator("C");
    }

    @Test
    public void testPig800Sort() throws Exception {
        File fp1 = File.createTempFile("test", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(fp1));
        ps.println("1\t1}");
        ps.close();
        this.pig.registerQuery("A = load '" + Util.generateURI(fp1.toString(), this.pig.getPigContext()) + "'; ");
        this.pig.registerQuery("B = foreach A generate flatten(" + Pig800Udf.class.getName() + "($0));");
        this.pig.registerQuery("C = order B by $0;");
        Iterator iter = this.pig.openIterator("C");
    }

    @Test
    public void testJoin1() throws Exception {
        File fp1 = File.createTempFile("test1", "txt");
        PrintStream ps = new PrintStream(new FileOutputStream(fp1));
        ps.println("1\t1");
        ps.println("2\t2");
        ps.close();
        File fp2 = File.createTempFile("test2", "txt");
        ps = new PrintStream(new FileOutputStream(fp2));
        ps.println("1\t1");
        ps.println("2\t2");
        ps.close();
        this.pig.registerQuery("A = load '" + Util.generateURI(fp1.toString(), this.pig.getPigContext()) + "'AS (a0:int, a1:int); ");
        this.pig.registerQuery("B = load '" + Util.generateURI(fp2.toString(), this.pig.getPigContext()) + "'AS (b0:int, b1:int); ");
        this.pig.registerQuery("C = join A by a0, B by b0;");
        Iterator iter = this.pig.openIterator("C");
        TestLocal2.assertTrue((boolean)iter.hasNext());
        Tuple t = (Tuple)iter.next();
        TestLocal2.assertTrue((boolean)t.get(0).equals(new Integer(1)));
        TestLocal2.assertTrue((boolean)t.get(1).equals(new Integer(1)));
        TestLocal2.assertTrue((boolean)t.get(2).equals(new Integer(1)));
        TestLocal2.assertTrue((boolean)t.get(3).equals(new Integer(1)));
        TestLocal2.assertTrue((boolean)iter.hasNext());
        t = (Tuple)iter.next();
        TestLocal2.assertTrue((boolean)t.get(0).equals(new Integer(2)));
        TestLocal2.assertTrue((boolean)t.get(1).equals(new Integer(2)));
        TestLocal2.assertTrue((boolean)t.get(2).equals(new Integer(2)));
        TestLocal2.assertTrue((boolean)t.get(3).equals(new Integer(2)));
        TestLocal2.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void verifyUnion(String id, int actualCount) throws Exception {
        Iterator it = this.pig.openIterator(id);
        Tuple t = null;
        int count = 0;
        while (it.hasNext()) {
            t = (Tuple)it.next();
            System.out.println(count + ":" + t);
            ++count;
        }
        Assert.assertEquals((int)count, (int)actualCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalInit() throws Exception {
        File pigFile = new File("script.pig");
        File siteFile = new File("mapred-site.xml");
        try {
            pigFile.createNewFile();
            int status = Util.executeJavaCommand("java -cp " + System.getProperty("java.class.path") + "  org.apache.pig.Main -x local " + pigFile.getAbsolutePath());
            String contents = "<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration xmlns:xi=\"http://www.w3.org/2001/XInclude\">\n  <property>\n    <name>mapred.system.dir</name>\n    <value>/mapredsystem/hadoop/mapredsystem</value>\n    <description>No description</description>\n    <final>true</final>\n  </property>\n</configuration>\n";
            TestLocal2.assertTrue((boolean)siteFile.createNewFile());
            PrintStream ps = new PrintStream(siteFile);
            ps.print(contents);
            ps.close();
            int status2 = Util.executeJavaCommand("java -cp " + System.getProperty("java.class.path") + "  org.apache.pig.Main -x local " + pigFile.getAbsolutePath());
            TestLocal2.assertEquals((String)"Without a mapred-site.xml pig should just run", (int)0, (int)status);
            TestLocal2.assertEquals((String)"With map.system.dir redefined in mapred-site.xml pig should exit", (int)2, (int)status2);
        }
        finally {
            if (siteFile.exists()) {
                siteFile.delete();
            }
            if (pigFile.exists()) {
                pigFile.delete();
            }
        }
    }

    private File genDataSetFile(boolean hasNulls, int dataLength) throws IOException {
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        if (hasNulls) {
            for (int i = 0; i < dataLength; ++i) {
                data[i] = new String[2];
                if (i % 7 == 0) {
                    data[i][0] = "";
                    data[i][1] = formatter.format(dataLength - i);
                    continue;
                }
                if (i % 10 == 0) {
                    data[i][0] = formatter.format(i % 10);
                    data[i][1] = "";
                    continue;
                }
                if (i % 13 == 0) {
                    data[i][0] = "";
                    data[i][1] = "";
                    continue;
                }
                data[i][0] = formatter.format(i % 10);
                data[i][1] = formatter.format(dataLength - i);
            }
        } else {
            for (int i = 0; i < dataLength; ++i) {
                data[i] = new String[2];
                data[i][0] = formatter.format(i % 10);
                data[i][1] = formatter.format(dataLength - i);
            }
        }
        return TestHelper.createTempFile(data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pig800Udf
    extends EvalFunc<DataBag> {
        public DataBag exec(Tuple input) throws IOException {
            DataBag output = BagFactory.getInstance().newDefaultBag();
            return output;
        }
    }
}

