/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LODefine;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.validators.LogicalPlanValidationExecutor;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.LocalLogToPhyTranslationVisitor;
import org.apache.pig.pen.util.FunctionalLogicalOptimizer;
import org.apache.pig.test.Util;
import org.junit.Test;

public class TestLocalPOSplit
extends TestCase {
    Random r = new Random();
    Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    PigContext pigContext = new PigContext(ExecType.LOCAL, new Properties());
    Map<LogicalOperator, LogicalPlan> aliases;
    Map<OperatorKey, LogicalOperator> logicalOpTable;
    Map<String, LogicalOperator> aliasOp;
    Map<String, String> fileNameMap;

    @Test
    public void testSplit() throws IOException, VisitorException, ExecException {
        int i;
        this.init();
        this.pigContext.connect();
        File datFile = File.createTempFile("tempA", ".dat");
        FileOutputStream dat = new FileOutputStream(datFile);
        for (int i2 = 0; i2 < 100; ++i2) {
            String str = this.r.nextInt(10) + "\n";
            dat.write(str.getBytes());
        }
        dat.close();
        String query = "split (load '" + Util.encodeEscape(datFile.getAbsolutePath()) + "') into a if $0 == 2, b if $0 == 9, c if $0 == 7 ;";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        DataBag[] bag = new DataBag[pp.getLeaves().size()];
        for (i = 0; i < bag.length; ++i) {
            bag[i] = BagFactory.getInstance().newDefaultBag();
        }
        for (i = 0; i < pp.getLeaves().size(); ++i) {
            Tuple t = null;
            Result res = ((PhysicalOperator)pp.getLeaves().get(i)).getNext(t);
            while (res.returnStatus != 3) {
                if (res.returnStatus == 0) {
                    bag[i].add((Tuple)res.result);
                }
                res = ((PhysicalOperator)pp.getLeaves().get(i)).getNext(t);
            }
        }
        HashMap<DataByteArray, Boolean> seen = new HashMap<DataByteArray, Boolean>();
        seen.put(new DataByteArray("7".getBytes()), false);
        seen.put(new DataByteArray("9".getBytes()), false);
        seen.put(new DataByteArray("2".getBytes()), false);
        for (int i3 = 0; i3 < bag.length; ++i3) {
            Tuple t;
            DataByteArray firstValue = null;
            Iterator it = bag[i3].iterator();
            if (it.hasNext()) {
                t = (Tuple)it.next();
                System.out.println(t);
                firstValue = (DataByteArray)t.get(0);
                TestLocalPOSplit.assertFalse((boolean)((Boolean)seen.get(firstValue)));
                seen.put(firstValue, true);
            }
            while (it.hasNext()) {
                t = (Tuple)it.next();
                System.out.println(t);
                TestLocalPOSplit.assertEquals((Object)t.get(0), (Object)firstValue);
            }
        }
    }

    @Test
    public void testSplitNulls() throws IOException, VisitorException, ExecException {
        int i;
        this.init();
        this.pigContext.connect();
        File datFile = File.createTempFile("tempN1", ".dat");
        String path1 = Util.encodeEscape(datFile.getAbsolutePath());
        FileOutputStream dat = new FileOutputStream(datFile);
        String s1 = "1\n2\n3\n42\n4\n5\n";
        dat.write(s1.getBytes());
        dat.close();
        String s2 = "1\n2\n43\n3\n4\n5\n";
        datFile = File.createTempFile("tempN2", ".dat");
        String path2 = Util.encodeEscape(datFile.getAbsolutePath());
        dat = new FileOutputStream(datFile);
        dat.write(s2.getBytes());
        dat.close();
        String query = "a = load '" + path1 + "'; b = load '" + path2 + "'; " + "c = cogroup a by $0, b by $0; d = foreach c generate $0, flatten($1), flatten($2); " + "split d into e if 1==1, f if 1==1;";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        DataBag[] bag = new DataBag[pp.getLeaves().size()];
        for (i = 0; i < bag.length; ++i) {
            bag[i] = BagFactory.getInstance().newDefaultBag();
        }
        for (i = 0; i < pp.getLeaves().size(); ++i) {
            System.out.println("Leaves: " + i);
            Tuple t = null;
            Result res = ((PhysicalOperator)pp.getLeaves().get(i)).getNext(t);
            while (res.returnStatus != 3) {
                if (res.returnStatus == 0) {
                    bag[i].add((Tuple)res.result);
                }
                System.out.println("Split: " + res.result);
                res = ((PhysicalOperator)pp.getLeaves().get(i)).getNext(t);
            }
        }
        HashMap<DataByteArray, Integer> seen = new HashMap<DataByteArray, Integer>();
        seen.put(new DataByteArray("1".getBytes()), new Integer(0));
        seen.put(new DataByteArray("2".getBytes()), new Integer(0));
        seen.put(new DataByteArray("3".getBytes()), new Integer(0));
        seen.put(new DataByteArray("4".getBytes()), new Integer(0));
        seen.put(new DataByteArray("5".getBytes()), new Integer(0));
        for (int i2 = 0; i2 < bag.length; ++i2) {
            DataByteArray value = null;
            for (Tuple t : bag[i2]) {
                System.out.println("Value: " + t);
                value = (DataByteArray)t.get(0);
                Integer count = (Integer)seen.get(value);
                count = count + 1;
                seen.put(value, count);
            }
        }
        for (Integer j : seen.values()) {
            TestLocalPOSplit.assertEquals((Object)j, (Object)new Integer(2));
        }
    }

    public PhysicalPlan buildPhysicalPlan(LogicalPlan lp) throws VisitorException {
        LocalLogToPhyTranslationVisitor visitor = new LocalLogToPhyTranslationVisitor(lp);
        visitor.setPigContext(this.pigContext);
        visitor.visit();
        return visitor.getPhysicalPlan();
    }

    public LogicalPlan buildPlan(String query) {
        return this.buildPlan(query, LogicalPlanBuilder.class.getClassLoader());
    }

    public LogicalPlan buildPlan(String query, ClassLoader cldr) {
        LogicalPlanBuilder.classloader = cldr;
        LogicalPlanBuilder builder = new LogicalPlanBuilder(this.pigContext);
        try {
            String[] qs = query.split(";");
            LogicalPlan lp = null;
            for (String q : qs) {
                if ((q = q.trim()).equals("")) continue;
                q = q + ";";
                System.out.println(q);
                lp = builder.parse("Test-Plan-Builder", q, this.aliases, this.logicalOpTable, this.aliasOp, this.fileNameMap);
            }
            List roots = lp.getRoots();
            if (roots.size() > 0) {
                for (LogicalOperator op : roots) {
                    if (op instanceof LOLoad || op instanceof LODefine) continue;
                    throw new Exception("Cannot have a root that is not the load or define operator. Found " + op.getClass().getName());
                }
            }
            System.err.println("Query: " + query);
            for (LogicalOperator op : lp.getRoots()) {
                System.err.println("Logical Plan Root: " + op.getClass().getName() + " object " + op);
                List listOp = lp.getSuccessors((Operator)op);
                if (null == listOp) continue;
                for (LogicalOperator lop : listOp) {
                    System.err.println("Successor: " + lop.getClass().getName() + " object " + lop);
                }
            }
            TestLocalPOSplit.assertTrue(((lp = this.refineLogicalPlan(lp)) != null ? 1 : 0) != 0);
            return lp;
        }
        catch (IOException e) {
            TestLocalPOSplit.fail((String)("IOException: " + e.getMessage()));
        }
        catch (Exception e) {
            this.log.error((Object)e);
            TestLocalPOSplit.fail((String)(e.getClass().getName() + ": " + e.getMessage() + " -- " + query));
        }
        return null;
    }

    private LogicalPlan refineLogicalPlan(LogicalPlan plan) {
        PlanSetter ps = new PlanSetter(plan);
        try {
            ps.visit();
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
        CompilationMessageCollector collector = new CompilationMessageCollector();
        FrontendException caught = null;
        try {
            boolean isBeforeOptimizer = true;
            LogicalPlanValidationExecutor validator = new LogicalPlanValidationExecutor(plan, this.pigContext, isBeforeOptimizer);
            validator.validate(plan, collector);
            FunctionalLogicalOptimizer optimizer = new FunctionalLogicalOptimizer(plan);
            optimizer.optimize();
            isBeforeOptimizer = false;
            validator = new LogicalPlanValidationExecutor(plan, this.pigContext, isBeforeOptimizer);
            validator.validate(plan, collector);
        }
        catch (FrontendException fe) {
            caught = fe;
        }
        return plan;
    }

    private void init() {
        this.aliases = new HashMap<LogicalOperator, LogicalPlan>();
        this.logicalOpTable = new HashMap<OperatorKey, LogicalOperator>();
        this.aliasOp = new HashMap<String, LogicalOperator>();
        this.fileNameMap = new HashMap<String, String>();
    }
}

