/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.SortColInfo;
import org.apache.pig.SortInfo;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogToPhyTranslationVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LODefine;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOPrinter;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanBuilder;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLogToPhyCompiler
extends TestCase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    File A;
    final int MAX_RANGE = 10;
    Random r = new Random();
    PigContext pc = new PigContext(ExecType.LOCAL, new Properties());
    private boolean generate = false;
    Map<LogicalOperator, LogicalPlan> aliases = new HashMap<LogicalOperator, LogicalPlan>();
    Map<OperatorKey, LogicalOperator> logicalOpTable = new HashMap<OperatorKey, LogicalOperator>();
    Map<String, LogicalOperator> aliasOp = new HashMap<String, LogicalOperator>();
    Map<String, String> fileNameMap = new HashMap<String, String>();

    protected void setUp() throws Exception {
        this.pc.connect();
    }

    private void writeData(File input, int noTuples, int arityOfTuples, char separator) throws IOException {
        FileOutputStream dat = new FileOutputStream(input);
        for (int i = 0; i < noTuples; ++i) {
            for (int j = 0; j < arityOfTuples; ++j) {
                int temp = this.r.nextInt(10);
                if (j == arityOfTuples - 1) {
                    dat.write((temp + "\n").getBytes());
                    continue;
                }
                dat.write((temp + "" + separator).getBytes());
            }
        }
        dat.close();
    }

    @Test
    public void testComplexForeach() throws VisitorException, IOException {
        String query = "foreach (load 'a') {B = FILTER $0 BY ($1 == $2);generate B;};";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/ComplexForeach.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/ComplexForeach.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    public void testSort() throws VisitorException, IOException {
        String query = "order (load 'a') by $0;";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Sort.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Sort.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    public void testDistinct() throws VisitorException, IOException {
        String query = "distinct (load 'a');";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Distinct.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Distinct.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    public void testCogroup() throws VisitorException, IOException {
        System.out.println("testCogroup");
        String query = "cogroup (load 'a') by ($0 + $1, $0 - $1), (load 'b') by ($0 + $1, $0 - $1);";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Cogroup.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Cogroup.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    public void testArithmetic() throws VisitorException, IOException, ExecException {
        String query = "foreach (load 'A') generate $0 + $1 + '5', $0 - '5' - $1, 'hello';";
        LogicalPlan lp = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        TestLogToPhyCompiler.assertEquals((int)1, (int)pp.getLeaves().size());
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Arithmetic.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Arithmetic.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    public void testComparison() throws VisitorException, IOException {
        String query = "filter (load 'a' using " + PigStorage.class.getName() + "(':')) by $0 + $1 > ($0 - $1) * ('4' / '2');";
        LogicalPlan lp = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        TestLogToPhyCompiler.assertEquals((int)1, (int)pp.getLeaves().size());
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Comparison.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Comparison.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    @Test
    public void testBinCond() throws VisitorException, IOException {
        String query = "foreach (load 'a') generate ($1 == '3'? $2 + $3 : $2 - $3) ;";
        LogicalPlan lp = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/BinCond.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/BinCond.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    @Test
    public void testGenerate() throws VisitorException, IOException {
        String query = "foreach (load 'a') generate ($1+$2), ($1-$2), ($1*$2), ($1/$2), ($1%$2), -($1) ;";
        LogicalPlan lp = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Generate.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Generate.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    @Test
    public void testUnion() throws VisitorException, IOException {
        String query = "union (load 'a'), (load 'b'), (load 'c');";
        LogicalPlan lp = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Union.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Union.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    @Test
    public void testSplit() throws VisitorException, IOException {
        String query = "split (load 'a') into x if $0 < '7', y if $0 > '7';";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Split1.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis1 = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Split1.gld");
        FileInputStream fis2 = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Split2.gld");
        byte[] b1 = new byte[MAX_SIZE];
        byte[] b2 = new byte[MAX_SIZE];
        int len = fis1.read(b1);
        int test = fis2.read(b2);
        String goldenPlan1 = new String(b1, 0, len);
        String goldenPlan2 = new String(b2, 0, len);
        goldenPlan1 = goldenPlan1.replaceAll("Load(.*)", "Load()");
        goldenPlan2 = goldenPlan2.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        if (compiledPlan.compareTo(goldenPlan1) != 0 && compiledPlan.compareTo(goldenPlan2) != 0) {
            System.out.println("Expected plan1=");
            System.out.println(goldenPlan1);
            System.out.println("Expected plan2=");
            System.out.println(goldenPlan1);
            System.out.println("Actual plan=");
            System.out.println(compiledPlan);
            System.out.println("**END**");
            TestLogToPhyCompiler.fail((String)"Plan not match");
        }
    }

    @Test
    public void testIsNull() throws VisitorException, IOException {
        String query = "split (load 'a') into x if $0 IS NULL, y if $0 IS NOT NULL;";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/IsNull1.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis1 = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/IsNull1.gld");
        FileInputStream fis2 = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/IsNull2.gld");
        byte[] b1 = new byte[MAX_SIZE];
        byte[] b2 = new byte[MAX_SIZE];
        int len = fis1.read(b1);
        int test = fis2.read(b2);
        String goldenPlan1 = new String(b1, 0, len);
        String goldenPlan2 = new String(b2, 0, len);
        goldenPlan1 = goldenPlan1.replaceAll("Load(.*)", "Load()");
        goldenPlan2 = goldenPlan2.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        if (compiledPlan.compareTo(goldenPlan1) != 0 && compiledPlan.compareTo(goldenPlan2) != 0) {
            System.out.println("Expected plan1=");
            System.out.println(goldenPlan1);
            System.out.println("Expected plan2=");
            System.out.println(goldenPlan1);
            System.out.println("Actual plan=");
            System.out.println(compiledPlan);
            System.out.println("**END**");
            TestLogToPhyCompiler.fail((String)"Plan not match");
        }
    }

    @Test
    public void testLimit() throws VisitorException, IOException {
        String query = "limit (load 'a') 5;";
        LogicalPlan plan = this.buildPlan(query);
        PhysicalPlan pp = this.buildPhysicalPlan(plan);
        int MAX_SIZE = 100000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pp.explain((OutputStream)baos);
        baos.write(10);
        String compiledPlan = baos.toString();
        compiledPlan = compiledPlan.replaceAll("Load(.*)", "Load()");
        if (this.generate) {
            FileOutputStream fos = new FileOutputStream("test/org/apache/pig/test/data/GoldenFiles/Limit.gld");
            fos.write(baos.toByteArray());
            return;
        }
        FileInputStream fis = new FileInputStream("test/org/apache/pig/test/data/GoldenFiles/Limit.gld");
        byte[] b = new byte[MAX_SIZE];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        goldenPlan = goldenPlan.replaceAll("Load(.*)", "Load()");
        System.out.println();
        System.out.println(compiledPlan);
        System.out.println("-------------");
        TestLogToPhyCompiler.assertEquals((String)compiledPlan, (String)goldenPlan);
    }

    @Test
    public void testErrLimit() throws VisitorException, IOException {
        String query = "limit (load 'a') 5;";
        LogicalPlan plan = this.buildPlan(query);
        plan.remove((Operator)plan.getRoots().get(0));
        try {
            this.buildPhysicalPlan(plan);
            TestLogToPhyCompiler.fail((String)"Expected error.");
        }
        catch (VisitorException ve) {
            TestLogToPhyCompiler.assertTrue((ve.getErrorCode() == 2051 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrFilter() throws VisitorException, IOException {
        String query = "filter (load 'a') by $0 > 5;";
        LogicalPlan plan = this.buildPlan(query);
        plan.remove((Operator)plan.getRoots().get(0));
        try {
            this.buildPhysicalPlan(plan);
            TestLogToPhyCompiler.fail((String)"Expected error.");
        }
        catch (VisitorException ve) {
            TestLogToPhyCompiler.assertTrue((ve.getErrorCode() == 2051 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrSort() throws VisitorException, IOException {
        String query = "order (load 'a') by $0 desc;";
        LogicalPlan plan = this.buildPlan(query);
        plan.remove((Operator)plan.getRoots().get(0));
        try {
            this.buildPhysicalPlan(plan);
            TestLogToPhyCompiler.fail((String)"Expected error.");
        }
        catch (VisitorException ve) {
            TestLogToPhyCompiler.assertTrue((ve.getErrorCode() == 2051 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrNull() throws VisitorException, IOException {
        String query = "filter (load 'a') by $0 is null;";
        LogicalPlan plan = this.buildPlan(query);
        LOFilter filter = (LOFilter)plan.getLeaves().get(0);
        LogicalPlan innerPlan = filter.getComparisonPlan();
        innerPlan.remove((Operator)innerPlan.getRoots().get(0));
        try {
            this.buildPhysicalPlan(plan);
            TestLogToPhyCompiler.fail((String)"Expected error.");
        }
        catch (VisitorException ve) {
            TestLogToPhyCompiler.assertTrue((ve.getErrorCode() == 2051 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSortInfoAsc() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'bla' as (i:int, n:chararray, d:double);");
        lpt.buildPlan("b = order a by i, d;");
        LogicalPlan lp = lpt.buildPlan("store b into 'foo';");
        PigServer.SortInfoSetter siSetter = new PigServer.SortInfoSetter(lp);
        siSetter.visit();
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        SortInfo si = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        SortInfo expected = this.getSortInfo(Arrays.asList("i", "d"), Arrays.asList(0, 2), Arrays.asList(SortColInfo.Order.ASCENDING, SortColInfo.Order.ASCENDING));
        TestLogToPhyCompiler.assertEquals((Object)expected, (Object)si);
    }

    @Test
    public void testSortInfoAscDesc() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'bla' as (i:int, n:chararray, d:double);");
        lpt.buildPlan("b = filter a by i > 10;");
        lpt.buildPlan("c = order b by i desc, d;");
        LogicalPlan lp = lpt.buildPlan("store c into 'foo';");
        PigServer.SortInfoSetter siSetter = new PigServer.SortInfoSetter(lp);
        siSetter.visit();
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        SortInfo si = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        SortInfo expected = this.getSortInfo(Arrays.asList("i", "d"), Arrays.asList(0, 2), Arrays.asList(SortColInfo.Order.DESCENDING, SortColInfo.Order.ASCENDING));
        TestLogToPhyCompiler.assertEquals((Object)expected, (Object)si);
    }

    @Test
    public void testSortInfoNoOrderBy1() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'bla' as (i:int, n:chararray, d:double);");
        lpt.buildPlan("b = filter a by i > 10;");
        LogicalPlan lp = lpt.buildPlan("store b into 'foo';");
        PigServer.SortInfoSetter siSetter = new PigServer.SortInfoSetter(lp);
        siSetter.visit();
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        SortInfo si = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        TestLogToPhyCompiler.assertEquals(null, (Object)si);
    }

    @Test
    public void testSortInfoNoOrderBy2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'bla' as (i:int, n:chararray, d:double);");
        lpt.buildPlan("b = order a by i, d;");
        lpt.buildPlan("c = filter b by i > 10;");
        LogicalPlan lp = lpt.buildPlan("store c into 'foo';");
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        PigServer.SortInfoSetter siSetter = new PigServer.SortInfoSetter(lp);
        siSetter.visit();
        SortInfo si = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        TestLogToPhyCompiler.assertEquals(null, (Object)si);
    }

    @Test
    public void testSortInfoOrderByLimit() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'bla' as (i:int, n:chararray, d:double);");
        lpt.buildPlan("b = order a by i, d desc;");
        lpt.buildPlan("c = limit b 10;");
        LogicalPlan lp = lpt.buildPlan("store c into 'foo';");
        PigServer.SortInfoSetter siSetter = new PigServer.SortInfoSetter(lp);
        siSetter.visit();
        LOPrinter lpr = new LOPrinter(System.err, lp);
        lpr.visit();
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        SortInfo si = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        SortInfo expected = this.getSortInfo(Arrays.asList("i", "d"), Arrays.asList(0, 2), Arrays.asList(SortColInfo.Order.ASCENDING, SortColInfo.Order.DESCENDING));
        TestLogToPhyCompiler.assertEquals((Object)expected, (Object)si);
    }

    @Test
    public void testSortInfoMultipleStore() throws Exception {
        PigServer myPig = new PigServer(ExecType.MAPREDUCE);
        myPig.setBatchOn();
        myPig.registerQuery("a = load 'bla' as (i:int, n:chararray, d:double);");
        myPig.registerQuery("b = order a by i, d desc;");
        myPig.registerQuery("store b into '1';");
        myPig.registerQuery("store b into '2';");
        Method compileLp = myPig.getClass().getDeclaredMethod("compileLp", String.class);
        compileLp.setAccessible(true);
        LogicalPlan lp = (LogicalPlan)compileLp.invoke((Object)myPig, new Object[]{null});
        LOPrinter lpr = new LOPrinter(System.err, lp);
        lpr.visit();
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        SortInfo si0 = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        SortInfo si1 = ((POStore)pp.getLeaves().get(1)).getSortInfo();
        SortInfo expected = this.getSortInfo(Arrays.asList("i", "d"), Arrays.asList(0, 2), Arrays.asList(SortColInfo.Order.ASCENDING, SortColInfo.Order.DESCENDING));
        TestLogToPhyCompiler.assertEquals((Object)expected, (Object)si0);
        TestLogToPhyCompiler.assertEquals((Object)expected, (Object)si1);
    }

    @Test
    public void testSortInfoNoOrderBySchema() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'bla' ;");
        lpt.buildPlan("b = order a by $0;");
        LogicalPlan lp = lpt.buildPlan("store b into 'foo';");
        PigServer.SortInfoSetter siSetter = new PigServer.SortInfoSetter(lp);
        siSetter.visit();
        PhysicalPlan pp = this.buildPhysicalPlan(lp);
        SortInfo si = ((POStore)pp.getLeaves().get(0)).getSortInfo();
        SortInfo expected = this.getSortInfo(Arrays.asList(new String[]{null}), Arrays.asList(0), Arrays.asList(SortColInfo.Order.ASCENDING));
        TestLogToPhyCompiler.assertEquals((Object)expected, (Object)si);
    }

    private SortInfo getSortInfo(List<String> colNames, List<Integer> colIndices, List<SortColInfo.Order> orderingTypes) {
        ArrayList<SortColInfo> sortColInfoList = new ArrayList<SortColInfo>();
        for (int i = 0; i < colNames.size(); ++i) {
            sortColInfoList.add(new SortColInfo(colNames.get(i), colIndices.get(i).intValue(), orderingTypes.get(i)));
        }
        return new SortInfo(sortColInfoList);
    }

    public PhysicalPlan buildPhysicalPlan(LogicalPlan lp) throws VisitorException {
        LogToPhyTranslationVisitor visitor = new LogToPhyTranslationVisitor(lp);
        visitor.setPigContext(this.pc);
        visitor.visit();
        return visitor.getPhysicalPlan();
    }

    public LogicalPlan buildPlan(String query) {
        return this.buildPlan(query, LogicalPlanBuilder.class.getClassLoader());
    }

    public LogicalPlan buildPlan(String query, ClassLoader cldr) {
        LogicalPlanBuilder.classloader = cldr;
        PigContext pigContext = new PigContext(ExecType.LOCAL, new Properties());
        try {
            pigContext.connect();
            LogicalPlanBuilder builder = new LogicalPlanBuilder(pigContext);
            LogicalPlan lp = builder.parse("Test-Plan-Builder", query, this.aliases, this.logicalOpTable, this.aliasOp, this.fileNameMap);
            List roots = lp.getRoots();
            if (roots.size() > 0) {
                for (LogicalOperator op : roots) {
                    if (op instanceof LOLoad || op instanceof LODefine) continue;
                    throw new Exception("Cannot have a root that is not the load or define operator. Found " + op.getClass().getName());
                }
            }
            System.err.println("Query: " + query);
            for (LogicalOperator op : lp.getRoots()) {
                System.err.println("Logical Plan Root: " + op.getClass().getName() + " object " + op);
                List listOp = lp.getSuccessors((Operator)op);
                if (null == listOp) continue;
                for (LogicalOperator lop : listOp) {
                    System.err.println("Successor: " + lop.getClass().getName() + " object " + lop);
                }
            }
            TestLogToPhyCompiler.assertTrue((lp != null ? 1 : 0) != 0);
            return lp;
        }
        catch (IOException e) {
            TestLogToPhyCompiler.fail((String)("IOException: " + e.getMessage()));
        }
        catch (Exception e) {
            this.log.error((Object)e);
            TestLogToPhyCompiler.fail((String)(e.getClass().getName() + ": " + e.getMessage() + " -- " + query));
        }
        return null;
    }
}

