/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.ExecType;
import org.apache.pig.Expression;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.impl.logicalLayer.LOPrinter;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.PlanSetter;
import org.apache.pig.impl.logicalLayer.optimizer.ImplicitSplitInserter;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalOptimizer;
import org.apache.pig.impl.logicalLayer.optimizer.OpLimitOptimizer;
import org.apache.pig.impl.logicalLayer.optimizer.TypeCastInserter;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.test.OpLimitOptimizerPrinter;
import org.apache.pig.test.utils.LogicalPlanTester;
import org.junit.Test;

public class TestLogicalOptimizer
extends TestCase {
    final String FILE_BASE_LOCATION = "test/org/apache/pig/test/data/DotFiles/";
    static final int MAX_SIZE = 100000;
    LogicalPlanTester planTester = new LogicalPlanTester();

    public static String printLimitGraph(LogicalPlan plan) {
        OpLimitOptimizerPrinter printer = new OpLimitOptimizerPrinter(plan);
        String rep = "digraph graph1 {\n";
        rep = rep + printer.printToString();
        rep = rep + "}";
        return rep;
    }

    public static int optimizePlan(LogicalPlan plan) throws Exception {
        LogicalOptimizer optimizer = new LogicalOptimizer(plan);
        return optimizer.optimize();
    }

    public static void optimizePlan(LogicalPlan plan, ExecType mode) throws OptimizerException {
        LogicalOptimizer optimizer = new LogicalOptimizer(plan, mode);
        optimizer.optimize();
    }

    void compareWithGoldenFile(LogicalPlan plan, String filename) throws Exception {
        FileInputStream fis = new FileInputStream(filename);
        byte[] b = new byte[100000];
        int len = fis.read(b);
        String goldenPlan = new String(b, 0, len);
        String actualPlan = TestLogicalOptimizer.printLimitGraph(plan);
        System.out.println("We get:");
        System.out.println(actualPlan);
        TestLogicalOptimizer.assertEquals((String)goldenPlan, (String)(actualPlan + "\n"));
    }

    @Test
    public void testTypeCastInsertion() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' as (p:int, q:long, r:float, s:double, t:map [], u:tuple (x:int, y:int), v:bag {x:tuple(z:int)});");
        LogicalPlan plan = this.planTester.buildPlan("B = order A by p;");
        this.planTester.typeCheckAgainstDotFile(plan, "test/org/apache/pig/test/data/DotFiles/optplan1.dot", true);
    }

    @Test
    public void testOPLimit1Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile';");
        this.planTester.buildPlan("B = order A by $0;");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan1.dot");
    }

    @Test
    public void testOPLimit2Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile';");
        this.planTester.buildPlan("B = limit A 10;");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan2.dot");
    }

    @Test
    public void testOPLimit3Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile1';");
        this.planTester.buildPlan("B = load 'myfile2';");
        this.planTester.buildPlan("C = cross A, B;");
        LogicalPlan plan = this.planTester.buildPlan("D = limit C 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan3.dot");
    }

    @Test
    public void testOPLimit4Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile1';");
        this.planTester.buildPlan("B = group A by $0;");
        this.planTester.buildPlan("C = foreach B generate flatten(A);");
        LogicalPlan plan = this.planTester.buildPlan("D = limit C 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan4.dot");
    }

    @Test
    public void testOPLimit5Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile1';");
        this.planTester.buildPlan("B = foreach A generate $0;");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan5.dot");
    }

    @Test
    public void testOPLimit6Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile';");
        this.planTester.buildPlan("B = limit A 50;");
        this.planTester.buildPlan("C = limit B 20;");
        LogicalPlan plan = this.planTester.buildPlan("D = limit C 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan6.dot");
    }

    @Test
    public void testOPLimit7Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile1';");
        this.planTester.buildPlan("B = foreach A generate flatten($0);");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 100;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan7.dot");
    }

    @Test
    public void testOPLimit8Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile';");
        this.planTester.buildPlan("B = order A by $0;");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 10;");
        TestLogicalOptimizer.optimizePlan(plan, ExecType.LOCAL);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan8.dot");
    }

    @Test
    public void testOPLimit9Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile';");
        this.planTester.buildPlan("B = order A by $0;");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 10;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan9.dot");
    }

    @Test
    public void testOPLimit10Optimizer() throws Exception {
        this.planTester.buildPlan("A = load 'myfile' AS (s:chararray);");
        this.planTester.buildPlan("B = limit A 100;");
        LogicalPlan plan = this.planTester.buildPlan("C = GROUP B by $0;");
        TestLogicalOptimizer.optimizePlan(plan);
        this.compareWithGoldenFile(plan, "test/org/apache/pig/test/data/DotFiles/optlimitplan10.dot");
    }

    @Test
    public void testOpLimitOptimizerCheck() throws Exception {
        this.planTester.buildPlan("A = load 'myfile';");
        this.planTester.buildPlan("B = foreach A generate $0;");
        LogicalPlan plan = this.planTester.buildPlan("C = limit B 100;");
        LogicalOptimizerDerivative optimizer = new LogicalOptimizerDerivative(plan);
        int numIterations = optimizer.optimize();
        TestLogicalOptimizer.assertFalse((String)("Checking number of iterations of the optimizer [actual = " + numIterations + ", expected < " + optimizer.getMaxIterations() + "]"), (optimizer.getMaxIterations() == numIterations ? 1 : 0) != 0);
    }

    @Test
    public void testErrImplicitSplitInserter() throws Exception {
        LogicalPlan lp = new LogicalPlan();
        ImplicitSplitInserter isi = new ImplicitSplitInserter(lp);
        try {
            isi.transform(lp.getRoots());
        }
        catch (Exception e) {
            TestLogicalOptimizer.assertTrue((((OptimizerException)e).getErrorCode() == 2052 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrTypeCastInserter() throws Exception {
        LogicalPlan lp = new LogicalPlan();
        TypeCastInserter tci = new TypeCastInserter(lp, "hello");
        try {
            tci.transform(lp.getRoots());
        }
        catch (Exception e) {
            TestLogicalOptimizer.assertTrue((((OptimizerException)e).getErrorCode() == 2052 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testErrOpLimitOptimizer() throws Exception {
        LogicalPlan lp = new LogicalPlan();
        OpLimitOptimizer olo = new OpLimitOptimizer(lp);
        try {
            olo.transform(lp.getRoots());
        }
        catch (Exception e) {
            TestLogicalOptimizer.assertTrue((((OptimizerException)e).getErrorCode() == 2052 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOPLimit11Optimizer() throws Exception {
        LogicalPlan plan = this.planTester.buildPlan("B = foreach (limit (order (load 'myfile' AS (a0, a1, a2)) by $1) 10) generate $0;");
        TestLogicalOptimizer.optimizePlan(plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadGetSchemaCalledOnce() throws Exception {
        String checkFileName = "checkLoadGetSchemaCalledOnce.txt";
        new File(checkFileName).delete();
        try {
            this.planTester.buildPlan("A = load 'myfile' using " + DummyMetadataLoader.class.getName() + "('" + checkFileName + "');");
            this.planTester.buildPlan("B = foreach A generate $0 ;");
            LogicalPlan plan = this.planTester.buildPlan("C = limit B 10;");
            new LOPrinter(System.err, plan).visit();
            PlanSetter ps = new PlanSetter(plan);
            ps.visit();
            LogicalOptimizerDerivative optimizer = new LogicalOptimizerDerivative(plan);
            int numIterations = optimizer.optimize();
            TestLogicalOptimizer.assertTrue((numIterations > 0 ? 1 : 0) != 0);
            TestLogicalOptimizer.assertTrue((boolean)new File(checkFileName).exists());
        }
        finally {
            new File(checkFileName).delete();
        }
    }

    public static class DummyMetadataLoader
    extends BinStorage
    implements LoadMetadata {
        String checkFileName;

        public DummyMetadataLoader() {
        }

        public DummyMetadataLoader(String checkFileName) {
            this.checkFileName = checkFileName;
        }

        public String[] getPartitionKeys(String location, Job job) throws IOException {
            return null;
        }

        public ResourceSchema getSchema(String location, Job job) throws IOException {
            try {
                if (!new File(this.checkFileName).createNewFile()) {
                    throw new RuntimeException(this.checkFileName + " already exists!");
                }
                return new ResourceSchema(Utils.getSchemaFromString((String)"a:chararray,b:int"));
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }

        public ResourceStatistics getStatistics(String location, Job job) throws IOException {
            return null;
        }

        public void setPartitionFilter(Expression partitionFilter) throws IOException {
        }
    }

    static class LogicalOptimizerDerivative
    extends LogicalOptimizer {
        public LogicalOptimizerDerivative(LogicalPlan plan) {
            super(plan);
        }

        public int getMaxIterations() {
            return this.mMaxIterations;
        }
    }
}

