/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.pig.FuncSpec;
import org.apache.pig.experimental.logical.LogicalPlanMigrationVistor;
import org.apache.pig.experimental.logical.expression.AndExpression;
import org.apache.pig.experimental.logical.expression.CastExpression;
import org.apache.pig.experimental.logical.expression.ConstantExpression;
import org.apache.pig.experimental.logical.expression.EqualExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpression;
import org.apache.pig.experimental.logical.expression.LogicalExpressionPlan;
import org.apache.pig.experimental.logical.expression.ProjectExpression;
import org.apache.pig.experimental.logical.optimizer.UidStamper;
import org.apache.pig.experimental.logical.relational.LOCogroup;
import org.apache.pig.experimental.logical.relational.LOFilter;
import org.apache.pig.experimental.logical.relational.LOForEach;
import org.apache.pig.experimental.logical.relational.LOGenerate;
import org.apache.pig.experimental.logical.relational.LOInnerLoad;
import org.apache.pig.experimental.logical.relational.LOJoin;
import org.apache.pig.experimental.logical.relational.LOLoad;
import org.apache.pig.experimental.logical.relational.LOStore;
import org.apache.pig.experimental.logical.relational.LogicalPlan;
import org.apache.pig.experimental.logical.relational.LogicalRelationalOperator;
import org.apache.pig.experimental.logical.relational.LogicalSchema;
import org.apache.pig.experimental.plan.Operator;
import org.apache.pig.experimental.plan.OperatorPlan;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.test.utils.LogicalPlanTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLogicalPlanMigrationVisitor
extends TestCase {
    public void testSimplePlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt';");
        lpt.buildPlan("b = filter a by $0==NULL;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        TestLogicalPlanMigrationVisitor.assertEquals((int)3, (int)newPlan.size());
        TestLogicalPlanMigrationVisitor.assertEquals((int)newPlan.getSources().size(), (int)1);
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSources().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOLoad.class);
        op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOFilter.class);
        LogicalExpressionPlan exp = ((LOFilter)op).getFilterPlan();
        EqualExpression eq = (EqualExpression)exp.getSources().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getLhs().getClass(), ProjectExpression.class);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)eq.getLhs()).getColNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)eq.getLhs()).getInputNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getRhs().getClass(), ConstantExpression.class);
        op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOStore.class);
    }

    public void testPlanWithCast() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd.txt' as (id, c);");
        lpt.buildPlan("b = filter a by (int)id==10;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into 'empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        TestLogicalPlanMigrationVisitor.assertEquals((int)3, (int)newPlan.size());
        TestLogicalPlanMigrationVisitor.assertEquals((int)newPlan.getSources().size(), (int)1);
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSources().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOLoad.class);
        op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOFilter.class);
        LogicalExpressionPlan exp = ((LOFilter)op).getFilterPlan();
        EqualExpression eq = (EqualExpression)exp.getSources().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getLhs().getClass(), CastExpression.class);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getLhs().getClass(), CastExpression.class);
        LogicalExpression ep = (LogicalExpression)exp.getSuccessors((Operator)eq.getLhs()).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(ep.getClass(), ProjectExpression.class);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)ep).getColNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)ep).getInputNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getRhs().getClass(), ConstantExpression.class);
        op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOStore.class);
    }

    public void testJoinPlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load 'd1.txt' as (id, c);");
        lpt.buildPlan("b = load 'd2.txt'as (id, c);");
        lpt.buildPlan("c = join a by id, b by c;");
        lpt.buildPlan("d = filter c by a::id==NULL AND b::c==NULL;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store d into 'empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        TestLogicalPlanMigrationVisitor.assertEquals((int)5, (int)newPlan.size());
        TestLogicalPlanMigrationVisitor.assertEquals((int)newPlan.getSources().size(), (int)2);
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOJoin.class);
        TestLogicalPlanMigrationVisitor.assertEquals((Object)((LOJoin)op).getJoinType(), (Object)LOJoin.JOINTYPE.HASH);
        LogicalRelationalOperator l1 = (LogicalRelationalOperator)newPlan.getPredecessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(l1.getClass(), LOLoad.class);
        TestLogicalPlanMigrationVisitor.assertEquals((String)l1.getAlias(), (String)"a");
        LogicalRelationalOperator l2 = (LogicalRelationalOperator)newPlan.getPredecessors((Operator)op).get(1);
        TestLogicalPlanMigrationVisitor.assertEquals(l2.getClass(), LOLoad.class);
        TestLogicalPlanMigrationVisitor.assertEquals((String)l2.getAlias(), (String)"b");
        LogicalExpressionPlan p1 = (LogicalExpressionPlan)((LOJoin)op).getJoinPlan(0).iterator().next();
        TestLogicalPlanMigrationVisitor.assertEquals((int)p1.size(), (int)1);
        ProjectExpression prj = (ProjectExpression)p1.getSources().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)prj.getInputNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)prj.getColNum(), (int)0);
        LogicalExpressionPlan p2 = (LogicalExpressionPlan)((LOJoin)op).getJoinPlan(1).iterator().next();
        TestLogicalPlanMigrationVisitor.assertEquals((int)p2.size(), (int)1);
        prj = (ProjectExpression)p2.getSources().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)prj.getInputNum(), (int)1);
        TestLogicalPlanMigrationVisitor.assertEquals((int)prj.getColNum(), (int)1);
        op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOFilter.class);
        LogicalExpressionPlan exp = ((LOFilter)op).getFilterPlan();
        AndExpression ae = (AndExpression)exp.getSources().get(0);
        EqualExpression eq = (EqualExpression)exp.getSuccessors((Operator)ae).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getLhs().getClass(), ProjectExpression.class);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)eq.getLhs()).getColNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)eq.getLhs()).getInputNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getRhs().getClass(), ConstantExpression.class);
        eq = (EqualExpression)exp.getSuccessors((Operator)ae).get(1);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getLhs().getClass(), ProjectExpression.class);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)eq.getLhs()).getColNum(), (int)3);
        TestLogicalPlanMigrationVisitor.assertEquals((int)((ProjectExpression)eq.getLhs()).getInputNum(), (int)0);
        TestLogicalPlanMigrationVisitor.assertEquals(eq.getRhs().getClass(), ConstantExpression.class);
        op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)op).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(op.getClass(), LOStore.class);
    }

    public void testForeachPlan() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (id, d);");
        lpt.buildPlan("b = foreach a generate id, FLATTEN(d);");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into '/test/empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        LogicalPlan expected = new LogicalPlan();
        LogicalSchema aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("d", null, 50));
        LOLoad load = new LOLoad(new FileSpec("file:///test/d.txt", new FuncSpec("org.apache.pig.builtin.PigStorage")), aschema, expected);
        expected.add((Operator)load);
        LOForEach foreach = new LOForEach((OperatorPlan)expected);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad l1 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 0);
        innerPlan.add((Operator)l1);
        LOInnerLoad l2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach, 1);
        ArrayList<LogicalExpressionPlan> eps = new ArrayList<LogicalExpressionPlan>();
        LogicalExpressionPlan p1 = new LogicalExpressionPlan();
        p1.add((Operator)new ProjectExpression((OperatorPlan)p1, 50, 0, 0));
        LogicalExpressionPlan p2 = new LogicalExpressionPlan();
        p2.add((Operator)new ProjectExpression((OperatorPlan)p2, 50, 1, 0));
        eps.add(p1);
        eps.add(p2);
        LOGenerate gen = new LOGenerate((OperatorPlan)innerPlan, eps, new boolean[]{false, true});
        innerPlan.add((Operator)gen);
        innerPlan.connect((Operator)l1, (Operator)gen);
        innerPlan.connect((Operator)l2, (Operator)gen);
        foreach.setInnerPlan(innerPlan);
        expected.add((Operator)foreach);
        LOStore s = new LOStore(expected, new FileSpec("file:///test/empty", new FuncSpec("org.apache.pig.builtin.PigStorage")));
        expected.add((Operator)s);
        expected.connect((Operator)load, (Operator)foreach);
        expected.connect((Operator)foreach, (Operator)s);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)expected);
            stamper.visit();
        }
        catch (Exception e) {
            throw new VisitorException((Throwable)e);
        }
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)expected.isEqual((OperatorPlan)newPlan));
        LogicalSchema schema = foreach.getSchema();
        aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("d", null, 50));
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)schema.isEqual((Object)aschema));
    }

    public void testForeachSchema() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (id, d:tuple(v, s));");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("b = foreach a generate id, FLATTEN(d);");
        LogicalPlan newPlan = this.migratePlan(plan);
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSinks().get(0);
        LogicalSchema s2 = new LogicalSchema();
        s2.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        s2.addField(new LogicalSchema.LogicalFieldSchema("v", null, 50));
        s2.addField(new LogicalSchema.LogicalFieldSchema("s", null, 50));
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)s2.isEqual((Object)op.getSchema()));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (id, d:bag{t:(v, s)});");
        plan = lpt.buildPlan("b = foreach a generate id, d;");
        newPlan = this.migratePlan(plan);
        op = (LogicalRelationalOperator)newPlan.getSinks().get(0);
        LogicalSchema aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        LogicalSchema aschema2 = new LogicalSchema();
        LogicalSchema aschema3 = new LogicalSchema();
        aschema3.addField(new LogicalSchema.LogicalFieldSchema("v", null, 50));
        aschema3.addField(new LogicalSchema.LogicalFieldSchema("s", null, 50));
        aschema2.addField(new LogicalSchema.LogicalFieldSchema("t", aschema3, 110));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("d", aschema2, 120));
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)aschema.isEqual((Object)op.getSchema()));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (id, d:bag{t:(v:int, s)});");
        lpt.buildPlan("b = foreach a generate id, FLATTEN(d);");
        plan = lpt.buildPlan("store b into '/test/empty';");
        newPlan = this.migratePlan(plan);
        op = (LogicalRelationalOperator)newPlan.getSinks().get(0);
        op = (LogicalRelationalOperator)newPlan.getPredecessors((Operator)op).get(0);
        LogicalSchema schema = op.getSchema();
        aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("v", null, 10));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("s", null, 50));
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)schema.isEqual((Object)aschema));
        lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (id, v:int, s:int);");
        lpt.buildPlan("b = foreach a generate id, v+s;");
        plan = lpt.buildPlan("store b into '/test/empty';");
        newPlan = this.migratePlan(plan);
        op = (LogicalRelationalOperator)newPlan.getSinks().get(0);
        op = (LogicalRelationalOperator)newPlan.getPredecessors((Operator)op).get(0);
        schema = op.getSchema();
        aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        aschema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 10));
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)schema.isEqual((Object)aschema));
    }

    public void testForeachPlan2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (id, d:bag{t:(id:int, s)});");
        lpt.buildPlan("b = foreach a generate id, FLATTEN(d);");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into '/test/empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        LogicalPlan expected = new LogicalPlan();
        LogicalSchema aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        LogicalSchema aschema2 = new LogicalSchema();
        LogicalSchema aschema3 = new LogicalSchema();
        aschema3.addField(new LogicalSchema.LogicalFieldSchema("id", null, 10));
        aschema3.addField(new LogicalSchema.LogicalFieldSchema("s", null, 50));
        aschema2.addField(new LogicalSchema.LogicalFieldSchema("t", aschema3, 110));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("d", aschema2, 120));
        LOLoad load = new LOLoad(new FileSpec("file:///test/d.txt", new FuncSpec("org.apache.pig.builtin.PigStorage")), aschema, expected);
        expected.add((Operator)load);
        LOForEach foreach2 = new LOForEach((OperatorPlan)expected);
        LogicalPlan innerPlan = new LogicalPlan();
        LOInnerLoad l1 = new LOInnerLoad((OperatorPlan)innerPlan, foreach2, 0);
        innerPlan.add((Operator)l1);
        LOInnerLoad l2 = new LOInnerLoad((OperatorPlan)innerPlan, foreach2, 1);
        ArrayList<LogicalExpressionPlan> eps = new ArrayList<LogicalExpressionPlan>();
        LogicalExpressionPlan p1 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)p1, 50, 0, 0);
        LogicalExpressionPlan p2 = new LogicalExpressionPlan();
        new ProjectExpression((OperatorPlan)p2, 120, 1, 0);
        eps.add(p1);
        eps.add(p2);
        LOGenerate gen = new LOGenerate((OperatorPlan)innerPlan, eps, new boolean[]{false, true});
        innerPlan.add((Operator)gen);
        innerPlan.connect((Operator)l1, (Operator)gen);
        innerPlan.connect((Operator)l2, (Operator)gen);
        foreach2.setInnerPlan(innerPlan);
        expected.add((Operator)foreach2);
        LOStore s = new LOStore(expected, new FileSpec("file:///test/empty", new FuncSpec("org.apache.pig.builtin.PigStorage")));
        expected.add((Operator)s);
        expected.connect((Operator)load, (Operator)foreach2);
        expected.connect((Operator)foreach2, (Operator)s);
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)expected);
            stamper.visit();
        }
        catch (Exception e) {
            throw new VisitorException((Throwable)e);
        }
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)expected.isEqual((OperatorPlan)newPlan));
        LogicalSchema schema = foreach2.getSchema();
        aschema = new LogicalSchema();
        aschema.addField(new LogicalSchema.LogicalFieldSchema("id", null, 50));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("d::id", null, 10));
        aschema.addField(new LogicalSchema.LogicalFieldSchema("s", null, 50));
        TestLogicalPlanMigrationVisitor.assertTrue((boolean)schema.isEqual((Object)aschema));
        TestLogicalPlanMigrationVisitor.assertTrue((schema.getField("id") == schema.getField(0) ? 1 : 0) != 0);
        TestLogicalPlanMigrationVisitor.assertTrue((schema.getField("d::id") == schema.getField(1) ? 1 : 0) != 0);
    }

    public void testCoGroup() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = group a by name;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into '/test/empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        LogicalSchema loadSchema = ((LogicalRelationalOperator)newPlan.getSources().get(0)).getSchema();
        Set<Long> uids = this.getAllUids(loadSchema);
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, op.getClass());
        LogicalSchema schema = op.getSchema();
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)schema.size());
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).uid));
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)0).alias.compareTo("group"));
        TestLogicalPlanMigrationVisitor.assertEquals((byte)120, (byte)schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)1).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)schema.getField((int)1).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)1).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)1).alias.compareTo("age"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)1).uid, (long)schema.getField((int)1).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)20, (byte)schema.getField((int)1).schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)2).alias.compareTo("gpa"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)2).uid, (long)schema.getField((int)1).schema.getField((int)2).uid);
        uids.add(schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)1).uid));
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, ((Operator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0)).getClass());
        LOCogroup cogroup = (LOCogroup)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        MultiMap expressionPlans = cogroup.getExpressionPlans();
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)expressionPlans.size());
        List plans = (List)expressionPlans.get((Object)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)plans.size());
        LogicalExpressionPlan exprPlan = (LogicalExpressionPlan)plans.get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan.getSinks().get(0)).getClass());
        ProjectExpression prj = (ProjectExpression)exprPlan.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)prj.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getInputNum());
    }

    public void testCoGroup2() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = group a by ( name, age );");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store b into '/test/empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        LogicalSchema loadSchema = ((LogicalRelationalOperator)newPlan.getSources().get(0)).getSchema();
        Set<Long> uids = this.getAllUids(loadSchema);
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, op.getClass());
        LogicalSchema schema = op.getSchema();
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)schema.size());
        TestLogicalPlanMigrationVisitor.assertEquals((byte)110, (byte)schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).uid));
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)0).alias.compareTo("group"));
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)0).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)0).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)120, (byte)schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)1).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)schema.getField((int)1).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)1).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)1).alias.compareTo("age"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)1).uid, (long)schema.getField((int)1).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)20, (byte)schema.getField((int)1).schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)2).alias.compareTo("gpa"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)2).uid, (long)schema.getField((int)1).schema.getField((int)2).uid);
        uids.add(schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).schema.getField((int)0).uid));
        uids.add(schema.getField((int)0).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).schema.getField((int)1).uid));
        uids.add(schema.getField((int)0).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)1).uid));
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, ((Operator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0)).getClass());
        LOCogroup cogroup = (LOCogroup)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        MultiMap expressionPlans = cogroup.getExpressionPlans();
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)expressionPlans.size());
        List plans = (List)expressionPlans.get((Object)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)plans.size());
        LogicalExpressionPlan exprPlan = (LogicalExpressionPlan)plans.get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan.getSinks().get(0)).getClass());
        ProjectExpression prj = (ProjectExpression)exprPlan.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)prj.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getInputNum());
        LogicalExpressionPlan exprPlan2 = (LogicalExpressionPlan)plans.get(1);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan2.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan2.getSinks().get(0)).getClass());
        ProjectExpression prj2 = (ProjectExpression)exprPlan2.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)1).uid, (long)prj2.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)prj2.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj2.getInputNum());
    }

    public void testCoGroup3() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = load '/test/e.txt' as (name:chararray, blah:chararray );");
        lpt.buildPlan("c = group a by name, b by name;");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into '/test/empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, ((Operator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0)).getClass());
        LOCogroup cogroup = (LOCogroup)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        LogicalSchema loadSchema = ((LogicalRelationalOperator)newPlan.getPredecessors((Operator)cogroup).get(0)).getSchema();
        LogicalSchema load2Schema = ((LogicalRelationalOperator)newPlan.getPredecessors((Operator)cogroup).get(1)).getSchema();
        Set<Long> uids = this.getAllUids(loadSchema);
        uids.addAll(this.getAllUids(load2Schema));
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, op.getClass());
        LogicalSchema schema = op.getSchema();
        TestLogicalPlanMigrationVisitor.assertEquals((int)3, (int)schema.size());
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).uid));
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)0).alias.compareTo("group"));
        TestLogicalPlanMigrationVisitor.assertEquals((byte)120, (byte)schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)1).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)schema.getField((int)1).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)1).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)1).alias.compareTo("age"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)1).uid, (long)schema.getField((int)1).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)20, (byte)schema.getField((int)1).schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)2).alias.compareTo("gpa"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)2).uid, (long)schema.getField((int)1).schema.getField((int)2).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)120, (byte)schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)2).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)2).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)0).uid, (long)schema.getField((int)2).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)2).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)2).schema.getField((int)1).alias.compareTo("blah"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)1).uid, (long)schema.getField((int)2).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)1).uid));
        uids.add(schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)2).uid));
        MultiMap expressionPlans = cogroup.getExpressionPlans();
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)expressionPlans.size());
        List plans = (List)expressionPlans.get((Object)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)plans.size());
        List plans2 = (List)expressionPlans.get((Object)1);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)plans2.size());
        LogicalExpressionPlan exprPlan = (LogicalExpressionPlan)plans.get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan.getSinks().get(0)).getClass());
        ProjectExpression prj = (ProjectExpression)exprPlan.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)prj.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getInputNum());
        LogicalExpressionPlan exprPlan2 = (LogicalExpressionPlan)plans2.get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan2.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan2.getSinks().get(0)).getClass());
        ProjectExpression prj2 = (ProjectExpression)exprPlan2.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)0).uid, (long)prj2.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj2.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)prj2.getInputNum());
    }

    public void testCoGroup4() throws Exception {
        LogicalPlanTester lpt = new LogicalPlanTester();
        lpt.buildPlan("a = load '/test/d.txt' as (name:chararray, age:int, gpa:float);");
        lpt.buildPlan("b = load '/test/e.txt' as (name:chararray, age:int, blah:chararray );");
        lpt.buildPlan("c = group a by ( name, age ), b by ( name, age );");
        org.apache.pig.impl.logicalLayer.LogicalPlan plan = lpt.buildPlan("store c into '/test/empty';");
        LogicalPlan newPlan = this.migratePlan(plan);
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, ((Operator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0)).getClass());
        LOCogroup cogroup = (LOCogroup)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        LogicalSchema loadSchema = ((LogicalRelationalOperator)newPlan.getPredecessors((Operator)cogroup).get(0)).getSchema();
        LogicalSchema load2Schema = ((LogicalRelationalOperator)newPlan.getPredecessors((Operator)cogroup).get(1)).getSchema();
        Set<Long> uids = this.getAllUids(loadSchema);
        uids.addAll(this.getAllUids(load2Schema));
        LogicalRelationalOperator op = (LogicalRelationalOperator)newPlan.getSuccessors((Operator)newPlan.getSources().get(0)).get(0);
        TestLogicalPlanMigrationVisitor.assertEquals(LOCogroup.class, op.getClass());
        LogicalSchema schema = op.getSchema();
        TestLogicalPlanMigrationVisitor.assertEquals((int)3, (int)schema.size());
        TestLogicalPlanMigrationVisitor.assertEquals((byte)110, (byte)schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).uid));
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)0).alias.compareTo("group"));
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)0).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)0).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)0).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)0).schema.getField((int)1).alias.compareTo("age"));
        TestLogicalPlanMigrationVisitor.assertEquals((byte)120, (byte)schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)1).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)schema.getField((int)1).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)1).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)1).alias.compareTo("age"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)1).uid, (long)schema.getField((int)1).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)20, (byte)schema.getField((int)1).schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)1).schema.getField((int)2).alias.compareTo("gpa"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)2).uid, (long)schema.getField((int)1).schema.getField((int)2).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)120, (byte)schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)2).schema.getField((int)0).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)2).schema.getField((int)0).alias.compareTo("name"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)0).uid, (long)schema.getField((int)2).schema.getField((int)0).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)10, (byte)schema.getField((int)2).schema.getField((int)1).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)2).schema.getField((int)1).alias.compareTo("age"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)1).uid, (long)schema.getField((int)2).schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((byte)55, (byte)schema.getField((int)2).schema.getField((int)2).type);
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)schema.getField((int)2).schema.getField((int)2).alias.compareTo("blah"));
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)2).uid, (long)schema.getField((int)2).schema.getField((int)2).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).schema.getField((int)0).uid));
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)0).schema.getField((int)1).uid));
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)1).uid));
        uids.add(schema.getField((int)1).uid);
        TestLogicalPlanMigrationVisitor.assertEquals((boolean)false, (boolean)uids.contains(schema.getField((int)2).uid));
        MultiMap expressionPlans = cogroup.getExpressionPlans();
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)expressionPlans.size());
        List plans = (List)expressionPlans.get((Object)0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)plans.size());
        List plans2 = (List)expressionPlans.get((Object)1);
        TestLogicalPlanMigrationVisitor.assertEquals((int)2, (int)plans2.size());
        LogicalExpressionPlan exprPlan = (LogicalExpressionPlan)plans.get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan.getSinks().get(0)).getClass());
        ProjectExpression prj = (ProjectExpression)exprPlan.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)0).uid, (long)prj.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj.getInputNum());
        LogicalExpressionPlan exprPlan2 = (LogicalExpressionPlan)plans.get(1);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan2.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan2.getSinks().get(0)).getClass());
        ProjectExpression prj2 = (ProjectExpression)exprPlan2.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)loadSchema.getField((int)1).uid, (long)prj2.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)prj2.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj2.getInputNum());
        LogicalExpressionPlan exprPlan3 = (LogicalExpressionPlan)plans2.get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan3.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan3.getSinks().get(0)).getClass());
        ProjectExpression prj3 = (ProjectExpression)exprPlan3.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)0).uid, (long)prj3.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)0, (int)prj3.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)prj3.getInputNum());
        LogicalExpressionPlan exprPlan4 = (LogicalExpressionPlan)plans2.get(1);
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)exprPlan4.getSinks().size());
        TestLogicalPlanMigrationVisitor.assertEquals(ProjectExpression.class, ((Operator)exprPlan4.getSinks().get(0)).getClass());
        ProjectExpression prj4 = (ProjectExpression)exprPlan4.getSinks().get(0);
        TestLogicalPlanMigrationVisitor.assertEquals((long)load2Schema.getField((int)1).uid, (long)prj4.getUid());
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)prj4.getColNum());
        TestLogicalPlanMigrationVisitor.assertEquals((int)1, (int)prj4.getInputNum());
    }

    private Set<Long> getAllUids(LogicalSchema schema) {
        HashSet<Long> uids = new HashSet<Long>();
        if (schema != null) {
            for (LogicalSchema.LogicalFieldSchema fieldSchema : schema.getFields()) {
                if ((fieldSchema.type == 120 || fieldSchema.type == 110) && fieldSchema.schema != null) {
                    uids.addAll(this.getAllUids(fieldSchema.schema));
                    continue;
                }
                uids.add(fieldSchema.uid);
            }
        }
        return uids;
    }

    private LogicalPlan migratePlan(org.apache.pig.impl.logicalLayer.LogicalPlan lp) throws VisitorException {
        LogicalPlanMigrationVistor visitor = new LogicalPlanMigrationVistor(lp);
        visitor.visit();
        LogicalPlan newPlan = visitor.getNewLogicalPlan();
        try {
            UidStamper stamper = new UidStamper((OperatorPlan)newPlan);
            stamper.visit();
            return newPlan;
        }
        catch (Exception e) {
            throw new VisitorException((Throwable)e);
        }
    }
}

