/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMultiQueryLocal
extends TestCase {
    private PigServer myPig;

    @Before
    public void setUp() throws Exception {
        PigContext context = new PigContext(ExecType.LOCAL, new Properties());
        context.getProperties().setProperty("opt.multiquery", "true");
        this.myPig = new PigServer(context);
        this.deleteOutputFiles();
    }

    @After
    public void tearDown() throws Exception {
        this.myPig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithTwoStores() {
        System.out.println("===== test multi-query with 2 stores =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.registerQuery("store b into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("c = group b by gid;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal2';");
            LogicalPlan lp = this.checkLogicalPlan(1, 2, 9);
            PhysicalPlan pp = this.checkPhysicalPlan(lp, 1, 2, 11);
            Assert.assertTrue((boolean)this.executePlan(pp));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    @Test
    public void testEmptyExecute() {
        System.out.println("=== test empty execute ===");
        try {
            this.myPig.setBatchOn();
            this.myPig.executeBatch();
            this.myPig.executeBatch();
            this.myPig.discardBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithTwoStores2() {
        System.out.println("===== test multi-query with 2 stores (2) =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.registerQuery("store b into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("c = group b by gid;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.executeBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithTwoStores2Execs() {
        System.out.println("===== test multi-query with 2 stores (2) =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.executeBatch();
            this.myPig.registerQuery("store b into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.executeBatch();
            this.myPig.registerQuery("c = group b by gid;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.executeBatch();
            this.myPig.discardBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithThreeStores() {
        System.out.println("===== test multi-query with 3 stores =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.registerQuery("store b into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("c = filter b by uid > 10;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.registerQuery("d = filter c by uid > 15;");
            this.myPig.registerQuery("store d into '/tmp/Pig-TestMultiQueryLocal3';");
            LogicalPlan lp = this.checkLogicalPlan(1, 3, 14);
            PhysicalPlan pp = this.checkPhysicalPlan(lp, 1, 3, 14);
            Assert.assertTrue((boolean)this.executePlan(pp));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithThreeStores2() {
        System.out.println("===== test multi-query with 3 stores (2) =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.registerQuery("store b into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("c = filter b by uid > 10;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.registerQuery("d = filter c by uid > 15;");
            this.myPig.registerQuery("store d into '/tmp/Pig-TestMultiQueryLocal3';");
            this.myPig.executeBatch();
            this.myPig.discardBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithTwoLoads() {
        System.out.println("===== test multi-query with two loads =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = load 'test/org/apache/pig/test/data/passwd2' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("c = filter a by uid > 5;");
            this.myPig.registerQuery("d = filter b by uid > 10;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("store d into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.registerQuery("e = cogroup c by uid, d by uid;");
            this.myPig.registerQuery("store e into '/tmp/Pig-TestMultiQueryLocal3';");
            LogicalPlan lp = this.checkLogicalPlan(2, 3, 16);
            PhysicalPlan pp = this.checkPhysicalPlan(lp, 2, 3, 19);
            Assert.assertTrue((boolean)this.executePlan(pp));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithTwoLoads2() {
        System.out.println("===== test multi-query with two loads (2) =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = load 'test/org/apache/pig/test/data/passwd2' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("c = filter a by uid > 5;");
            this.myPig.registerQuery("d = filter b by uid > 10;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("store d into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.registerQuery("e = cogroup c by uid, d by uid;");
            this.myPig.registerQuery("store e into '/tmp/Pig-TestMultiQueryLocal3';");
            this.myPig.executeBatch();
            this.myPig.discardBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    @Test
    public void testMultiQueryWithNoStore() {
        System.out.println("===== test multi-query with no store =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.registerQuery("group b by gid;");
            LogicalPlan lp = this.checkLogicalPlan(0, 0, 0);
            PhysicalPlan physicalPlan = this.checkPhysicalPlan(lp, 0, 0, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testMultiQueryWithNoStore2() {
        System.out.println("===== test multi-query with no store (2) =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);");
            this.myPig.registerQuery("b = filter a by uid > 5;");
            this.myPig.registerQuery("group b by gid;");
            this.myPig.executeBatch();
            this.myPig.discardBatch();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithExplain() {
        System.out.println("===== test multi-query with explain =====");
        try {
            String script = "a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);b = filter a by uid > 5;explain b;store b into '/tmp/Pig-TestMultiQueryLocal1';\n";
            GruntParser parser = new GruntParser((Reader)new StringReader(script));
            parser.setInteractive(false);
            parser.setParams(this.myPig);
            parser.parseStopOnError();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithDump() {
        System.out.println("===== test multi-query with dump =====");
        try {
            String script = "a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);b = filter a by uid > 5;dump b;store b into '/tmp/Pig-TestMultiQueryLocal1';\n";
            GruntParser parser = new GruntParser((Reader)new StringReader(script));
            parser.setInteractive(false);
            parser.setParams(this.myPig);
            parser.parseStopOnError();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithDescribe() {
        System.out.println("===== test multi-query with describe =====");
        try {
            String script = "a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);b = filter a by uid > 5;describe b;store b into '/tmp/Pig-TestMultiQueryLocal1';\n";
            GruntParser parser = new GruntParser((Reader)new StringReader(script));
            parser.setInteractive(false);
            parser.setParams(this.myPig);
            parser.parseStopOnError();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQueryWithIllustrate() {
        System.out.println("===== test multi-query with illustrate =====");
        try {
            String script = "a = load 'test/org/apache/pig/test/data/passwd' using PigStorage(':') as (uname:chararray, passwd:chararray, uid:int,gid:int);b = filter a by uid > 5;illustrate b;store b into '/tmp/Pig-TestMultiQueryLocal1';\n";
            GruntParser parser = new GruntParser((Reader)new StringReader(script));
            parser.setInteractive(false);
            parser.setParams(this.myPig);
            parser.parseStopOnError();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreOrder() {
        System.out.println("===== multi-query store order =====");
        try {
            this.myPig.setBatchOn();
            this.myPig.registerQuery("a = load 'test/org/apache/pig/test/data/passwd';");
            this.myPig.registerQuery("store a into '/tmp/Pig-TestMultiQueryLocal1' using BinStorage();");
            this.myPig.registerQuery("a = load '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("store a into '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.registerQuery("a = load '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("store a into '/tmp/Pig-TestMultiQueryLocal3';");
            this.myPig.registerQuery("a = load '/tmp/Pig-TestMultiQueryLocal2' using BinStorage();");
            this.myPig.registerQuery("store a into '/tmp/Pig-TestMultiQueryLocal4';");
            this.myPig.registerQuery("a = load '/tmp/Pig-TestMultiQueryLocal2';");
            this.myPig.registerQuery("b = load '/tmp/Pig-TestMultiQueryLocal1';");
            this.myPig.registerQuery("c = cogroup a by $0, b by $0;");
            this.myPig.registerQuery("store c into '/tmp/Pig-TestMultiQueryLocal5';");
            LogicalPlan lp = this.checkLogicalPlan(1, 3, 12);
            PhysicalPlan pp = this.checkPhysicalPlan(lp, 1, 3, 15);
            this.myPig.executeBatch();
            this.myPig.discardBatch();
            Assert.assertTrue((boolean)new File("/tmp/Pig-TestMultiQueryLocal1").exists());
            Assert.assertTrue((boolean)new File("/tmp/Pig-TestMultiQueryLocal2").exists());
            Assert.assertTrue((boolean)new File("/tmp/Pig-TestMultiQueryLocal3").exists());
            Assert.assertTrue((boolean)new File("/tmp/Pig-TestMultiQueryLocal4").exists());
            Assert.assertTrue((boolean)new File("/tmp/Pig-TestMultiQueryLocal5").exists());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            this.deleteOutputFiles();
        }
    }

    private <T extends OperatorPlan<? extends Operator<?>>> void showPlanOperators(T p) {
        System.out.println("Operators:");
        ArrayList ops = new ArrayList(p.getKeys().values());
        Collections.sort(ops);
        for (Operator op : ops) {
            System.out.println("    op: " + op.name());
        }
        System.out.println();
    }

    private LogicalPlan checkLogicalPlan(int expectedRoots, int expectedLeaves, int expectedSize) throws IOException, ParseException {
        System.out.println("===== check logical plan =====");
        LogicalPlan lp = null;
        try {
            Method compileLp = this.myPig.getClass().getDeclaredMethod("compileLp", String.class);
            compileLp.setAccessible(true);
            lp = (LogicalPlan)compileLp.invoke((Object)this.myPig, new Object[]{null});
            Assert.assertNotNull((Object)lp);
        }
        catch (Exception e) {
            PigException pe = LogUtils.getPigException((Throwable)e);
            if (pe != null) {
                throw pe;
            }
            e.printStackTrace();
            Assert.fail();
        }
        Assert.assertEquals((int)expectedRoots, (int)lp.getRoots().size());
        Assert.assertEquals((int)expectedLeaves, (int)lp.getLeaves().size());
        Assert.assertEquals((int)expectedSize, (int)lp.size());
        this.showPlanOperators(lp);
        return lp;
    }

    private PhysicalPlan checkPhysicalPlan(LogicalPlan lp, int expectedRoots, int expectedLeaves, int expectedSize) throws IOException {
        System.out.println("===== check physical plan =====");
        PhysicalPlan pp = this.myPig.getPigContext().getExecutionEngine().compile(lp, null);
        Assert.assertEquals((int)expectedRoots, (int)pp.getRoots().size());
        Assert.assertEquals((int)expectedLeaves, (int)pp.getLeaves().size());
        Assert.assertEquals((int)expectedSize, (int)pp.size());
        this.showPlanOperators(pp);
        return pp;
    }

    private boolean executePlan(PhysicalPlan pp) throws IOException {
        boolean failed = true;
        FileLocalizer.clearDeleteOnFail();
        List jobs = this.myPig.getPigContext().getExecutionEngine().execute(pp, "execute");
        for (ExecJob job : jobs) {
            failed = job.getStatus() == ExecJob.JOB_STATUS.FAILED;
            if (!failed) continue;
            FileLocalizer.triggerDeleteOnFail();
            break;
        }
        return !failed;
    }

    private void deleteOutputFiles() {
        String[] outputFiles = new String[]{"/tmp/Pig-TestMultiQueryLocal1", "/tmp/Pig-TestMultiQueryLocal2", "/tmp/Pig-TestMultiQueryLocal3", "/tmp/Pig-TestMultiQueryLocal4", "/tmp/Pig-TestMultiQueryLocal5"};
        try {
            for (String outputFile : outputFiles) {
                if (this.isDirectory(outputFile)) {
                    this.deleteDir(new File(outputFile));
                    continue;
                }
                FileLocalizer.delete((String)outputFile, (PigContext)this.myPig.getPigContext());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void deleteDir(File file) {
        if (file.isDirectory() && file.listFiles().length != 0) {
            for (File innerFile : file.listFiles()) {
                this.deleteDir(innerFile);
            }
        }
        file.delete();
    }

    private boolean isDirectory(String filepath) {
        File file = new File(filepath);
        return file.isDirectory();
    }
}

