/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Before;
import org.junit.Test;

public class TestNullConstant
extends TestCase {
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pigServer;

    @Before
    public void setUp() throws Exception {
        this.pigServer = new PigServer(ExecType.MAPREDUCE, this.cluster.getProperties());
    }

    @Test
    public void testArithExpressions() throws IOException, ExecException {
        String inputFileName = "testArithExpressions-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double);");
        this.pigServer.registerQuery("b = foreach a generate x + null, x * null, x / null, x - null, null % x, y + null, y * null, y / null, y - null;");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        for (int i = 0; i < 9; ++i) {
            TestNullConstant.assertEquals(null, (Object)t.get(i));
        }
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testBinCond() throws IOException, ExecException {
        int i;
        String inputFileName = "testBinCond-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double);");
        this.pigServer.registerQuery("b = foreach a generate (2 > 1? null : 1), ( 2 < 1 ? null : 1), (2 > 1 ? 1 : null), ( 2 < 1 ? 1 : null);");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        Object[] result = new Object[]{null, 1, 1, null};
        for (i = 0; i < 4; ++i) {
            TestNullConstant.assertEquals((Object)result[i], (Object)t.get(i));
        }
        this.pigServer.registerQuery("b = foreach a generate (null is null ? 1 : 2), ( null is not null ? 2 : 1);");
        it = this.pigServer.openIterator("b");
        t = (Tuple)it.next();
        for (i = 0; i < 2; ++i) {
            TestNullConstant.assertEquals((Object)1, (Object)t.get(i));
        }
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testForeachGenerate() throws ExecException, IOException {
        String inputFileName = "testForeachGenerate-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double);");
        this.pigServer.registerQuery("b = foreach a generate x, null, y, null;");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        Object[] result = new Object[]{10, null, 11.0, null};
        for (int i = 0; i < 4; ++i) {
            TestNullConstant.assertEquals((Object)result[i], (Object)t.get(i));
        }
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testOuterJoin() throws IOException, ExecException {
        String inputFileName1 = "testOuterJoin-input1.txt";
        Util.createInputFile(this.cluster, inputFileName1, new String[]{"10\twill_join", "11\twill_not_join"});
        String inputFileName2 = "testOuterJoin-input2.txt";
        Util.createInputFile(this.cluster, inputFileName2, new String[]{"10\twill_join", "12\twill_not_join"});
        this.pigServer.registerQuery("a = load '" + inputFileName1 + "' as (x:int, y:chararray);");
        this.pigServer.registerQuery("b = load '" + inputFileName2 + "' as (u:int, v:chararray);");
        this.pigServer.registerQuery("c = cogroup a by x, b by u;");
        this.pigServer.registerQuery("d = foreach c generate flatten((SIZE(a) == 0 ? null : a)), flatten((SIZE(b) == 0 ? null : b));");
        Iterator it = this.pigServer.openIterator("d");
        Object[][] results = new Object[][]{{10, "will_join", 10, "will_join"}, {11, "will_not_join", null}, {null, 12, "will_not_join"}};
        int i = 0;
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            Object[] result = results[i++];
            TestNullConstant.assertEquals((int)result.length, (int)t.size());
            for (int j = 0; j < result.length; ++j) {
                TestNullConstant.assertEquals((Object)result[j], (Object)t.get(j));
            }
        }
        Util.deleteFile(this.cluster, inputFileName1);
        Util.deleteFile(this.cluster, inputFileName2);
    }

    @Test
    public void testConcatAndSize() throws IOException, ExecException {
        String inputFileName = "testConcatAndSize-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0\tstring"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double, str:chararray);");
        this.pigServer.registerQuery("b = foreach a generate SIZE(null), CONCAT(str, null), CONCAT(null, str);");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        for (int i = 0; i < 3; ++i) {
            TestNullConstant.assertEquals(null, (Object)t.get(i));
        }
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testExplicitCast() throws IOException, ExecException {
        String inputFileName = "testExplicitCast-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0\tstring"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double, str:chararray);");
        this.pigServer.registerQuery("b = foreach a generate (int)null, (double)null, (chararray)null, (map[])null;");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        for (int i = 0; i < 3; ++i) {
            TestNullConstant.assertEquals(null, (Object)t.get(i));
        }
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testComplexNullConstants() throws IOException, ExecException {
        String inputFileName = "testComplexNullConstants-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0\tstring"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double, str:chararray);");
        this.pigServer.registerQuery("b = foreach a generate {(null)}, ['2'#null];");
        Iterator it = this.pigServer.openIterator("b");
        Tuple t = (Tuple)it.next();
        TestNullConstant.assertEquals(null, (Object)((Tuple)((DataBag)t.get(0)).iterator().next()).get(0));
        TestNullConstant.assertEquals(null, ((Map)t.get(1)).get("2"));
        Util.deleteFile(this.cluster, inputFileName);
    }

    @Test
    public void testMapNullKeyFailure() throws IOException {
        String inputFileName = "testMapNullKeyFailure-input.txt";
        Util.createInputFile(this.cluster, inputFileName, new String[]{"10\t11.0\tstring"});
        this.pigServer.registerQuery("a = load '" + inputFileName + "' as (x:int, y:double, str:chararray);");
        boolean exceptionOccured = false;
        try {
            this.pigServer.registerQuery("b = foreach a generate [null#'2'];");
        }
        catch (Exception e) {
            exceptionOccured = true;
            String msg = e.getMessage();
            TestNullConstant.assertTrue((boolean)msg.contains("key in a map cannot be null"));
        }
        Util.deleteFile(this.cluster, inputFileName);
        if (!exceptionOccured) {
            TestNullConstant.fail();
        }
    }
}

