/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.utils.TestHelper;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOrderBy2
extends TestCase {
    private String initString = "mapreduce";
    MiniCluster cluster = MiniCluster.buildCluster();
    private PigServer pig = new PigServer(this.initString);

    @Test
    public void testTopLevelOrderBy_Col0_ASC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile1();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $0;", new int[]{0}, new boolean[]{false});
    }

    @Test
    public void testTopLevelOrderBy_Col0_DESC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile1();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $0 DESC ;", new int[]{0}, new boolean[]{true});
    }

    @Test
    public void testTopLeveleeOrderBy_Col1_ASC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile1();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $1 ASC ;", new int[]{1}, new boolean[]{false});
    }

    @Test
    public void testTopLeveleeOrderBy_Col1_DESC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile1();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $1 DESC ;", new int[]{1}, new boolean[]{true});
    }

    @Test
    public void testTopLeveleeOrderBy_Col0Col1_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile2();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $0, $1 ;", new int[]{0, 1}, new boolean[]{false, false});
    }

    @Test
    public void testTopLeveleeOrderBy_Col0Col1_DESC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile2();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $0 DESC, $1 DESC ;", new int[]{0, 1}, new boolean[]{true, true});
    }

    @Test
    public void testTopLeveleeOrderBy_Col1Col0_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile3();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $1, $0 ;", new int[]{1, 0}, new boolean[]{false, false});
    }

    @Test
    public void testTopLeveleeOrderBy_Col1Col0_DESC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile3();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $1 DESC, $0 DESC ;", new int[]{1, 0}, new boolean[]{true, true});
    }

    @Test
    public void testTopLeveleeOrderBy_Col1Col0_ASCDESC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile3();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY $1 ASC, $0 DESC ;", new int[]{1, 0}, new boolean[]{false, true});
    }

    @Test
    public void testTopLevelOrderBy_Star_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile3();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY * ; ", new int[]{0, 1}, new boolean[]{false, false});
    }

    @Test
    public void testTopLevelOrderBy_Star_DESC_NoUsing() throws Exception {
        File tmpFile = this.genDataSetFile3();
        this.runTest("myid = order (load 'file:" + tmpFile + "') BY * DESC ; ", new int[]{0, 1}, new boolean[]{true, true});
    }

    private void checkOrder(Iterator<Tuple> dataIter, int[] sortCols, boolean[] descFlags) throws ExecException {
        Assert.assertEquals((String)"checkOrder params have to be of the same size", (int)sortCols.length, (int)descFlags.length);
        ArrayList<String> error = new ArrayList<String>();
        Tuple lastTuple = null;
        while (dataIter.hasNext()) {
            Tuple current = dataIter.next();
            System.out.println(current.toString());
            if (lastTuple != null) {
                for (int i = 0; i < sortCols.length; ++i) {
                    int colIdx = sortCols[i];
                    int lastInt = DataType.toInteger((Object)lastTuple.get(colIdx));
                    int curInt = DataType.toInteger((Object)current.get(colIdx));
                    if (!descFlags[i]) {
                        if (curInt < lastInt) {
                            error.add("Not ASC");
                        }
                        if (curInt <= lastInt) continue;
                        break;
                    }
                    if (curInt > lastInt) {
                        error.add("Not DESC");
                    }
                    if (curInt < lastInt) break;
                }
            }
            lastTuple = current;
        }
        Assert.assertTrue((error.size() == 0 ? 1 : 0) != 0);
    }

    private void runTest(String query, int[] sortCols, boolean[] descFlags) throws Exception {
        System.out.println(query);
        this.pig.registerQuery(query);
        Iterator it = this.pig.openIterator("myid");
        this.checkOrder(it, sortCols, descFlags);
    }

    private File genDataSetFile1() throws IOException {
        int dataLength = 256;
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        for (int i = 0; i < dataLength; ++i) {
            data[i] = new String[2];
            data[i][0] = formatter.format(i);
            data[i][1] = formatter.format(dataLength - i - 1);
        }
        return TestHelper.createTempFile(data);
    }

    private File genDataSetFile2() throws IOException {
        int dataLength = 256;
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        for (int i = 0; i < dataLength; ++i) {
            data[i] = new String[2];
            data[i][0] = formatter.format(i % 20);
            data[i][1] = formatter.format(dataLength - i - 1);
        }
        return TestHelper.createTempFile(data);
    }

    private File genDataSetFile3() throws IOException {
        int dataLength = 256;
        String[][] data = new String[dataLength][];
        DecimalFormat formatter = new DecimalFormat("0000000");
        for (int i = 0; i < dataLength; ++i) {
            data[i] = new String[2];
            data[i][0] = formatter.format(i);
            data[i][1] = formatter.format(i % 20);
        }
        return TestHelper.createTempFile(data);
    }
}

