/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.test.utils.GenPhyOp;
import org.junit.Before;

public class TestPOBinCond
extends TestCase {
    Random r = new Random();
    DataBag bag = BagFactory.getInstance().newDefaultBag();
    DataBag bagDefault = BagFactory.getInstance().newDefaultBag();
    DataBag bagWithNull = BagFactory.getInstance().newDefaultBag();
    DataBag bagWithBoolean = BagFactory.getInstance().newDefaultBag();
    DataBag bagWithBooleanAndNull = BagFactory.getInstance().newDefaultBag();
    final int MAX = 10;

    @Before
    public void setUp() {
        Tuple t;
        int i;
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple();
            t.append((Object)this.r.nextInt(2));
            t.append((Object)1);
            t.append((Object)0);
            this.bagDefault.add(t);
        }
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple();
            if (this.r.nextInt(4) % 3 == 0) {
                t.append(null);
            } else {
                t.append((Object)this.r.nextInt(2));
            }
            t.append((Object)1);
            t.append((Object)0);
            this.bagWithNull.add(t);
        }
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple();
            if (this.r.nextInt(2) % 2 == 0) {
                t.append((Object)true);
            } else {
                t.append((Object)false);
            }
            t.append((Object)1);
            t.append((Object)0);
            this.bagWithBoolean.add(t);
        }
        for (i = 0; i < 10; ++i) {
            t = TupleFactory.getInstance().newTuple();
            if (this.r.nextInt(3) % 2 == 0) {
                t.append(null);
            } else if (this.r.nextInt(2) % 2 == 0) {
                t.append((Object)true);
            } else {
                t.append((Object)false);
            }
            t.append((Object)1);
            t.append((Object)0);
            this.bagWithBooleanAndNull.add(t);
        }
    }

    public void testPOBinCondWithInteger() throws ExecException, PlanException {
        this.bag = this.getBag((byte)10);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(10, new Integer(1));
        for (Tuple t : this.bag) {
            testHelper.getPlan().attachInput(t);
            Integer value = (Integer)t.get(0);
            int expected = value == 1 ? 1 : 0;
            Integer result = (Integer)testHelper.getOperator().getNext((Integer)value).result;
            int actual = result;
            TestPOBinCond.assertEquals((int)expected, (int)actual);
        }
    }

    public void testPOBinCondWithLong() throws ExecException, PlanException {
        this.bag = this.getBag((byte)15);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(15, new Long(1L));
        for (Tuple t : this.bag) {
            testHelper.getPlan().attachInput(t);
            Long value = (Long)t.get(0);
            int expected = value == 1L ? 1 : 0;
            Integer dummy = new Integer(0);
            Integer result = (Integer)testHelper.getOperator().getNext((Integer)dummy).result;
            int actual = result;
            TestPOBinCond.assertEquals((int)expected, (int)actual);
        }
    }

    public void testPOBinCondWithFloat() throws ExecException, PlanException {
        this.bag = this.getBag((byte)20);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(20, new Float(1.0f));
        for (Tuple t : this.bag) {
            testHelper.getPlan().attachInput(t);
            Float value = (Float)t.get(0);
            int expected = value.floatValue() == 1.0f ? 1 : 0;
            Integer dummy = new Integer(0);
            Integer result = (Integer)testHelper.getOperator().getNext((Integer)dummy).result;
            int actual = result;
            TestPOBinCond.assertEquals((int)expected, (int)actual);
        }
    }

    public void testPOBinCondWithDouble() throws ExecException, PlanException {
        this.bag = this.getBag((byte)25);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(25, new Double(1.0));
        for (Tuple t : this.bag) {
            testHelper.getPlan().attachInput(t);
            Double value = (Double)t.get(0);
            int expected = value == 1.0 ? 1 : 0;
            Integer dummy = new Integer(0);
            Integer result = (Integer)testHelper.getOperator().getNext((Integer)dummy).result;
            int actual = result;
            TestPOBinCond.assertEquals((int)expected, (int)actual);
        }
    }

    public void testPOBinCondIntWithNull() throws ExecException, PlanException {
        this.bag = this.getBagWithNulls((byte)10);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(10, new Integer(1));
        for (Tuple t : this.bag) {
            Integer result;
            testHelper.getPlan().attachInput(t);
            Integer value = null;
            if (t.get(0) != null) {
                value = (Integer)t.get(0);
                result = (Integer)testHelper.getOperator().getNext((Integer)value).result;
            } else {
                result = (Integer)testHelper.getOperator().getNext((Integer)((Integer)null)).result;
            }
            if (value != null) {
                int expected = value == 1 ? 1 : 0;
                int actual = result;
                TestPOBinCond.assertEquals((int)expected, (int)actual);
                continue;
            }
            TestPOBinCond.assertEquals(null, (Object)result);
        }
    }

    public void testPOBinCondLongWithNull() throws ExecException, PlanException {
        this.bag = this.getBagWithNulls((byte)15);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(15, new Long(1L));
        for (Tuple t : this.bag) {
            testHelper.getPlan().attachInput(t);
            Long value = null;
            if (t.get(0) != null) {
                value = (Long)t.get(0);
            }
            Integer dummy = new Integer(0);
            Integer result = (Integer)testHelper.getOperator().getNext((Integer)dummy).result;
            if (value != null) {
                int expected = value.intValue() == 1 ? 1 : 0;
                int actual = result;
                TestPOBinCond.assertEquals((int)expected, (int)actual);
                continue;
            }
            TestPOBinCond.assertEquals(null, (Object)result);
        }
    }

    public void testPOBinCondDoubleWithNull() throws ExecException, PlanException {
        this.bag = this.getBagWithNulls((byte)25);
        TestPoBinCondHelper testHelper = new TestPoBinCondHelper(25, new Double(1.0));
        for (Tuple t : this.bag) {
            testHelper.getPlan().attachInput(t);
            Double value = null;
            if (t.get(0) != null) {
                value = (Double)t.get(0);
            }
            Integer dummy = new Integer(0);
            Integer result = (Integer)testHelper.getOperator().getNext((Integer)dummy).result;
            if (value != null) {
                int expected = value.intValue() == 1 ? 1 : 0;
                int actual = result;
                TestPOBinCond.assertEquals((int)expected, (int)actual);
                continue;
            }
            TestPOBinCond.assertEquals(null, (Object)result);
        }
    }

    private DataBag getBag(byte type) {
        DataBag bag = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            switch (type) {
                case 10: {
                    t.append((Object)this.r.nextInt(2));
                    break;
                }
                case 15: {
                    t.append((Object)(this.r.nextLong() % 2L));
                    break;
                }
                case 20: {
                    t.append((Object)Float.valueOf(i % 2 == 0 ? 1.0f : 0.0f));
                    break;
                }
                case 25: {
                    t.append((Object)(i % 2 == 0 ? 1.0 : 0.0));
                }
            }
            t.append((Object)1);
            t.append((Object)0);
            bag.add(t);
        }
        return bag;
    }

    private DataBag getBagWithNulls(byte type) {
        DataBag bag = DefaultBagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            if (this.r.nextInt(4) % 3 == 0) {
                t.append(null);
            } else {
                switch (type) {
                    case 10: {
                        t.append((Object)this.r.nextInt(2));
                        break;
                    }
                    case 15: {
                        t.append((Object)(this.r.nextLong() % 2L));
                        break;
                    }
                    case 20: {
                        t.append((Object)Float.valueOf(i % 2 == 0 ? 1.0f : 0.0f));
                        break;
                    }
                    case 25: {
                        t.append((Object)(i % 2 == 0 ? 1.0 : 0.0));
                    }
                }
            }
            t.append((Object)1);
            t.append((Object)0);
            bag.add(t);
        }
        return bag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TestPoBinCondHelper {
        PhysicalPlan plan = null;
        POBinCond op = null;

        public <U> TestPoBinCondHelper(byte type, U value) throws ExecException, PlanException {
            ConstantExpression rt = GenPhyOp.exprConst();
            rt.setValue(value);
            rt.setResultType(type);
            POProject prj1 = GenPhyOp.exprProject();
            prj1.setColumn(0);
            prj1.setResultType(type);
            EqualToExpr equal = GenPhyOp.compEqualToExpr();
            equal.setLhs((ExpressionOperator)prj1);
            equal.setRhs((ExpressionOperator)rt);
            equal.setOperandType(type);
            POProject prjLhs = GenPhyOp.exprProject();
            prjLhs.setResultType((byte)10);
            prjLhs.setColumn(1);
            POProject prjRhs = GenPhyOp.exprProject();
            prjRhs.setResultType((byte)10);
            prjRhs.setColumn(2);
            this.op = new POBinCond(new OperatorKey("", TestPOBinCond.this.r.nextLong()), -1, (ExpressionOperator)equal, (ExpressionOperator)prjLhs, (ExpressionOperator)prjRhs);
            this.op.setResultType((byte)10);
            this.plan = new PhysicalPlan();
            this.plan.add((Operator)this.op);
            this.plan.add((Operator)prjLhs);
            this.plan.add((Operator)prjRhs);
            this.plan.add((Operator)equal);
            this.plan.connect((PhysicalOperator)equal, (PhysicalOperator)this.op);
            this.plan.connect((PhysicalOperator)prjLhs, (PhysicalOperator)this.op);
            this.plan.connect((PhysicalOperator)prjRhs, (PhysicalOperator)this.op);
            this.plan.add((Operator)prj1);
            this.plan.add((Operator)rt);
            this.plan.connect((PhysicalOperator)prj1, (PhysicalOperator)equal);
            this.plan.connect((PhysicalOperator)rt, (PhysicalOperator)equal);
        }

        public PhysicalPlan getPlan() {
            return this.plan;
        }

        public POBinCond getOperator() {
            return this.op;
        }
    }
}

