/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.builtin.BinStorage;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.BufferedPositionedInputStream;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.Test;

public class TestPOCast
extends TestCase {
    Random r = new Random();
    final int MAX = 10;
    Tuple dummyTuple = null;
    Map<Object, Object> dummyMap = null;
    DataBag dummyBag = null;

    @Test
    public void testIntegerToOther() throws IOException {
        Result res;
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            t.append((Object)this.r.nextInt());
            bag.add(t);
        }
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)10);
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        for (Tuple t : bag) {
            plan.attachInput(t);
            Integer i = (Integer)t.get(0);
            res = op.getNext(i);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)i, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(i);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Float f = Float.valueOf(((Integer)t.get(0)).floatValue());
            res = op.getNext(f);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)f, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(f);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)f, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Long l = ((Integer)t.get(0)).longValue();
            res = op.getNext(l);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)l, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(l);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)l, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Double d = ((Integer)t.get(0)).doubleValue();
            res = op.getNext(d);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)d, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(d);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)d, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            String str = ((Integer)t.get(0)).toString();
            res = op.getNext(str);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)str, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(str);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataByteArray dba = new DataByteArray(((Integer)t.get(0)).toString().getBytes());
            res = op.getNext(dba);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)dba, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(dba);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)dba, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Map map = null;
            res = op.getNext(map);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Result res2 = op.getNext(t);
            TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataBag b = null;
            res = op.getNext(b);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyMap);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyTuple);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyBag);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
    }

    @Test
    public void testLongToOther() throws IOException {
        Result res;
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            t.append((Object)this.r.nextLong());
            bag.add(t);
        }
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)15);
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        for (Tuple t : bag) {
            plan.attachInput(t);
            Integer i = ((Long)t.get(0)).intValue();
            res = op.getNext(i);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)i, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(i);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Float f = Float.valueOf(((Long)t.get(0)).floatValue());
            res = op.getNext(f);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)f, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(f);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)f, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Long l = (long)((Long)t.get(0));
            res = op.getNext(l);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)l, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(l);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)l, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Double d = ((Long)t.get(0)).doubleValue();
            res = op.getNext(d);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)d, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(d);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)d, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            String str = ((Long)t.get(0)).toString();
            res = op.getNext(str);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)str, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(str);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataByteArray dba = new DataByteArray(((Long)t.get(0)).toString().getBytes());
            res = op.getNext(dba);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)dba, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(dba);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)dba, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Map map = null;
            res = op.getNext(map);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Result res2 = op.getNext(t);
            TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataBag b = null;
            res = op.getNext(b);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyMap);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyTuple);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyBag);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
    }

    @Test
    public void testFloatToOther() throws IOException {
        Result res;
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            t.append((Object)Float.valueOf(this.r.nextFloat()));
            bag.add(t);
        }
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)20);
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        for (Tuple t : bag) {
            plan.attachInput(t);
            Integer i = ((Float)t.get(0)).intValue();
            res = op.getNext(i);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)i, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(i);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Float f = Float.valueOf(((Float)t.get(0)).floatValue());
            res = op.getNext(f);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)f, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(f);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)f, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Long l = ((Float)t.get(0)).longValue();
            res = op.getNext(l);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)l, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(l);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)l, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Double d = ((Float)t.get(0)).doubleValue();
            res = op.getNext(d);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)d, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(d);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)d, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            String str = ((Float)t.get(0)).toString();
            res = op.getNext(str);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)str, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(str);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataByteArray dba = new DataByteArray(((Float)t.get(0)).toString().getBytes());
            res = op.getNext(dba);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)dba, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(dba);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)dba, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            if (t.get(0) != null) continue;
            Float result = (Float)op.getNext((Float)((Float)null)).result;
            TestPOCast.assertEquals(null, (Object)result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Map map = null;
            res = op.getNext(map);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Result res2 = op.getNext(t);
            TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataBag b = null;
            res = op.getNext(b);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyMap);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyTuple);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyBag);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
    }

    @Test
    public void testDoubleToOther() throws IOException {
        Result res;
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            t.append((Object)this.r.nextDouble());
            bag.add(t);
        }
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)25);
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        for (Tuple t : bag) {
            plan.attachInput(t);
            Integer i = ((Double)t.get(0)).intValue();
            res = op.getNext(i);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)i, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(i);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Float f = Float.valueOf(((Double)t.get(0)).floatValue());
            res = op.getNext(f);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)f, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(f);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)f, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Long l = ((Double)t.get(0)).longValue();
            res = op.getNext(l);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)l, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(l);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)l, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Double d = (double)((Double)t.get(0));
            res = op.getNext(d);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)d, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(d);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)d, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            String str = ((Double)t.get(0)).toString();
            res = op.getNext(str);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)str, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(str);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataByteArray dba = new DataByteArray(((Double)t.get(0)).toString().getBytes());
            res = op.getNext(dba);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)dba, (Object)res.result);
            }
            planToTestBACasts.attachInput(t);
            res = opWithInputTypeAsBA.getNext(dba);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)dba, (Object)res.result);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Map map = null;
            res = op.getNext(map);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            Result res2 = op.getNext(t);
            TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        }
        for (Tuple t : bag) {
            plan.attachInput(t);
            DataBag b = null;
            res = op.getNext(b);
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyMap);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyTuple);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyBag);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
    }

    @Test
    public void testStringToOther() throws IOException {
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)55);
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t = tf.newTuple();
        t.append((Object)new Integer(this.r.nextInt()).toString());
        plan.attachInput(t);
        Number i = Integer.valueOf((String)t.get(0));
        Result res = op.getNext(i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new Float(this.r.nextFloat()).toString());
        plan.attachInput(t);
        i = Float.valueOf((String)t.get(0));
        res = op.getNext((Float)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext((Float)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new Long(this.r.nextLong()).toString());
        plan.attachInput(t);
        i = Long.valueOf((String)t.get(0));
        res = op.getNext((Long)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext((Long)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new Double(this.r.nextDouble()).toString());
        plan.attachInput(t);
        i = Double.valueOf((String)t.get(0));
        res = op.getNext((Double)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext((Double)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        plan.attachInput(t);
        String str = (String)t.get(0);
        res = op.getNext(str);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(str);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        plan.attachInput(t);
        DataByteArray dba = new DataByteArray(((String)t.get(0)).getBytes());
        res = op.getNext(dba);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)dba, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(dba);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)dba, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        plan.attachInput(t);
        Map map = null;
        res = op.getNext(map);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        plan.attachInput(t);
        Result res2 = op.getNext(t);
        TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        plan.attachInput(t);
        DataBag b = null;
        res = op.getNext(b);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyMap);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyTuple);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
        planToTestBACasts.attachInput(this.dummyTuple);
        try {
            opWithInputTypeAsBA.getNext(this.dummyBag);
        }
        catch (Exception e) {
            TestPOCast.assertEquals(ExecException.class, e.getClass());
        }
    }

    @Test
    public void testByteArrayToOther() throws IOException {
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)50);
        TupleFactory tf = TupleFactory.getInstance();
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        Tuple t = tf.newTuple();
        t.append((Object)new DataByteArray(new Integer(this.r.nextInt()).toString().getBytes()));
        plan.attachInput(t);
        Number i = Integer.valueOf(((DataByteArray)t.get(0)).toString());
        Result res = op.getNext(i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new DataByteArray(new Float(this.r.nextFloat()).toString().getBytes()));
        plan.attachInput(t);
        i = Float.valueOf(((DataByteArray)t.get(0)).toString());
        res = op.getNext((Float)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext((Float)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new DataByteArray(new Long(this.r.nextLong()).toString().getBytes()));
        plan.attachInput(t);
        i = Long.valueOf(((DataByteArray)t.get(0)).toString());
        res = op.getNext((Long)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext((Long)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new DataByteArray(new Double(this.r.nextDouble()).toString().getBytes()));
        plan.attachInput(t);
        i = Double.valueOf(((DataByteArray)t.get(0)).toString());
        res = op.getNext((Double)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext((Double)i);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)i, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new DataByteArray(GenRandomData.genRandString(this.r).getBytes()));
        plan.attachInput(t);
        String str = ((DataByteArray)t.get(0)).toString();
        res = op.getNext(str);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(str);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)str, (Object)res.result);
        }
        t = tf.newTuple();
        t.append((Object)new DataByteArray(GenRandomData.genRandString(this.r).getBytes()));
        plan.attachInput(t);
        DataByteArray dba = (DataByteArray)t.get(0);
        res = op.getNext(dba);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(dba);
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        }
        t = tf.newTuple();
        t.append((Object)new DataByteArray(GenRandomData.genRandString(this.r).getBytes()));
        plan.attachInput(t);
        Map map = null;
        res = op.getNext(map);
        TestPOCast.assertEquals((byte)0, (byte)res.returnStatus);
        TestPOCast.assertEquals(null, (Object)res.result);
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(map);
        TestPOCast.assertEquals((byte)0, (byte)res.returnStatus);
        TestPOCast.assertEquals(null, (Object)res.result);
        t = tf.newTuple();
        t.append((Object)new DataByteArray(GenRandomData.genRandString(this.r).getBytes()));
        plan.attachInput(t);
        Result res2 = op.getNext(t);
        TestPOCast.assertEquals((byte)0, (byte)res2.returnStatus);
        TestPOCast.assertEquals(null, (Object)res2.result);
        planToTestBACasts.attachInput(t);
        res2 = opWithInputTypeAsBA.getNext(t);
        TestPOCast.assertEquals((byte)0, (byte)res2.returnStatus);
        TestPOCast.assertEquals(null, (Object)res2.result);
        t = tf.newTuple();
        t.append((Object)new DataByteArray(GenRandomData.genRandString(this.r).getBytes()));
        plan.attachInput(t);
        DataBag b = null;
        res = op.getNext(b);
        TestPOCast.assertEquals((byte)0, (byte)res.returnStatus);
        TestPOCast.assertEquals(null, (Object)res.result);
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(b);
        TestPOCast.assertEquals((byte)0, (byte)res.returnStatus);
        TestPOCast.assertEquals(null, (Object)res.result);
    }

    private PhysicalPlan constructPlan(POCast op) throws IOException {
        TestLoader load = new TestLoader();
        op.setFuncSpec(new FuncSpec(((Object)((Object)load)).getClass().getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)50);
        return plan;
    }

    @Test
    public void testByteArrayToOtherNoCast() throws IOException {
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan plan = this.constructPlan(op);
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t = tf.newTuple();
        Integer input = new Integer(this.r.nextInt());
        t.append((Object)input);
        plan.attachInput(t);
        Result res = op.getNext(new Integer(0));
        if (res.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input, (Object)res.result);
        }
        POCast newOp = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        plan = this.constructPlan(newOp);
        Tuple t2 = tf.newTuple();
        Serializable input2 = new Float(this.r.nextFloat());
        t2.append((Object)input2);
        plan.attachInput(t2);
        Result res2 = newOp.getNext(new Float(0.0f));
        if (res2.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input2, (Object)res2.result);
        }
        newOp = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        plan = this.constructPlan(newOp);
        t2 = tf.newTuple();
        input2 = new Long(this.r.nextLong());
        t2.append((Object)input2);
        plan.attachInput(t2);
        res2 = newOp.getNext(new Long(0L));
        if (res2.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input2, (Object)res2.result);
        }
        newOp = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        plan = this.constructPlan(newOp);
        t2 = tf.newTuple();
        input2 = new Double(this.r.nextDouble());
        t2.append((Object)input2);
        plan.attachInput(t2);
        res2 = newOp.getNext(new Double(0.0));
        if (res2.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input2, (Object)res2.result);
        }
        newOp = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        plan = this.constructPlan(newOp);
        t2 = tf.newTuple();
        input2 = GenRandomData.genRandSmallTuple("test", (Integer)1);
        t2.append((Object)input2);
        plan.attachInput(t2);
        res2 = newOp.getNext(tf.newTuple());
        if (res2.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input2, (Object)res2.result);
        }
        newOp = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        plan = this.constructPlan(newOp);
        t2 = tf.newTuple();
        input2 = GenRandomData.genRandSmallTupDataBag(this.r, 10, 100);
        t2.append((Object)input2);
        plan.attachInput(t2);
        res2 = newOp.getNext(DefaultBagFactory.getInstance().newDefaultBag());
        if (res2.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input2, (Object)res2.result);
        }
        newOp = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        plan = this.constructPlan(newOp);
        t2 = tf.newTuple();
        input2 = new HashMap();
        input2.put("key1", "value1");
        input2.put("key2", "value2");
        t2.append((Object)input2);
        plan.attachInput(t2);
        res2 = newOp.getNext(new HashMap());
        if (res2.returnStatus == 0) {
            TestPOCast.assertEquals((Object)input2, (Object)res2.result);
        }
    }

    @Test
    public void testTupleToOther() throws IOException {
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        op.setFuncSpec(new FuncSpec(PigStorage.class.getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)110);
        TupleFactory tf = TupleFactory.getInstance();
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        Tuple t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        Tuple tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        Map map = null;
        Result res = op.getNext(map);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        Result res2 = op.getNext(t);
        TestPOCast.assertEquals((Object)t, (Object)res2.result);
        planToTestBACasts.attachInput(tNew);
        res2 = opWithInputTypeAsBA.getNext(t);
        TestPOCast.assertEquals((Object)t, (Object)res2.result);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        DataBag b = null;
        res = op.getNext(b);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        DataByteArray i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandString(this.r));
        tNew = tf.newTuple();
        tNew.append((Object)t);
        plan.attachInput(tNew);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        op.setFuncSpec(new FuncSpec(BinStorage.class.getName()));
        plan.attachInput(tNew);
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
    }

    @Test
    public void testBagToOther() throws IOException {
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        op.setFuncSpec(new FuncSpec(PigStorage.class.getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)120);
        TupleFactory tf = TupleFactory.getInstance();
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        Tuple t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        Map map = null;
        Result res = op.getNext(map);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        Result res2 = op.getNext(t);
        TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        DataBag b = (DataBag)t.get(0);
        res = op.getNext(b);
        TestPOCast.assertEquals((Object)b, (Object)res.result);
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(b);
        TestPOCast.assertEquals((Object)b, (Object)res.result);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        DataByteArray i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append((Object)GenRandomData.genRandSmallTupDataBag(this.r, 1, 100));
        plan.attachInput(t);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        op.setFuncSpec(new FuncSpec(BinStorage.class.getName()));
        plan.attachInput(t);
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
    }

    @Test
    public void testMapToOther() throws IOException {
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        op.setFuncSpec(new FuncSpec(PigStorage.class.getName()));
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)100);
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        TupleFactory tf = TupleFactory.getInstance();
        Tuple t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        plan.attachInput(t);
        Map map = (Map)t.get(0);
        Result res = op.getNext(map);
        TestPOCast.assertEquals((Object)map, (Object)res.result);
        planToTestBACasts.attachInput(t);
        res = opWithInputTypeAsBA.getNext(map);
        TestPOCast.assertEquals((Object)map, (Object)res.result);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        plan.attachInput(t);
        Result res2 = op.getNext(t);
        TestPOCast.assertEquals((byte)2, (byte)res2.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        plan.attachInput(t);
        DataBag b = null;
        res = op.getNext(b);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        DataByteArray i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        t = tf.newTuple();
        t.append(GenRandomData.genRandMap(this.r, 10));
        plan.attachInput(t);
        i = null;
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
        op.setFuncSpec(new FuncSpec(BinStorage.class.getName()));
        plan.attachInput(t);
        res = op.getNext(i);
        TestPOCast.assertEquals((byte)2, (byte)res.returnStatus);
    }

    @Test
    public void testNullToOther() throws PlanException, ExecException {
        Object result;
        Tuple t3;
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t2 = TupleFactory.getInstance().newTuple();
            t2.append((Object)this.r.nextInt());
            bag.add(t2);
            if (this.r.nextInt(3) % 3 != 0) continue;
            t2 = TupleFactory.getInstance().newTuple();
            t2.append(null);
            bag.add(t2);
        }
        POCast op = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        POProject prj = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        PhysicalPlan plan = new PhysicalPlan();
        plan.add((Operator)prj);
        plan.add((Operator)op);
        plan.connect((PhysicalOperator)prj, (PhysicalOperator)op);
        prj.setResultType((byte)10);
        for (Tuple t3 : bag) {
            plan.attachInput(t3);
            if (t3.get(0) != null) continue;
            result = (Integer)op.getNext((Integer)((Integer)null)).result;
            TestPOCast.assertEquals(null, (Object)result);
        }
        prj.setResultType((byte)20);
        for (Tuple t3 : bag) {
            plan.attachInput(t3);
            if (t3.get(0) != null) continue;
            result = (Integer)op.getNext((Integer)((Integer)null)).result;
            TestPOCast.assertEquals(null, (Object)result);
        }
        prj.setResultType((byte)25);
        for (Tuple t3 : bag) {
            plan.attachInput(t3);
            if (t3.get(0) != null) continue;
            result = (Double)op.getNext((Double)((Double)null)).result;
            TestPOCast.assertEquals(null, (Object)result);
        }
        prj.setResultType((byte)55);
        for (Tuple t3 : bag) {
            plan.attachInput(t3);
            if (t3.get(0) != null) continue;
            result = (String)op.getNext((String)((String)null)).result;
            TestPOCast.assertEquals(null, (String)result);
        }
        prj.setResultType((byte)50);
        TupleFactory tf = TupleFactory.getInstance();
        t3 = tf.newTuple();
        t3.append((Object)new DataByteArray(new Integer(this.r.nextInt()).toString().getBytes()));
        plan.attachInput(t3);
        if (t3.get(0) == null) {
            result = (DataByteArray)op.getNext((String)((String)null)).result;
            TestPOCast.assertEquals(null, (Object)result);
        }
    }

    @Test
    public void testValueTypesChanged() throws IOException {
        POCast opWithInputTypeAsBA = new POCast(new OperatorKey("", this.r.nextLong()), -1);
        PhysicalPlan planToTestBACasts = this.constructPlan(opWithInputTypeAsBA);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < 10; ++i) {
            Tuple t = TupleFactory.getInstance().newTuple();
            if (i % 4 == 0) {
                t.append((Object)this.r.nextInt());
            }
            if (i % 4 == 1) {
                t.append((Object)this.r.nextLong());
            }
            if (i % 4 == 2) {
                t.append((Object)this.r.nextDouble());
            }
            if (i % 4 == 3) {
                t.append((Object)Float.valueOf(this.r.nextFloat()));
            }
            bag.add(t);
        }
        for (Tuple t : bag) {
            planToTestBACasts.attachInput(t);
            Object toCast = t.get(0);
            Integer i = DataType.toInteger((Object)toCast);
            Result res = opWithInputTypeAsBA.getNext(i);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)i, (Object)res.result);
            }
            Long l = DataType.toLong((Object)toCast);
            res = opWithInputTypeAsBA.getNext(l);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)l, (Object)res.result);
            }
            Float f = DataType.toFloat((Object)toCast);
            res = opWithInputTypeAsBA.getNext(f);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)f, (Object)res.result);
            }
            Double d = DataType.toDouble((Object)toCast);
            res = opWithInputTypeAsBA.getNext(d);
            if (res.returnStatus == 0) {
                TestPOCast.assertEquals((Object)d, (Object)res.result);
            }
            String s = DataType.toString((Object)toCast);
            res = opWithInputTypeAsBA.getNext(s);
            if (res.returnStatus != 0) continue;
            TestPOCast.assertEquals((Object)s, (Object)res.result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestLoader
    extends LoadFunc
    implements LoadCaster {
        public void bindTo(String fileName, BufferedPositionedInputStream is, long offset, long end) throws IOException {
        }

        public Tuple getNext() throws IOException {
            return null;
        }

        public DataBag bytesToBag(byte[] b, ResourceSchema.ResourceFieldSchema s) throws IOException {
            return null;
        }

        public Boolean bytesToBoolean(byte[] b) throws IOException {
            DataByteArray dba = new DataByteArray(b);
            String str = dba.toString();
            if (str.length() == 0) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public String bytesToCharArray(byte[] b) throws IOException {
            DataByteArray dba = new DataByteArray(b);
            return dba.toString();
        }

        public Double bytesToDouble(byte[] b) throws IOException {
            return new Double(Double.valueOf(new DataByteArray(b).toString()));
        }

        public Float bytesToFloat(byte[] b) throws IOException {
            return new Float(Float.valueOf(new DataByteArray(b).toString()).floatValue());
        }

        public Integer bytesToInteger(byte[] b) throws IOException {
            return new Integer(Integer.valueOf(new DataByteArray(b).toString()));
        }

        public Long bytesToLong(byte[] b) throws IOException {
            return new Long(Long.valueOf(new DataByteArray(b).toString()));
        }

        public Map<String, Object> bytesToMap(byte[] b) throws IOException {
            return null;
        }

        public Tuple bytesToTuple(byte[] b, ResourceSchema.ResourceFieldSchema s) throws IOException {
            return null;
        }

        public byte[] toBytes(DataBag bag) throws IOException {
            return null;
        }

        public byte[] toBytes(String s) throws IOException {
            return s.getBytes();
        }

        public byte[] toBytes(Double d) throws IOException {
            return d.toString().getBytes();
        }

        public byte[] toBytes(Float f) throws IOException {
            return f.toString().getBytes();
        }

        public byte[] toBytes(Integer i) throws IOException {
            return i.toString().getBytes();
        }

        public byte[] toBytes(Long l) throws IOException {
            return l.toString().getBytes();
        }

        public byte[] toBytes(Map<String, Object> m) throws IOException {
            return null;
        }

        public byte[] toBytes(Tuple t) throws IOException {
            return null;
        }

        public InputFormat getInputFormat() throws IOException {
            return null;
        }

        public LoadCaster getLoadCaster() throws IOException {
            return this;
        }

        public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        }

        public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
            return null;
        }

        public void setLocation(String location, Job job) throws IOException {
        }
    }
}

