/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.LinkedList;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORead;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.pen.physicalOperators.POCross;
import org.junit.Before;
import org.junit.Test;

public class TestPOCross
extends TestCase {
    DataBag[] inputs = new DataBag[2];
    Random r = new Random();

    @Before
    public void setUp() {
        Tuple t = TupleFactory.getInstance().newTuple();
        t.append((Object)1);
        this.inputs[0] = BagFactory.getInstance().newDefaultBag();
        this.inputs[0].add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)2);
        this.inputs[0].add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)3);
        this.inputs[0].add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)5);
        this.inputs[1] = BagFactory.getInstance().newDefaultBag();
        this.inputs[1].add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)6);
        this.inputs[1].add(t);
    }

    @Test
    public void testCross() throws ExecException {
        PORead pr1 = new PORead(new OperatorKey("", this.r.nextLong()), this.inputs[0]);
        PORead pr2 = new PORead(new OperatorKey("", this.r.nextLong()), this.inputs[1]);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(pr1);
        inputs.add(pr2);
        DataBag expected = BagFactory.getInstance().newDefaultBag();
        Tuple t = TupleFactory.getInstance().newTuple();
        t.append((Object)1);
        t.append((Object)5);
        expected.add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)2);
        t.append((Object)5);
        expected.add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)3);
        t.append((Object)5);
        expected.add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)1);
        t.append((Object)6);
        expected.add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)2);
        t.append((Object)6);
        expected.add(t);
        t = TupleFactory.getInstance().newTuple();
        t.append((Object)3);
        t.append((Object)6);
        expected.add(t);
        POCross poc = new POCross(new OperatorKey("", this.r.nextLong()), inputs);
        DataBag obtained = BagFactory.getInstance().newDefaultBag();
        Result res = poc.getNext(t);
        while (res.returnStatus != 3) {
            if (res.returnStatus == 0) {
                obtained.add((Tuple)res.result);
            }
            System.out.println(res.result);
            res = poc.getNext(t);
        }
        TestPOCross.assertEquals((long)expected.size(), (long)obtained.size());
        TestPOCross.assertEquals((int)0, (int)DataType.compare((Object)expected, (Object)obtained));
    }
}

