/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORead;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.junit.Before;
import org.junit.Test;

public class TestPODistinct
extends TestCase {
    DataBag input = BagFactory.getInstance().newDefaultBag();
    Random r = new Random();
    final int MAX_VALUE = 10;
    final int MAX_SAMPLES = 100;

    @Before
    public void setUp() {
    }

    @Test
    public void testPODistictWithInt() throws ExecException {
        this.input = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (int i = 0; i < 100; ++i) {
            Tuple t = tf.newTuple();
            t.append((Object)this.r.nextInt(10));
            this.input.add(t);
        }
        this.confirmDistinct();
    }

    public void testPODistictWithNullValues() throws ExecException {
        this.input = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (int i = 0; i < 100; ++i) {
            Tuple t = tf.newTuple();
            t.append(null);
            this.input.add(t);
        }
        this.confirmDistinct();
    }

    public void testPODistictWithIntAndNullValues() throws ExecException {
        this.input = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (int i = 0; i < 100; ++i) {
            Tuple t = tf.newTuple();
            t.append((Object)this.r.nextInt(10));
            this.input.add(t);
            t = tf.newTuple();
            t.append(null);
            this.input.add(t);
        }
        this.confirmDistinct();
    }

    public void testPODistictWithIntNullValues() throws ExecException {
        this.input = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (int i = 0; i < 100; ++i) {
            Tuple t = tf.newTuple();
            t.append((Object)this.r.nextInt(10));
            t.append(null);
            this.input.add(t);
        }
        this.confirmDistinct();
    }

    public void testPODistictWithNullIntValues() throws ExecException {
        this.input = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (int i = 0; i < 100; ++i) {
            Tuple t = tf.newTuple();
            t.append(null);
            t.append((Object)this.r.nextInt(10));
            this.input.add(t);
        }
        this.confirmDistinct();
    }

    public void testPODistictArityWithNullValues() throws ExecException {
        this.input = BagFactory.getInstance().newDefaultBag();
        TupleFactory tf = TupleFactory.getInstance();
        for (int i = 0; i < 100; ++i) {
            Tuple t = tf.newTuple();
            if (this.r.nextInt(10) % 3 == 0) {
                t.append(null);
            }
            t.append((Object)this.r.nextInt(10));
            t.append((Object)this.r.nextInt(10));
            this.input.add(t);
        }
        this.confirmDistinct();
    }

    public void confirmDistinct() throws ExecException {
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), this.input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        PODistinct distinct = new PODistinct(new OperatorKey("", this.r.nextLong()), -1, inputs);
        HashMap<Tuple, Integer> output = new HashMap<Tuple, Integer>();
        Tuple t = null;
        Result res = distinct.getNext(t);
        t = (Tuple)res.result;
        while (res.returnStatus != 3) {
            if (output.containsKey(t)) {
                int i = (Integer)output.get(t);
                output.put(t, ++i);
            } else {
                output.put(t, 1);
            }
            res = distinct.getNext(t);
            t = (Tuple)res.result;
        }
        for (Map.Entry e : output.entrySet()) {
            int i = (Integer)e.getValue();
            TestPODistinct.assertEquals((int)1, (int)i);
        }
    }
}

