/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.LinkedList;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.junit.Before;

public class TestPOGenerate
extends TestCase {
    DataBag cogroup;
    DataBag partialFlatten;
    DataBag simpleGenerate;
    Random r = new Random();
    BagFactory bf = BagFactory.getInstance();
    TupleFactory tf = TupleFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        int i;
        int i2;
        Tuple[] inputA = new Tuple[4];
        Tuple[] inputB = new Tuple[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            inputA[i3] = this.tf.newTuple(2);
            inputB[i3] = this.tf.newTuple(1);
        }
        inputA[0].set(0, (Object)Character.valueOf('a'));
        inputA[0].set(1, (Object)Character.valueOf('1'));
        inputA[1].set(0, (Object)Character.valueOf('b'));
        inputA[1].set(1, (Object)Character.valueOf('1'));
        inputA[2].set(0, (Object)Character.valueOf('a'));
        inputA[2].set(1, (Object)Character.valueOf('1'));
        inputA[3].set(0, (Object)Character.valueOf('c'));
        inputA[3].set(1, (Object)Character.valueOf('1'));
        inputB[0].set(0, (Object)Character.valueOf('b'));
        inputB[1].set(0, (Object)Character.valueOf('b'));
        inputB[2].set(0, (Object)Character.valueOf('a'));
        inputB[3].set(0, (Object)Character.valueOf('d'));
        DataBag cg11 = this.bf.newDefaultBag();
        cg11.add(inputA[0]);
        cg11.add(inputA[2]);
        DataBag cg21 = this.bf.newDefaultBag();
        cg21.add(inputA[1]);
        DataBag cg31 = this.bf.newDefaultBag();
        cg31.add(inputA[3]);
        DataBag emptyBag = this.bf.newDefaultBag();
        DataBag cg12 = this.bf.newDefaultBag();
        cg12.add(inputB[2]);
        DataBag cg22 = this.bf.newDefaultBag();
        cg22.add(inputB[0]);
        cg22.add(inputB[1]);
        DataBag cg42 = this.bf.newDefaultBag();
        cg42.add(inputB[3]);
        Tuple[] tIn = new Tuple[4];
        for (i2 = 0; i2 < 4; ++i2) {
            tIn[i2] = this.tf.newTuple(2);
        }
        tIn[0].set(0, (Object)cg11);
        tIn[0].set(1, (Object)cg12);
        tIn[1].set(0, (Object)cg21);
        tIn[1].set(1, (Object)cg22);
        tIn[2].set(0, (Object)cg31);
        tIn[2].set(1, (Object)emptyBag);
        tIn[3].set(0, (Object)emptyBag);
        tIn[3].set(1, (Object)cg42);
        this.cogroup = this.bf.newDefaultBag();
        for (i2 = 0; i2 < 4; ++i2) {
            this.cogroup.add(tIn[i2]);
        }
        Tuple[] tPartial = new Tuple[4];
        for (i = 0; i < 4; ++i) {
            tPartial[i] = this.tf.newTuple(2);
            tPartial[i].set(0, inputA[i].get(0));
            tPartial[i].set(1, inputA[i].get(1));
        }
        tPartial[0].append((Object)cg12);
        tPartial[1].append((Object)cg22);
        tPartial[2].append((Object)cg12);
        tPartial[3].append((Object)emptyBag);
        this.partialFlatten = this.bf.newDefaultBag();
        for (i = 0; i < 4; ++i) {
            this.partialFlatten.add(tPartial[i]);
        }
        this.simpleGenerate = this.bf.newDefaultBag();
        for (i = 0; i < 4; ++i) {
            this.simpleGenerate.add(inputA[i]);
        }
    }

    public void testJoin() throws Exception {
        POProject prj1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        POProject prj2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        prj1.setResultType((byte)120);
        prj2.setResultType((byte)120);
        LinkedList<Boolean> toBeFlattened = new LinkedList<Boolean>();
        toBeFlattened.add(true);
        toBeFlattened.add(true);
        PhysicalPlan plan1 = new PhysicalPlan();
        plan1.add((Operator)prj1);
        PhysicalPlan plan2 = new PhysicalPlan();
        plan2.add((Operator)prj2);
        LinkedList<PhysicalPlan> inputs = new LinkedList<PhysicalPlan>();
        inputs.add(plan1);
        inputs.add(plan2);
        POForEach poGen = new POForEach(new OperatorKey("", this.r.nextLong()), 1, inputs, toBeFlattened);
        for (Tuple t : this.cogroup) {
            poGen.attachInput(t);
            Result output = poGen.getNext(t);
            while (output.result != null && output.returnStatus != 3) {
                Tuple tObtained = (Tuple)output.result;
                TestPOGenerate.assertTrue((boolean)tObtained.get(0).toString().equals(tObtained.get(2).toString()));
                output = poGen.getNext(t);
            }
        }
    }

    public void testPartialJoin() throws Exception {
        POProject prj1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        POProject prj2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        prj1.setResultType((byte)120);
        prj2.setResultType((byte)120);
        LinkedList<Boolean> toBeFlattened = new LinkedList<Boolean>();
        toBeFlattened.add(true);
        toBeFlattened.add(false);
        PhysicalPlan plan1 = new PhysicalPlan();
        plan1.add((Operator)prj1);
        PhysicalPlan plan2 = new PhysicalPlan();
        plan2.add((Operator)prj2);
        LinkedList<PhysicalPlan> inputs = new LinkedList<PhysicalPlan>();
        inputs.add(plan1);
        inputs.add(plan2);
        POForEach poGen = new POForEach(new OperatorKey("", this.r.nextLong()), 1, inputs, toBeFlattened);
        LinkedList<String> obtained = new LinkedList<String>();
        for (Tuple t : this.cogroup) {
            poGen.attachInput(t);
            Result output = poGen.getNext(t);
            while (output.result != null && output.returnStatus != 3) {
                obtained.add(((Tuple)output.result).toString());
                output = poGen.getNext(t);
            }
        }
        int count = 0;
        for (Tuple t : this.partialFlatten) {
            TestPOGenerate.assertTrue((boolean)obtained.contains(t.toString()));
            ++count;
        }
        TestPOGenerate.assertEquals((long)this.partialFlatten.size(), (long)count);
    }

    public void testSimpleGenerate() throws Exception {
        POProject prj1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        POProject prj2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        prj1.setResultType((byte)10);
        prj2.setResultType((byte)10);
        LinkedList<Boolean> toBeFlattened = new LinkedList<Boolean>();
        toBeFlattened.add(true);
        toBeFlattened.add(false);
        PhysicalPlan plan1 = new PhysicalPlan();
        plan1.add((Operator)prj1);
        PhysicalPlan plan2 = new PhysicalPlan();
        plan2.add((Operator)prj2);
        LinkedList<PhysicalPlan> inputs = new LinkedList<PhysicalPlan>();
        inputs.add(plan1);
        inputs.add(plan2);
        POForEach poGen = new POForEach(new OperatorKey("", this.r.nextLong()), 1, inputs, toBeFlattened);
        LinkedList<String> obtained = new LinkedList<String>();
        for (Tuple t : this.simpleGenerate) {
            poGen.attachInput(t);
            Result output = poGen.getNext(t);
            while (output.result != null && output.returnStatus != 3) {
                obtained.add(((Tuple)output.result).toString());
                output = poGen.getNext(t);
            }
        }
        int count = 0;
        for (Tuple t : this.simpleGenerate) {
            TestPOGenerate.assertTrue((boolean)obtained.contains(t.toString()));
            ++count;
        }
        TestPOGenerate.assertEquals((long)this.simpleGenerate.size(), (long)count);
    }
}

