/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.util.LinkedList;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORead;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.DefaultTupleFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.Test;

public class TestPOSort
extends TestCase {
    Random r = new Random();
    int MAX_TUPLES = 10;

    @Test
    public void testPOSortAscString() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, this.MAX_TUPLES, 100);
        this.poSortAscString(input);
    }

    @Test
    public void testPOSortAscStringWithNull() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, this.MAX_TUPLES, 100);
        this.poSortAscString(input);
    }

    public void poSortAscString(DataBag input) throws ExecException {
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        pr1.setResultType((byte)55);
        PhysicalPlan expPlan = new PhysicalPlan();
        expPlan.add((Operator)pr1);
        sortPlans.add(expPlan);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(true);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res1 = sort.getNext(t);
        Result res2 = sort.getNext(t);
        while (res2.returnStatus != 3) {
            Object i1 = ((Tuple)res1.result).get(0);
            Object i2 = ((Tuple)res2.result).get(0);
            int i = DataType.compare((Object)i1, (Object)i2);
            System.out.println("RESULT2=i : " + res2.result + " i = " + i);
            TestPOSort.assertEquals((boolean)true, (i <= 0 ? 1 : 0) != 0);
            res1 = res2;
            res2 = sort.getNext(t);
        }
    }

    @Test
    public void testPOSortDescString() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, this.MAX_TUPLES, 100);
        this.poSortDescString(input);
    }

    @Test
    public void testPOSortDescStringWithNulls() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, this.MAX_TUPLES, 100);
        this.poSortDescString(input);
    }

    public void poSortDescString(DataBag input) throws ExecException {
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        pr1.setResultType((byte)55);
        PhysicalPlan expPlan = new PhysicalPlan();
        expPlan.add((Operator)pr1);
        sortPlans.add(expPlan);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(false);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res1 = sort.getNext(t);
        Result res2 = sort.getNext(t);
        while (res2.returnStatus != 3) {
            Object i2;
            Object i1 = ((Tuple)res1.result).get(0);
            int i = DataType.compare((Object)i1, (Object)(i2 = ((Tuple)res2.result).get(0)));
            TestPOSort.assertEquals((boolean)true, (i >= 0 ? 1 : 0) != 0);
            res1 = res2;
            res2 = sort.getNext(t);
        }
    }

    @Test
    public void testPOSortAsc() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, this.MAX_TUPLES, 100);
        this.poSortAscInt(input);
    }

    @Test
    public void testPOSortAscWithNulls() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, this.MAX_TUPLES, 100);
        this.poSortAscInt(input);
    }

    public void poSortAscInt(DataBag input) throws ExecException {
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        pr1.setResultType((byte)10);
        PhysicalPlan expPlan = new PhysicalPlan();
        expPlan.add((Operator)pr1);
        sortPlans.add(expPlan);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(true);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res1 = sort.getNext(t);
        Result res2 = sort.getNext(t);
        while (res2.returnStatus != 3) {
            Object i2;
            Object i1 = ((Tuple)res1.result).get(1);
            int i = DataType.compare((Object)i1, (Object)(i2 = ((Tuple)res2.result).get(1)));
            TestPOSort.assertEquals((boolean)true, (i <= 0 ? 1 : 0) != 0);
            res1 = res2;
            res2 = sort.getNext(t);
        }
    }

    @Test
    public void testPOSortDescInt() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, this.MAX_TUPLES, 100);
        this.poSortDescInt(input);
    }

    @Test
    public void testPOSortDescIntWithNulls() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, this.MAX_TUPLES, 100);
        this.poSortDescInt(input);
    }

    public void poSortDescInt(DataBag input) throws ExecException {
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        pr1.setResultType((byte)10);
        PhysicalPlan expPlan = new PhysicalPlan();
        expPlan.add((Operator)pr1);
        sortPlans.add(expPlan);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(false);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res1 = sort.getNext(t);
        Result res2 = sort.getNext(t);
        while (res2.returnStatus != 3) {
            Object i2;
            Object i1 = ((Tuple)res1.result).get(1);
            int i = DataType.compare((Object)i1, (Object)(i2 = ((Tuple)res2.result).get(1)));
            TestPOSort.assertEquals((boolean)true, (i >= 0 ? 1 : 0) != 0);
            res1 = res2;
            res2 = sort.getNext(t);
        }
    }

    @Test
    public void testPOSortMixAscDesc1() throws ExecException {
        DataBag input = DefaultBagFactory.getInstance().newDefaultBag();
        Tuple t1 = DefaultTupleFactory.getInstance().newTuple();
        t1.append((Object)1);
        t1.append((Object)10);
        input.add(t1);
        Tuple t2 = DefaultTupleFactory.getInstance().newTuple();
        t2.append((Object)3);
        t2.append((Object)8);
        input.add(t2);
        Tuple t3 = DefaultTupleFactory.getInstance().newTuple();
        t3.append((Object)2);
        t3.append((Object)8);
        input.add(t3);
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        pr1.setResultType((byte)10);
        PhysicalPlan expPlan1 = new PhysicalPlan();
        expPlan1.add((Operator)pr1);
        sortPlans.add(expPlan1);
        POProject pr2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        pr2.setResultType((byte)10);
        PhysicalPlan expPlan2 = new PhysicalPlan();
        expPlan2.add((Operator)pr2);
        sortPlans.add(expPlan2);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(false);
        mAscCols.add(true);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)1);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)10);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)2);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)3);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
    }

    @Test
    public void testPOSortMixAscDesc1WithNull() throws ExecException {
        DataBag input = DefaultBagFactory.getInstance().newDefaultBag();
        Tuple t1 = DefaultTupleFactory.getInstance().newTuple();
        t1.append(null);
        t1.append((Object)10);
        input.add(t1);
        Tuple t2 = DefaultTupleFactory.getInstance().newTuple();
        t2.append((Object)1);
        t2.append((Object)8);
        input.add(t2);
        Tuple t3 = DefaultTupleFactory.getInstance().newTuple();
        t3.append((Object)1);
        t3.append(null);
        input.add(t3);
        Tuple t4 = DefaultTupleFactory.getInstance().newTuple();
        t4.append(null);
        t4.append(null);
        input.add(t4);
        Tuple t5 = DefaultTupleFactory.getInstance().newTuple();
        t5.append((Object)3);
        t5.append((Object)8);
        input.add(t5);
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        pr1.setResultType((byte)10);
        PhysicalPlan expPlan1 = new PhysicalPlan();
        expPlan1.add((Operator)pr1);
        sortPlans.add(expPlan1);
        POProject pr2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        pr2.setResultType((byte)10);
        PhysicalPlan expPlan2 = new PhysicalPlan();
        expPlan2.add((Operator)pr2);
        sortPlans.add(expPlan2);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(false);
        mAscCols.add(true);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), null);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)10);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)1);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)3);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), null);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), null);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)1);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), null);
    }

    @Test
    public void testPOSortMixAscDesc2() throws ExecException {
        DataBag input = DefaultBagFactory.getInstance().newDefaultBag();
        Tuple t1 = DefaultTupleFactory.getInstance().newTuple();
        t1.append((Object)1);
        t1.append((Object)2);
        input.add(t1);
        Tuple t2 = DefaultTupleFactory.getInstance().newTuple();
        t2.append((Object)3);
        t2.append((Object)5);
        input.add(t2);
        Tuple t3 = DefaultTupleFactory.getInstance().newTuple();
        t3.append((Object)3);
        t3.append((Object)8);
        input.add(t3);
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        pr1.setResultType((byte)10);
        PhysicalPlan expPlan1 = new PhysicalPlan();
        expPlan1.add((Operator)pr1);
        sortPlans.add(expPlan1);
        POProject pr2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        pr2.setResultType((byte)10);
        PhysicalPlan expPlan2 = new PhysicalPlan();
        expPlan2.add((Operator)pr2);
        sortPlans.add(expPlan2);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(false);
        mAscCols.add(true);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)3);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)5);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)3);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)1);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)2);
    }

    @Test
    public void testPOSortMixAscDesc2Null() throws ExecException {
        DataBag input = DefaultBagFactory.getInstance().newDefaultBag();
        Tuple t1 = DefaultTupleFactory.getInstance().newTuple();
        t1.append(null);
        t1.append((Object)10);
        input.add(t1);
        Tuple t2 = DefaultTupleFactory.getInstance().newTuple();
        t2.append((Object)1);
        t2.append((Object)8);
        input.add(t2);
        Tuple t3 = DefaultTupleFactory.getInstance().newTuple();
        t3.append((Object)1);
        t3.append(null);
        input.add(t3);
        Tuple t4 = DefaultTupleFactory.getInstance().newTuple();
        t4.append(null);
        t4.append(null);
        input.add(t4);
        Tuple t5 = DefaultTupleFactory.getInstance().newTuple();
        t5.append((Object)3);
        t5.append((Object)8);
        input.add(t5);
        LinkedList<PhysicalPlan> sortPlans = new LinkedList<PhysicalPlan>();
        POProject pr1 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 0);
        pr1.setResultType((byte)10);
        PhysicalPlan expPlan1 = new PhysicalPlan();
        expPlan1.add((Operator)pr1);
        sortPlans.add(expPlan1);
        POProject pr2 = new POProject(new OperatorKey("", this.r.nextLong()), -1, 1);
        pr2.setResultType((byte)10);
        PhysicalPlan expPlan2 = new PhysicalPlan();
        expPlan2.add((Operator)pr2);
        sortPlans.add(expPlan2);
        LinkedList<Boolean> mAscCols = new LinkedList<Boolean>();
        mAscCols.add(false);
        mAscCols.add(true);
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, sortPlans, mAscCols, null);
        Tuple t = null;
        Result res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)3);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)1);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), null);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), (Object)1);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)8);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), null);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), null);
        res = sort.getNext(t);
        Assert.assertEquals((Object)((Tuple)res.result).get(0), null);
        Assert.assertEquals((Object)((Tuple)res.result).get(1), (Object)10);
    }

    @Test
    public void testPOSortUDF() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, this.MAX_TUPLES, 100);
        this.poSortUDFWithNull(input);
    }

    @Test
    public void testPOSortUDFWithNull() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, this.MAX_TUPLES, 100);
        this.poSortUDFWithNull(input);
    }

    public void poSortUDFWithNull(DataBag input) throws ExecException {
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        String funcName = WeirdComparator.class.getName() + "()";
        POUserComparisonFunc comparator = new POUserComparisonFunc(new OperatorKey("", this.r.nextLong()), -1, null, new FuncSpec(funcName));
        POSort sort = new POSort(new OperatorKey("", this.r.nextLong()), -1, inputs, null, null, comparator);
        Tuple t = null;
        Result res1 = sort.getNext(t);
        Result res2 = sort.getNext(t);
        while (res2.returnStatus != 3) {
            int i1 = (Integer)((Tuple)res1.result).get(1) == null ? 0 : (Integer)((Tuple)res1.result).get(1);
            int i2 = (Integer)((Tuple)res2.result).get(1) == null ? 0 : (Integer)((Tuple)res2.result).get(1);
            int i = (i1 - 50) * (i1 - 50) - (i2 - 50) * (i2 - 50);
            TestPOSort.assertEquals((boolean)true, (i <= 0 ? 1 : 0) != 0);
            System.out.println(i + " : " + res2.result);
            res1 = res2;
            res2 = sort.getNext(t);
        }
    }

    public static class WeirdComparator
    extends ComparisonFunc {
        public int compare(Tuple t1, Tuple t2) {
            int result = 0;
            try {
                int i1 = (Integer)t1.get(1) == null ? 0 : (Integer)t1.get(1);
                int i2 = (Integer)t2.get(1) == null ? 0 : (Integer)t2.get(1);
                result = (i1 - 50) * (i1 - 50) - (i2 - 50) * (i2 - 50);
            }
            catch (ExecException e) {
                e.printStackTrace();
            }
            return result;
        }
    }
}

