/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.Algebraic;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORead;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.test.Util;
import org.apache.pig.test.utils.GenRandomData;
import org.junit.Test;

public class TestPOUserFunc
extends TestCase {
    Random r = new Random();
    int MAX_TUPLES = 10;

    @Test
    public void testUserFuncArity() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, this.MAX_TUPLES, 100);
        this.userFuncArity(input);
    }

    @Test
    public void testUserFuncArityWithNulls() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, this.MAX_TUPLES, 100);
        this.userFuncArity(input);
    }

    public void userFuncArity(DataBag input) throws ExecException {
        String funcSpec = ARITY.class.getName() + "()";
        PORead read = new PORead(new OperatorKey("", this.r.nextLong()), input);
        LinkedList<PORead> inputs = new LinkedList<PORead>();
        inputs.add(read);
        POUserFunc userFunc = new POUserFunc(new OperatorKey("", this.r.nextLong()), -1, inputs, new FuncSpec(funcSpec));
        Result res = new Result();
        Integer i = null;
        res = userFunc.getNext(i);
        while (res.returnStatus != 3) {
            int result = (Integer)res.result;
            TestPOUserFunc.assertEquals((int)2, (int)result);
            res = userFunc.getNext(i);
        }
    }

    @Test
    public void testUDFCompare() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBag(this.r, 2, 100);
        this.udfCompare(input);
    }

    @Test
    public void testUDFCompareWithNulls() throws ExecException {
        DataBag input = GenRandomData.genRandSmallTupDataBagWithNulls(this.r, 2, 100);
        this.udfCompare(input);
    }

    public void udfCompare(DataBag input) throws ExecException {
        String funcSpec = WeirdComparator.class.getName() + "()";
        POUserComparisonFunc userFunc = new POUserComparisonFunc(new OperatorKey("", this.r.nextLong()), -1, null, new FuncSpec(funcSpec));
        Iterator it = input.iterator();
        Tuple t1 = (Tuple)it.next();
        Tuple t2 = (Tuple)it.next();
        t1.append((Object)2);
        t2.append((Object)3);
        userFunc.attachInput(t1, t2);
        Integer i = null;
        int result = (Integer)userFunc.getNext(i).result;
        TestPOUserFunc.assertEquals((int)-1, (int)result);
    }

    @Test
    public void testAlgebraicAVG() throws IOException, ExecException {
        Integer[] input = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.algebraicAVG(input, 55.0, 10L, 110.0, 20L, 5.5);
    }

    @Test
    public void testAlgebraicAVGWithNulls() throws IOException, ExecException {
        Integer[] input = new Integer[]{1, 2, 3, 4, null, 6, 7, 8, 9, 10};
        this.algebraicAVG(input, 50.0, 10L, 100.0, 20L, 5.0);
    }

    @Test
    public void algebraicAVG(Integer[] input, double initialExpectedSum, long initialExpectedCount, double intermedExpectedSum, long intermedExpectedCount, double expectedAvg) throws IOException, ExecException {
        byte INIT = 0;
        byte INTERMED = 1;
        byte FINAL = 2;
        Tuple tup1 = Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), input);
        Tuple tup2 = Util.loadNestTuple(TupleFactory.getInstance().newTuple(1), input);
        String funcSpec = AVG.class.getName() + "()";
        POUserFunc po = new POUserFunc(new OperatorKey("", this.r.nextLong()), -1, null, new FuncSpec(funcSpec));
        TupleFactory tf = TupleFactory.getInstance();
        po.setAlgebraicFunction(INIT);
        po.attachInput(tup1);
        Tuple t = null;
        Result res = po.getNext(t);
        Tuple outputInitial1 = res.returnStatus == 0 ? (Tuple)res.result : null;
        Tuple outputInitial2 = res.returnStatus == 0 ? (Tuple)res.result : null;
        System.out.println(outputInitial1 + " " + outputInitial2);
        TestPOUserFunc.assertEquals((Object)outputInitial1, (Object)outputInitial2);
        double sum = (Double)outputInitial1.get(0);
        long count = (Long)outputInitial1.get(1);
        TestPOUserFunc.assertEquals((Object)initialExpectedSum, (Object)sum);
        TestPOUserFunc.assertEquals((long)initialExpectedCount, (long)count);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(outputInitial1);
        bag.add(outputInitial2);
        Tuple outputInitial = tf.newTuple();
        outputInitial.append((Object)bag);
        po = new POUserFunc(new OperatorKey("", this.r.nextLong()), -1, null, new FuncSpec(funcSpec));
        po.setAlgebraicFunction(INTERMED);
        po.attachInput(outputInitial);
        res = po.getNext(t);
        Tuple outputIntermed = res.returnStatus == 0 ? (Tuple)res.result : null;
        sum = (Double)outputIntermed.get(0);
        count = (Long)outputIntermed.get(1);
        TestPOUserFunc.assertEquals((Object)intermedExpectedSum, (Object)sum);
        TestPOUserFunc.assertEquals((long)intermedExpectedCount, (long)count);
        System.out.println(outputIntermed);
        po = new POUserFunc(new OperatorKey("", this.r.nextLong()), -1, null, new FuncSpec(funcSpec));
        po.setAlgebraicFunction(FINAL);
        po.attachInput(outputInitial);
        res = po.getNext(t);
        Double output = res.returnStatus == 0 ? (Double)res.result : null;
        TestPOUserFunc.assertEquals((Object)expectedAvg, (Object)output);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AVG
    extends EvalFunc<Double>
    implements Algebraic {
        private static TupleFactory mTupleFactory = TupleFactory.getInstance();

        public Double exec(Tuple input) throws IOException {
            double sum = 0.0;
            double count = 0.0;
            try {
                sum = AVG.sum(input);
                count = AVG.count(input);
            }
            catch (ExecException e) {
                e.printStackTrace();
            }
            double avg = 0.0;
            if (count > 0.0) {
                avg = sum / count;
            }
            return new Double(avg);
        }

        public String getInitial() {
            return Initial.class.getName();
        }

        public String getIntermed() {
            return Intermed.class.getName();
        }

        public String getFinal() {
            return Final.class.getName();
        }

        protected static Tuple combine(DataBag values) throws ExecException {
            double sum = 0.0;
            long count = 0L;
            Tuple output = mTupleFactory.newTuple(2);
            for (Tuple t : values) {
                sum += ((Double)t.get(0)).doubleValue();
                count += ((Long)t.get(1)).longValue();
            }
            output.set(0, (Object)new Double(sum));
            output.set(1, (Object)new Long(count));
            return output;
        }

        protected static long count(Tuple input) throws ExecException {
            DataBag values = (DataBag)input.get(0);
            return values.size();
        }

        protected static double sum(Tuple input) throws ExecException {
            DataBag values = (DataBag)input.get(0);
            double sum = 0.0;
            for (Tuple t : values) {
                Double d = DataType.toDouble((Object)t.get(0));
                if (d == null) continue;
                sum += d.doubleValue();
            }
            return sum;
        }

        public Schema outputSchema(Schema input) {
            return new Schema(new Schema.FieldSchema(null, 25));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Final
        extends EvalFunc<Double> {
            public Double exec(Tuple input) throws IOException {
                double sum = 0.0;
                double count = 0.0;
                try {
                    DataBag b = (DataBag)input.get(0);
                    Tuple combined = AVG.combine(b);
                    sum = (Double)combined.get(0);
                    count = ((Long)combined.get(1)).longValue();
                }
                catch (ExecException e) {
                    e.printStackTrace();
                }
                double avg = 0.0;
                if (count > 0.0) {
                    avg = sum / count;
                }
                return new Double(avg);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Intermed
        extends EvalFunc<Tuple> {
            public Tuple exec(Tuple input) throws IOException {
                DataBag b = null;
                Tuple t = null;
                try {
                    b = (DataBag)input.get(0);
                    t = AVG.combine(b);
                }
                catch (ExecException e) {
                    e.printStackTrace();
                }
                return t;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Initial
        extends EvalFunc<Tuple> {
            public Tuple exec(Tuple input) throws IOException {
                try {
                    Tuple t = mTupleFactory.newTuple(2);
                    t.set(0, (Object)new Double(AVG.sum(input)));
                    t.set(1, (Object)new Long(AVG.count(input)));
                    return t;
                }
                catch (ExecException t) {
                    throw new RuntimeException(t.getMessage() + ": " + input);
                }
            }
        }
    }

    public static class WeirdComparator
    extends ComparisonFunc {
        public int compare(Tuple t1, Tuple t2) {
            Object o1 = null;
            Object o2 = null;
            try {
                o1 = t1.get(2);
                o2 = t2.get(2);
            }
            catch (ExecException e) {
                e.printStackTrace();
            }
            if (o1 == null || o2 == null) {
                return -1;
            }
            int i1 = (Integer)o1 - 2;
            int i2 = (Integer)o2 - 2;
            return i1 * i1 - i2 * i2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ARITY
    extends EvalFunc<Integer> {
        public Integer exec(Tuple input) throws IOException {
            try {
                return new Integer(((Tuple)input.get(0)).size());
            }
            catch (ExecException e) {
                e.printStackTrace();
                return 0;
            }
        }

        public Schema outputSchema(Schema input) {
            return new Schema(new Schema.FieldSchema(null, 10));
        }
    }
}

