/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.test.utils.GenRandomData;
import org.apache.pig.test.utils.TestHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestPackage
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    private void runTest(Object key, boolean[] inner) throws ExecException, IOException {
        Random r = new Random();
        DataBag db1 = GenRandomData.genRandSmallTupDataBag(r, 10, 100);
        DataBag db2 = GenRandomData.genRandSmallTupDataBag(r, 10, 100);
        ArrayList<NullableTuple> db = new ArrayList<NullableTuple>(200);
        Iterator db1Iter = db1.iterator();
        if (!inner[0]) {
            while (db1Iter.hasNext()) {
                NullableTuple it = new NullableTuple((Tuple)db1Iter.next());
                it.setIndex((byte)0);
                db.add(it);
            }
        }
        Iterator db2Iter = db2.iterator();
        while (db2Iter.hasNext()) {
            NullableTuple it = new NullableTuple((Tuple)db2Iter.next());
            it.setIndex((byte)1);
            db.add(it);
        }
        POPackage pop = new POPackage(new OperatorKey("", r.nextLong()));
        pop.setNumInps(2);
        pop.setInner(inner);
        PigNullableWritable k = HDataType.getWritableComparableTypes((Object)key, (byte)0);
        pop.attachInput(k, db.iterator());
        HashMap<Integer, Pair> keyInfo = new HashMap<Integer, Pair>();
        Pair p = new Pair((Object)false, new HashMap());
        keyInfo.put(0, p);
        keyInfo.put(1, p);
        pop.setKeyInfo(keyInfo);
        Tuple t = null;
        Result res = null;
        res = pop.getNext(t);
        if (res.returnStatus == 1 && inner[0]) {
            return;
        }
        TestPackage.assertEquals((byte)0, (byte)res.returnStatus);
        t = (Tuple)res.result;
        Object outKey = t.get(0);
        DataBag outDb1 = (DataBag)t.get(1);
        DataBag outDb2 = (DataBag)t.get(2);
        TestPackage.assertEquals((Object)key, (Object)outKey);
        TestPackage.assertTrue((boolean)TestHelper.compareBags(db1, outDb1));
        TestPackage.assertTrue((boolean)TestHelper.compareBags(db2, outDb2));
    }

    private void pickTest(byte t, boolean[] inner) throws ExecException, IOException {
        Random r = new Random();
        switch (t) {
            case 120: {
                this.runTest(GenRandomData.genRandSmallTupDataBag(r, 10, 100), inner);
                break;
            }
            case 5: {
                this.runTest(r.nextBoolean(), inner);
                break;
            }
            case 50: {
                this.runTest(GenRandomData.genRandDBA(r), inner);
                break;
            }
            case 60: {
                String s = GenRandomData.genRandString(r);
                while (s.length() < 65535) {
                    s = s + GenRandomData.genRandString(r);
                }
                this.runTest(s, inner);
                break;
            }
            case 55: {
                this.runTest(GenRandomData.genRandString(r), inner);
                break;
            }
            case 25: {
                this.runTest(r.nextDouble(), inner);
                break;
            }
            case 20: {
                this.runTest(Float.valueOf(r.nextFloat()), inner);
                break;
            }
            case 10: {
                this.runTest(r.nextLong(), inner);
                break;
            }
            case 15: {
                this.runTest(r.nextLong(), inner);
                break;
            }
            case 6: 
            case 100: 
            case 127: {
                return;
            }
            case 110: {
                this.runTest(GenRandomData.genRandSmallBagTuple(r, 10, 100), inner);
                break;
            }
            default: {
                TestPackage.fail((String)("No test case for type " + DataType.findTypeName((byte)t)));
            }
        }
    }

    @Test
    public void testOperator() throws ExecException, IOException {
        byte[] types;
        for (byte b : types = DataType.genAllTypes()) {
            if (b == 123) continue;
            System.out.println("Type " + DataType.findTypeName((byte)b));
            boolean succ = true;
            int NUM_TRIALS = 10;
            boolean[] inner1 = new boolean[]{false, false};
            for (int i = 0; i < NUM_TRIALS; ++i) {
                this.pickTest(b, inner1);
            }
            boolean[] inner2 = new boolean[]{true, false};
            for (int i = 0; i < NUM_TRIALS; ++i) {
                this.pickTest(b, inner2);
            }
        }
    }
}

