/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPigContext
extends TestCase {
    private static final String TMP_DIR_PROP = "/tmp/hadoop-hadoop";
    private static final String FS_NAME = "file:///";
    private static final String JOB_TRACKER = "local";
    private File input;
    private PigContext pigContext;
    MiniCluster cluster = MiniCluster.buildCluster();

    @Before
    protected void setUp() throws Exception {
        this.pigContext = new PigContext(ExecType.LOCAL, TestPigContext.getProperties());
        this.input = File.createTempFile("PigContextTest-", ".txt");
    }

    @Test
    public void testSetProperties_way_num01() throws Exception {
        PigServer pigServer = new PigServer(this.pigContext);
        this.registerAndStore(pigServer);
        this.check_asserts(pigServer);
    }

    @Test
    public void testSetProperties_way_num02() throws Exception {
        PigServer pigServer = new PigServer(ExecType.LOCAL, TestPigContext.getProperties());
        this.registerAndStore(pigServer);
        this.check_asserts(pigServer);
    }

    @Test
    public void testSetProperties_way_num03() throws Exception {
        this.pigContext.connect();
        PigServer pigServer = new PigServer(this.pigContext);
        this.registerAndStore(pigServer);
        this.check_asserts(pigServer);
    }

    @Test
    public void testHadoopExceptionCreation() throws Exception {
        Object object = PigContext.instantiateFuncFromSpec((String)"org.apache.hadoop.mapred.FileAlreadyExistsException");
        TestPigContext.assertTrue((boolean)(object instanceof FileAlreadyExistsException));
    }

    @Test
    public void testImportList() throws Exception {
        String FILE_SEPARATOR = System.getProperty("file.separator");
        File tmpDir = File.createTempFile("test", "");
        tmpDir.delete();
        tmpDir.mkdir();
        File udf1Dir = new File(tmpDir.getAbsolutePath() + FILE_SEPARATOR + "com" + FILE_SEPARATOR + "xxx" + FILE_SEPARATOR + "udf1");
        udf1Dir.mkdirs();
        File udf2Dir = new File(tmpDir.getAbsolutePath() + FILE_SEPARATOR + "com" + FILE_SEPARATOR + "xxx" + FILE_SEPARATOR + "udf2");
        udf2Dir.mkdirs();
        File udf1JavaSrc = new File(udf1Dir.getAbsolutePath() + FILE_SEPARATOR + "TestUDF1.java");
        File udf2JavaSrc = new File(udf2Dir.getAbsolutePath() + FILE_SEPARATOR + "TestUDF2.java");
        String udf1Src = new String("package com.xxx.udf1;\nimport java.io.IOException;\nimport org.apache.pig.EvalFunc;\nimport org.apache.pig.data.Tuple;\npublic class TestUDF1 extends EvalFunc<Integer>{\npublic Integer exec(Tuple input) throws IOException {\nreturn 1;}\n}");
        String udf2Src = new String("package com.xxx.udf2;\nimport org.apache.pig.builtin.PigStorage;\npublic class TestUDF2 extends PigStorage { }\n");
        FileOutputStream outStream1 = new FileOutputStream(udf1JavaSrc);
        OutputStreamWriter outWriter1 = new OutputStreamWriter(outStream1);
        outWriter1.write(udf1Src);
        outWriter1.close();
        FileOutputStream outStream2 = new FileOutputStream(udf2JavaSrc);
        OutputStreamWriter outWriter2 = new OutputStreamWriter(outStream2);
        outWriter2.write(udf2Src);
        outWriter2.close();
        int status = Util.executeJavaCommand("javac -cp " + System.getProperty("java.class.path") + " " + udf1JavaSrc);
        status = Util.executeJavaCommand("javac -cp " + System.getProperty("java.class.path") + " " + udf2JavaSrc);
        String jarName = "TestUDFJar.jar";
        String jarFile = tmpDir.getAbsolutePath() + FILE_SEPARATOR + jarName;
        status = Util.executeJavaCommand("jar -cf " + tmpDir.getAbsolutePath() + FILE_SEPARATOR + jarName + " -C " + tmpDir.getAbsolutePath() + " " + "com");
        TestPigContext.assertTrue((status == 0 ? 1 : 0) != 0);
        Properties properties = this.cluster.getProperties();
        PigContext pigContext = new PigContext(ExecType.MAPREDUCE, properties);
        pigContext.getProperties().setProperty("pig.additional.jars", jarFile);
        PigServer pigServer = new PigServer(pigContext);
        PigContext.initializeImportList((String)"com.xxx.udf1:com.xxx.udf2.");
        ArrayList importList = PigContext.getPackageImportList();
        TestPigContext.assertTrue((importList.size() == 5 ? 1 : 0) != 0);
        TestPigContext.assertTrue((boolean)((String)importList.get(0)).equals("com.xxx.udf1."));
        TestPigContext.assertTrue((boolean)((String)importList.get(1)).equals("com.xxx.udf2."));
        TestPigContext.assertTrue((boolean)((String)importList.get(2)).equals(""));
        TestPigContext.assertTrue((boolean)((String)importList.get(3)).equals("org.apache.pig.builtin."));
        TestPigContext.assertTrue((boolean)((String)importList.get(4)).equals("org.apache.pig.impl.builtin."));
        Object udf = PigContext.instantiateFuncFromSpec((String)"TestUDF1");
        TestPigContext.assertTrue((boolean)udf.getClass().toString().endsWith("com.xxx.udf1.TestUDF1"));
        int LOOP_COUNT = 40;
        File tmpFile = File.createTempFile("test", "txt");
        tmpFile.deleteOnExit();
        String[] input = new String[LOOP_COUNT];
        Random r = new Random(1L);
        for (int i = 0; i < LOOP_COUNT; ++i) {
            int rand = r.nextInt(100);
            input[i] = Integer.toString(rand);
        }
        Util.createInputFile(this.cluster, tmpFile.getCanonicalPath(), input);
        FileLocalizer.deleteTempFiles();
        pigServer.registerQuery("A = LOAD '" + tmpFile.getCanonicalPath() + "' using TestUDF2() AS (num:chararray);");
        pigServer.registerQuery("B = foreach A generate TestUDF1(num);");
        Iterator iter = pigServer.openIterator("B");
        if (!iter.hasNext()) {
            TestPigContext.fail((String)"No output found");
        }
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            TestPigContext.assertTrue((boolean)(t.get(0) instanceof Integer));
            TestPigContext.assertTrue(((Integer)t.get(0) == 1 ? 1 : 0) != 0);
        }
        Util.deleteFile(this.cluster, tmpFile.getCanonicalPath());
        Util.deleteDirectory(tmpDir);
    }

    @After
    protected void tearDown() throws Exception {
        this.input.delete();
    }

    private static Properties getProperties() {
        Properties props = new Properties();
        props.put("mapred.job.tracker", JOB_TRACKER);
        props.put("fs.default.name", FS_NAME);
        props.put("hadoop.tmp.dir", TMP_DIR_PROP);
        return props;
    }

    private List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("my_input = LOAD '" + Util.encodeEscape(this.input.getAbsolutePath()) + "' USING PigStorage();");
        commands.add("words = FOREACH my_input GENERATE FLATTEN(TOKENIZE($0));");
        commands.add("grouped = GROUP words BY $0;");
        commands.add("counts = FOREACH grouped GENERATE group, COUNT(words);");
        return commands;
    }

    private void registerAndStore(PigServer pigServer) throws IOException {
        List<String> commands = this.getCommands();
        for (String command : commands) {
            pigServer.registerQuery(command);
        }
        pigServer.store("counts", this.input.getAbsolutePath() + ".out");
    }

    private void check_asserts(PigServer pigServer) {
        TestPigContext.assertEquals((String)JOB_TRACKER, (String)pigServer.getPigContext().getProperties().getProperty("mapred.job.tracker"));
        TestPigContext.assertEquals((String)FS_NAME, (String)pigServer.getPigContext().getProperties().getProperty("fs.default.name"));
        TestPigContext.assertEquals((String)TMP_DIR_PROP, (String)pigServer.getPigContext().getProperties().getProperty("hadoop.tmp.dir"));
    }
}

