/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.test.MiniCluster;
import org.apache.pig.test.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPigStorage {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static MiniCluster cluster = MiniCluster.buildCluster();

    @Before
    public void setup() {
        FileLocalizer.setInitialized((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockBoundary() throws ExecException {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : cluster.getProperties().entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        props.setProperty("mapred.max.split.size", "20");
        PigServer pigServer = new PigServer(ExecType.MAPREDUCE, props);
        String[] inputs = new String[]{"abcdefgh1", "abcdefgh2", "abcdefgh3", "abcdefgh4", "abcdefgh5", "abcdefgh6", "abcdefgh7", "abcdefgh8", "abcdefgh9"};
        String[] expected = new String[]{"(abcdefgh1)", "(abcdefgh2)", "(abcdefgh3)", "(abcdefgh4)", "(abcdefgh5)", "(abcdefgh6)", "(abcdefgh7)", "(abcdefgh8)", "(abcdefgh9)"};
        System.setProperty("pig.overrideBlockSize", "20");
        String INPUT_FILE = "tmp.txt";
        try {
            PrintWriter w = new PrintWriter(new FileWriter(INPUT_FILE));
            for (String s : inputs) {
                w.println(s);
            }
            w.close();
            Util.copyFromLocalToCluster(cluster, INPUT_FILE, INPUT_FILE);
            pigServer.registerQuery("a = load '" + INPUT_FILE + "';");
            Iterator iter = pigServer.openIterator("a");
            int counter = 0;
            while (iter.hasNext()) {
                Assert.assertEquals((Object)expected[counter++].toString(), (Object)((Tuple)iter.next()).toString());
            }
            Assert.assertEquals((long)expected.length, (long)counter);
        }
        catch (Exception e) {
            e.printStackTrace();
            junit.framework.Assert.fail();
        }
        finally {
            new File(INPUT_FILE).delete();
            try {
                Util.deleteFile(cluster, INPUT_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
                junit.framework.Assert.fail();
            }
        }
    }

    @Test
    public void testPruneColumnsWithMissingFields() throws IOException {
        String inputFileName = "TestPigStorage-testPruneColumnsWithMissingFields-input.txt";
        Util.createLocalInputFile(inputFileName, new String[]{"1\t2\t3", "4", "5\t6\t7"});
        PigServer ps = new PigServer(ExecType.LOCAL);
        String script = "a = load '" + inputFileName + "' as (i:int, j:int, k:int);" + "b = foreach a generate j, k;";
        Util.registerMultiLineQuery(ps, script);
        Iterator it = ps.openIterator("b");
        Assert.assertEquals((Object)Util.createTuple(new Integer[]{2, 3}), it.next());
        Assert.assertEquals((Object)Util.createTuple(new Integer[]{null, null}), it.next());
        Assert.assertEquals((Object)Util.createTuple(new Integer[]{6, 7}), it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }
}

